/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.renderer;

import com.ibm.debug.memorymap.AbstractMemoryMapRendering;
import com.ibm.debug.memorymap.MemoryMap;
import com.ibm.debug.memorymap.utils.MemoryMapException;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapMessages;
import com.ibm.debug.memorymap.utils.MemoryMapUtils;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.StringTokenizer;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.ui.DebugUITools;

public class MemoryMapRenderer {
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_ENDIAN = 1;
    private AbstractMemoryMapRendering fRendering;
    private String asciiCodePage;
    private String ebcdicCodePage;

    public MemoryMapRenderer(AbstractMemoryMapRendering rendering) {
        this.fRendering = rendering;
        this.updateASCIICodePage();
        this.updateEBCDICCodePage();
    }

    private byte[] convertEncodingToByteArray(String data, String enc, MemoryByte[] currentValues) {
        try {
            byte[] bytes = data.getBytes(enc);
            int i = 0;
            while (i < bytes.length && i < currentValues.length) {
                if (bytes[i] == 1 && currentValues[i].getValue() == 0) {
                    bytes[i] = 0;
                }
                ++i;
            }
            return bytes;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private String convertByteArrayToEBCDIC(MemoryByte[] data) {
        return this.convertByteArrayToEncoding(data, this.ebcdicCodePage);
    }

    private String convertByteArrayToASCII(MemoryByte[] data) {
        return this.convertByteArrayToEncoding(data, this.asciiCodePage);
    }

    private String convertByteArrayToEncoding(MemoryByte[] data, String enc) {
        byte[] rawData = new byte[data.length];
        int i = 0;
        while (i < data.length) {
            rawData[i] = data[i].getValue() == 0 ? (byte)1 : data[i].getValue();
            ++i;
        }
        try {
            return new String(rawData, enc);
        }
        catch (UnsupportedEncodingException e) {
            return MemoryMapLabels.MemoryMapRenderer_Error;
        }
    }

    private short convertByteArrayToShort(MemoryByte[] array, int endianess) {
        short value;
        byte[] byteArray = new byte[array.length];
        int i = 0;
        while (i < byteArray.length) {
            byteArray[i] = array[i].getValue();
            ++i;
        }
        if (array.length < 2) {
            byteArray = this.fillArray(byteArray, 2, endianess);
        }
        if (endianess == 0) {
            value = 0;
            int i2 = 0;
            while (i2 < 2) {
                short b = byteArray[i2];
                b = (short)(b & 0xFF);
                value = (short)(value | b << i2 * 8);
                ++i2;
            }
            return value;
        }
        value = 0;
        int i3 = 0;
        while (i3 < 2) {
            short b = byteArray[i3];
            b = (short)(b & 0xFF);
            value = (short)(value | b << (1 - i3) * 8);
            ++i3;
        }
        return value;
    }

    private byte[] convertShortToByteArray(short i, int endianess) {
        byte[] buf = new byte[2];
        if (endianess == 0) {
            int j = 0;
            while (j < 2) {
                buf[j] = Integer.valueOf(i >> j * 8).byteValue();
                j = (short)(j + 1);
            }
            return buf;
        }
        int j = 1;
        while (j >= 0) {
            buf[j] = Integer.valueOf(i >> (1 - j) * 8).byteValue();
            j = (short)(j - 1);
        }
        return buf;
    }

    private int convertByteArrayToInt(MemoryByte[] array, int endianess) {
        int value;
        byte[] byteArray = new byte[array.length];
        int i = 0;
        while (i < byteArray.length) {
            byteArray[i] = array[i].getValue();
            ++i;
        }
        if (array.length < 4) {
            byteArray = this.fillArray(byteArray, 4, endianess);
        }
        if (endianess == 0) {
            value = 0;
            int i2 = 0;
            while (i2 < 4) {
                int ord;
                int b = byteArray[i2];
                int shift = (b &= 0xFF) << i2 * 8;
                value = ord = value | shift;
                ++i2;
            }
            return value;
        }
        value = 0;
        int i3 = 0;
        while (i3 < 4) {
            int b = byteArray[i3];
            value |= (b &= 0xFF) << (3 - i3) * 8;
            ++i3;
        }
        return value;
    }

    private byte[] convertIntToByteArray(int i, int endianess) {
        byte[] buf = new byte[4];
        if (endianess == 0) {
            int j = 0;
            while (j < 4) {
                buf[j] = Integer.valueOf(i >> j * 8).byteValue();
                ++j;
            }
            return buf;
        }
        int j = 3;
        while (j >= 0) {
            buf[j] = Integer.valueOf(i >> (3 - j) * 8).byteValue();
            --j;
        }
        return buf;
    }

    private byte[] convertLongToByteArray(long i, int endianess) {
        byte[] buf = new byte[8];
        if (endianess == 0) {
            int j = 0;
            while (j < 8) {
                buf[j] = Long.valueOf(i >> j * 8).byteValue();
                ++j;
            }
            return buf;
        }
        int j = 7;
        while (j >= 0) {
            buf[j] = Long.valueOf(i >> (7 - j) * 8).byteValue();
            --j;
        }
        return buf;
    }

    private byte[] convertHexStringToByteArray(String value) throws NumberFormatException {
        StringBuffer trim = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(value, " ");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            trim.append(token);
        }
        value = trim.toString();
        byte[] bytes = new byte[value.length() / 2];
        if (value.length() > bytes.length * 2) {
            throw new NumberFormatException(MemoryMapMessages.memory_map_utils_error_invalid_hex_value);
        }
        int index = 0;
        int i = 0;
        while (index < bytes.length) {
            char multiple = value.charAt(i);
            int digit = Character.digit(multiple, 16) * 16;
            if (digit < 0) {
                throw new NumberFormatException(MemoryMapMessages.memory_map_utils_error_invalid_hex_value);
            }
            bytes[index] = Integer.valueOf(digit += i + 1 < value.length() ? Character.digit(value.charAt(i + 1), 16) : 0).byteValue();
            ++index;
            i += 2;
        }
        return bytes;
    }

    private String convertByteArrayToHexString(MemoryByte[] byteArray, String paddedStr) {
        Object sRetVal = "";
        char[] charArray = new char[2];
        int i = 0;
        while (i < byteArray.length) {
            if ((byteArray[i].getFlags() & 2) == 0) {
                sRetVal = (String)sRetVal + paddedStr;
                sRetVal = (String)sRetVal + " ";
            } else {
                int val = byteArray[i].getValue();
                if (val < 0) {
                    val += 256;
                }
                charArray[0] = Character.forDigit(val / 16, 16);
                charArray[1] = Character.forDigit(val % 16, 16);
                sRetVal = (String)sRetVal + new String(charArray).toUpperCase();
                sRetVal = (String)sRetVal + " ";
            }
            ++i;
        }
        return sRetVal;
    }

    private String convertByteArrayToBitString(MemoryByte[] byteArray, String paddedStr) {
        Object sRetVal = "";
        int i = 0;
        while (i < byteArray.length) {
            if ((byteArray[i].getFlags() & 2) == 0) {
                Object invalid = "";
                int j = 0;
                while (j < 8) {
                    invalid = (String)invalid + paddedStr;
                    ++j;
                }
                sRetVal = (String)sRetVal + (String)invalid;
            } else {
                Object s;
                int val = byteArray[i].getValue();
                if (val < 0) {
                    val += 256;
                }
                if (((String)(s = Integer.toBinaryString(val))).length() < 8) {
                    s = "00000000".substring(1, 8 - ((String)s).length() + 1) + (String)s;
                }
                sRetVal = (String)sRetVal + (String)s;
            }
            ++i;
        }
        return sRetVal;
    }

    private byte[] convertBitStringToByteArray(String bitString) {
        byte[] bytes = new byte[bitString.length() / 8];
        int i = 0;
        while (i < bytes.length) {
            String binString = bitString.substring(i * 8, i * 8 + 8);
            bytes[i] = Integer.valueOf(Integer.parseInt(binString, 2)).byteValue();
            ++i;
        }
        return bytes;
    }

    private byte[] fillArray(byte[] array, int size, int endianess) {
        if (endianess == 0) {
            byte[] temp = new byte[size];
            int i = 0;
            while (i < array.length) {
                temp[i] = array[i];
                ++i;
            }
            i = array.length;
            while (i < size) {
                temp[i] = 0;
                ++i;
            }
            array = temp;
            return array;
        }
        byte[] temp = new byte[size];
        int i = 0;
        while (i < size - array.length) {
            temp[i] = 0;
            ++i;
        }
        int j = 0;
        int i2 = size - array.length;
        while (i2 < size) {
            temp[i2] = array[j];
            ++j;
            ++i2;
        }
        array = temp;
        return array;
    }

    private boolean readable(MemoryByte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            if ((bytes[i].getFlags() & 2) == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getString(String renderType, BigInteger address, MemoryByte[] data, String paddedStr) {
        if (data == null) {
            return MemoryMapLabels.MemoryMapRenderer_No_Data;
        }
        if (data.length == 0) {
            return "0x" + address.toString(16);
        }
        String dataType = "HEX";
        String displayType = "DEFAULT";
        StringTokenizer tokenizer = new StringTokenizer(renderType, ":");
        if (tokenizer.hasMoreTokens()) {
            dataType = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreElements()) {
            displayType = tokenizer.nextToken();
        }
        Object label = "";
        if (!(dataType.equals("HEX") || dataType.equals("BIT") || dataType.equals("BITMASK") || this.readable(data))) {
            int i = 0;
            while (i < data.length) {
                label = (String)label + paddedStr;
                if (displayType.equals("HEX")) {
                    label = (String)label + " ";
                }
                ++i;
            }
            return label;
        }
        if (MemoryMapUtils.isMixedEndianness(data) && (dataType.equals("16_BIT_INT") || dataType.equals("16_BIT_UINT") || dataType.equals("16_BIT_HINT") || dataType.equals("32_BIT_INT") || dataType.equals("32_BIT_UINT") || dataType.equals("32_BIT_HINT") || dataType.equals("32_BIT_FLOAT") || dataType.equals("64_BIT_INT") || dataType.equals("64_BIT_FLOAT"))) {
            int i = 0;
            while (i < data.length) {
                label = (String)label + paddedStr;
                ++i;
            }
            return label;
        }
        int endianess = 1;
        if (this.fRendering.getMemoryBlock() instanceof IMemoryBlockExtension) {
            endianess = data[0].isBigEndian() ? 1 : 0;
        }
        if (dataType.equals("16_BIT_INT")) {
            label = this.getStringForShort(data, paddedStr, displayType, endianess);
        } else if (dataType.equals("16_BIT_UINT")) {
            label = this.getStringForInteger(data, paddedStr, displayType, endianess);
        } else if (dataType.equals("16_BIT_HINT")) {
            label = this.getStringForInteger(data, paddedStr, displayType, endianess);
        } else if (dataType.equals("32_BIT_INT")) {
            label = this.getStringForInteger(data, paddedStr, displayType, endianess);
        } else if (dataType.equals("32_BIT_UINT")) {
            label = this.getStringForLong(data, paddedStr, displayType, endianess);
        } else if (dataType.equals("32_BIT_HINT")) {
            label = this.getStringForLong(data, paddedStr, displayType, endianess);
        } else if (dataType.equals("32_BIT_FLOAT")) {
            label = this.getStringForLong(data, paddedStr, displayType, endianess);
        } else if (dataType.equals("64_BIT_INT")) {
            label = this.getStringForLong(data, paddedStr, displayType, endianess);
        } else if (dataType.equals("64_BIT_FLOAT")) {
            label = this.getStringForLong(data, paddedStr, displayType, endianess);
        } else if (dataType.equals("CHARACTER")) {
            label = this.getStringForCharacters(data, paddedStr, displayType, endianess);
        } else if (dataType.equals("HEX")) {
            label = this.getStringForCharacters(data, paddedStr, displayType, endianess);
        } else if (dataType.equals("ASCII")) {
            label = this.getStringForCharacters(data, paddedStr, displayType, endianess);
        } else if (dataType.equals("EBCDIC")) {
            label = this.getStringForCharacters(data, paddedStr, displayType, endianess);
        } else if (dataType.equals("BITMASK")) {
            label = this.getStringForShort(data, paddedStr, displayType, endianess);
        } else if (dataType.equals("BIT")) {
            label = this.convertByteArrayToBitString(data, paddedStr);
        }
        return label;
    }

    private String getStringForCharacters(MemoryByte[] data, String paddedStr, String displayType, int endianess) {
        String label = displayType.equals("HEX") ? this.convertByteArrayToHexString(data, paddedStr) : (displayType.equals("ASCII") ? this.convertByteArrayToASCII(data) : (displayType.equals("EBCDIC") ? this.convertByteArrayToEBCDIC(data) : this.convertByteArrayToHexString(data, paddedStr)));
        return label;
    }

    private String getStringForShort(MemoryByte[] data, String paddedStr, String displayType, int endianess) {
        String label;
        if (displayType.equals("DECIMAL")) {
            label = Short.toString(this.convertByteArrayToShort(data, endianess));
        } else if (displayType.equals("HEX")) {
            if (endianess == 0) {
                data = this.reverseBytes(data);
            }
            label = this.convertByteArrayToHexString(data, paddedStr);
        } else if (displayType.equals("BINARY")) {
            if (endianess == 0) {
                data = this.reverseBytes(data);
            }
            label = this.convertByteArrayToBitString(data, paddedStr);
        } else {
            label = Short.toString(this.convertByteArrayToShort(data, endianess));
        }
        return label;
    }

    private String getStringForInteger(MemoryByte[] data, String paddedStr, String displayType, int endianess) {
        String label;
        if (displayType.equals("DECIMAL")) {
            label = Integer.toString(this.convertByteArrayToInt(data, endianess));
        } else if (displayType.equals("HEX")) {
            if (endianess == 0) {
                data = this.reverseBytes(data);
            }
            label = this.convertByteArrayToHexString(data, paddedStr);
        } else if (displayType.equals("BINARY")) {
            if (endianess == 0) {
                data = this.reverseBytes(data);
            }
            label = this.convertByteArrayToBitString(data, paddedStr);
        } else {
            label = Integer.toString(this.convertByteArrayToInt(data, endianess));
        }
        return label;
    }

    private String getStringForLong(MemoryByte[] data, String paddedStr, String displayType, int endianess) {
        String label;
        if (displayType.equals("DECIMAL")) {
            label = Long.toString(this.convertByteArrayToInt(data, endianess));
        } else if (displayType.equals("HEX")) {
            if (endianess == 0) {
                data = this.reverseBytes(data);
            }
            label = this.convertByteArrayToHexString(data, paddedStr);
        } else if (displayType.equals("BINARY")) {
            if (endianess == 0) {
                data = this.reverseBytes(data);
            }
            label = this.convertByteArrayToBitString(data, paddedStr);
        } else {
            label = Long.toString(this.convertByteArrayToInt(data, endianess));
        }
        return label;
    }

    private MemoryByte[] reverseBytes(MemoryByte[] input) {
        MemoryByte[] output = new MemoryByte[input.length];
        int j = 0;
        int i = input.length - 1;
        while (i >= 0) {
            output[j] = input[i];
            ++j;
            --i;
        }
        return output;
    }

    private byte[] reverseRawBytes(byte[] input) {
        byte[] output = new byte[input.length];
        int j = 0;
        int i = input.length - 1;
        while (i >= 0) {
            output[j] = input[i];
            ++j;
            --i;
        }
        return output;
    }

    public byte[] getBytes(MemoryMap selected, String expression) throws MemoryMapException {
        String renderType = selected.getType() + ":" + selected.getDisplayType();
        MemoryByte[] currentValues = null;
        try {
            currentValues = selected.getBytes();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        if (currentValues == null) {
            return null;
        }
        String dataType = "HEX";
        String displayType = "DEFAULT";
        StringTokenizer tokenizer = new StringTokenizer(renderType, ":");
        if (tokenizer.hasMoreTokens()) {
            dataType = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreElements()) {
            displayType = tokenizer.nextToken();
        }
        int endianess = 1;
        if (MemoryMapUtils.isMixedEndianness(currentValues) && (dataType.equals("16_BIT_INT") || dataType.equals("16_BIT_UINT") || dataType.equals("16_BIT_HINT") || dataType.equals("32_BIT_INT") || dataType.equals("32_BIT_UINT") || dataType.equals("32_BIT_HINT") || dataType.equals("32_BIT_FLOAT") || dataType.equals("64_BIT_INT") || dataType.equals("64_BIT_FLOAT"))) {
            throw new MemoryMapException("", MemoryMapLabels.MemoryMapConstants_13, selected.getLayout().getMappingFile(), 3);
        }
        if (this.fRendering.getMemoryBlock() instanceof IMemoryBlockExtension) {
            endianess = currentValues[0].isBigEndian() ? 1 : 0;
        }
        byte[] bytes = null;
        try {
            if (dataType.equals("16_BIT_INT")) {
                bytes = this.getBytesForShort(expression, displayType, endianess);
            } else if (dataType.equals("16_BIT_UINT")) {
                bytes = this.getBytesForInteger(expression, displayType, endianess);
                bytes = this.extractBytes(bytes, endianess, 2);
            } else if (dataType.equals("16_BIT_HINT")) {
                bytes = this.getBytesForInteger(expression, displayType, endianess);
                bytes = this.extractBytes(bytes, endianess, 2);
            } else if (dataType.equals("32_BIT_INT")) {
                bytes = this.getBytesForInteger(expression, displayType, endianess);
            } else if (dataType.equals("32_BIT_UINT")) {
                bytes = this.getBytesForLong(expression, displayType, endianess);
                bytes = this.extractBytes(bytes, endianess, 4);
            } else if (dataType.equals("32_BIT_HINT")) {
                bytes = this.getBytesForLong(expression, displayType, endianess);
                bytes = this.extractBytes(bytes, endianess, 4);
            } else if (dataType.equals("32_BIT_FLOAT")) {
                bytes = this.getBytesForLong(expression, displayType, endianess);
            } else if (dataType.equals("64_BIT_INT")) {
                bytes = this.getBytesForLong(expression, displayType, endianess);
            } else if (dataType.equals("64_BIT_FLOAT")) {
                bytes = this.getBytesForLong(expression, displayType, endianess);
            } else if (dataType.equals("CHARACTER")) {
                bytes = this.getBytesForCharacters(expression, displayType, endianess, currentValues);
            } else if (dataType.equals("HEX")) {
                bytes = this.getBytesForCharacters(expression, displayType, endianess, currentValues);
            } else if (dataType.equals("ASCII")) {
                bytes = this.getBytesForCharacters(expression, displayType, endianess, currentValues);
            } else if (dataType.equals("EBCDIC")) {
                bytes = this.getBytesForCharacters(expression, displayType, endianess, currentValues);
            } else if (dataType.equals("BITMASK")) {
                bytes = this.getBytesForShort(expression, displayType, endianess);
            } else if (dataType.equals("BIT")) {
                bytes = this.convertBitStringToByteArray(expression);
            }
        }
        catch (NumberFormatException e1) {
            return null;
        }
        return bytes;
    }

    private byte[] getBytesForShort(String data, String displayType, int endianess) {
        byte[] bytes = null;
        if (displayType.equals("DECIMAL")) {
            bytes = this.convertShortToByteArray(Short.parseShort(data), endianess);
        } else if (displayType.equals("HEX")) {
            bytes = this.convertHexStringToByteArray(data);
            if (endianess == 0) {
                bytes = this.reverseRawBytes(bytes);
            }
        } else if (displayType.equals("BINARY")) {
            bytes = this.convertBitStringToByteArray(data);
            if (endianess == 0) {
                bytes = this.reverseRawBytes(bytes);
            }
        } else {
            bytes = this.convertShortToByteArray(Short.parseShort(data), endianess);
        }
        return bytes;
    }

    private byte[] getBytesForInteger(String data, String displayType, int endianess) {
        byte[] bytes = null;
        if (displayType.equals("DECIMAL")) {
            bytes = this.convertIntToByteArray(Integer.parseInt(data), endianess);
        } else if (displayType.equals("HEX")) {
            bytes = this.convertHexStringToByteArray(data);
            if (endianess == 0) {
                bytes = this.reverseRawBytes(bytes);
            }
        } else if (displayType.equals("BINARY")) {
            bytes = this.convertBitStringToByteArray(data);
            if (endianess == 0) {
                bytes = this.reverseRawBytes(bytes);
            }
        } else {
            bytes = this.convertIntToByteArray(Integer.parseInt(data), endianess);
        }
        return bytes;
    }

    private byte[] getBytesForLong(String data, String displayType, int endianess) {
        byte[] bytes = null;
        if (displayType.equals("DECIMAL")) {
            bytes = this.convertLongToByteArray(Long.parseLong(data), endianess);
        } else if (displayType.equals("HEX")) {
            bytes = this.convertHexStringToByteArray(data);
            if (endianess == 0) {
                bytes = this.reverseRawBytes(bytes);
            }
        } else if (displayType.equals("BINARY")) {
            bytes = this.convertBitStringToByteArray(data);
            if (endianess == 0) {
                bytes = this.reverseRawBytes(bytes);
            }
        } else {
            bytes = this.convertLongToByteArray(Long.parseLong(data), endianess);
        }
        return bytes;
    }

    private byte[] extractBytes(byte[] bytes, int endianess, int numBytes) {
        if (numBytes > bytes.length) {
            throw new NumberFormatException();
        }
        if (endianess == 1) {
            int i = 0;
            while (i < numBytes) {
                if (bytes[i] != 0) {
                    throw new NumberFormatException();
                }
                ++i;
            }
            byte[] copy = new byte[numBytes];
            int j = 0;
            int k = bytes.length - numBytes;
            while (j < copy.length && k < bytes.length) {
                copy[j] = bytes[k];
                ++j;
                ++k;
            }
            bytes = copy;
        } else {
            int i = numBytes;
            while (i < bytes.length) {
                if (bytes[i] != 0) {
                    throw new NumberFormatException();
                }
                ++i;
            }
            byte[] copy = new byte[numBytes];
            int j = 0;
            while (j < copy.length) {
                copy[j] = bytes[j];
                ++j;
            }
            bytes = copy;
        }
        return bytes;
    }

    private byte[] getBytesForCharacters(String data, String displayType, int endianess, MemoryByte[] currentValues) {
        byte[] bytes = null;
        bytes = displayType.equals("ASCII") ? this.convertEncodingToByteArray(data, this.asciiCodePage, currentValues) : (displayType.equals("HEX") ? this.convertHexStringToByteArray(data) : (displayType.equals("EBCDIC") ? this.convertEncodingToByteArray(data, this.ebcdicCodePage, currentValues) : this.convertHexStringToByteArray(data)));
        return bytes;
    }

    public void updateASCIICodePage() {
        this.asciiCodePage = DebugUITools.getPreferenceStore().getString("org.eclipse.debug.ui.defaultAsciiCodePage");
    }

    public void updateEBCDICCodePage() {
        this.ebcdicCodePage = DebugUITools.getPreferenceStore().getString("org.eclipse.debug.ui.defaultEbcdicCodePage");
    }
}

