/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.dialogs;

import com.ibm.debug.memorymap.MemoryMapPlugin;
import com.ibm.debug.memorymap.utils.MemoryMapConstants;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapMessages;
import com.ibm.debug.memorymap.utils.MemoryMapUtils;
import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.rsecommon.IBrowseDialogDelegate;
import com.ibm.debug.pdt.rsecommon.IRemoteFileMgr;
import com.ibm.debug.pdt.rsecommon.RSECommonPlugin;
import com.ibm.debug.pdt.rsecommon.RSELabels;
import com.ibm.debug.pdt.rsecommon.RSEMessages;
import com.ibm.debug.pdt.rsecommon.RSEUtils;
import java.io.File;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MemoryMapPreferencepage
extends PreferencePage {
    private static final BigInteger MIN_SIZE = new BigInteger("25");
    private static final Object fLock = new Object();
    private String fLocation;
    private Text fLocationText;
    private IBrowseDialogDelegate fRemoteBrowseDialog = null;
    private boolean remoteBrowseEnabled = false;
    private String fConnection;
    private String fProfile;
    private Combo connectionList;
    private Combo profileList;
    private IRemoteFileMgr remoteFileMgr;
    private Text fMinBlockSize;
    private Text fMaxBlockSize;
    private Button[] fCheckBoxes;
    private static final int NUMBER_OF_BUTTONS = 5;

    public MemoryMapPreferencepage() {
        this(null);
    }

    public MemoryMapPreferencepage(String title) {
        super(title);
        IPreferenceStore store = MemoryMapPlugin.getInstance().getPreferenceStore();
        this.setPreferenceStore(store);
        if (store != null) {
            this.fLocation = store.getString("com.ibm.debug.memorymap.memoryMapLocation");
            this.fProfile = store.getString("com.ibm.debug.memorymap.profile_name");
            this.fConnection = store.getString("com.ibmm.debug.memorymap.conn_name");
            if (this.fLocation.length() == 0) {
                this.fLocation = MemoryMapLabels.MemoryMapLocationDialog_Specify_Directory;
            }
        }
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.debug.memorymap.MemoryMapPreferenceDialog_context");
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.verticalSpacing = 6;
        parent.setLayout((Layout)gridLayout);
        this.getShell().setText(MemoryMapLabels.MemoryMapPreferences_3);
        Button browseButton = null;
        this.remoteFileMgr = RSECommonPlugin.getRemoteFileMgr();
        if (this.remoteFileMgr != null) {
            String[] localProfile;
            this.remoteBrowseEnabled = true;
            Group group = new Group(parent, 0);
            group.setText(MemoryMapLabels.MemoryMapPreferences_4);
            Label profileLabel = new Label((Composite)group, 0);
            profileLabel.setText(RSELabels.Profile);
            this.profileList = new Combo((Composite)group, 12);
            Label connectionLabel = new Label((Composite)group, 0);
            connectionLabel.setText(RSELabels.Connection);
            this.connectionList = new Combo((Composite)group, 12);
            if ((this.fProfile.length() == 0 || this.fConnection.length() == 0) && (localProfile = this.remoteFileMgr.getAnyLocalConnection()) != null) {
                this.fProfile = localProfile[0];
                this.fConnection = localProfile[1];
            }
            this.updateSelection(this.remoteFileMgr.getAvailableProfiles());
            this.profileList.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int index = MemoryMapPreferencepage.this.profileList.getSelectionIndex();
                    if (index <= 0) {
                        MemoryMapPreferencepage.this.connectionList.setEnabled(false);
                        if (MemoryMapPreferencepage.this.profileList.getItems().length > 1) {
                            MemoryMapPreferencepage.this.connectionList.select(0);
                            return;
                        }
                    } else {
                        MemoryMapPreferencepage.this.connectionList.setEnabled(true);
                    }
                    MemoryMapPreferencepage.this.fProfile = MemoryMapPreferencepage.this.profileList.getItem(index);
                    MemoryMapPreferencepage.this.updateSelection(MemoryMapPreferencepage.this.remoteFileMgr.getAvailableProfiles());
                }
            });
            Label label = new Label((Composite)group, 0);
            label.setText(RSELabels.ChooseRemoteDir);
            this.fLocationText = new Text((Composite)group, 2052);
            browseButton = new Button((Composite)group, 0);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        } else {
            Label textLabel = new Label(parent, 0);
            textLabel.setText(MemoryMapLabels.MemoryMapPreferences_4 + ":");
            GridData textLayout = new GridData(768);
            textLayout.verticalAlignment = 2;
            textLayout.horizontalAlignment = 1;
            textLayout.horizontalSpan = 1;
            textLabel.setLayoutData((Object)textLayout);
            this.fLocationText = new Text(parent, 2052);
            browseButton = new Button(parent, 0);
        }
        this.fLocationText.setText(this.fLocation);
        this.fLocationText.setSelection(0, this.fLocation.length());
        GridData spec = new GridData(768);
        spec.grabExcessVerticalSpace = false;
        spec.grabExcessHorizontalSpace = false;
        spec.horizontalAlignment = 1;
        spec.verticalAlignment = 1;
        spec.horizontalSpan = 2;
        spec.verticalSpan = 1;
        spec.widthHint = 250;
        this.fLocationText.setLayoutData((Object)spec);
        browseButton.setText(MemoryMapLabels.MemoryMapLocationDialog_Browse);
        GridData specButton = new GridData();
        specButton.horizontalAlignment = 3;
        specButton.verticalAlignment = 2;
        specButton.horizontalSpan = 2;
        specButton.verticalSpan = 3;
        browseButton.setLayoutData((Object)specButton);
        Label l = new Label(parent, 0);
        l.setText(MemoryMapLabels.MemoryMapPreferences_BlkSzMin);
        this.fMinBlockSize = new Text(parent, 2052);
        this.fMinBlockSize.setText(this.getPreferenceStore().getString("com.ibm.debug.memorymap.mbsz"));
        GridData blkData = new GridData();
        blkData.horizontalAlignment = 4;
        blkData.grabExcessHorizontalSpace = true;
        this.fMinBlockSize.setLayoutData((Object)blkData);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String error = null;
                try {
                    BigInteger min = new BigInteger(MemoryMapPreferencepage.this.fMinBlockSize.getText());
                    BigInteger max = new BigInteger(MemoryMapPreferencepage.this.fMaxBlockSize.getText());
                    if (min.compareTo(MIN_SIZE) < 0 || min.compareTo(max) > 0) {
                        error = NLS.bind((String)MemoryMapMessages.MemoryMapPreferences_BlkSzError1, (Object)max);
                    }
                    if (max.compareTo(min) < 0 || max.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) >= 0) {
                        error = NLS.bind((String)MemoryMapMessages.MemoryMapPreferences_BlkSzError2, (Object)"20000", (Object)min);
                    }
                }
                catch (NumberFormatException nfe) {
                    error = MemoryMapMessages.MemoryMapPreferences_BlkSzError3;
                }
                MemoryMapPreferencepage.this.setErrorMessage(error);
                MemoryMapPreferencepage.this.setValid(error == null);
            }
        };
        l = new Label(parent, 0);
        l.setText(MemoryMapLabels.MemoryMapPreferences_BlkSzMax);
        this.fMaxBlockSize = new Text(parent, 2052);
        this.fMaxBlockSize.setText(this.getPreferenceStore().getString("com.ibm.debug.memorymap.mxsz"));
        blkData = new GridData();
        blkData.horizontalAlignment = 4;
        blkData.grabExcessHorizontalSpace = true;
        this.fMaxBlockSize.setLayoutData((Object)blkData);
        this.fMinBlockSize.addModifyListener(modifyListener);
        this.fMaxBlockSize.addModifyListener(modifyListener);
        this.fCheckBoxes = new Button[5];
        String[] checkBoxLabels = new String[]{MemoryMapLabels.MemoryMapPreferences_0, MemoryMapLabels.MemoryMapPreferences_5, MemoryMapLabels.MemoryMapPreferences_6, MemoryMapLabels.MemoryMapPreferences_8, MemoryMapLabels.MemoryMapPreferences_7};
        String[] preferenceKeys = new String[]{"com.ibm.debug.memorymap.removeAllConfirm", "com.ibm.debug.memorymap.rebuild_prompt", "com.ibm.debug.memorymap.do_export", "com.ibm.debug.memormymap.autobuild", "com.ibm.debug.memorymap.warn"};
        int i = 0;
        while (i < 5) {
            this.fCheckBoxes[i] = new Button(parent, 32);
            this.fCheckBoxes[i].setText(checkBoxLabels[i]);
            this.fCheckBoxes[i].setData((Object)preferenceKeys[i]);
            this.fCheckBoxes[i].setSelection(this.getPreferenceStore().getBoolean(preferenceKeys[i]));
            ++i;
        }
        Label filler = new Label(parent, 0);
        filler.setText(" ");
        GridData fillerData = new GridData(1040);
        fillerData.horizontalSpan = 2;
        fillerData.verticalSpan = 45;
        filler.setLayoutData((Object)fillerData);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MemoryMapPreferencepage.this.fRemoteBrowseDialog == null) {
                    MemoryMapPreferencepage.this.fRemoteBrowseDialog = RSECommonPlugin.getRemoteBrowseDialog();
                }
                String newText = null;
                if (MemoryMapPreferencepage.this.fRemoteBrowseDialog != null) {
                    newText = MemoryMapPreferencepage.this.openRemoteBrowseDialog();
                } else {
                    DirectoryDialog dirDialog = new DirectoryDialog(CommonUtils.getShell());
                    dirDialog.setMessage(MemoryMapLabels.MemoryMapLocationDialog_Specify_Directory_Message);
                    newText = dirDialog.open();
                }
                if (newText != null) {
                    MemoryMapPreferencepage.this.fLocationText.setText(newText);
                }
            }
        });
        return this.fLocationText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performOk() {
        String text;
        int i = 0;
        while (i < 5) {
            this.getPreferenceStore().setValue((String)this.fCheckBoxes[i].getData(), this.fCheckBoxes[i].getSelection());
            ++i;
        }
        String newLocation = this.fLocationText.getText().trim();
        if (newLocation != null && newLocation.length() > 0) {
            boolean isRemote = false;
            if (this.remoteBrowseEnabled) {
                int profileIndex = this.profileList.getSelectionIndex();
                int connIndex = this.connectionList.getSelectionIndex();
                if (profileIndex <= 0 || connIndex <= 0) {
                    if (!this.validateLocalFile(newLocation)) {
                        return false;
                    }
                    isRemote = false;
                } else {
                    this.fProfile = this.profileList.getItem(profileIndex);
                    this.fConnection = this.connectionList.getItem(connIndex);
                    boolean selectionIsValid = this.remoteFileMgr.validateDirectory(this.fProfile, this.fConnection, newLocation);
                    boolean bl = isRemote = !this.remoteFileMgr.isConnectionLocal(this.fProfile, this.fConnection);
                    if (!selectionIsValid) {
                        Status status = new Status(4, "com.ibm.debug.memorymap", 4, NLS.bind((String)RSEMessages.RemoteDirNotFound, (Object[])new String[]{newLocation, this.fConnection}), null);
                        Shell shell = CommonUtils.getShell();
                        ErrorDialog.openError((Shell)shell, (String)MemoryMapMessages.MemoryMapLocationDialog_Set_Directory_Failed, (String)MemoryMapMessages.MemoryMapLocationDialog_Unable_to_save_directory, (IStatus)status);
                        return false;
                    }
                }
            } else if (!this.validateLocalFile(newLocation)) {
                return false;
            }
            MemoryMapPlugin.getInstance().getPreferenceStore().setValue("com.ibmm.debug.memorymap.conn_name", this.fConnection);
            MemoryMapPlugin.getInstance().getPreferenceStore().setValue("com.ibm.debug.memorymap.profile_name", this.fProfile);
            MemoryMapPlugin.getInstance().getPreferenceStore().setValue("map_location_is_remote", isRemote);
            MemoryMapPlugin.getInstance().getPreferenceStore().setValue("com.ibm.debug.memorymap.memoryMapLocation", newLocation);
        }
        if ((text = this.fMinBlockSize.getText().trim()).length() == 0) {
            text = "0";
        }
        Object object = fLock;
        synchronized (object) {
            MemoryMapConstants.MIN_BLOCK_SIZE = Integer.parseInt(text);
            text = this.fMaxBlockSize.getText().trim();
            if (text.length() == 0) {
                text = "0";
            }
            MemoryMapConstants.MAX_BLOCK_SIZE = Integer.parseInt(text);
        }
        this.getPreferenceStore().setValue("com.ibm.debug.memorymap.mbsz", MemoryMapConstants.MIN_BLOCK_SIZE);
        this.getPreferenceStore().setValue("com.ibm.debug.memorymap.mxsz", MemoryMapConstants.MAX_BLOCK_SIZE);
        return super.performOk();
    }

    private boolean validateLocalFile(String newLocation) {
        this.fConnection = "";
        this.fProfile = "";
        File file = new File(newLocation);
        if (!file.exists() || !file.isDirectory()) {
            Status status = new Status(4, "com.ibm.debug.memorymap", 4, NLS.bind((String)MemoryMapMessages.MemoryMapLocationDialog_Directory_Does_Not_Exist, (Object)newLocation), null);
            Shell shell = CommonUtils.getShell();
            ErrorDialog.openError((Shell)shell, (String)MemoryMapMessages.MemoryMapLocationDialog_Set_Directory_Failed, (String)MemoryMapMessages.MemoryMapLocationDialog_Unable_to_save_directory, (IStatus)status);
            return false;
        }
        return true;
    }

    protected void performDefaults() {
        String defaultLocation = MemoryMapUtils.getDefaultMapLocation();
        this.fConnection = "";
        this.fProfile = "";
        if (this.remoteBrowseEnabled) {
            String[] localProfile = this.remoteFileMgr.getAnyLocalConnection();
            if (localProfile != null) {
                this.fProfile = localProfile[0];
                this.fConnection = localProfile[1];
            }
            this.profileList.select(this.profileList.indexOf(this.fProfile));
            this.connectionList.select(this.connectionList.indexOf(this.fConnection));
            this.connectionList.setEnabled(true);
            this.profileList.setEnabled(true);
        }
        this.fLocationText.setText(defaultLocation);
        this.fLocation = defaultLocation;
        int i = 0;
        while (i < 5) {
            if (i != 2) {
                this.fCheckBoxes[i].setSelection(true);
            } else {
                this.fCheckBoxes[i].setSelection(false);
            }
            ++i;
        }
        super.performDefaults();
        this.fMinBlockSize.setText(Integer.toString(MemoryMapConstants.MIN_BLOCK_SIZE));
        this.fMaxBlockSize.setText(Integer.toString(MemoryMapConstants.MAX_BLOCK_SIZE));
    }

    private void updateSelection(HashMap<String, String[]> map) {
        Object[] profiles = map.keySet().toArray(new String[0]);
        if (profiles.length > 0) {
            Arrays.sort(profiles);
            this.profileList.setItems((String[])profiles);
            this.profileList.add(RSELabels.SelectProfile, 0);
            Object[] connections = map.get(this.fProfile);
            this.connectionList.removeAll();
            if (connections != null) {
                this.profileList.select(this.profileList.indexOf(this.fProfile));
                if (connections.length > 0) {
                    Arrays.sort(connections);
                    this.connectionList.setItems((String[])connections);
                    this.connectionList.add(RSELabels.SelectConnection, 0);
                    this.connectionList.select(0);
                    this.connectionList.select(this.connectionList.indexOf(this.fConnection));
                    this.connectionList.setEnabled(true);
                } else {
                    this.connectionList.setItems(new String[]{RSELabels.NoConnections});
                    this.connectionList.select(0);
                }
            }
        } else {
            this.profileList.setItems(new String[]{RSELabels.NoProfiles});
            this.profileList.select(0);
            this.connectionList.setEnabled(false);
        }
    }

    private String openRemoteBrowseDialog() {
        HashMap selectionInfo;
        String newDirectory = null;
        if (this.profileList.getSelectionIndex() > 0) {
            this.fProfile = this.profileList.getItem(this.profileList.getSelectionIndex());
            if (this.connectionList.getSelectionIndex() > 0) {
                this.fConnection = this.connectionList.getItem(this.connectionList.getSelectionIndex());
            }
            this.fRemoteBrowseDialog.setDefaultConnection(this.fProfile, this.fConnection);
        }
        if (this.fRemoteBrowseDialog.open(true, null) == 0 && (newDirectory = (String)(selectionInfo = this.fRemoteBrowseDialog.getSelectionInfo()).get(RSEUtils.DIRECTORY)) != null) {
            this.fConnection = (String)selectionInfo.get(RSEUtils.CONNECTION);
            this.fProfile = (String)selectionInfo.get(RSEUtils.PROFILE);
        }
        this.updateSelection(this.remoteFileMgr.getAvailableProfiles());
        return newDirectory;
    }
}

