/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.dialogs;

import com.ibm.debug.memorymap.AbstractMemoryMapRendering;
import com.ibm.debug.memorymap.MemoryMapPlugin;
import com.ibm.debug.memorymap.actions.AutoExportAction;
import com.ibm.debug.memorymap.dialogs.ResizeableConfirmationDialog;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapMessages;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ManageGroupsDialog
extends DebugTrayDialog {
    private static final String DIALOG_ID = "com.ibm.debug.memorymap.ChangeTextFileAction";
    private AbstractMemoryMapRendering fRendering;
    private Text newGroupText = null;
    private Button addButton = null;
    private List groupList = null;
    private Label groupListLabel = null;
    private Button removeButton = null;
    private Button removeAllButton = null;
    private static final int defaultButtonWidth = 83;

    public ManageGroupsDialog(Shell shell, AbstractMemoryMapRendering rendering) {
        super(shell);
        this.fRendering = rendering;
        this.setShellStyle(34928);
    }

    protected Control createDialogArea(Composite parent) {
        super.createDialogArea(parent);
        Composite composite = (Composite)super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.debug.memorymap.ManageGroupsDialog_context");
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        Label groupName = new Label(composite, 0);
        groupName.setText(MemoryMapLabels.ManageGroupDialog_1);
        groupName.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 1, 1));
        this.newGroupText = new Text(composite, 2048);
        this.newGroupText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.newGroupText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    ManageGroupsDialog.this.performAddGroup();
                }
            }
        });
        this.addButton = new Button(composite, 0x1000000);
        this.addButton.setText(MemoryMapLabels.ManageGroupDialog_2);
        StringBuffer label = new StringBuffer("   ");
        this.addButton.setText(label.append(MemoryMapLabels.ManageGroupDialog_2).append("   ").toString());
        GridData data = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        data.widthHint = Math.max(83, this.addButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.addButton.setLayoutData((Object)data);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManageGroupsDialog.this.performAddGroup();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.groupListLabel = new Label(composite, 0);
        this.groupListLabel.setText(MemoryMapLabels.ManageGroupDialog_3);
        this.groupListLabel.setLayoutData((Object)new GridData(16384, 1024, false, false, 3, 1));
        this.groupList = new List(composite, 2818);
        data = new GridData(4, 4, true, true, 2, 2);
        data.heightHint = 50;
        data.widthHint = 100;
        this.groupList.setLayoutData((Object)data);
        this.removeButton = new Button(composite, 0x1000000);
        this.removeButton.setText(MemoryMapLabels.ManageGroupDialog_4);
        label = new StringBuffer("   ");
        this.removeButton.setText(label.append(MemoryMapLabels.ManageGroupDialog_4).append("   ").toString());
        data = new GridData(0x1000000, 128, false, false, 1, 1);
        data.widthHint = Math.max(83, this.removeButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManageGroupsDialog.this.groupList.remove(ManageGroupsDialog.this.groupList.getSelectionIndices());
                if (ManageGroupsDialog.this.groupList.getItemCount() == 0) {
                    ManageGroupsDialog.this.removeButton.setEnabled(false);
                    ManageGroupsDialog.this.removeAllButton.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeAllButton = new Button(composite, 0x1000000);
        label = new StringBuffer("   ");
        this.removeAllButton.setText(label.append(MemoryMapLabels.ManageGroupDialog_5).append("   ").toString());
        data = new GridData(0x1000000, 128, false, false, 1, 1);
        data.widthHint = Math.max(83, this.removeAllButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.removeAllButton.setLayoutData((Object)data);
        this.removeAllButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ManageGroupsDialog.this.groupList.getItemCount() == 0) {
                    return;
                }
                if (MemoryMapPlugin.getInstance().getPreferenceStore().getBoolean("com.ibm.debug.memorymap.removeAllConfirm")) {
                    ResizeableConfirmationDialog prompt = new ResizeableConfirmationDialog(ManageGroupsDialog.this.getShell(), MemoryMapLabels.RemoveAllGroupsDialog_0, null, MemoryMapLabels.RemoveAllGroupsDialog_1, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1, MemoryMapLabels.RemoveAllGroupsDialog_4, false);
                    if (prompt.open() < 0) {
                        return;
                    }
                    MemoryMapPlugin.getInstance().getPreferenceStore().setValue("com.ibm.debug.memorymap.removeAllConfirm", !prompt.getToggleState());
                    if (prompt.getReturnCode() == 2) {
                        ManageGroupsDialog.this.groupList.removeAll();
                        ManageGroupsDialog.this.removeButton.setEnabled(false);
                        ManageGroupsDialog.this.removeAllButton.setEnabled(false);
                    }
                } else {
                    ManageGroupsDialog.this.groupList.removeAll();
                    ManageGroupsDialog.this.removeButton.setEnabled(false);
                    ManageGroupsDialog.this.removeAllButton.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.getShell().setText(MemoryMapLabels.ManageGroupDialog_0);
        Iterator<String> iter = this.fRendering.getGroups();
        while (iter.hasNext()) {
            this.groupList.add(iter.next());
        }
        this.removeButton.setEnabled(this.groupList.getItemCount() > 0);
        this.removeAllButton.setEnabled(this.groupList.getItemCount() > 0);
        composite.pack(true);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 2, IDialogConstants.CANCEL_LABEL, false);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings ds = MemoryMapPlugin.getInstance().getDialogSettings();
        if (ds != null && ds.getSection(DIALOG_ID) == null) {
            return ds.addNewSection(DIALOG_ID);
        }
        return ds;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            this.okPressed();
        } else if (buttonId == 2) {
            this.cancelPressed();
        }
    }

    protected void okPressed() {
        String[] groups = this.groupList.getItems();
        boolean modified = false;
        Iterator<String> iter = this.fRendering.getGroups();
        ArrayList<String> groupsToRemove = new ArrayList<String>();
        while (iter.hasNext()) {
            String group = iter.next();
            boolean deleted = true;
            int i = 0;
            while (deleted && i < groups.length) {
                if (group.equals(groups[i])) {
                    deleted = false;
                }
                ++i;
            }
            if (!deleted) continue;
            groupsToRemove.add(group);
            modified = true;
        }
        int i = 0;
        while (i < groupsToRemove.size()) {
            this.fRendering.removeGroup(((String)groupsToRemove.get(i)).toString());
            ++i;
        }
        i = 0;
        while (i < groups.length) {
            if (this.fRendering.addGroup(groups[i])) {
                modified = true;
            }
            ++i;
        }
        if (groups.length == 0) {
            this.fRendering.setCurrentGroup(null);
        } else {
            boolean removed = true;
            int i2 = 0;
            while (removed && i2 < groups.length) {
                if (groups[i2].equals(this.fRendering.getCurrentGroup())) {
                    removed = false;
                }
                ++i2;
            }
            if (removed) {
                this.fRendering.setCurrentGroup(null);
            }
        }
        super.okPressed();
        if (modified) {
            try {
                new AutoExportAction(this.fRendering, this.fRendering.getAllLayouts(false, true)).run();
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
    }

    private void performAddGroup() {
        String newGroup = this.newGroupText.getText();
        if (newGroup.length() == 0) {
            return;
        }
        String[] groups = newGroup.split(",");
        int i = 0;
        while (i < groups.length) {
            this.addGroup(groups[i].trim());
            ++i;
        }
        this.newGroupText.setText("");
        this.removeButton.setEnabled(this.groupList.getItemCount() > 0);
        this.removeAllButton.setEnabled(this.groupList.getItemCount() > 0);
    }

    private void addGroup(String group) {
        if (group.length() == 0) {
            return;
        }
        if (group.equalsIgnoreCase("ALL")) {
            String title = NLS.bind((String)MemoryMapMessages.MultiSelectMenu_8, (Object)group);
            ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)new Status(4, "com.ibm.debug.memorymap", 0, NLS.bind((String)MemoryMapMessages.MultiSelectMenu_5, (Object)group), null));
            return;
        }
        String[] existingGroups = this.groupList.getItems();
        int i = 0;
        while (i < existingGroups.length) {
            if (existingGroups[i].equals(group)) {
                String title = NLS.bind((String)MemoryMapMessages.MultiSelectMenu_8, (Object)group);
                ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)new Status(4, "com.ibm.debug.memorymap", 0, NLS.bind((String)MemoryMapMessages.MultiSelectMenu_6, (Object)group), null));
                return;
            }
            ++i;
        }
        String[] groups = this.groupList.getItems();
        int i2 = 0;
        while (i2 < groups.length) {
            if (group.compareTo(groups[i2]) < 0) break;
            ++i2;
        }
        this.groupList.add(group, i2);
    }
}

