/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.dialogs;

import com.ibm.debug.memorymap.MapElement;
import com.ibm.debug.memorymap.MemoryMap;
import com.ibm.debug.memorymap.MemoryMapPartitionElement;
import com.ibm.debug.memorymap.MemoryMapPlugin;
import com.ibm.debug.memorymap.MemoryMapRendering;
import com.ibm.debug.memorymap.actions.BuildMapAction;
import com.ibm.debug.memorymap.dialogs.ExpansionErrorDialog;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.views.FindDialogLabelProvider;
import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class FindFieldDialog
extends DebugTrayDialog {
    private static final String SETTINGSSECTION = "com.ibm.debug.memorymap.find_dialog";
    private MapElement[] fCurrentlyDisplayedMaps;
    private DetailViewer fDetailViewer;
    private Text searchQuery;
    private FindDialogLabelProvider fLabelProvider;
    private MapElement[] fMapElements;
    private MemoryMapRendering fRendering;
    private IPreferenceStore fStore;
    private List<Object> fUnbuiltElements;
    private String fLastSearchFilter;
    private MapElement fResult;
    private int fSearchColumn = 0;
    private int fSortDirection = 128;
    private int fSortColumnIndex = 0;
    private Table fTable;
    private TableColumn fDescCol;
    private TableColumn fPathCol;
    private TableColumn fGroupCol;
    private TableColumn fFieldCol;
    private Combo fSearchTypeCombo;
    private String[] columnLabels;
    public static final int FIELD_COL_INDEX = 0;
    public static final int DESC_COL_INDEX = 1;
    public static final int PATH_COL_INDEX = 2;
    public static final int GROUP_COL_INDEX = 3;

    public FindFieldDialog(Shell parent, FindDialogLabelProvider labelProvider, MemoryMapRendering rendering) {
        super(parent);
        this.fLabelProvider = labelProvider;
        this.fRendering = rendering;
        this.fStore = MemoryMapPlugin.getInstance().getPreferenceStore();
        this.setShellStyle(34928);
    }

    public Control createDialogArea(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        dialogArea.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        dialogArea.setLayoutData((Object)data);
        Label label = new Label(dialogArea, 0);
        label.setText(MemoryMapLabels.FindFieldDialog_2);
        this.fSearchTypeCombo = new Combo(dialogArea, 12);
        GridData selectComboData = new GridData(1);
        this.fSearchTypeCombo.setLayoutData((Object)selectComboData);
        this.columnLabels = new String[]{MemoryMapLabels.FieldColumnHeader, MemoryMapLabels.DescColumnHeader, MemoryMapLabels.PathColumnHeader, MemoryMapLabels.GroupColumnHeader};
        this.fSearchTypeCombo.setItems(this.columnLabels);
        this.fSearchTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String filterType = FindFieldDialog.this.fSearchTypeCombo.getItem(FindFieldDialog.this.fSearchTypeCombo.getSelectionIndex());
                int i = 0;
                while (i < FindFieldDialog.this.columnLabels.length) {
                    if (filterType.equals(FindFieldDialog.this.columnLabels[i])) {
                        FindFieldDialog.this.fSearchColumn = i;
                        break;
                    }
                    ++i;
                }
                FindFieldDialog.this.getElements(false);
                FindFieldDialog.this.sort(false);
                String currentSearch = FindFieldDialog.this.searchQuery.getText();
                if (currentSearch.length() > 0) {
                    FindFieldDialog.this.search(currentSearch);
                }
            }
        });
        Button columnSelect = new Button(dialogArea, 8);
        GridData columnSelectData = new GridData();
        columnSelect.setText(MemoryMapLabels.FindFieldDialog_11);
        columnSelectData.horizontalAlignment = 1;
        columnSelect.setLayoutData((Object)columnSelectData);
        columnSelect.addSelectionListener((SelectionListener)new ColumnSelectListener());
        label = new Label(dialogArea, 0);
        label.setText(MemoryMapLabels.find_field_action_dialog_message);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        this.searchQuery = new Text(dialogArea, 2052);
        this.searchQuery.setLayoutData((Object)new GridData(4, 4, true, false));
        this.searchQuery.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String filter = FindFieldDialog.this.searchQuery.getText();
                FindFieldDialog.this.search(filter);
            }
        });
        this.searchQuery.setFocus();
        this.fTable = new Table(dialogArea, 268503044);
        this.fFieldCol = new TableColumn(this.fTable, 18432);
        this.fFieldCol.setText(MemoryMapLabels.FieldColumnHeader);
        this.fDescCol = new TableColumn(this.fTable, 18432);
        this.fDescCol.setText(MemoryMapLabels.DescColumnHeader);
        this.fPathCol = new TableColumn(this.fTable, 18432);
        this.fPathCol.setText(MemoryMapLabels.PathColumnHeader);
        this.fGroupCol = new TableColumn(this.fTable, 18432);
        this.fGroupCol.setText(MemoryMapLabels.GroupColumnHeader);
        this.fTable.setLinesVisible(true);
        this.fTable.setHeaderVisible(true);
        Listener tableUpdateListener = new Listener(){

            public void handleEvent(Event event) {
                TableItem tableItem = (TableItem)event.item;
                int i = event.index;
                if (i < FindFieldDialog.this.fCurrentlyDisplayedMaps.length) {
                    MapElement selectedMap = FindFieldDialog.this.fCurrentlyDisplayedMaps[i];
                    FindFieldDialog.this.setupSingleRow(tableItem, selectedMap);
                }
            }
        };
        this.fTable.addListener(36, tableUpdateListener);
        SelectionAdapter sortListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableColumn column = (TableColumn)e.widget;
                FindFieldDialog.this.fSortColumnIndex = FindFieldDialog.this.fTable.indexOf(column);
                FindFieldDialog.this.fSortDirection = FindFieldDialog.this.fTable.getSortDirection();
                FindFieldDialog.this.sort(true);
            }
        };
        this.fTable.setSortColumn(this.fFieldCol);
        this.fTable.setSortDirection(this.fSortDirection);
        this.sort(false);
        this.getElements(true);
        this.fFieldCol.setData((Object)"com.ibm.debug.debug.memorymap.showfield");
        this.fPathCol.setData((Object)"com.ibm.debug.debug.memorymap.showpaths");
        this.fDescCol.setData((Object)"com.ibm.debug.debug.memorymap.showdesc");
        this.fGroupCol.setData((Object)"com.ibm.debug.debug.memorymap.showgrps");
        GridData tableData = new GridData();
        tableData.horizontalAlignment = 4;
        tableData.verticalAlignment = 4;
        tableData.grabExcessHorizontalSpace = true;
        tableData.grabExcessVerticalSpace = true;
        tableData.heightHint = this.fTable.getItemHeight() * 15;
        this.fTable.setLayoutData((Object)tableData);
        this.fTable.pack();
        this.fTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindFieldDialog.this.handleSelectionChanged();
            }
        });
        this.fTable.addListener(8, new Listener(){

            public void handleEvent(Event e) {
                FindFieldDialog.this.okPressed();
            }
        });
        int i = 0;
        while (i < this.fTable.getColumnCount()) {
            TableColumn column = this.fTable.getColumn(i);
            boolean isVisible = this.fStore.getBoolean((String)column.getData());
            column.pack();
            column.setWidth(isVisible ? 150 : 0);
            if (!isVisible) {
                this.fSearchTypeCombo.remove(this.columnLabels[i]);
            }
            column.setMoveable(true);
            column.addSelectionListener((SelectionListener)sortListener);
            ++i;
        }
        this.fSearchColumn = this.fStore.getInt("com.ibm.debug.memormymap.last_srch");
        this.fSearchTypeCombo.select(this.fSearchColumn);
        if (this.fSearchColumn < 0) {
            this.fSearchColumn = 0;
        }
        Button showPartitions = new Button(dialogArea, 32);
        showPartitions.setText(MemoryMapLabels.FindFieldDialog_8);
        showPartitions.setSelection(this.fStore.getBoolean("com.ibm.debug.memormymap.showpartitions"));
        showPartitions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindFieldDialog.this.togglePreference("com.ibm.debug.memormymap.showpartitions");
                FindFieldDialog.this.getElements(true);
                FindFieldDialog.this.sort(false);
                if (FindFieldDialog.this.searchQuery.getText().length() > 0) {
                    FindFieldDialog.this.search(FindFieldDialog.this.searchQuery.getText());
                }
            }
        });
        showPartitions.setToolTipText(MemoryMapLabels.FindFieldDialog_9);
        final Button autoExpandButton = new Button(dialogArea, 32);
        autoExpandButton.setText(MemoryMapLabels.FindDialog_auto_expand);
        autoExpandButton.setSelection(this.fStore.getBoolean("com.ibm.debug.memormymap.autobuild"));
        autoExpandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean autoExpand = autoExpandButton.getSelection();
                if (autoExpand && FindFieldDialog.this.fUnbuiltElements != null && FindFieldDialog.this.fUnbuiltElements.size() > 0) {
                    FindFieldDialog.this.expandUnbuilt();
                    FindFieldDialog.this.togglePreference("com.ibm.debug.memormymap.autobuild");
                    FindFieldDialog.this.getElements(false);
                    FindFieldDialog.this.sort(false);
                    if (FindFieldDialog.this.searchQuery.getText().length() > 0) {
                        FindFieldDialog.this.search(FindFieldDialog.this.searchQuery.getText());
                    }
                    autoExpandButton.setSelection(FindFieldDialog.this.fStore.getBoolean("com.ibm.debug.memormymap.autobuild"));
                } else {
                    FindFieldDialog.this.fStore.setValue("com.ibm.debug.memormymap.autobuild", autoExpand);
                }
            }
        });
        this.fDetailViewer = new DetailViewer(dialogArea);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialogArea, "com.ibm.debug.memorymap.FindField_context");
        this.getShell().setText(MemoryMapLabels.find_field_action_dialog_title);
        dialogArea.pack();
        this.fLastSearchFilter = "";
        return dialogArea;
    }

    public MapElement getResult() {
        return this.fResult;
    }

    public void setElements(MapElement[] elements) {
        this.fMapElements = elements;
        this.fCurrentlyDisplayedMaps = this.fMapElements;
    }

    public void setUnbuiltElements(List<Object> unbuiltElements) {
        this.fUnbuiltElements = unbuiltElements;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = MemoryMapPlugin.getInstance().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGSSECTION);
        if (section == null) {
            section = settings.addNewSection(SETTINGSSECTION);
        }
        return section;
    }

    protected void handleSelectionChanged() {
        TableItem[] selected = this.fTable.getSelection();
        if (selected.length > 0) {
            this.fDetailViewer.updateDetails((MapElement)selected[0].getData());
        } else {
            this.fDetailViewer.clearLabels();
        }
    }

    protected void okPressed() {
        TableItem[] selection = this.fTable.getSelection();
        if (selection != null && selection.length > 0) {
            this.fResult = (MapElement)selection[0].getData();
        }
        super.okPressed();
    }

    public boolean close() {
        this.fStore.setValue("com.ibm.debug.memormymap.last_srch", this.fSearchTypeCombo.getSelectionIndex());
        return super.close();
    }

    private void expandUnbuilt() {
        BuildMapAction action = new BuildMapAction(this.fRendering, false);
        action.setRootList(this.fUnbuiltElements);
        HashSet<MapElement> newElements = new HashSet<MapElement>(Arrays.asList(this.fMapElements));
        newElements.addAll(action.runWithoutExpand(true));
        Exception error = action.getException();
        if (error == null) {
            this.fUnbuiltElements = Collections.emptyList();
        } else if (!error.getMessage().equals(MemoryMapLabels.ExpandMapAction_cancelling_expansion)) {
            ExpansionErrorDialog dialog = new ExpansionErrorDialog(action.getException(), CommonUtils.getShell(), new String[]{IDialogConstants.OK_LABEL}, true);
            dialog.open();
        }
        action.setExpansionRoot((MemoryMap)this.fRendering.getRootElement());
        this.fMapElements = new MapElement[newElements.size()];
        newElements.toArray(this.fMapElements);
    }

    private void getElements(boolean reset) {
        this.fCurrentlyDisplayedMaps = !this.fStore.getBoolean("com.ibm.debug.memormymap.showpartitions") ? this.getFilteredList(this.fMapElements) : this.fMapElements;
        if (reset) {
            this.resetTable();
        }
    }

    private MapElement[] getFilteredList(MapElement[] elements) {
        ArrayList<MapElement> newList = new ArrayList<MapElement>();
        int i = 0;
        while (i < elements.length) {
            if (!(elements[i] instanceof MemoryMapPartitionElement)) {
                newList.add(elements[i]);
            }
            ++i;
        }
        return newList.toArray(new MapElement[newList.size()]);
    }

    private void resetTable() {
        this.fTable.clearAll();
        this.fTable.setItemCount(this.fCurrentlyDisplayedMaps.length);
    }

    private void search(String filter) {
        if (filter.length() == 0) {
            this.fLastSearchFilter = "";
            this.getElements(true);
            this.sort(false);
            return;
        }
        filter = filter.replace('?', '.');
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < filter.length()) {
            if (filter.charAt(i) == '*') {
                buffer.append(".*");
            } else {
                buffer.append(filter.charAt(i));
            }
            ++i;
        }
        filter = buffer.toString();
        filter = filter.replaceAll("([\\^\\(\\)\\+\\{\\}\\[\\]\\|\\$\\-])", "\\\\$1");
        Pattern pattern = Pattern.compile(filter, 2);
        if (!filter.startsWith(this.fLastSearchFilter)) {
            this.getElements(false);
        }
        ArrayList<MapElement> list = new ArrayList<MapElement>();
        int i2 = 0;
        while (i2 < this.fCurrentlyDisplayedMaps.length) {
            String text = this.fLabelProvider.getColumnText(this.fCurrentlyDisplayedMaps[i2], this.fSearchColumn);
            if (pattern.matcher(text).find()) {
                list.add(this.fCurrentlyDisplayedMaps[i2]);
            }
            ++i2;
        }
        this.fLastSearchFilter = filter;
        this.fCurrentlyDisplayedMaps = new MapElement[list.size()];
        list.toArray(this.fCurrentlyDisplayedMaps);
        this.resetTable();
    }

    private void setupSingleRow(TableItem tableItem, MapElement selectedMap) {
        tableItem.setData((Object)selectedMap);
        tableItem.setText(this.fLabelProvider.getAllLabels(selectedMap));
        tableItem.setImage(this.fLabelProvider.getColumnImage(selectedMap, 0));
        tableItem.setForeground(this.fLabelProvider.getForeground(selectedMap));
    }

    private void togglePreference(String preferenceName) {
        this.fStore.setValue(preferenceName, !this.fStore.getBoolean(preferenceName));
    }

    private void sort(boolean swapDirection) {
        if (swapDirection) {
            this.fSortDirection = this.fSortDirection == 128 ? 1024 : 128;
        }
        Arrays.sort(this.fCurrentlyDisplayedMaps, new Comparator<Object>(){

            @Override
            public int compare(Object arg0, Object arg1) {
                if (arg0 == null || !(arg0 instanceof MapElement) || arg1 == null || !(arg1 instanceof MapElement)) {
                    return 0;
                }
                MapElement map0 = (MapElement)arg0;
                MapElement map1 = (MapElement)arg1;
                String p0 = FindFieldDialog.this.fLabelProvider.getColumnText(map0, FindFieldDialog.this.fSortColumnIndex);
                String p1 = FindFieldDialog.this.fLabelProvider.getColumnText(map1, FindFieldDialog.this.fSortColumnIndex);
                if (FindFieldDialog.this.fSortDirection == 128) {
                    return p0.compareTo(p1);
                }
                return p1.compareTo(p0);
            }
        });
        this.fTable.setSortColumn(this.fTable.getColumn(this.fSortColumnIndex));
        this.fTable.setSortDirection(this.fSortDirection);
        this.resetTable();
    }

    private class ColumnSelectListener
    extends SelectionAdapter {
        IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] elements = new Object[3];
                System.arraycopy(((ColumnSelectListener)ColumnSelectListener.this).FindFieldDialog.this.fTable.getColumns(), 1, elements, 0, 3);
                return elements;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                return ((TableColumn)element).getText();
            }
        };

        private ColumnSelectListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            ListSelectionDialog dialog = ListSelectionDialog.of((Object)FindFieldDialog.this.fTable).contentProvider(this.contentProvider).labelProvider((ILabelProvider)this.labelProvider).message(MemoryMapLabels.FindFieldDialog_12).create(FindFieldDialog.this.getShell());
            ArrayList<TableColumn> defaultSelections = new ArrayList<TableColumn>();
            int i = 1;
            while (i < FindFieldDialog.this.fTable.getColumnCount()) {
                if (FindFieldDialog.this.fTable.getColumn(i).getWidth() > 0) {
                    defaultSelections.add(FindFieldDialog.this.fTable.getColumn(i));
                }
                ++i;
            }
            dialog.setInitialElementSelections(defaultSelections);
            dialog.setTitle(MemoryMapLabels.FindFieldDialog_10);
            if (dialog.open() == 0) {
                Object[] selection = dialog.getResult();
                FindFieldDialog.this.fPathCol.setWidth(0);
                FindFieldDialog.this.fGroupCol.setWidth(0);
                FindFieldDialog.this.fDescCol.setWidth(0);
                int i2 = 0;
                while (i2 < selection.length) {
                    ((TableColumn)selection[i2]).setWidth(150);
                    ++i2;
                }
                String currentSearchType = FindFieldDialog.this.fSearchTypeCombo.getItem(FindFieldDialog.this.fSearchTypeCombo.getSelectionIndex());
                FindFieldDialog.this.fSearchTypeCombo.setItems(FindFieldDialog.this.columnLabels);
                int i3 = 1;
                while (i3 < 4) {
                    TableColumn column = FindFieldDialog.this.fTable.getColumn(i3);
                    boolean isVisible = column.getWidth() != 0;
                    FindFieldDialog.this.fStore.setValue((String)column.getData(), isVisible);
                    if (!isVisible) {
                        FindFieldDialog.this.fSearchTypeCombo.remove(FindFieldDialog.this.columnLabels[i3]);
                    }
                    ++i3;
                }
                if (FindFieldDialog.this.fTable.getColumn(FindFieldDialog.this.fSearchColumn).getWidth() == 0) {
                    FindFieldDialog.this.fSearchTypeCombo.select(0);
                    FindFieldDialog.this.fSearchColumn = 0;
                    FindFieldDialog.this.getElements(false);
                    FindFieldDialog.this.search(FindFieldDialog.this.searchQuery.getText());
                } else {
                    i3 = 0;
                    while (i3 < FindFieldDialog.this.fSearchTypeCombo.getItems().length) {
                        if (FindFieldDialog.this.fSearchTypeCombo.getItems()[i3].equals(currentSearchType)) {
                            FindFieldDialog.this.fSearchTypeCombo.select(i3);
                            break;
                        }
                        ++i3;
                    }
                }
                if (FindFieldDialog.this.fTable.getSortColumn().getWidth() == 0) {
                    FindFieldDialog.this.fSortColumnIndex = 0;
                    FindFieldDialog.this.fSortDirection = FindFieldDialog.this.fTable.getSortDirection();
                    FindFieldDialog.this.sort(false);
                }
            }
        }
    }

    private class DetailViewer {
        private Label fAddress;
        private Text fContents;
        private Label fDescription;
        private Label fMapOffset;
        private Composite fParent;

        public DetailViewer(Composite composite) {
            this.fParent = new Composite(composite, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.horizontalSpacing = 1;
            this.fParent.setLayout((Layout)layout);
            GridData data = new GridData(1808);
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            this.fParent.setLayoutData((Object)data);
            GridData valueData = new GridData(1808);
            valueData.verticalAlignment = 1;
            GridData labelData = new GridData();
            labelData.verticalAlignment = 1;
            Label fAddressLabel = new Label(this.fParent, 0);
            fAddressLabel.setLayoutData((Object)labelData);
            this.fAddress = new Label(this.fParent, 0);
            this.fAddress.setLayoutData((Object)valueData);
            labelData = new GridData();
            labelData.verticalAlignment = 1;
            Label fMapOffsetLabel = new Label(this.fParent, 0);
            fMapOffsetLabel.setLayoutData((Object)labelData);
            this.fMapOffset = new Label(this.fParent, 0);
            this.fMapOffset.setLayoutData((Object)valueData);
            labelData = new GridData();
            labelData.verticalAlignment = 1;
            Label descriptionLabel = new Label(this.fParent, 0);
            descriptionLabel.setLayoutData((Object)labelData);
            this.fDescription = new Label(this.fParent, 0);
            this.fDescription.setLayoutData((Object)valueData);
            labelData = new GridData();
            labelData.verticalAlignment = 1;
            Label fContentLabel = new Label(this.fParent, 0);
            fContentLabel.setLayoutData((Object)labelData);
            this.fContents = new Text(this.fParent, 842);
            GC gc = new GC((Drawable)this.fContents);
            gc.setFont(this.fContents.getFont());
            FontMetrics fontMetrics = gc.getFontMetrics();
            gc.dispose();
            int height = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)4);
            GridData data2 = new GridData(4, 1, true, true);
            data2.heightHint = height;
            this.fContents.setLayoutData((Object)data2);
            this.fContents.setSize(this.fContents.computeSize(-1, -1));
            fAddressLabel.setText(MemoryMapLabels.FindFieldDialog_4);
            descriptionLabel.setText(MemoryMapLabels.Description);
            fMapOffsetLabel.setText(MemoryMapLabels.FindFieldDialog_5);
            fContentLabel.setText(MemoryMapLabels.FindFieldDialog_6);
        }

        public void clearLabels() {
            this.fContents.setText("");
            this.fMapOffset.setText("");
            this.fAddress.setText("");
            this.fDescription.setText("");
        }

        public void updateDetails(MapElement element) {
            StringBuffer buffer = new StringBuffer(" ");
            this.fAddress.setText(buffer.append(element.getAddressInHexString()).toString());
            this.fMapOffset.setText(NLS.bind((String)MemoryMapLabels.hex_string_prefix, (Object)Long.toHexString(element.getOffset())));
            String text = FindFieldDialog.this.fLabelProvider.getValue(element);
            this.fContents.setText(text);
            this.fContents.setSize(this.fContents.computeSize(-1, -1));
            this.fDescription.setText(element.getDescription());
            this.fParent.pack(true);
            ((Composite)FindFieldDialog.this.getDialogArea()).layout(true);
        }
    }
}

