/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.dialogs;

import com.ibm.debug.memorymap.MemoryMapPlugin;
import com.ibm.debug.memorymap.actions.OpenMapFileAction;
import com.ibm.debug.memorymap.utils.MemoryMapException;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapMessages;
import com.ibm.debug.memorymap.utils.MemoryMapUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExpansionErrorDialog
extends MessageDialog {
    private Exception fException;
    private boolean fOpenFileOnClose = false;
    private boolean fIsFindDialogError = false;

    public ExpansionErrorDialog(Exception e, Shell parentShell, String[] labels, boolean isFindDialogError) {
        super(parentShell, MemoryMapMessages.ExpansionErrorDialog_0, MessageDialog.getDefaultImage(), new StringBuffer(MemoryMapMessages.ExpansionErrorDialog_1).append(System.getProperty("line.separator")).append(e.getMessage()).toString(), 1, labels, 0);
        this.fException = e;
        this.fIsFindDialogError = isFindDialogError;
    }

    protected Control createCustomArea(Composite composite) {
        if (this.fException instanceof MemoryMapException) {
            String text = ((MemoryMapException)this.fException).getField();
            Text field = null;
            GridData data = new GridData(0x1000000, 0x1000000, false, false);
            if (text.length() > 100) {
                int h;
                field = new Text(composite, 584);
                field.setText(text);
                GC gc = new GC((Drawable)field);
                gc.setFont(field.getFont());
                FontMetrics fontMetrics = gc.getFontMetrics();
                gc.dispose();
                int w = Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)90);
                data.widthHint = Math.min(w, this.getMinimumMessageWidth());
                data.heightHint = h = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)3);
            } else {
                field = new Text(composite, 72);
                field.setText(text);
            }
            field.setLayoutData((Object)data);
            final Button openFileButton = new Button(composite, 32);
            String file = MemoryMapUtils.getFileName(((MemoryMapException)this.fException).getMappingFile());
            openFileButton.setText(NLS.bind((String)MemoryMapLabels.MemoryMapRendering_4, (Object)file));
            openFileButton.setSelection(false);
            openFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExpansionErrorDialog.this.fOpenFileOnClose = openFileButton.getSelection();
                }
            });
            openFileButton.setFocus();
        }
        if (this.fIsFindDialogError) {
            Button disableAutoExpand = new Button(composite, 32);
            disableAutoExpand.setText(MemoryMapLabels.FindFieldAction_disable_auto_build);
            disableAutoExpand.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean autoExpand = MemoryMapPlugin.getInstance().getPreferenceStore().getBoolean("com.ibm.debug.memormymap.autobuild");
                    MemoryMapPlugin.getInstance().getPreferenceStore().setValue("com.ibm.debug.memormymap.autobuild", !autoExpand);
                }
            });
            Label disclaimer = new Label(composite, 0);
            disclaimer.setText(MemoryMapMessages.AutoExpandErrorDialog_0);
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 0 && this.fOpenFileOnClose) {
            new OpenMapFileAction(((MemoryMapException)this.fException).getMappingFile(), false).run();
        }
    }
}

