/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.dialogs;

import com.ibm.debug.memorymap.MapElement;
import com.ibm.debug.memorymap.MemoryMap;
import com.ibm.debug.memorymap.MemoryMapLayout;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.pdt.internal.ui.dialogs.DebugTrayDialog;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EditDescriptionDialog
extends DebugTrayDialog {
    private MemoryMap[] fSelectedMaps;
    private Table fTable;
    private Button fCascadeButton;
    private HashSet<MemoryMapLayout> fChangedLayouts;

    public EditDescriptionDialog(MemoryMap[] elements) {
        super(Display.getCurrent().getActiveShell());
        this.fSelectedMaps = elements;
        this.setShellStyle(34928);
        this.fChangedLayouts = new HashSet(5);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 6;
        composite.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.fTable = new Table(composite, 67588);
        data.verticalSpan = this.fTable.getItemHeight() * this.fSelectedMaps.length + 1;
        TableColumn fieldCol = new TableColumn(this.fTable, 18432);
        fieldCol.setText(MemoryMapLabels.FieldColumnHeader);
        TableColumn descCol = new TableColumn(this.fTable, 18432);
        descCol.setText(MemoryMapLabels.DescColumnHeader);
        this.fTable.setLinesVisible(true);
        this.fTable.setHeaderVisible(true);
        int i = 0;
        while (i < this.fSelectedMaps.length) {
            TableItem tableItem = new TableItem(this.fTable, 0);
            MemoryMap selectedMap = this.fSelectedMaps[i];
            this.createElement(tableItem, selectedMap);
            ++i;
        }
        descCol.pack();
        fieldCol.pack();
        this.fCascadeButton = new Button(composite, 32);
        boolean DESCRIPTION_COL = true;
        this.fCascadeButton.setText(MemoryMapLabels.EditDescriptionDialog_1);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == EditDescriptionDialog.this.fCascadeButton) {
                    TableItem[] items = EditDescriptionDialog.this.fTable.getItems();
                    if (EditDescriptionDialog.this.fTable.getSelectionCount() != 1 || !EditDescriptionDialog.this.fCascadeButton.getSelection()) {
                        return;
                    }
                    TableItem item = EditDescriptionDialog.this.fTable.getSelection()[0];
                    int i = 0;
                    while (i < items.length) {
                        items[i].setText(1, item.getText(1));
                        ++i;
                    }
                } else {
                    TableColumn column = (TableColumn)event.widget;
                    EditDescriptionDialog.this.fTable.setSortColumn(column);
                    final int sortDirection = EditDescriptionDialog.this.fTable.getSortDirection() == 128 ? 1024 : 128;
                    EditDescriptionDialog.this.fTable.setSortDirection(sortDirection);
                    final int sortColumn = EditDescriptionDialog.this.fTable.indexOf(column);
                    Arrays.sort(EditDescriptionDialog.this.fSelectedMaps, new Comparator<Object>(){

                        @Override
                        public int compare(Object arg0, Object arg1) {
                            String item0Text = ((MapElement)arg0).getDescription();
                            String item1Text = ((MapElement)arg1).getDescription();
                            if (sortColumn != 1) {
                                item0Text = ((MapElement)arg0).getName();
                                item1Text = ((MapElement)arg1).getName();
                            }
                            if (sortDirection == 128) {
                                return item0Text.compareTo(item1Text);
                            }
                            return item1Text.compareTo(item0Text);
                        }
                    });
                    EditDescriptionDialog.this.fTable.clearAll();
                    EditDescriptionDialog.this.fTable.setItemCount(EditDescriptionDialog.this.fSelectedMaps.length);
                    int i = 0;
                    while (i < EditDescriptionDialog.this.fSelectedMaps.length) {
                        TableItem tableItem = EditDescriptionDialog.this.fTable.getItem(i);
                        EditDescriptionDialog.this.createElement(tableItem, EditDescriptionDialog.this.fSelectedMaps[i]);
                        ++i;
                    }
                }
            }
        };
        descCol.addListener(13, listener);
        fieldCol.addListener(13, listener);
        this.fCascadeButton.addListener(13, listener);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.fCascadeButton.pack();
        this.fCascadeButton.setLayoutData((Object)data);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.heightHint = this.fTable.getItemHeight() * 10;
        this.fTable.setLayoutData((Object)data);
        this.fTable.pack();
        final TableEditor editor = new TableEditor(this.fTable);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        editor.minimumWidth = descCol.getWidth();
        this.fTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Control oldEditor = editor.getEditor();
                if (oldEditor != null) {
                    oldEditor.dispose();
                }
                if (e.item == null) {
                    return;
                }
                TableItem selection = (TableItem)e.item;
                final Text newEditor = new Text((Composite)EditDescriptionDialog.this.fTable, 0);
                newEditor.setBackground(selection.getBackground());
                newEditor.setText(selection.getText(1));
                newEditor.selectAll();
                newEditor.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        TableItem tableItem = editor.getItem();
                        tableItem.setText(1, ((Text)editor.getEditor()).getText());
                        if ((this).EditDescriptionDialog.this.fCascadeButton.getSelection()) {
                            TableItem[] items = (this).EditDescriptionDialog.this.fTable.getItems();
                            int i = 0;
                            while (i < items.length) {
                                items[i].setText(1, tableItem.getText(1));
                                ++i;
                            }
                        }
                    }
                });
                newEditor.addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent e) {
                        TableItem tableItem = editor.getItem();
                        switch (e.detail) {
                            case 4: {
                                tableItem.setText(1, ((Text)editor.getEditor()).getText());
                                newEditor.removeTraverseListener((TraverseListener)this);
                                editor.getEditor().dispose();
                                e.doit = false;
                                break;
                            }
                            case 2: {
                                newEditor.removeTraverseListener((TraverseListener)this);
                                editor.getEditor().dispose();
                                e.doit = false;
                                tableItem.setText(1, ((MapElement)tableItem.getData()).getDescription());
                                if (!(this).EditDescriptionDialog.this.fCascadeButton.getSelection()) break;
                                TableItem[] items = (this).EditDescriptionDialog.this.fTable.getItems();
                                int i = 0;
                                while (i < items.length) {
                                    items[i].setText(1, ((MapElement)items[i].getData()).getDescription());
                                    ++i;
                                }
                                break;
                            }
                        }
                    }
                });
                newEditor.setFocus();
                editor.setEditor((Control)newEditor, selection, 1);
            }
        });
        this.getShell().setText(MemoryMapLabels.EditDescriptionDialog_2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.debug.memorymap.EditDescriptionValueDialog");
        composite.pack(true);
        return composite;
    }

    protected void okPressed() {
        TableItem[] items = this.fTable.getItems();
        int i = 0;
        while (i < items.length) {
            MemoryMap mapElement;
            String oldDesc;
            String newDesc = items[i].getText(1).trim();
            if (!newDesc.equals(oldDesc = (mapElement = this.fSelectedMaps[i]).getDescription())) {
                mapElement.setDescription(newDesc);
                this.fChangedLayouts.add(mapElement.getLayout());
            }
            ++i;
        }
        super.okPressed();
    }

    public Set<MemoryMapLayout> getChangedLayouts() {
        return this.fChangedLayouts;
    }

    private void createElement(TableItem tableItem, MapElement selectedMap) {
        String description = selectedMap.getDescription();
        String label = new StringBuffer(selectedMap.getName()).append(" - ").append(selectedMap.getParent().getPath()).toString();
        tableItem.setText(new String[]{label, description});
        tableItem.setData((Object)selectedMap);
    }
}

