/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.actions;

import com.ibm.debug.memorymap.MapElement;
import com.ibm.debug.memorymap.MemoryMapLayout;
import com.ibm.debug.memorymap.MemoryMapRendering;
import com.ibm.debug.memorymap.actions.AutoExportAction;
import com.ibm.debug.memorymap.utils.MemoryMapUtils;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;

public class SetGroupAction
extends Action {
    private MemoryMapRendering fRendering;
    private MapElement[] fSelectedMaps;
    private String fSelectedGroup;
    private boolean isChecked;

    public SetGroupAction(MemoryMapRendering rendering, MapElement[] maps, String group, int style) {
        super(group, style);
        this.fRendering = rendering;
        this.fSelectedMaps = maps;
        this.fSelectedGroup = group;
        this.setId("com.ibm.debug.memorymap.SetGroupAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, this.getId());
        this.isChecked = this.update();
    }

    public void run() {
        if (!MemoryMapUtils.canEditGroupsOrDescriptions(this.fSelectedMaps)) {
            return;
        }
        try {
            MemoryMapLayout[] allLayouts = this.fRendering.getAllLayouts(false, false);
            int i = 0;
            while (i < this.fSelectedMaps.length) {
                List<MemoryMapLayout> identicalLayouts = MemoryMapUtils.getIdenticalLayouts(allLayouts, this.fSelectedMaps[i].getLayout());
                ListIterator<MemoryMapLayout> layoutIterator = identicalLayouts.listIterator();
                while (layoutIterator.hasNext()) {
                    MapElement[] foundElements = MemoryMapUtils.getIdenticalElements(this.fSelectedMaps[i], layoutIterator.next());
                    int j = 0;
                    while (j < foundElements.length) {
                        if (this.isChecked) {
                            foundElements[j].removeGroup(this.fSelectedGroup);
                        } else {
                            foundElements[j].addGroup(this.fSelectedGroup, true);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            new AutoExportAction(this.fRendering, allLayouts).run();
        }
        catch (DebugException e) {
            MemoryMapUtils.openError(e);
        }
    }

    private boolean update() {
        int i = 0;
        while (i < this.fSelectedMaps.length) {
            if (!this.fSelectedMaps[i].getExplicitGroups().contains(this.fSelectedGroup)) {
                this.setChecked(false);
                return false;
            }
            ++i;
        }
        this.setChecked(true);
        return true;
    }
}

