/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.actions;

import com.ibm.debug.memorymap.MemoryMapRendering;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapUtils;
import com.ibm.debug.pdt.internal.common.CommonUtils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.ui.PlatformUI;

public class PrintMemoryMapAction
extends Action {
    private MemoryMapRendering fRendering;

    public PrintMemoryMapAction(MemoryMapRendering rendering) {
        super(MemoryMapLabels.MemoryMapPrintAction_name);
        this.setToolTipText(MemoryMapLabels.MemoryMapPrintAction_name);
        this.setImageDescriptor(MemoryMapUtils.getImageDescriptor("PRINT_MAP"));
        this.setId("com.ibm.debug.memorymap.PrintMemoryMapAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, this.getId());
        this.fRendering = rendering;
    }

    public void run() {
        String[] lines = this.fRendering.getContentAsPrintLines();
        PrintDialog printDialog = new PrintDialog(CommonUtils.getShell());
        PrinterData printerData = printDialog.open();
        if (printerData == null) {
            this.setChecked(false);
            return;
        }
        Printer printer = new Printer(printerData);
        GC printGC = new GC((Drawable)printer);
        printer.startJob(this.fRendering.getLabel());
        printer.startPage();
        int lineNum = 1;
        int maxCharacters = printer.getClientArea().width / (int)printGC.getFontMetrics().getAverageCharacterWidth() - 15;
        int i = 0;
        while (i < lines.length) {
            int numChar = lines[i].length();
            if (numChar > maxCharacters) {
                String tempStr = lines[i].trim();
                int prefixSize = lines[i].length() - tempStr.length();
                int itemMax = printer.getClientArea().width / (int)printGC.getFontMetrics().getAverageCharacterWidth() - 5 - prefixSize;
                StringBuffer prefix = new StringBuffer();
                int k = 0;
                while (k < prefixSize) {
                    prefix.append(" ");
                    ++k;
                }
                String prefixStr = prefix.toString();
                ArrayList<CallSite> breakdown = new ArrayList<CallSite>();
                int start = 0;
                int end = itemMax - 1;
                while (end < tempStr.length()) {
                    breakdown.add((CallSite)((Object)(prefixStr + tempStr.substring(start, end))));
                    if (start == 0) {
                        prefix.append("  ");
                        prefixStr = prefix.toString();
                        itemMax -= 2;
                    }
                    end = (start += itemMax) + itemMax - 1;
                }
                if (start == 0) {
                    breakdown.add((CallSite)((Object)(prefixStr + tempStr)));
                } else if (start + 1 < tempStr.length()) {
                    breakdown.add((CallSite)((Object)(prefixStr + tempStr.substring(start + 1))));
                }
                int j = 0;
                while (j < breakdown.size()) {
                    printGC.drawString((String)breakdown.get(j), 10, 10 + lineNum * printGC.getFontMetrics().getHeight());
                    ++lineNum;
                    ++j;
                }
            } else {
                printGC.drawString(lines[i], 10, 10 + lineNum * printGC.getFontMetrics().getHeight());
                ++lineNum;
            }
            if (20 + lineNum * printGC.getFontMetrics().getHeight() > printer.getClientArea().height) {
                lineNum = 1;
                printer.endPage();
                printer.startPage();
            }
            ++i;
        }
        printer.endPage();
        printer.endJob();
        printGC.dispose();
        printer.dispose();
        this.setChecked(false);
    }
}

