/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.actions;

import com.ibm.debug.memorymap.MemoryMapPlugin;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapMessages;
import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.rsecommon.RSEUtils;
import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OpenMapFileAction
extends Action {
    private File fLayoutFile;
    private boolean fEntireLabel;

    public OpenMapFileAction(String path, boolean entireLabel) {
        this.fEntireLabel = entireLabel;
        this.setLayoutPath(path);
        this.setId("com.ibm.debug.memorymap.OpenMapFileAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, this.getId());
    }

    public void setLayoutPath(String path) {
        this.fLayoutFile = new File(path);
        if (this.fEntireLabel) {
            this.setText(NLS.bind((String)MemoryMapLabels.MemoryMapConstants_11, (Object)this.fLayoutFile.getName()));
        } else {
            this.setText(this.fLayoutFile.getName());
        }
    }

    public void run() {
        if (!this.fLayoutFile.exists()) {
            ErrorDialog.openError((Shell)CommonUtils.getShell(), (String)NLS.bind((String)MemoryMapLabels.MemoryMapConstants_11, (Object)this.fLayoutFile.getName()), null, (IStatus)new Status(4, "com.ibm.debug.memorymap", 0, NLS.bind((String)MemoryMapMessages.MemoryMapConstants_15, (Object)this.fLayoutFile.getName()), null));
            return;
        }
        try {
            RSEUtils.openFileInEditor((File)this.fLayoutFile, (int)0);
        }
        catch (Exception exception) {
            StringBuffer message = new StringBuffer(NLS.bind((String)MemoryMapMessages.memory_map_utils_error_file_error, (Object)this.fLayoutFile.getName()));
            if (exception.getMessage() != null) {
                message.append("\n\n").append(exception.getMessage());
            }
            ErrorDialog.openError((Shell)CommonUtils.getShell(), (String)NLS.bind((String)MemoryMapLabels.MemoryMapConstants_11, (Object)this.fLayoutFile.getName()), null, (IStatus)new Status(4, "com.ibm.debug.memorymap", 0, message.toString(), null));
            MemoryMapPlugin.logException(exception);
        }
    }
}

