/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.actions;

import com.ibm.debug.memorymap.MapMemoryElementRendering;
import com.ibm.debug.memorymap.utils.MapMemoryElementActionFilter;
import com.ibm.debug.memorymap.utils.MemoryMapMessages;
import com.ibm.debug.pdt.core.IAddressable;
import com.ibm.debug.pdt.internal.core.model.DebuggeeThread;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import com.ibm.debug.pdt.internal.ui.PICLDebugPlugin;
import com.ibm.debug.pdt.internal.ui.PICLDebugTarget;
import com.ibm.debug.pdt.internal.ui.memory.MapStorageAction;
import com.ibm.debug.pdt.internal.ui.memory.PICLMemoryBlock;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class MapMemoryElementAction
extends Action {
    private IAddressable fElement;
    private String fMappingFileName;

    public static MapMemoryElementAction makeMapMemoryElementAction(ISelection selection) {
        Object element;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IAddressable) {
            return MapMemoryElementAction.makeMapMemoryElementAction((IAddressable)element);
        }
        return null;
    }

    public static MapMemoryElementAction makeMapMemoryElementAction(IAddressable element) {
        MapMemoryElementActionFilter filter = MapMemoryElementActionFilter.getFilter(element);
        String mappingFileName = filter.getMappingFileName(element);
        if (PDTCoreUtils.isEmpty((String)mappingFileName)) {
            return null;
        }
        return new MapMemoryElementAction(element, mappingFileName);
    }

    private MapMemoryElementAction(IAddressable element, String mappingFileName) {
        this.fElement = element;
        this.fMappingFileName = mappingFileName;
    }

    IDebugTarget getDebugTarget() {
        return this.fElement.getDebugTarget();
    }

    public void run() {
        IMemoryBlock memblk = this.getMemoryBlock();
        if (memblk == null) {
            return;
        }
        IMemoryRendering memren = this.getMemoryRendering();
        if (memren == null) {
            return;
        }
        MapStorageAction.monitorAndRenderMemory((IMemoryBlock)memblk, (IMemoryRendering)memren, null);
    }

    private IMemoryBlock getMemoryBlock() {
        DebuggeeThread thread;
        long addr = this.fElement.getMemoryStartAddress();
        if (addr < 0L) {
            this.showNotMappableMessage(null);
            return null;
        }
        PICLMemoryBlock memblk = null;
        PICLDebugTarget tgt = (PICLDebugTarget)this.fElement.getDebugTarget();
        if (tgt != null && !tgt.isTerminated() && (thread = tgt.getCurrentThread()) != null) {
            try {
                memblk = new PICLMemoryBlock(Long.toHexString(addr), thread, thread.getLocation());
            }
            catch (DebugException de) {
                this.showNotMappableMessage(de.getMessage());
                return null;
            }
        }
        return memblk;
    }

    private void showNotMappableMessage(String additionalMessage) {
        Object msg = MemoryMapMessages.memory_map_error_instance_not_mappable;
        if (!PDTCoreUtils.isEmpty((String)additionalMessage)) {
            msg = additionalMessage + "\n\n" + (String)msg;
        }
        PICLDebugPlugin.showMessageDialog(null, (String)msg, (boolean)true);
    }

    private IMemoryRendering getMemoryRendering() {
        MapMemoryElementRendering memren = null;
        try {
            memren = new MapMemoryElementRendering(this.fMappingFileName, new File(this.fMappingFileName), this.fElement.getMemoryAddressLabel());
        }
        catch (CoreException e) {
            this.showNotMappableMessage(e.getMessage());
            return null;
        }
        return memren;
    }
}

