/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.actions;

import com.ibm.debug.memorymap.MapElement;
import com.ibm.debug.memorymap.MemoryMap;
import com.ibm.debug.memorymap.MemoryMapPlugin;
import com.ibm.debug.memorymap.MemoryMapRendering;
import com.ibm.debug.memorymap.actions.BuildMapAction;
import com.ibm.debug.memorymap.dialogs.ExpansionErrorDialog;
import com.ibm.debug.memorymap.dialogs.FindFieldDialog;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.views.FindDialogLabelProvider;
import com.ibm.debug.pdt.internal.common.CommonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class FindFieldAction
extends Action {
    private MemoryMapRendering fRendering;
    private List<Object> fUnbuiltElements = Collections.emptyList();

    public FindFieldAction(MemoryMapRendering rendering) {
        super(MemoryMapLabels.find_field_action_menu_item);
        this.setToolTipText(MemoryMapLabels.find_field_action_menu_item);
        this.setId("com.ibm.debug.memorymap.FindFieldAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, this.getId());
        this.fRendering = rendering;
    }

    public void run() {
        MapElement result;
        MapElement[] elementList = new MapElement[]{};
        boolean autoExpand = MemoryMapPlugin.getInstance().getPreferenceStore().getBoolean("com.ibm.debug.memormymap.autobuild");
        if (autoExpand) {
            BuildMapAction action = new BuildMapAction(this.fRendering, false);
            action.setExpansionRoot((MemoryMap)this.fRendering.getRootElement());
            List<Object> elements = action.runWithoutExpand(true);
            elementList = new MapElement[elements.size()];
            elements.toArray(elementList);
            Exception error = action.getException();
            if (error != null) {
                if (!error.getMessage().equals(MemoryMapLabels.ExpandMapAction_cancelling_expansion)) {
                    String[] labels = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
                    ExpansionErrorDialog errorDialog = new ExpansionErrorDialog(error, CommonUtils.getShell(), labels, true);
                    if (errorDialog.open() == 1) {
                        return;
                    }
                }
                elementList = new MapElement[]{};
            }
        }
        if (elementList.length == 0) {
            ArrayList<Object> elements = new ArrayList<Object>();
            this.fUnbuiltElements = new ArrayList<Object>();
            MapElement root = this.fRendering.getRootElement();
            elements.add(root);
            this.generateList(root, elements);
            elementList = new MapElement[elements.size()];
            elements.toArray(elementList);
        }
        FindDialogLabelProvider lp = new FindDialogLabelProvider(this.fRendering);
        Shell sh = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        FindFieldDialog dialog = new FindFieldDialog(sh, lp, this.fRendering);
        dialog.setUnbuiltElements(this.fUnbuiltElements);
        dialog.setElements(elementList);
        int returnCode = dialog.open();
        if (returnCode == 0 && (result = dialog.getResult()) != null) {
            this.fRendering.setSelection(result);
        }
        this.fUnbuiltElements = Collections.emptyList();
    }

    private void generateList(MapElement rootElement, ArrayList<Object> elements) {
        ArrayList children = (ArrayList)rootElement.getChildrenAsList();
        elements.addAll(children);
        int i = 0;
        while (i < children.size()) {
            MapElement child = (MapElement)children.get(i);
            if (child.hasChildren()) {
                if (child instanceof MemoryMap && !((MemoryMap)child).isBuilt()) {
                    if (!((MemoryMap)child).isMap()) {
                        this.fUnbuiltElements.add(child);
                    }
                } else {
                    this.generateList(child, elements);
                }
            }
            ++i;
        }
    }
}

