/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.actions;

import com.ibm.debug.memorymap.AbstractMemoryMapRendering;
import com.ibm.debug.memorymap.ErrorMapElement;
import com.ibm.debug.memorymap.MapElement;
import com.ibm.debug.memorymap.MemoryMap;
import com.ibm.debug.memorymap.MemoryMapLayout;
import com.ibm.debug.memorymap.MemoryMapPlugin;
import com.ibm.debug.memorymap.ORGParent;
import com.ibm.debug.memorymap.utils.MemoryMapException;
import com.ibm.debug.memorymap.utils.MemoryMapFileWriter;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapMessages;
import com.ibm.debug.memorymap.utils.MemoryMapUtils;
import com.ibm.debug.pdt.internal.common.CommonUtils;
import com.ibm.debug.pdt.rsecommon.RSEUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ExportMapAction
extends Action {
    private AbstractMemoryMapRendering fRendering;
    private String fDestDir;

    public ExportMapAction(AbstractMemoryMapRendering rendering) {
        super(MemoryMapLabels.GroupFieldsDialog_7);
        this.fRendering = rendering;
        this.setId("com.ibm.debug.memorymap.ExportMapAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, this.getId());
    }

    public void run() {
        this.fDestDir = null;
        try {
            MemoryMapLayout[] layouts = this.fRendering.getAllLayouts(true, true);
            DebugException debugException = this.fRendering.getDebugException();
            if (debugException != null) {
                MemoryMapUtils.openError(debugException, MemoryMapMessages.GroupFieldsDialog_8);
                return;
            }
            StringBuffer message = new StringBuffer(MemoryMapLabels.GroupFieldsDialog_14);
            message.append(":\n");
            int i = 0;
            while (i < layouts.length) {
                File temp = new File(layouts[i].getMappingFile());
                message.append(temp.getName()).append(", ");
                ++i;
            }
            message.deleteCharAt(message.length() - 1).deleteCharAt(message.length() - 1);
            Shell shell = CommonUtils.getShell();
            DirectoryDialog dirDialog = new DirectoryDialog(shell);
            dirDialog.setMessage(message.toString());
            dirDialog.setFilterPath(MemoryMapPlugin.getInstance().getPreferenceStore().getString("com.ibm.debug.memorymap.memoryMapLocation"));
            this.fDestDir = dirDialog.open();
            if (this.fDestDir != null) {
                this.exportMap(this.fDestDir, layouts);
            }
        }
        catch (DebugException e) {
            MemoryMapUtils.openError(e, MemoryMapMessages.GroupFieldsDialog_8);
        }
    }

    public String getExportDestination() {
        return this.fDestDir;
    }

    public boolean exportAllLayouts(String destDir, MemoryMapLayout[] layouts) {
        String currentGroup = this.fRendering.getCurrentGroup();
        this.fRendering.setCurrentGroup(null);
        ArrayList<String> exportedFiles = new ArrayList<String>();
        boolean success = true;
        int i = 0;
        while (i < layouts.length) {
            String fileName;
            boolean preserveFilename = false;
            boolean copyEncoding = true;
            String savePath = fileName = layouts[i].getMappingFile();
            if (destDir != null) {
                fileName = MemoryMapUtils.getFileName(fileName);
                savePath = new StringBuffer(destDir).append(File.separatorChar).append(fileName).toString();
                copyEncoding = false;
            } else {
                preserveFilename = true;
            }
            if (!exportedFiles.contains(layouts[i].getMappingFile())) {
                exportedFiles.add(layouts[i].getMappingFile());
                success = this.exportLayout(savePath, layouts[i], preserveFilename, copyEncoding);
                if (!success) break;
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IFile f = workspaceRoot.getFileForLocation((IPath)new Path(savePath));
                if (f != null) {
                    try {
                        f.refreshLocal(0, null);
                    }
                    catch (CoreException e) {
                        this.openExportMapFileError(fileName, (Exception)((Object)e));
                        success = false;
                        break;
                    }
                }
            }
            ++i;
        }
        this.fRendering.setCurrentGroup(currentGroup);
        return success;
    }

    private void openExportMapFileError(String saveFileName, Exception e) {
        String exceptionMessage;
        String field;
        Throwable throwable;
        StringBuffer title = new StringBuffer(MemoryMapMessages.GroupFieldsDialog_8);
        StringBuilder message = new StringBuilder();
        message.append(saveFileName);
        if (e instanceof DebugException && (throwable = ((DebugException)((Object)e)).getStatus().getException()) instanceof MemoryMapException && (field = ((MemoryMapException)throwable).getField()).length() != 0) {
            message.append("\n\n").append(field);
        }
        if ((exceptionMessage = e.getMessage()) != null) {
            message.append("\n\n").append(exceptionMessage);
        }
        ErrorDialog.openError((Shell)CommonUtils.getShell(), (String)title.toString(), null, (IStatus)new Status(4, "com.ibm.debug.memorymap", 0, NLS.bind((String)MemoryMapMessages.SaveMap_1, (Object)message.toString()), null));
        MemoryMapPlugin.logException(e);
    }

    public boolean exportMap(String destDir, MemoryMapLayout[] layouts) {
        ArrayList<String> existingFiles = new ArrayList<String>();
        int i = 0;
        while (i < layouts.length) {
            Path destPath = new Path(destDir);
            Path srcPath = new Path(layouts[i].getMappingFile());
            File destFile = destPath.append(srcPath.lastSegment()).toFile();
            if (destFile.exists() && destFile.canWrite()) {
                existingFiles.add(destFile.getAbsolutePath());
            }
            ++i;
        }
        if (existingFiles.size() != 0) {
            StringBuffer title = new StringBuffer(MemoryMapLabels.GroupFieldsDialog_14);
            StringBuilder message = new StringBuilder();
            ListIterator filesIterator = existingFiles.listIterator();
            while (filesIterator.hasNext()) {
                message.append("\n").append((String)filesIterator.next());
            }
            message.append("\n\n").append(MemoryMapLabels.SaveMap_4);
            if (!MessageDialog.openQuestion((Shell)CommonUtils.getShell(), (String)title.toString(), (String)NLS.bind((String)MemoryMapMessages.SaveMap_3, (Object)message.toString()))) {
                return false;
            }
        }
        if (!this.copyLayoutDTD(destDir)) {
            return false;
        }
        return this.exportAllLayouts(destDir, layouts);
    }

    private boolean copyLayoutDTD(String destDir) {
        Path destPath = new Path(destDir);
        destPath = destPath.addTrailingSeparator().append("Layout.dtd");
        File destDTD = destPath.toFile();
        Path sourcePath = new Path(this.fRendering.getMappingFile());
        File sourceDTD = (sourcePath = sourcePath.removeLastSegments(1).addTrailingSeparator().append("Layout.dtd")).toFile();
        if (!sourceDTD.exists() || destDTD.exists()) {
            return true;
        }
        try {
            BufferedReader inFile = new BufferedReader(new FileReader(sourceDTD));
            BufferedWriter outFile = new BufferedWriter(new FileWriter(destDTD));
            String line = inFile.readLine();
            while (line != null) {
                outFile.write(line + "\n");
                line = inFile.readLine();
            }
            inFile.close();
            outFile.close();
            return true;
        }
        catch (IOException e) {
            this.openExportMapFileError(sourceDTD.getName(), e);
            return false;
        }
    }

    private boolean exportLayout(String savePath, MemoryMapLayout layout, boolean preserveDirStructure, boolean copyEncoding) {
        MemoryMapFileWriter writer;
        File outputFile = new File(savePath);
        if (outputFile.exists() && (!outputFile.canWrite() || RSEUtils.isReadOnly((String)savePath))) {
            savePath = MemoryMapUtils.getFileName(savePath);
            String msg = NLS.bind((String)MemoryMapMessages.CannotExportMsg, (Object)savePath);
            this.openExportMapFileError(outputFile.getName(), new Exception(msg));
            return false;
        }
        try {
            String encoding = this.fRendering.getEncoding();
            if (!copyEncoding) {
                encoding = null;
            }
            writer = new MemoryMapFileWriter(outputFile, layout.getName(), layout.getRootElement().getDescription(), layout.getLength(), encoding);
            try {
                this.writeFIELDs(writer, layout.getRootElement(), 0, preserveDirStructure);
                Iterator<String> iter = this.fRendering.getGroups();
                while (iter.hasNext()) {
                    writer.writeGROUPTag(iter.next());
                }
            }
            catch (Exception e) {
                this.openExportMapFileError(outputFile.getName(), e);
                return false;
            }
        }
        catch (IOException e) {
            this.openExportMapFileError(outputFile.getName(), e);
            return false;
        }
        writer.closeMapFile();
        return true;
    }

    private void writeFIELDs(MemoryMapFileWriter writer, MapElement element, int numTabs, boolean preserveDirStructure) {
        MemoryMap map;
        MapElement[] children = new MapElement[]{};
        boolean errorOccurred = false;
        try {
            children = element.getChildren(true);
        }
        catch (DebugException e) {
            errorOccurred = true;
        }
        if (errorOccurred) {
            MemoryMap map2 = (MemoryMap)element;
            map2.exportFromXML(writer, numTabs);
            return;
        }
        if (children.length == 0 && element instanceof MemoryMap && (map = (MemoryMap)element).containsORGElement()) {
            ArrayList<ORGParent> externalChildren = map.getExternalOrgChildren();
            int i = 0;
            while (i < externalChildren.size()) {
                ORGParent orgChild = externalChildren.get(i);
                writer.append(numTabs, orgChild.getTagForExport(preserveDirStructure));
                if (orgChild.hasChildren()) {
                    writer.append(0, "\r\n");
                    this.writeFIELDs(writer, orgChild, numTabs + 1, preserveDirStructure);
                    writer.append(numTabs, "</ORG_GROUP>\r\n");
                } else {
                    writer.append(0, "</ORG_GROUP>\r\n");
                }
                ++i;
            }
        }
        MemoryMap parent = null;
        int numExportedORGs = 0;
        int numExpectedORGs = 0;
        if (element instanceof MemoryMap) {
            parent = (MemoryMap)element;
            numExpectedORGs = parent.getExternalOrgChildren().size();
        }
        int i = 0;
        while (i < children.length || numExpectedORGs > numExportedORGs) {
            MapElement child;
            ORGParent orgChild;
            if (parent != null && parent.containsORGElement() && (orgChild = parent.getORGChild(i)) != null) {
                writer.append(numTabs, orgChild.getTagForExport(preserveDirStructure));
                if (orgChild.hasChildren()) {
                    writer.append(0, "\r\n");
                    this.writeFIELDs(writer, orgChild, numTabs + 1, preserveDirStructure);
                    writer.append(numTabs, "</ORG_GROUP>\r\n");
                } else {
                    writer.append(0, "</ORG_GROUP>\r\n");
                }
                ++numExportedORGs;
            }
            if (!(i >= children.length || (child = children[i]).isORGParent() && ((ORGParent)child).getORGedToElement() != null)) {
                if (child instanceof MemoryMap) {
                    String nodeName;
                    MemoryMap map3 = (MemoryMap)child;
                    hasEmbeddedFIELDs = map3.isStructure() && !map3.isExternalMapOrStructure() || map3.isUnion() || map3.isORGParent() || map3.isBitmask();
                    writer.append(numTabs, map3.getTagForExport(preserveDirStructure));
                    String string = nodeName = !child.isORGParent() ? "FIELD" : "ORG_GROUP";
                    if (hasEmbeddedFIELDs) {
                        writer.append(0, "\r\n");
                        this.writeFIELDs(writer, child, numTabs + 1, preserveDirStructure);
                        writer.append(numTabs, "</" + nodeName + ">\r\n");
                    } else {
                        writer.append(0, "</" + nodeName + ">\r\n");
                    }
                } else if (child instanceof ErrorMapElement) {
                    ErrorMapElement errorMap = (ErrorMapElement)child;
                    hasEmbeddedFIELDs = errorMap.isStructure() || errorMap.isBitmask();
                    writer.append(numTabs, errorMap.getTagForExport(preserveDirStructure));
                    if (hasEmbeddedFIELDs) {
                        writer.append(0, "\r\n");
                        this.writeFIELDs(writer, child, numTabs + 1, preserveDirStructure);
                        writer.closeFIELDTag(numTabs);
                    } else {
                        writer.closeFIELDTag(0);
                    }
                }
            }
            ++i;
        }
    }
}

