/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.actions;

import com.ibm.debug.memorymap.MemoryMap;
import com.ibm.debug.memorymap.MemoryMapLayout;
import com.ibm.debug.memorymap.MemoryMapPartitionElement;
import com.ibm.debug.memorymap.actions.AutoExportAction;
import com.ibm.debug.memorymap.renderer.MemoryMapRenderer;
import com.ibm.debug.memorymap.utils.MemoryMapException;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapMessages;
import com.ibm.debug.memorymap.utils.MemoryMapUtils;
import com.ibm.debug.pdt.internal.common.CommonUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;

public class EditValueAction
extends SelectionProviderAction {
    private MemoryMap fSelected;
    private MemoryMapRenderer fRenderTool;
    protected Composite fComposite;
    protected TreeViewer fTreeViewer;
    protected Text fEditorText;
    protected TreeEditor fTreeEditor;
    private int fColumn;
    private boolean crEvent;

    public EditValueAction(TreeViewer viewer, MemoryMapRenderer renderer) {
        super((ISelectionProvider)viewer, MemoryMapLabels.edit_value_action_menu_item);
        this.setToolTipText(MemoryMapLabels.edit_value_action_menu_item);
        this.fTreeViewer = viewer;
        this.fRenderTool = renderer;
        this.fTreeEditor = new TreeEditor(this.fTreeViewer.getTree());
        this.setId("com.ibm.debug.memorymap.EditValueAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "com.ibm.debug.memorymap.EditValueAction");
    }

    public void dispose() {
        super.dispose();
    }

    public void run() {
        if (this.fEditorText != null) {
            this.doEditValue();
        }
        this.fSelected = (MemoryMap)this.getStructuredSelection().getFirstElement();
        if (this.fColumn == 4 && (this.fSelected.isORGParent() || this.fSelected instanceof MemoryMapPartitionElement || !MemoryMapUtils.canEditGroupsOrDescriptions(new MemoryMap[]{this.fSelected}))) {
            return;
        }
        this.fComposite = this.createComposite();
        int textStyles = 16384;
        if (SWT.getPlatform().equals("win32")) {
            textStyles |= 0x800;
        }
        String valueString = "";
        Tree tree = this.fTreeViewer.getTree();
        if (this.fColumn == 1) {
            MemoryByte[] bytes = null;
            try {
                bytes = this.fSelected.getBytes();
            }
            catch (DebugException e) {
                return;
            }
            valueString = this.fRenderTool.getString(this.fSelected.getType() + ":" + this.fSelected.getDisplayType(), null, bytes, MemoryMapUtils.getPaddedString());
            if (this.fSelected.getType().equals("BIT")) {
                int offset = this.fSelected.getBitOffset();
                valueString = valueString.substring(offset, offset + this.fSelected.getLength());
            }
        } else if (this.fColumn == 4) {
            valueString = this.fSelected.getDescription();
            tree.showColumn(tree.getColumn(4));
        } else {
            return;
        }
        this.fTreeEditor.horizontalAlignment = 16384;
        this.fTreeEditor.grabHorizontal = true;
        this.fTreeEditor.setEditor((Control)this.fComposite, tree.getSelection()[0], this.fColumn);
        this.fEditorText = new Text(this.fComposite, textStyles);
        this.fEditorText.setLayoutData((Object)new GridData(1808));
        this.fEditorText.setText(valueString);
        this.fEditorText.selectAll();
        this.fEditorText.setFocus();
        this.fComposite.layout(true);
        this.fComposite.setVisible(true);
        this.fEditorText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (EditValueAction.this.fEditorText.isVisible() && event.character == '\r') {
                    EditValueAction.this.crEvent = true;
                    EditValueAction.this.doEditValue();
                }
                if (event.character == '\u001b') {
                    EditValueAction.this.cleanup();
                }
            }
        });
        this.fEditorText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (!EditValueAction.this.crEvent) {
                    EditValueAction.this.doEditValue();
                }
                EditValueAction.this.crEvent = false;
            }

            public void focusGained(FocusEvent e) {
            }
        });
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!EditValueAction.this.crEvent) {
                    EditValueAction.this.doEditValue();
                }
                EditValueAction.this.fTreeViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
                EditValueAction.this.crEvent = false;
            }
        });
    }

    private Composite createComposite() {
        Composite composite = new Composite((Composite)this.fTreeViewer.getTree(), 0);
        composite.setBackground(this.fTreeViewer.getTree().getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void cleanup() {
        if (this.fEditorText != null) {
            this.fEditorText.dispose();
            this.fEditorText = null;
            this.fTreeEditor.setEditor(null, null);
            this.fComposite.setVisible(false);
        }
    }

    private void saveDescription() {
        if (this.fEditorText != null) {
            String newDesc = this.fEditorText.getText();
            this.cleanup();
            if (!newDesc.equals(this.fSelected.getDescription())) {
                this.fSelected.setDescription(newDesc);
                new AutoExportAction(this.fSelected.getLayout().getRendering(), new MemoryMapLayout[]{this.fSelected.getLayout()}).run();
            }
        }
    }

    private void doEditValue() {
        if (this.fSelected.isEditable() && this.fColumn == 1) {
            if (this.fEditorText != null) {
                Object newMapString = null;
                MemoryMap changedMap = this.fSelected;
                String selectedMapString = this.fEditorText.getText();
                String selectedMapType = this.fSelected.getType();
                String currentMapString = null;
                try {
                    MemoryByte[] currentMapInBytes = this.fSelected.getBytes();
                    if (currentMapInBytes != null) {
                        currentMapString = this.fRenderTool.getString(selectedMapType + ":" + this.fSelected.getDisplayType(), null, currentMapInBytes, MemoryMapUtils.getPaddedString());
                    }
                }
                catch (DebugException e1) {
                    ErrorDialog.openError((Shell)CommonUtils.getShell(), (String)MemoryMapMessages.memory_map_error_edit, (String)NLS.bind((String)MemoryMapMessages.MemoryMapLayout_Failed_to_edit_the_selected_field, (Object)this.fSelected.getName()), (IStatus)e1.getStatus());
                    this.cleanup();
                    return;
                }
                if (selectedMapType.equals("BIT")) {
                    if (selectedMapString == null || selectedMapString.length() == 0 || selectedMapString.length() != this.fSelected.getLength()) {
                        Shell shell = CommonUtils.getShell();
                        ErrorDialog.openError((Shell)shell, (String)MemoryMapMessages.memory_map_error_edit, null, (IStatus)new Status(4, "com.ibm.debug.memorymap", 0, NLS.bind((String)MemoryMapMessages.MemoryMapLayout_Failed_to_edit_the_selected_field, (Object)this.fSelected.getName()), null));
                        this.cleanup();
                        return;
                    }
                    int offset = this.fSelected.getBitOffset();
                    newMapString = currentMapString.substring(0, offset) + selectedMapString + currentMapString.substring(offset + this.fSelected.getLength());
                    changedMap = (MemoryMap)this.fSelected.getParent();
                } else {
                    newMapString = selectedMapString;
                }
                if (!currentMapString.equals(newMapString)) {
                    byte[] bytes = null;
                    try {
                        bytes = this.fRenderTool.getBytes(changedMap, (String)newMapString);
                    }
                    catch (MemoryMapException e) {
                        StringBuilder message = new StringBuilder();
                        message.append(changedMap.getName()).append("\n\n").append(e.getMessage());
                        Shell shell = CommonUtils.getShell();
                        ErrorDialog.openError((Shell)shell, (String)MemoryMapMessages.memory_map_error_edit, null, (IStatus)new Status(4, "com.ibm.debug.memorymap", 0, NLS.bind((String)MemoryMapMessages.MemoryMapLayout_Failed_to_edit_the_selected_field, (Object)message.toString()), null));
                        this.cleanup();
                        return;
                    }
                    if (bytes == null || bytes.length == 0 || bytes.length > changedMap.getLength()) {
                        Shell shell = CommonUtils.getShell();
                        ErrorDialog.openError((Shell)shell, (String)MemoryMapMessages.memory_map_error_edit, null, (IStatus)new Status(4, "com.ibm.debug.memorymap", 0, NLS.bind((String)MemoryMapMessages.MemoryMapLayout_Failed_to_edit_the_selected_field, (Object)changedMap.getName()), null));
                        this.cleanup();
                        return;
                    }
                    changedMap.getLayout().updateMemoryValue(changedMap.getAddress(), bytes);
                }
            }
            this.cleanup();
        } else if (this.fColumn == 4) {
            this.saveDescription();
        }
    }

    public void setEditColumn(int column) {
        if (this.fEditorText != null) {
            this.doEditValue();
        }
        this.fColumn = column;
    }

    public int getCurrentEditColumn() {
        return this.fColumn;
    }
}

