/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.actions;

import com.ibm.debug.memorymap.MapElement;
import com.ibm.debug.memorymap.MemoryMap;
import com.ibm.debug.memorymap.MemoryMapLayout;
import com.ibm.debug.memorymap.MemoryMapPartitionElement;
import com.ibm.debug.memorymap.actions.AutoExportAction;
import com.ibm.debug.memorymap.actions.EditValueAction;
import com.ibm.debug.memorymap.dialogs.EditDescriptionDialog;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapUtils;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class EditDescriptionAction
extends Action {
    private MemoryMap[] fMaps;
    private EditValueAction fEditValueAction;

    public EditDescriptionAction(EditValueAction editValueAction) {
        super(MemoryMapLabels.EditDescription);
        this.fEditValueAction = editValueAction;
        this.fMaps = new MemoryMap[0];
        this.setId("com.ibm.debug.memorymap.EditDescriptionValueAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, this.getId());
    }

    public void run() {
        MemoryMapLayout[] layouts = null;
        if (!MemoryMapUtils.canEditGroupsOrDescriptions(this.fMaps)) {
            return;
        }
        if (this.fMaps.length > 1 || this.fEditValueAction.fTreeViewer.getTree().getColumn(4).getWidth() == 0) {
            EditDescriptionDialog dialog = new EditDescriptionDialog(this.fMaps);
            if (dialog.open() == 0) {
                layouts = dialog.getChangedLayouts().toArray(new MemoryMapLayout[0]);
                new AutoExportAction(this.fMaps[0].getLayout().getRendering(), layouts).run();
            }
        } else if (this.fMaps.length == 1) {
            this.fEditValueAction.setEditColumn(4);
            this.fEditValueAction.run();
        }
    }

    public void setSelectedMaps(MemoryMap[] maps) {
        this.fMaps = maps;
    }

    public boolean setSelectedItems(TreeItem[] items) {
        this.fMaps = new MemoryMap[0];
        ArrayList<Object> selected = new ArrayList<Object>();
        int i = 0;
        while (i < items.length) {
            Object data = items[i].getData();
            if (data instanceof MemoryMap && !((MapElement)data).isORGParent() && !(data instanceof MemoryMapPartitionElement)) {
                selected.add(data);
            }
            ++i;
        }
        this.setSelectedMaps(selected.toArray(new MemoryMap[selected.size()]));
        return this.fMaps.length != 0;
    }
}

