/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.actions;

import com.ibm.debug.memorymap.MemoryMapRendering;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapUtils;
import com.ibm.debug.pdt.internal.common.CommonUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.PlatformUI;

public class CopyMemoryMapToClipboardAction
extends Action {
    private MemoryMapRendering fRendering;

    public CopyMemoryMapToClipboardAction(MemoryMapRendering rendering) {
        super(MemoryMapLabels.MemoryMapCopyAction_name);
        this.setToolTipText(MemoryMapLabels.MemoryMapCopyAction_name);
        this.setImageDescriptor(MemoryMapUtils.getImageDescriptor("COPY_TO_CLIPBOARD"));
        this.setId("com.ibm.debug.memorymap.CopyMemoryMapToClipboardAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "com.ibm.debug.memorymap.CopyMemoryMapToClipboardAction");
        this.fRendering = rendering;
    }

    public void run() {
        String content = this.fRendering.getContentAsString();
        if (content == null) {
            return;
        }
        Clipboard clip = new Clipboard(CommonUtils.getDisplay());
        if (content.length() != 0) {
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            clip.setContents(new Object[]{content}, new Transfer[]{plainTextTransfer});
        }
    }
}

