/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.actions;

import com.ibm.debug.memorymap.MemoryMapPlugin;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.pdt.internal.common.CommonUtils;
import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class ChooseRenderingColumnsAction
extends Action {
    private Tree fTree;
    private LabelProvider fLabelProvider;
    private IStructuredContentProvider fContentProvider;

    public ChooseRenderingColumnsAction(Tree tree) {
        super(MemoryMapLabels.FindFieldDialog_11);
        this.fTree = tree;
        this.setId("com.ibm.debug.memorymap.ChooseColumnsAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, this.getId());
        this.fContentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] elements = new Object[ChooseRenderingColumnsAction.this.fTree.getColumnCount() - 1];
                System.arraycopy(ChooseRenderingColumnsAction.this.fTree.getColumns(), 1, elements, 0, ChooseRenderingColumnsAction.this.fTree.getColumnCount() - 1);
                return elements;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        this.fLabelProvider = new LabelProvider(){

            public String getText(Object element) {
                return ((TreeColumn)element).getText();
            }
        };
    }

    public void run() {
        ListSelectionDialog dialog = ListSelectionDialog.of((Object)this.fTree).contentProvider(this.fContentProvider).labelProvider((ILabelProvider)this.fLabelProvider).message(MemoryMapLabels.FindFieldDialog_12).create(CommonUtils.getShell());
        ArrayList<TreeColumn> defaultSelections = new ArrayList<TreeColumn>();
        int numberOfColumns = this.fTree.getColumnCount();
        int i = 1;
        while (i < numberOfColumns) {
            if (this.fTree.getColumn(i).getWidth() > 0) {
                defaultSelections.add(this.fTree.getColumn(i));
            }
            ++i;
        }
        dialog.setInitialElementSelections(defaultSelections);
        dialog.setTitle(MemoryMapLabels.FindFieldDialog_10);
        if (dialog.open() == 0) {
            int[] oldWidths = new int[numberOfColumns];
            int i2 = 1;
            while (i2 < numberOfColumns) {
                TreeColumn column = this.fTree.getColumn(i2);
                oldWidths[i2] = column.getWidth();
                column.setWidth(0);
                column.setResizable(false);
                ++i2;
            }
            Object[] selection = dialog.getResult();
            if (selection != null) {
                int i3 = 0;
                while (i3 < selection.length) {
                    TreeColumn column;
                    int oldWidth = oldWidths[this.fTree.indexOf(column = (TreeColumn)selection[i3]) - 1];
                    column.setWidth(oldWidth == 0 ? 150 : oldWidth);
                    column.setResizable(true);
                    column.setMoveable(true);
                    ++i3;
                }
            }
            IPreferenceStore store = MemoryMapPlugin.getInstance().getPreferenceStore();
            int i4 = 1;
            while (i4 < numberOfColumns) {
                TreeColumn column = this.fTree.getColumn(i4);
                store.setValue((String)column.getData("visible"), column.getWidth() > 0);
                ++i4;
            }
        }
    }
}

