/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.actions;

import com.ibm.debug.memorymap.MapElement;
import com.ibm.debug.memorymap.MemoryMap;
import com.ibm.debug.memorymap.MemoryMapLayout;
import com.ibm.debug.memorymap.MemoryMapParent;
import com.ibm.debug.memorymap.MemoryMapRendering;
import com.ibm.debug.memorymap.dialogs.ExpansionErrorDialog;
import com.ibm.debug.memorymap.utils.MemoryMapException;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.pdt.internal.common.CommonUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class BuildMapAction
extends Action {
    private MemoryMapRendering fRendering;
    private List<Object> fExpandable;
    private MemoryMap fExpansionRoot;
    private List<Object> fMapElements;
    private List<Object> fRootList;
    private Exception fException;
    private MapElement fCause;

    public BuildMapAction(MemoryMapRendering rendering, boolean selectedElementOnly) {
        super(MemoryMapLabels.expand_map_label);
        this.fRendering = rendering;
        this.fMapElements = new ArrayList<Object>();
        this.fRootList = new ArrayList<Object>();
        if (selectedElementOnly) {
            this.setId("com.ibm.debug.memorymap.ExpandDSA");
        } else {
            this.setId("com.ibm.debug.memorymap.ExpandEntireMap");
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, this.getId());
    }

    public Exception getException() {
        return this.fException;
    }

    public void setRootList(List<Object> list) {
        this.fRootList = list;
    }

    public void setExpansionRoot(MemoryMap element) {
        this.fRootList = new ArrayList<Object>(1);
        this.fRootList.add(element);
        this.fExpansionRoot = element;
    }

    public void run() {
        ISelection currentSelection = this.fRendering.getSelection();
        if (currentSelection == null || currentSelection.isEmpty()) {
            currentSelection = new StructuredSelection((Object)this.fExpansionRoot);
        }
        this.fExpandable = new ArrayList<Object>(Arrays.asList(this.fRendering.getExpandedElements()));
        this.fExpandable.addAll(this.fRootList);
        boolean expand = true;
        this.startExpansion(false, expand, true);
        if (this.fException != null && !MemoryMapLabels.ExpandMapAction_cancelling_expansion.equals(this.fException.getMessage())) {
            if (this.fCause != null) {
                this.fExpandable.add(this.fCause);
                currentSelection = new StructuredSelection((Object)this.fCause);
            }
            String[] buttonLabels = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
            ExpansionErrorDialog dialog = new ExpansionErrorDialog(this.fException, CommonUtils.getShell(), buttonLabels, false);
            dialog.setBlockOnOpen(true);
            boolean bl = expand = dialog.open() == 0;
        }
        if (expand) {
            this.fRendering.disableRefresh();
            this.fRendering.setExpandedElements(this.fExpandable.toArray());
            this.fRendering.enableRefresh();
        }
        this.fRendering.setSelection(currentSelection);
        this.fExpandable = Collections.emptyList();
    }

    public List<Object> runWithoutExpand(boolean showProgressDialog) {
        this.startExpansion(true, false, showProgressDialog);
        this.fMapElements.addAll(this.fRootList);
        if (this.fException != null && this.fCause != null) {
            this.fRendering.setSelection(this.fCause);
        }
        List<Object> elements = this.fMapElements;
        this.fMapElements = Collections.emptyList();
        return elements;
    }

    private void startExpansion(final boolean createList, final boolean expandViewer, boolean showProgress) {
        this.fException = null;
        this.fCause = null;
        ProgressMonitorDialog p = new ProgressMonitorDialog(CommonUtils.getShell());
        p.setBlockOnOpen(false);
        p.setOpenOnRun(showProgress);
        p.setCancelable(true);
        this.fMapElements = new ArrayList<Object>(20);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(MemoryMapLabels.ExpandMapAction_expanding_map, -1);
                int i = 0;
                while (i < BuildMapAction.this.fRootList.size()) {
                    BuildMapAction.this.fExpansionRoot = (MemoryMap)BuildMapAction.this.fRootList.get(i);
                    BuildMapAction.this.expandSingleElement(monitor, createList, expandViewer, BuildMapAction.this.fExpansionRoot, 0);
                    ++i;
                }
                monitor.done();
            }
        };
        try {
            p.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            this.fException = (Exception)e.getTargetException();
        }
        catch (InterruptedException e) {
            this.fException = e;
        }
    }

    private void expandSingleElement(IProgressMonitor monitor, boolean createList, boolean expandViewer, MemoryMap element, int depth) throws InvocationTargetException, InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException(MemoryMapLabels.ExpandMapAction_cancelling_expansion);
        }
        if (!element.isBuilt() && this.isRecursiveStructure(element)) {
            String msg = MemoryMapLabels.ExpandMapAction_map_is_recursive;
            String field = element.getName();
            MemoryMapException mme = new MemoryMapException(field, msg, element.getLayout().getMappingFile(), 4);
            InvocationTargetException exception = new InvocationTargetException(mme);
            this.fCause = element;
            throw exception;
        }
        Object[] binding = new String[]{element.getName(), String.valueOf(element.getLength()), String.valueOf(depth)};
        monitor.subTask(NLS.bind((String)MemoryMapLabels.expand_map_current_item, (Object[])binding));
        MapElement[] children = null;
        try {
            children = element.getChildren(!element.isMap() || element == this.fExpansionRoot);
        }
        catch (Exception exception) {
            if (exception instanceof DebugException) {
                exception = (Exception)((DebugException)((Object)exception)).getStatus().getException();
            }
            this.fCause = element;
            throw new InvocationTargetException(exception);
        }
        if (createList) {
            this.fMapElements.addAll(Arrays.asList(children));
        }
        int pollingInterval = 25;
        int i = 0;
        while (i < children.length) {
            if (i % pollingInterval == 0 && monitor.isCanceled()) {
                throw new InterruptedException(MemoryMapLabels.ExpandMapAction_cancelling_expansion);
            }
            MapElement childElement = children[i];
            if (childElement.hasChildren()) {
                if (childElement instanceof MemoryMap) {
                    MemoryMap child = (MemoryMap)childElement;
                    this.expandSingleElement(monitor, createList, expandViewer, child, depth + 1);
                    if (child.isBuilt() && expandViewer) {
                        this.fExpandable.add(child);
                    }
                } else if (createList) {
                    this.fMapElements.addAll(childElement.getChildrenAsList());
                }
            }
            ++i;
        }
    }

    private boolean isRecursiveStructure(MemoryMap element) {
        if (!element.isStructure()) {
            return false;
        }
        boolean isPotentiallyRecursive = false;
        MemoryMapLayout elementLayout = element.getLayout();
        Path layoutPath = new Path(elementLayout.getMappingFile());
        MapElement parent = element.getParent();
        while (!(parent instanceof MemoryMapParent)) {
            MemoryMapLayout parentLayout = parent.getLayout();
            Path parentPath = new Path(parentLayout.getMappingFile());
            if (parentLayout != elementLayout && parentLayout.getLayoutType().equals(element.getType()) && layoutPath.equals((Object)parentPath)) {
                isPotentiallyRecursive = true;
                break;
            }
            parent = parent.getParent();
        }
        return isPotentiallyRecursive;
    }
}

