/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap.actions;

import com.ibm.debug.memorymap.AbstractMemoryMapRendering;
import com.ibm.debug.memorymap.MappingFileChangeListener;
import com.ibm.debug.memorymap.MemoryMapLayout;
import com.ibm.debug.memorymap.MemoryMapPlugin;
import com.ibm.debug.memorymap.actions.ExportMapAction;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapMessages;
import com.ibm.debug.memorymap.utils.MemoryMapRenderingMgr;
import com.ibm.debug.memorymap.utils.MemoryMapUtils;
import java.util.HashSet;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public class AutoExportAction
extends ExportMapAction {
    private MemoryMapLayout[] fMapLayouts;

    public AutoExportAction(AbstractMemoryMapRendering rendering, MemoryMapLayout[] layouts) {
        super(rendering);
        this.fMapLayouts = layouts;
    }

    @Override
    public void run() {
        boolean shouldExport = MemoryMapPlugin.getInstance().getPreferenceStore().getBoolean("com.ibm.debug.memorymap.do_export");
        if (this.fMapLayouts != null && this.fMapLayouts.length > 0) {
            AbstractMemoryMapRendering rendering = this.fMapLayouts[0].getRendering();
            if (shouldExport) {
                this.exportAndRebuildMap(this.fMapLayouts, rendering);
            } else {
                rendering.refresh();
            }
        }
    }

    private void exportAndRebuildMap(MemoryMapLayout[] changedLayouts, AbstractMemoryMapRendering rendering) {
        MessageDialogWithToggle dialog;
        boolean isShared = false;
        StringBuffer fileBuffer = new StringBuffer("");
        int i = 0;
        while (i < changedLayouts.length) {
            MemoryMapLayout layout = changedLayouts[i];
            HashSet<MappingFileChangeListener> similarRenderings = MemoryMapRenderingMgr.getRenderingsByFile(layout.getMappingFile());
            if (similarRenderings.size() > 1) {
                isShared = true;
                fileBuffer.append("\n").append(MemoryMapUtils.getFileName(layout.getMappingFile()));
            }
            ++i;
        }
        IPreferenceStore preferenceStore = MemoryMapPlugin.getInstance().getPreferenceStore();
        if (isShared && preferenceStore.getBoolean("com.ibm.debug.memorymap.warn") && (dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)rendering.getControl().getShell(), (String)MemoryMapLabels.PreExportTitle, (String)NLS.bind((String)MemoryMapMessages.PreExportWarning, (Object)fileBuffer.toString()), (String)MemoryMapLabels.MemoryMapRendering_7, (boolean)false, (IPreferenceStore)preferenceStore, (String)"com.ibm.debug.memorymap.warn")).getReturnCode() == 1) {
            rendering.refresh();
            return;
        }
        boolean success = this.exportAllLayouts(null, changedLayouts);
        if (success) {
            MemoryMapRenderingMgr.fireChangeEvent(changedLayouts);
        } else {
            rendering.refresh();
        }
    }
}

