/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap;

import com.ibm.debug.memorymap.AbstractMemoryMapRendering;
import com.ibm.debug.memorymap.FillerMapElement;
import com.ibm.debug.memorymap.MapElement;
import com.ibm.debug.memorymap.MemoryMapLayout;
import com.ibm.debug.memorymap.MemoryMapParent;
import com.ibm.debug.memorymap.MemoryMapSelection;
import com.ibm.debug.memorymap.utils.MemoryMapException;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapMessages;
import com.ibm.debug.memorymap.views.BasicDebugViewContentProvider;
import com.ibm.debug.memorymap.views.MemoryMapLabelProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PageBook;

public class TableMapRendering
extends AbstractMemoryMapRendering
implements ISelectionChangedListener {
    TableViewer fTableViewer;
    PageBook fPageBook;

    public TableMapRendering(String renderingId, File file) {
        super(renderingId, file);
    }

    @Override
    public boolean shouldRetrieveGroups() {
        return false;
    }

    @Override
    public void handleDebugError(DebugException e) {
        this.fErrorOccurred = true;
        this.fPageBook.showPage(this.createDebugErrorPage(e, (Composite)this.fPageBook));
    }

    @Override
    public void handleMapError(MemoryMapException mme) {
        this.fTableViewer.getContentProvider().dispose();
        this.fErrorOccurred = true;
        this.fPageBook.showPage((Control)this.createMapErrorPage(mme, (Composite)this.fPageBook));
    }

    public void mapModified() {
    }

    @Override
    public void refresh() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (TableMapRendering.this.fTableViewer.getTable().isDisposed()) {
                    return;
                }
                TableMapRendering.this.fTableViewer.refresh();
            }
        });
    }

    @Override
    public boolean supportsGrouping() {
        return false;
    }

    @Override
    public void mappingFileChanged() {
        this.createMapRoot(this.fRootLayout.getMemoryBlock());
        this.refresh();
    }

    public Control createControl(Composite parent) {
        this.fPageBook = new PageBook(parent, 0);
        this.fTableViewer = new TableViewer((Composite)this.fPageBook, 68354);
        Table table = this.fTableViewer.getTable();
        table.setHeaderVisible(true);
        TableColumn fieldColumn = new TableColumn(table, 16384);
        fieldColumn.setText(MemoryMapLabels.FieldColumnHeader);
        fieldColumn.setWidth(149);
        fieldColumn.setMoveable(true);
        TableColumn offSetColumn = new TableColumn(table, 16384);
        offSetColumn.setText("Value");
        offSetColumn.setMoveable(true);
        offSetColumn.setWidth(153);
        offSetColumn = new TableColumn(table, 16384);
        offSetColumn.setText(MemoryMapLabels.OffsetColumnHeader);
        offSetColumn.setMoveable(true);
        offSetColumn.setWidth(153);
        TableColumn descColumn = new TableColumn(table, 16384);
        descColumn.setText(MemoryMapLabels.DescColumnHeader);
        descColumn.setMoveable(true);
        descColumn.setWidth(149);
        this.fTableViewer.setContentProvider((IContentProvider)new TCP());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new MemoryMapLabelProvider(this, this.fRenderTool));
        this.createPopupMenu(this.fTableViewer.getControl());
        this.createPopupMenuActions();
        this.fPageBook.showPage(this.fTableViewer.getControl());
        this.setUpMap();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this.fTableViewer.getContentProvider());
        this.fTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        return this.fPageBook;
    }

    private void setUpMap() {
        if (this.createMapRoot(this.getMemoryBlock()) == null) {
            return;
        }
        if (this.fRootLayout.getAddress() != null && this.fTableViewer != null) {
            this.fTableViewer.setInput(this.fMapParent.getChildrenAsList().get(0));
            if (!this.fErrorOccurred) {
                this.fTableViewer.refresh();
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.fTableViewer != null && this.fTableViewer.getControl() != null) {
            this.fTableViewer.getControl().dispose();
        }
        this.disposeOfLayouts();
    }

    @Override
    public void rebuildMap() {
        super.rebuildMap();
        if (this.fTableViewer == null) {
            this.fTableViewer = new TableViewer((Composite)this.fPageBook, 68354);
        }
        this.fTableViewer.setInput(this.fMapParent.getChildrenAsList().get(0));
        this.fTableViewer.setContentProvider((IContentProvider)new TCP());
        this.fTableViewer.refresh();
        if (!this.fErrorOccurred) {
            this.fPageBook.showPage(this.fTableViewer.getControl());
        }
    }

    @Override
    protected MemoryMapLayout createMapRoot(IMemoryBlock memoryBlock) {
        super.createMapRoot(memoryBlock);
        return this.fRootLayout;
    }

    public Control getControl() {
        return this.fPageBook;
    }

    @Override
    public boolean supportsCaching() {
        return false;
    }

    @Override
    public void setMappingFile(String file) {
        this.fMappingFile = file;
        this.disposeOfLayouts();
        this.createMapRoot(this.fRootLayout.getMemoryBlock());
    }

    @Override
    public void retrieveGroupingInfo(boolean process) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
    }

    public void resetRendering() throws DebugException {
    }

    @Override
    protected void updateSelection(ArrayList<MapElement> items) {
        this.fTableViewer.setSelection((ISelection)new StructuredSelection(items));
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() == this) {
            return;
        }
        MemoryMapSelection[] selections = this.getSelectionsFromItem((Item[])this.fTableViewer.getTable().getSelection());
        if (selections != null && selections.length > 0 && selections[0].getStartAddress() != null) {
            this.fireSelectedAddressesChanged(selections);
        }
    }

    class TCP
    extends BasicDebugViewContentProvider
    implements IDebugEventSetListener {
        TCP() {
        }

        @Override
        public Object[] getChildren(Object parent) {
            MapElement element = (MapElement)parent;
            Object[] children = null;
            try {
                children = element.getChildren(true);
                if (!(element instanceof MemoryMapParent) && children.length == 0) {
                    children = new MapElement[]{new FillerMapElement(element.getLayout(), element, MemoryMapLabels.MemoryMapConstants_6, null, element.getAddress(), new HashSet<String>())};
                }
            }
            catch (DebugException de) {
                if (!(element.getParent() instanceof MemoryMapParent)) {
                    String field = "";
                    Throwable throwable = de.getStatus().getException();
                    if (throwable instanceof MemoryMapException) {
                        field = ((MemoryMapException)throwable).getField();
                    }
                    children = new MapElement[]{new FillerMapElement(element.getLayout(), element, NLS.bind((String)MemoryMapMessages.MemoryMapLayout_Failed_to_build_memory_map, (Object)field), de.getMessage(), element.getAddress(), element.getExplicitGroups())};
                    element.addChild((MapElement)children[0]);
                }
                Throwable throwable = de.getStatus().getException();
                if (throwable instanceof MemoryMapException) {
                    TableMapRendering.this.handleMapError((MemoryMapException)throwable);
                } else {
                    TableMapRendering.this.handleDebugError(de);
                }
                return new Object[]{new Object()};
            }
            return children;
        }

        @Override
        public boolean hasChildren(Object element) {
            return ((MapElement)element).hasChildren();
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        @Override
        public void dispose() {
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
            super.dispose();
        }

        @Override
        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object getParent(Object element) {
            return ((MapElement)element).getParent();
        }

        @Override
        public void handleDebugEvents(DebugEvent[] events) {
            if (this.isDisposed()) {
                return;
            }
            if (TableMapRendering.this.fTableViewer.getTable().isDisposed()) {
                return;
            }
            TableMapRendering.this.refresh();
        }

        @Override
        protected Object[] doGetChildren(Object parent) {
            return this.getChildren(parent);
        }

        @Override
        protected void doHandleDebugEvent(DebugEvent event) {
            this.handleDebugEvents(new DebugEvent[]{event});
        }
    }
}

