/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap;

import com.ibm.debug.memorymap.MemoryBlockSegment;
import com.ibm.debug.memorymap.MemoryMapPlugin;
import java.math.BigInteger;

public class SparseMapPartitioner {
    public static MemoryBlockSegment[] partitionBlock(int blockLength, BigInteger startAddress) {
        MemoryBlockSegment[] blocks = new MemoryBlockSegment[]{};
        if (blockLength > 0) {
            int min_block_size = MemoryMapPlugin.getInstance().getPreferenceStore().getInt("com.ibm.debug.memorymap.mbsz");
            if (blockLength <= min_block_size || min_block_size <= 0) {
                blocks = new MemoryBlockSegment[]{new MemoryBlockSegment(startAddress, blockLength)};
            } else {
                double numberOfPrtsAsDouble = (double)blockLength / (double)min_block_size;
                int numberOfFullBlocks = (int)Math.floor(numberOfPrtsAsDouble);
                int numberOfBlocks = (int)Math.ceil(numberOfPrtsAsDouble);
                blocks = new MemoryBlockSegment[numberOfBlocks];
                BigInteger nextStartAddress = startAddress;
                int i = 0;
                while (i < numberOfFullBlocks) {
                    blocks[i] = new MemoryBlockSegment(nextStartAddress, min_block_size);
                    nextStartAddress = nextStartAddress.add(BigInteger.valueOf(min_block_size));
                    ++i;
                }
                if (numberOfBlocks != numberOfFullBlocks) {
                    blocks[numberOfFullBlocks] = new MemoryBlockSegment(nextStartAddress, blockLength % min_block_size);
                }
            }
        }
        return blocks;
    }
}

