/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap;

import com.ibm.debug.memorymap.AbstractMemoryMapRendering;
import com.ibm.debug.memorymap.MapElement;
import com.ibm.debug.memorymap.MemoryMap;
import com.ibm.debug.memorymap.MemoryMapBuilder;
import com.ibm.debug.memorymap.MemoryMapLayout;
import com.ibm.debug.memorymap.MemoryMapRendering;
import com.ibm.debug.memorymap.utils.MemoryMapException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Node;

public class ORGParent
extends MemoryMap {
    private MapElement fORGedElement;

    public ORGParent(MemoryMapLayout layout, MapElement parent, String name, BigInteger address, int offset, Node node, Set<String> groups) throws MemoryMapException {
        super(layout, parent, name, address, offset, 0, "ORG", groups, node);
    }

    public void build() throws MemoryMapException {
        this.fChildren = new ArrayList();
        AbstractMemoryMapRendering rendering = this.fMapLayout.getRendering();
        MemoryMapBuilder builder = rendering.getMapBuilder(this, this.fAddress, this.fNode, this.fOffset);
        try {
            builder.buildChildren();
        }
        catch (MemoryMapException e) {
            this.fChildren = Collections.emptyList();
            throw e;
        }
        this.fIsBuilt = true;
        if (this.fParent instanceof MemoryMap && ((MemoryMap)this.fParent).isBuilt() && Display.getCurrent() != null) {
            if (rendering instanceof MemoryMapRendering) {
                ((MemoryMapRendering)rendering).refreshElement(this.fParent);
            } else {
                rendering.refresh();
            }
        }
        this.addGroupsToChildren(this);
        this.addGroupsToParent(builder.getAddedGroups());
    }

    @Override
    public boolean hasChildren() {
        return !this.fChildren.isEmpty();
    }

    public MapElement getORGedToElement() {
        return this.fORGedElement;
    }

    protected void setORGedElement(MapElement m) {
        if (this.fORGedElement == null && m != null) {
            this.fORGedElement = m;
        }
    }

    public String getORGField() {
        return MemoryMapBuilder.getAttribute(this.fNode.getAttributes(), "FIELD");
    }

    public int getLastOffset() {
        int offset = 0;
        if (this.fIsBuilt && !this.fChildren.isEmpty()) {
            MapElement lastChild = (MapElement)this.fChildren.get(this.fChildren.size() - 1);
            offset = lastChild.isORGParent() ? ((ORGParent)lastChild).getLastOffset() : lastChild.getOffset() + lastChild.getLength();
        }
        return offset;
    }

    @Override
    public MemoryByte[] getBytes() throws DebugException {
        return null;
    }

    @Override
    public int getOffset() {
        return this.fOffset;
    }

    @Override
    public boolean isORGParent() {
        return true;
    }

    @Override
    public String getType() {
        return "ORG";
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public String getTagForExport(boolean preserveDirectoryStructure) {
        StringBuffer tag = new StringBuffer("<");
        tag.append("ORG_GROUP").append(" ");
        tag.append("FIELD").append(" = ").append("\"").append(this.getORGField()).append("\"");
        tag.append(" ");
        tag.append("Header").append(" = ").append("\"").append(this.fName).append("\"");
        tag.append(" ");
        if (!this.fExplicitGroups.isEmpty()) {
            String groups = this.fExplicitGroups.toString();
            groups = groups.replaceAll("[\\]\\[]", "");
            tag.append("Groups").append(" = ").append("\"").append(groups).append("\"");
            tag.append(" ");
        }
        tag.append(">");
        return tag.toString();
    }
}

