/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap;

import com.ibm.debug.memorymap.AbstractMemoryMapRendering;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.debug.ui.memory.IMemoryRendering;

public class MemoryMapSelection {
    private BigInteger fStartAddress;
    private long fLength;
    private boolean fHasChildren;
    private Set<IMemoryRendering> fSynchronizedRenderings;

    public MemoryMapSelection(AbstractMemoryMapRendering rendering, BigInteger integer, long length, boolean hasChildren) {
        this.fStartAddress = integer;
        this.fLength = length;
        this.fHasChildren = hasChildren;
        this.fSynchronizedRenderings = new HashSet<IMemoryRendering>();
        this.fSynchronizedRenderings.add((IMemoryRendering)rendering);
    }

    public BigInteger getStartAddress() {
        return this.fStartAddress;
    }

    public long getLength() {
        return this.fLength;
    }

    public boolean hasChildren() {
        return this.fHasChildren;
    }

    public void addRendering(IMemoryRendering rendering) {
        this.fSynchronizedRenderings.add(rendering);
    }

    public void removeRendering(IMemoryRendering rendering) {
        this.fSynchronizedRenderings.remove(rendering);
    }

    public IMemoryRendering[] getSynchronizedRenderings() {
        return this.fSynchronizedRenderings.toArray(new IMemoryRendering[0]);
    }

    public void clearSynchronizedRenderings() {
        this.fSynchronizedRenderings.clear();
    }
}

