/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap;

import com.ibm.debug.memorymap.AbstractMemoryMapRendering;
import com.ibm.debug.memorymap.MemoryMapBindingProvider;
import com.ibm.debug.memorymap.MemoryMapPlugin;
import com.ibm.debug.memorymap.MemoryMapRendering;
import com.ibm.debug.memorymap.MemoryMapRenderingFile;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapUtils;
import com.ibm.debug.pdt.rsecommon.IBrowseDialogDelegate;
import com.ibm.debug.pdt.rsecommon.IRemoteFileMgr;
import com.ibm.debug.pdt.rsecommon.RSECommonPlugin;
import com.ibm.debug.pdt.rsecommon.RSELabels;
import com.ibm.debug.pdt.rsecommon.RSEMessages;
import com.ibm.debug.pdt.rsecommon.RSEUtils;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class MemoryMapRenderingFolder
extends MemoryMapRenderingFile {
    private String[] fDirectoryContents;
    private boolean fNeedsRefresh;
    private MemoryMapBindingProvider fBindingProvider;

    public MemoryMapRenderingFolder(String file, MemoryMapBindingProvider provider) {
        super(file);
        this.fName = MemoryMapLabels.memory_map_directory_option;
        this.fDirectoryContents = new String[0];
        this.fNeedsRefresh = true;
        this.fBindingProvider = provider;
    }

    public void setNewDirectory(String newDirectory) {
        this.fFileName = newDirectory;
        this.fNeedsRefresh = true;
        this.fDirectoryContents = new String[0];
        this.fProfile = null;
        this.fConnection = null;
    }

    @Override
    public IMemoryRendering createRendering() throws CoreException {
        AbstractMemoryMapRendering rendering = null;
        rendering = this.openBrowseDialog();
        if (this.fNeedsRefresh) {
            this.updateFileList();
            this.fBindingProvider.markBindingsAsStale();
        }
        return rendering;
    }

    public void updateFileList() {
        if (this.fNeedsRefresh) {
            this.fNeedsRefresh = false;
            this.fDirectoryContents = new String[0];
            try {
                if (!this.isRemote()) {
                    this.getLocalFileList();
                } else {
                    this.getRemoteFileList();
                }
            }
            catch (DebugException e) {
                UIJob job = new UIJob(RSELabels.GenericError){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        String title = NLS.bind((String)RSEMessages.ErrorListingDirectory, (Object)MemoryMapRenderingFolder.this.fFileName);
                        MessageDialog.openError((Shell)this.getDisplay().getActiveShell(), (String)title, (String)e.getStatus().getMessage());
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            }
        }
    }

    public String[] getDirectoryContents() {
        return this.fDirectoryContents;
    }

    private void getRemoteFileList() throws DebugException {
        IRemoteFileMgr mgr = RSECommonPlugin.getRemoteFileMgr();
        if (mgr != null) {
            String profile = MemoryMapPlugin.getInstance().getPreferenceStore().getString("com.ibm.debug.memorymap.profile_name");
            String con = MemoryMapPlugin.getInstance().getPreferenceStore().getString("com.ibmm.debug.memorymap.conn_name");
            try {
                this.fDirectoryContents = mgr.getRemoteFileContents(profile, con, this.fFileName, ".xml");
            }
            catch (Exception e) {
                throw new DebugException((IStatus)new Status(4, "com.ibm.debug.memorymap", 0, e.getMessage(), null));
            }
        } else {
            StringBuffer message = new StringBuffer(NLS.bind((String)RSEMessages.ErrorListingDirectory, (Object)this.fFileName));
            message.append("\n").append(NLS.bind((String)RSEMessages.RequiredPluginNotFound, (Object)"com.ibm.debug.pdt.remotebrowse"));
            this.fIsRemote = false;
            this.fProfile = null;
            this.fConnection = null;
            this.fFileName = MemoryMapUtils.getDefaultMapLocation();
            this.savePreferences(null, null, false, this.fFileName);
        }
    }

    private void getLocalFileList() throws DebugException {
        File fileObject = new File(this.fFileName);
        final ArrayList directoryContents = new ArrayList();
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File childFileOrFolder) {
                boolean acceptFile;
                boolean bl = acceptFile = childFileOrFolder.isFile() && childFileOrFolder.getAbsolutePath().endsWith(".xml");
                if (acceptFile) {
                    directoryContents.add(childFileOrFolder.getAbsolutePath());
                }
                return acceptFile;
            }
        };
        try {
            fileObject.listFiles(filter);
            this.fDirectoryContents = directoryContents.toArray(new String[0]);
        }
        catch (SecurityException e) {
            throw new DebugException((IStatus)new Status(4, "com.ibm.debug.memorymap", 0, e.getMessage(), null));
        }
    }

    private AbstractMemoryMapRendering openBrowseDialog() throws DebugException {
        IBrowseDialogDelegate dialog = RSECommonPlugin.getRemoteBrowseDialog();
        String mappingFile = null;
        String encoding = null;
        if (dialog != null) {
            dialog.setInitialSelection(this.fProfile, this.fConnection, this.fFileName, this.fNeedsRefresh);
            if (dialog.open(false, new String[]{"xml"}) == 0) {
                mappingFile = dialog.getTempFileForSelection();
                if (mappingFile != null) {
                    HashMap newPreferenceInfo = dialog.getSelectionInfo();
                    IRemoteFileMgr fileManager = dialog.getFileManager();
                    fileManager.copyRequiredExternalFiles(dialog.getSelectedFile(), mappingFile);
                    String remoteFolderName = MemoryMapUtils.getFolderName((String)newPreferenceInfo.get(RSEUtils.DIRECTORY));
                    this.fProfile = (String)newPreferenceInfo.get(RSEUtils.PROFILE);
                    this.fConnection = (String)newPreferenceInfo.get(RSEUtils.CONNECTION);
                    this.fFileName = remoteFolderName;
                    this.fIsRemote = (Boolean)newPreferenceInfo.get("is_remote");
                    encoding = fileManager.getSystemEncoding(this.fProfile, this.fConnection, this.fFileName);
                }
                if (!this.fIsRemote) {
                    encoding = "ISO-8859-1";
                }
            }
        } else {
            if (this.isRemote()) {
                String message = NLS.bind((String)RSEMessages.RequiredPluginNotFound, (Object)"com.ibm.debug.pdt.remotebrowse");
                this.fProfile = null;
                this.fConnection = null;
                this.fFileName = MemoryMapUtils.getDefaultMapLocation();
                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)RSELabels.GenericError, (String)message.toString());
            }
            FileDialog fileDialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 0);
            fileDialog.setFilterPath(this.getId());
            fileDialog.setFilterExtensions(new String[]{"*.xml"});
            mappingFile = fileDialog.open();
            if (mappingFile != null) {
                this.fFileName = MemoryMapUtils.getFolderName(mappingFile);
                this.fConnection = null;
                this.fProfile = null;
                this.fIsRemote = false;
            }
            encoding = "ISO-8859-1";
        }
        this.fNeedsRefresh = true;
        if (mappingFile == null) {
            return null;
        }
        this.savePreferences(this.fProfile, this.fConnection, this.fIsRemote, this.fFileName);
        this.fBindingProvider.updateRecentlySelectedMappingFilesList(new MemoryMapRenderingFile.Memento(this.fProfile, this.fConnection, this.fIsRemote, mappingFile));
        MemoryMapRendering memoryMapRendering = new MemoryMapRendering(MemoryMapUtils.getFileName(mappingFile), new File(mappingFile));
        memoryMapRendering.setEncoding(encoding);
        return memoryMapRendering;
    }

    private void savePreferences(String profile, String connection, boolean isRemote, String fileName) {
        IPreferenceStore store = MemoryMapPlugin.getInstance().getPreferenceStore();
        store.setValue("com.ibm.debug.memorymap.profile_name", profile == null ? "" : profile);
        store.setValue("com.ibmm.debug.memorymap.conn_name", connection == null ? "" : connection);
        store.setValue("map_location_is_remote", isRemote);
        store.setValue("com.ibm.debug.memorymap.memoryMapLocation", fileName);
    }

    @Override
    public int getOrdinal() {
        return super.getOrdinal() - 1;
    }
}

