/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap;

import com.ibm.debug.memorymap.AbstractMemoryMapRendering;
import com.ibm.debug.memorymap.MemoryMapBindingProvider;
import com.ibm.debug.memorymap.MemoryMapPlugin;
import com.ibm.debug.memorymap.MemoryMapRendering;
import com.ibm.debug.memorymap.utils.MemoryMapUtils;
import com.ibm.debug.pdt.rsecommon.IRemoteFileMgr;
import com.ibm.debug.pdt.rsecommon.RSECommonPlugin;
import com.ibm.debug.pdt.rsecommon.RSEMessages;
import com.ibm.debug.pdt.ui.IOrderableMemoryRenderingType;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;

public class MemoryMapRenderingFile
implements IOrderableMemoryRenderingType {
    protected String fName;
    protected boolean fIsRemote;
    protected String fFileName;
    private boolean duplicate;
    protected String fProfile;
    protected String fConnection;
    private MemoryMapBindingProvider fCreator = null;

    MemoryMapRenderingFile(Memento memento, MemoryMapBindingProvider creator) {
        this(memento);
        this.fCreator = creator;
    }

    MemoryMapRenderingFile(Memento memento) {
        this(memento.getFileName());
        this.fIsRemote = memento.isRemote();
        this.fProfile = memento.getProfile();
        this.fConnection = memento.getConnection();
    }

    public MemoryMapRenderingFile(String file) {
        this.fFileName = file;
        this.duplicate = false;
        this.fName = MemoryMapUtils.getFileName(this.fFileName);
    }

    public String getRenderingId() {
        return this.fName;
    }

    public String getName() {
        if (this.duplicate) {
            return this.fName + " (" + this.fFileName + ")";
        }
        return this.fName;
    }

    public String getLayoutHeader() {
        return this.fName;
    }

    public void setHasDuplicate(boolean isDuplicate) {
        this.duplicate = isDuplicate;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public String getLabel() {
        return this.getName();
    }

    public String getId() {
        return this.fFileName;
    }

    public boolean isRemote() {
        return this.fIsRemote;
    }

    public void setRemote(boolean isRemote) {
        if (this.fCreator != null) {
            return;
        }
        this.fIsRemote = isRemote;
        if (isRemote) {
            this.fProfile = MemoryMapPlugin.getInstance().getPreferenceStore().getString("com.ibm.debug.memorymap.profile_name");
            this.fConnection = MemoryMapPlugin.getInstance().getPreferenceStore().getString("com.ibmm.debug.memorymap.conn_name");
        }
    }

    public String toString() {
        return this.getName();
    }

    public IMemoryRendering createRendering() throws CoreException {
        AbstractMemoryMapRendering rendering = null;
        if (this.fIsRemote) {
            rendering = this.copyRequiredRemoteFiles(this.fFileName);
        } else {
            rendering = new MemoryMapRendering(this.getId(), new File(this.fFileName));
            rendering.setEncoding("ISO-8859-1");
        }
        if (this.fCreator != null) {
            this.fCreator.updateRecentlySelectedMappingFilesList(new Memento(this.fProfile, this.fConnection, this.fIsRemote, this.fFileName));
        }
        return rendering;
    }

    private AbstractMemoryMapRendering copyRequiredRemoteFiles(String remoteFileName) throws DebugException {
        String mappingFile = null;
        IRemoteFileMgr mgr = RSECommonPlugin.getRemoteFileMgr();
        String error = null;
        String encoding = null;
        if (mgr != null) {
            try {
                mappingFile = mgr.copyRequiredExternalFiles(this.fProfile, this.fConnection, remoteFileName);
                encoding = mgr.getSystemEncoding(this.fProfile, this.fConnection, remoteFileName);
            }
            catch (Exception e) {
                error = e.getMessage();
            }
        } else {
            error = NLS.bind((String)RSEMessages.RequiredPluginNotFound, (Object)"com.ibm.debug.pdt.remotebrowse");
        }
        if (error != null) {
            throw new DebugException((IStatus)new Status(4, "com.ibm.debug.memorymap", 0, error, null));
        }
        MemoryMapRendering rendering = null;
        if (mappingFile != null) {
            rendering = new MemoryMapRendering(this.getId(), new File(mappingFile));
            rendering.setEncoding(encoding);
        }
        return rendering;
    }

    public int getOrdinal() {
        return 101;
    }

    static class Memento {
        private final String fProfile;
        private final String fConnection;
        private final boolean fIsRemote;
        private final String fFileName;

        Memento(String profile, String connection, boolean isRemote, String fileName) {
            this.fProfile = profile;
            this.fConnection = connection;
            this.fIsRemote = isRemote;
            this.fFileName = fileName;
        }

        Memento(IPreferenceStore store, int ordinal) {
            String extension = Integer.toString(ordinal);
            this.fFileName = store.getString("com.ibm.debug.memorymap.MemoryMapRenderingFile.Memento.fFileName_".concat(extension));
            this.fIsRemote = store.getBoolean("com.ibm.debug.memorymap.MemoryMapRenderingFile.Memento.fIsRemote_".concat(extension));
            if (this.fIsRemote) {
                this.fConnection = store.getString("com.ibm.debug.memorymap.MemoryMapRenderingFile.Memento.fConnection_".concat(extension));
                this.fProfile = store.getString("com.ibm.debug.memorymap.MemoryMapRenderingFile.Memento.fProfile_".concat(extension));
            } else {
                this.fConnection = null;
                this.fProfile = null;
            }
        }

        void persist(IPreferenceStore store, int ordinal) {
            String extension = Integer.toString(ordinal);
            if (this.fIsRemote) {
                store.setValue("com.ibm.debug.memorymap.MemoryMapRenderingFile.Memento.fProfile_".concat(extension), this.fProfile);
                store.setValue("com.ibm.debug.memorymap.MemoryMapRenderingFile.Memento.fConnection_".concat(extension), this.fConnection);
            }
            store.setValue("com.ibm.debug.memorymap.MemoryMapRenderingFile.Memento.fIsRemote_".concat(extension), this.fIsRemote);
            store.setValue("com.ibm.debug.memorymap.MemoryMapRenderingFile.Memento.fFileName_".concat(extension), this.fFileName);
        }

        protected final String getProfile() {
            return this.fProfile;
        }

        protected final String getConnection() {
            return this.fConnection;
        }

        protected final boolean isRemote() {
            return this.fIsRemote;
        }

        protected final String getFileName() {
            return this.fFileName;
        }

        public boolean equals(Object o) {
            return o instanceof Memento ? this.equals((Memento)o) : false;
        }

        boolean equals(Memento other) {
            boolean extendedCheck;
            boolean commonCheck;
            boolean bl = commonCheck = this.fFileName.equals(other.fFileName) && this.fIsRemote == other.fIsRemote;
            boolean bl2 = this.fIsRemote ? this.fProfile.equals(other.fProfile) && this.fConnection.equals(other.fConnection) : (extendedCheck = true);
            return commonCheck && extendedCheck;
        }

        public int hashCode() {
            return this.fProfile.hashCode() + this.fConnection.hashCode() + this.fFileName.hashCode();
        }
    }
}

