/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap;

import com.ibm.debug.memorymap.AbstractMemoryMapRendering;
import com.ibm.debug.memorymap.ErrorMapElement;
import com.ibm.debug.memorymap.FillerMapElement;
import com.ibm.debug.memorymap.MapElement;
import com.ibm.debug.memorymap.MappingFileChangeListener;
import com.ibm.debug.memorymap.MemoryMap;
import com.ibm.debug.memorymap.MemoryMapLayout;
import com.ibm.debug.memorymap.MemoryMapParent;
import com.ibm.debug.memorymap.MemoryMapPlugin;
import com.ibm.debug.memorymap.MemoryMapSelection;
import com.ibm.debug.memorymap.actions.BuildMapAction;
import com.ibm.debug.memorymap.actions.ChangeGroupAction;
import com.ibm.debug.memorymap.actions.ChangeOffsetModeAction;
import com.ibm.debug.memorymap.actions.ChangeRepresentationAction;
import com.ibm.debug.memorymap.actions.ChooseRenderingColumnsAction;
import com.ibm.debug.memorymap.actions.CollapseAllAction;
import com.ibm.debug.memorymap.actions.CopyMemoryMapToClipboardAction;
import com.ibm.debug.memorymap.actions.EditDescriptionAction;
import com.ibm.debug.memorymap.actions.EditValueAction;
import com.ibm.debug.memorymap.actions.FindFieldAction;
import com.ibm.debug.memorymap.actions.ManageGroupsAction;
import com.ibm.debug.memorymap.actions.OpenMapFileAction;
import com.ibm.debug.memorymap.actions.PrintMemoryMapAction;
import com.ibm.debug.memorymap.actions.SetGroupAction;
import com.ibm.debug.memorymap.actions.ToggleShowTypesAction;
import com.ibm.debug.memorymap.dialogs.ResizeableConfirmationDialog;
import com.ibm.debug.memorymap.utils.CachedMapElement;
import com.ibm.debug.memorymap.utils.MemoryMapException;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapMessages;
import com.ibm.debug.memorymap.utils.MemoryMapProperty;
import com.ibm.debug.memorymap.views.MemoryMapContentProvider;
import com.ibm.debug.memorymap.views.MemoryMapLabelProvider;
import com.ibm.debug.pdt.internal.common.CommonUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.ui.memory.IResettableMemoryRendering;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.PageBook;

public class MemoryMapRendering
extends AbstractMemoryMapRendering
implements IResettableMemoryRendering,
ISelectionChangedListener,
IPropertyChangeListener,
MappingFileChangeListener {
    private static final String SPACE = " ";
    private static boolean fConfirmPreserveGroups = true;
    private static boolean fPreserveGroups = false;
    private static final Object fLock = new Object();
    private MemoryMapLabelProvider fLabelProvider;
    private MemoryMapContentProvider fContentProvider;
    private boolean fFinishedSetup;
    private File fFile;
    private Label fToolTipLabel;
    private Shell fToolTipShell;
    private MenuManager fChangeGroupMenu;
    public static final String CHANGE_GROUP_MENU = "com.ibm.debug.memorymap.showGroup";
    private MenuManager fSetGroupMenu;
    public static final String SET_GROUP_MENU = "com.ibm.debug.memorymap.setGroup";
    private MenuManager fOpenMapFileMenu;
    public static final String OPEN_MAP_FILE_MENU = "com.ibm.debug.memorymap.openMapFile";
    private MenuManager fRepresentationMenu;
    public static final String REPRESENTATION_MENU = "com.ibm.debug.memorymap.representation";
    public static final String CONTEXT_ID = "com.ibm.debug.memorymap.context";
    public static final String FIND_COMMAND_ID = "com.ibm.debug.memorymap.command.find";
    public static final String EDIT_COMMAND_ID = "com.ibm.debug.memorymap.command.edit";
    private ChangeRepresentationAction fHex;
    private ChangeRepresentationAction fAscii;
    private ChangeRepresentationAction fEbcdic;
    private ChangeRepresentationAction fDecimal;
    private ChangeRepresentationAction fBinary;
    private ChangeRepresentationAction fRestore;
    private CollapseAllAction fCollapseAllAction;
    private BuildMapAction fBuildAllAction;
    private BuildMapAction fBuildSingleElementAction;
    private EditValueAction fEditValueAction;
    private FindFieldAction fFindFieldAction;
    private IHandler fFindFieldActionHandler;
    private IHandler fEditDescActionHandler;
    private ManageGroupsAction fManageGroupsAction;
    private PrintMemoryMapAction fPrintAction;
    private CopyMemoryMapToClipboardAction fCopyAction;
    private EditDescriptionAction fEditDescriptionAction;
    private ToggleShowTypesAction fShowTypeAction;
    private PageBook fPageBook;
    private TreeViewer fTreeViewer;
    private ArrayList<IContextActivation> fContextList;
    private ArrayList<Object> fOldExpandedElements;
    private ArrayList<MemoryMap> fNewExpandedElements;
    private boolean fExtractGroups;
    private boolean fMapPropertyModified;
    private ChangeGroupAction fShowWholeMapAction;
    private ChooseRenderingColumnsAction fChooseColumnsAction;
    private static ChangeOffsetModeAction fDecimalModeAction = new ChangeOffsetModeAction("DECIMAL");
    private static ChangeOffsetModeAction fHexModeAction = new ChangeOffsetModeAction("HEX");

    public MemoryMapRendering(String renderingId, File inputFile) throws DebugException {
        super(renderingId, inputFile);
        this.fFile = inputFile;
        if (!this.fFile.exists()) {
            Status status = new Status(4, "com.ibm.debug.memorymap", 0, NLS.bind((String)MemoryMapMessages.memory_map_utils_error_file_error, (Object)inputFile), null);
            throw new DebugException((IStatus)status);
        }
        if (this.getRenderingId() == null) {
            throw new NullPointerException();
        }
        this.fExtractGroups = true;
        this.fMapPropertyModified = false;
        this.fCurrentGroup = null;
        this.fOldExpandedElements = new ArrayList();
        this.fNewExpandedElements = new ArrayList();
        this.fContextList = new ArrayList();
        this.createActionHandlers();
        this.fFinishedSetup = false;
    }

    protected final void finalize() {
    }

    @Override
    public String getMappingFile() {
        return this.fMappingFile;
    }

    public MapElement getRootElement() {
        return this.fRootLayout.getRootElement();
    }

    public Control createControl(Composite parent) {
        this.fPageBook = new PageBook(parent, 0);
        this.fTreeViewer = new TreeViewer((Composite)this.fPageBook, 68354);
        final Tree tree = this.fTreeViewer.getTree();
        tree.setHeaderVisible(true);
        IPreferenceStore store = MemoryMapPlugin.getInstance().getPreferenceStore();
        String[] headers = new String[]{MemoryMapLabels.FieldColumnHeader, MemoryMapLabels.ValueColumnHeader, MemoryMapLabels.OffsetColumnHeader, MemoryMapLabels.AddressColumnHeader, MemoryMapLabels.DescColumnHeader};
        String[] prefKeys = new String[]{"com.ibm.debug.memorymap.show_field", "com.ibm.debug.memorymap.show_val", "com.ibm.debug.memorymap.show_offset", "com.ibm.debug.memorymap.show_addr", "com.ibm.debug.memorymap.show_desc"};
        String[] widthKeys = new String[]{"com.ibm.debug.memorymap.field_col", "com.ibm.debug.memorymap.value", "com.ibm.debug.memorymap.offset", "com.ibm.debug.memorymap.addr", "com.ibm.debug.memorymap.desc_col"};
        Listener resizeListener = new Listener(){

            public void handleEvent(Event event) {
                TreeColumn column = (TreeColumn)event.widget;
                MemoryMapPlugin.getInstance().getPreferenceStore().setValue(column.getData("width").toString(), column.getWidth());
            }
        };
        int i = 0;
        while (i < headers.length) {
            int defaultColWidth = store.getInt(widthKeys[i]);
            TreeColumn column = new TreeColumn(tree, 16384);
            column.setText(headers[i]);
            boolean showColumn = store.getBoolean(prefKeys[i]);
            column.setWidth(showColumn ? defaultColWidth : 0);
            column.setData("visible", (Object)prefKeys[i]);
            column.setData("width", (Object)widthKeys[i]);
            column.setMoveable(showColumn);
            column.setResizable(showColumn);
            column.addListener(11, resizeListener);
            if (showColumn) {
                column.setResizable(true);
            }
            ++i;
        }
        int[] nArray = new int[5];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        tree.setColumnOrder(nArray);
        tree.setLinesVisible(true);
        tree.addListener(8, new Listener(){

            public void handleEvent(Event e) {
                MemoryMapRendering.this.doubleClick(tree, e);
            }
        });
        this.fTreeViewer.setUseHashlookup(true);
        this.fPageBook.showPage(this.fTreeViewer.getControl());
        this.configureToolTip();
        this.createPopupMenuActions();
        this.setUpMap();
        this.setUpContentProvider();
        this.fTreeViewer.setInput((Object)this.fMapParent);
        this.createPopupMenu(this.fTreeViewer.getControl());
        this.fTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.setupSynchronization();
        if (!this.fErrorOccurred && this.fRootLayout.getRootElement() != null) {
            try {
                this.fTreeViewer.setExpandedState((Object)this.fRootLayout.getRootElement(), true);
            }
            catch (Exception e) {
                MemoryMapPlugin.logException(e);
            }
        }
        this.fFinishedSetup = true;
        this.fLabelProvider = new MemoryMapLabelProvider(this, this.fRenderTool);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        return this.fPageBook;
    }

    public Control getControl() {
        return this.fPageBook;
    }

    private void displayTreeViewer() {
        if (this.fTreeViewer != null) {
            this.fErrorOccurred = false;
            this.fPageBook.showPage(this.fTreeViewer.getControl());
        }
    }

    @Override
    public void handleMapError(MemoryMapException mme) {
        Composite errorPage = this.createMapErrorPage(mme, (Composite)this.fPageBook);
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
        }
        this.fPageBook.showPage((Control)errorPage);
    }

    @Override
    public void handleDebugError(DebugException e) {
        this.fPageBook.showPage(this.createDebugErrorPage(e, (Composite)this.fPageBook));
    }

    public void activated() {
        super.activated();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IContextService contextService = (IContextService)workbench.getAdapter(IContextService.class);
        ICommandService commandService = (ICommandService)workbench.getAdapter(ICommandService.class);
        if (contextService != null && commandService != null) {
            this.fContextList.add(contextService.activateContext(CONTEXT_ID));
            if (this.fFindFieldActionHandler == null || this.fEditDescActionHandler == null) {
                this.createActionHandlers();
            }
            Command findFieldCommand = commandService.getCommand(FIND_COMMAND_ID);
            findFieldCommand.setHandler(this.fFindFieldActionHandler);
            Command editDescCommand = commandService.getCommand(EDIT_COMMAND_ID);
            editDescCommand.setHandler(this.fEditDescActionHandler);
        }
    }

    @Override
    public void setMappingFile(String file) {
        this.fMappingFile = file;
        this.disposeOfLayouts();
        this.fFile = new File(this.fMappingFile);
        this.createMapRoot(this.getMemoryBlock());
        if (this.fRootLayout != null) {
            this.createPopupMenuActions();
            this.createActionHandlers();
            this.fBuildAllAction.setExpansionRoot((MemoryMap)this.fRootLayout.getRootElement());
        }
    }

    @Override
    public boolean supportsGrouping() {
        return true;
    }

    @Override
    public boolean supportsCaching() {
        return true;
    }

    @Override
    public boolean shouldRetrieveGroups() {
        return this.fExtractGroups && this.supportsGrouping();
    }

    public void deactivated() {
        super.deactivated();
        IWorkbench workbench = PlatformUI.getWorkbench();
        IContextService contextService = (IContextService)workbench.getAdapter(IContextService.class);
        ICommandService commandService = (ICommandService)workbench.getAdapter(ICommandService.class);
        if (contextService != null && commandService != null) {
            contextService.deactivateContexts(this.fContextList);
            commandService.getCommand(FIND_COMMAND_ID).setHandler(null);
            commandService.getCommand(EDIT_COMMAND_ID).setHandler(null);
        }
    }

    private void createActionHandlers() {
        this.fFindFieldActionHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent arg0) throws ExecutionException {
                if (MemoryMapRendering.this.fTreeViewer.getControl().isVisible()) {
                    MemoryMapRendering.this.fFindFieldAction.run();
                }
                return null;
            }
        };
        this.fEditDescActionHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent arg0) throws ExecutionException {
                TreeItem[] items;
                if (MemoryMapRendering.this.fTreeViewer.getControl().isVisible() && (items = MemoryMapRendering.this.getSelectedTreeItems()) != null && items.length > 0 && MemoryMapRendering.this.fEditDescriptionAction.setSelectedItems(items)) {
                    MemoryMapRendering.this.fEditDescriptionAction.run();
                }
                return null;
            }
        };
    }

    private void configureToolTip() {
        this.fToolTipShell = new Shell(this.fTreeViewer.getTree().getDisplay().getActiveShell(), 16384);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 0;
        this.fToolTipShell.setLayout((Layout)gridLayout);
        this.fToolTipShell.setBackground(this.fTreeViewer.getTree().getDisplay().getSystemColor(29));
        this.fToolTipLabel = new Label((Composite)this.fToolTipShell, 64);
        this.fToolTipLabel.setForeground(this.fTreeViewer.getTree().getDisplay().getSystemColor(28));
        this.fToolTipLabel.setBackground(this.fTreeViewer.getTree().getDisplay().getSystemColor(29));
        GridData gridData = new GridData(4, 0x1000000, false, false);
        this.fToolTipLabel.setLayoutData((Object)gridData);
        this.fToolTipShell.pack();
        this.fTreeViewer.getTree().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){
            private TreeItem toolTipItem = null;

            public void mouseExit(MouseEvent e) {
                MemoryMapRendering.this.fToolTipShell.setVisible(false);
                this.toolTipItem = null;
            }

            public void mouseHover(MouseEvent e) {
                Tree tree;
                TreeItem item;
                Point hoverPoint = new Point(e.x, e.y);
                if (e.widget instanceof Tree && (this.toolTipItem != (item = (tree = (Tree)e.widget).getItem(hoverPoint)) || item == null)) {
                    this.toolTipItem = item;
                    if (item != null && !(item.getData() instanceof ErrorMapElement)) {
                        String offset = MemoryMapRendering.this.fLabelProvider.getColumnText(item.getData(), 2);
                        StringBuffer tip = new StringBuffer();
                        if (item.getData() instanceof MemoryMap) {
                            MemoryMap map = (MemoryMap)item.getData();
                            if (map.isBit()) {
                                tip.append(NLS.bind((String)MemoryMapLabels.BitOffsetMsg, (Object[])new String[]{Integer.toString(map.getBitOffset())}));
                            } else {
                                tip.append(MemoryMapLabels.memory_map_offset).append(": ").append(offset);
                            }
                            tip.append("\n").append(MemoryMapLabels.FindFieldDialog_4).append(MemoryMapRendering.SPACE).append(map.getAddressInHexString());
                            String desc = map.getDescription();
                            if (desc.length() > 0) {
                                tip.append("\n").append(MemoryMapLabels.Description).append(MemoryMapRendering.SPACE).append(desc);
                            }
                            if (map.isExternalMapOrStructure()) {
                                tip.append("\n").append(NLS.bind((String)MemoryMapLabels.memory_map_layout, (Object)map.getLayout().getMappingFile()));
                            }
                        }
                        MemoryMapRendering.this.fToolTipLabel.setText(tip.toString());
                        hoverPoint = MemoryMapRendering.this.fTreeViewer.getTree().toDisplay(hoverPoint);
                        Rectangle shellBounds = MemoryMapRendering.this.fToolTipShell.getBounds();
                        shellBounds.x = hoverPoint.x;
                        shellBounds.y = hoverPoint.y + 16;
                        MemoryMapRendering.this.fToolTipShell.setBounds(shellBounds);
                        MemoryMapRendering.this.fToolTipShell.pack();
                        MemoryMapRendering.this.fToolTipShell.setVisible(true);
                    } else {
                        MemoryMapRendering.this.fToolTipShell.setVisible(false);
                    }
                }
            }
        });
    }

    public void setMonitored(boolean monitored) {
        if (this.fErrorOccurred) {
            return;
        }
        if (this.fRootLayout != null) {
            this.fRootLayout.setMonitored(monitored);
        }
    }

    private TreeItem[] getSelectedTreeItems() {
        if (this.fTreeViewer == null) {
            return null;
        }
        if (this.fTreeViewer.getTree().getSelection().length > 0) {
            return this.fTreeViewer.getTree().getSelection();
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        MemoryMapSelection[] selections = this.getSelections();
        if (selections != null && selections.length > 0 && selections[0].getStartAddress() != null) {
            this.fireSelectedAddressesChanged(selections);
        }
    }

    private MemoryMapSelection[] getSelections() {
        TreeItem[] selected = this.getSelectedTreeItems();
        if (selected == null || !this.areMapElements(selected)) {
            return null;
        }
        return this.getSelectionsFromItem((Item[])selected);
    }

    @Override
    protected void updateSelection(ArrayList<MapElement> items) {
        if (!this.fFinishedSetup || this.fTreeViewer == null) {
            return;
        }
        if (items.isEmpty()) {
            this.fTreeViewer.getTree().deselectAll();
        } else {
            Object[] newSelection = items.toArray(new MapElement[items.size()]);
            if (newSelection.length > 0) {
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection(newSelection), true);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!this.fFinishedSetup) {
            return;
        }
        super.propertyChange(event);
        if (event.getProperty().equals("com.ibm.debug.memorymap.off_mode")) {
            this.refreshTree();
        }
    }

    @Override
    protected void createPopupMenuActions() {
        super.createPopupMenuActions();
        this.fEditValueAction = new EditValueAction(this.fTreeViewer, this.fRenderTool);
        this.fFindFieldAction = new FindFieldAction(this);
        this.fShowTypeAction = new ToggleShowTypesAction(this);
        this.fBuildAllAction = new BuildMapAction(this, true);
        this.fBuildSingleElementAction = new BuildMapAction(this, false);
        this.fRepresentationMenu = new MenuManager(MemoryMapLabels.MemoryMapTab_RepresentationMenu, REPRESENTATION_MENU);
        this.fHex = new ChangeRepresentationAction(MemoryMapLabels.MemoryMapTab_Hexadecimal, "HEX", this);
        this.fAscii = new ChangeRepresentationAction(MemoryMapLabels.MemoryMapTab_ASCII, "ASCII", this);
        this.fEbcdic = new ChangeRepresentationAction(MemoryMapLabels.MemoryMapTab_EBCDIC, "EBCDIC", this);
        this.fDecimal = new ChangeRepresentationAction(MemoryMapLabels.MemoryMapTab_Decimal, "DECIMAL", this);
        this.fBinary = new ChangeRepresentationAction(MemoryMapLabels.MemoryMapTab_Binary, "BINARY", this);
        this.fRestore = new ChangeRepresentationAction(MemoryMapLabels.MemoryMapTab_RestoreDefault, "DEFAULT", this);
        this.fOpenMapFileMenu = new MenuManager(MemoryMapLabels.MemoryMapConstants_17, OPEN_MAP_FILE_MENU);
        this.fPrintAction = new PrintMemoryMapAction(this);
        this.fCopyAction = new CopyMemoryMapToClipboardAction(this);
        this.fChangeGroupMenu = new MenuManager(MemoryMapLabels.MemoryMapRendering_2, CHANGE_GROUP_MENU);
        this.fManageGroupsAction = new ManageGroupsAction(this);
        this.fSetGroupMenu = new MenuManager(MemoryMapLabels.SetGroupAction_0, SET_GROUP_MENU);
        this.fCollapseAllAction = new CollapseAllAction(this);
        this.fEditDescriptionAction = new EditDescriptionAction(this.fEditValueAction);
        this.fShowWholeMapAction = new ChangeGroupAction(this, null, 2);
        fHexModeAction.setText(MemoryMapLabels.MemoryMapTab_Hexadecimal);
        fDecimalModeAction.setText(MemoryMapLabels.MemoryMapTab_Decimal);
        this.fChooseColumnsAction = new ChooseRenderingColumnsAction(this.fTreeViewer.getTree());
        MemoryMapPlugin.getInstance().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    @Override
    public void becomesVisible() {
        if (!this.fFinishedSetup) {
            super.becomesVisible();
            return;
        }
        if (this.fFinishedSetup && !this.fErrorOccurred) {
            super.becomesVisible();
            IMemoryBlock memoryBlock = this.getMemoryBlock();
            if (memoryBlock.getDebugTarget().isDisconnected() || memoryBlock.getDebugTarget().isTerminated()) {
                return;
            }
            if (this.fContentProvider != null && !this.fContentProvider.isDisposed()) {
                this.refresh(false);
            } else {
                this.firePropertyChangedEvent(new PropertyChangeEvent((Object)this, "org.eclipse.jface.text", null, null));
            }
        }
    }

    @Override
    public void becomesHidden() {
        super.becomesHidden();
        this.firePropertyChangedEvent(new PropertyChangeEvent((Object)this, "org.eclipse.jface.text", null, null));
    }

    public void collapseAll() {
        this.fTreeViewer.collapseAll();
    }

    public void toggleShowTypes() {
        this.fLabelProvider.toggleShowType();
        this.fTreeViewer.refresh();
    }

    @Override
    public void setCurrentGroup(String group) {
        this.fCurrentGroup = group;
        this.refreshTree();
    }

    public String getContentAsString() {
        if (this.fErrorOccurred || this.fRootLayout == null) {
            Control control;
            StyledText text = null;
            if (this.fMapErrorComposite != null && !this.fMapErrorComposite.isDisposed() && this.fMapErrorComposite.isVisible()) {
                text = this.fMapErrorTextViewer.getTextWidget();
            } else if (this.fDebugErrorTextViewer != null && (control = this.fDebugErrorTextViewer.getControl()) != null && !control.isDisposed() && control.isVisible()) {
                text = this.fDebugErrorTextViewer.getTextWidget();
            }
            return text == null || text.isDisposed() ? "" : text.getText();
        }
        MemoryMap rootElement = (MemoryMap)this.fRootLayout.getRootElement();
        StringBuffer buffer = new StringBuffer();
        this.getLabelForElement(rootElement, buffer, "");
        buffer.append("\r\n");
        String childrenContent = this.getChildrenContentAsString(rootElement, "    ");
        buffer.append(childrenContent);
        return buffer.toString();
    }

    private void getLabelForElement(MapElement rootElement, StringBuffer buffer, String prefix) {
        Tree tree = this.fTreeViewer.getTree();
        buffer.append(prefix);
        int[] columnOrder = tree.getColumnOrder();
        int i = 0;
        while (i < tree.getColumnCount()) {
            int columnIndex = columnOrder[i];
            TreeColumn column = tree.getColumn(columnIndex);
            if (column.getWidth() > 0) {
                String label = column.getText();
                String value = this.fLabelProvider.getColumnText(rootElement, columnIndex);
                if (value != null && value.length() > 0) {
                    if (tree.indexOf(column) > 1) {
                        buffer.append(label).append(" = ");
                    }
                    buffer.append(value).append("    ");
                }
            }
            ++i;
        }
    }

    @Override
    public void addToCache(CachedMapElement id, MemoryMapProperty property) {
        super.addToCache(id, property);
        this.fMapPropertyModified = true;
    }

    private String getChildrenContentAsString(MapElement element, String prefix) {
        MapElement[] childrenElements;
        block12: {
            Object[] expandedElements = this.fTreeViewer.getExpandedElements();
            childrenElements = null;
            int i = 0;
            while (i < expandedElements.length) {
                if (element == expandedElements[i]) {
                    childrenElements = element.getChildren(false);
                    break;
                }
                ++i;
            }
            if (childrenElements != null) break block12;
            return "";
        }
        try {
            if (childrenElements.length == 0) {
                childrenElements = new MapElement[]{new FillerMapElement(element.getLayout(), element, MemoryMapLabels.MemoryMapConstants_6, null, element.getAddress(), new HashSet<String>())};
            }
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < childrenElements.length) {
                buffer.append(prefix);
                if (childrenElements[i].hasChildren() && childrenElements[i].getChildren(false).length == 0) {
                    buffer.append("+ ");
                } else if (childrenElements[i].hasChildren() && childrenElements[i].getChildren(false).length > 0) {
                    buffer.append("- ");
                } else {
                    buffer.append(". ");
                }
                this.getLabelForElement(childrenElements[i], buffer, prefix);
                buffer.append("\r\n");
                if (childrenElements[i].hasChildren()) {
                    buffer.append(this.getChildrenContentAsString(childrenElements[i], prefix + "    "));
                }
                ++i;
            }
            return buffer.toString();
        }
        catch (DebugException e) {
            ErrorDialog.openError((Shell)CommonUtils.getShell(), (String)MemoryMapLabels.MemoryMapCopyAction_error_title, null, (IStatus)new Status(4, "com.ibm.debug.memorymap", 0, MemoryMapMessages.MemoryMapCopyAction_error_message, null));
            return "";
        }
    }

    public String[] getContentAsPrintLines() {
        String content = this.getContentAsString();
        String[] strArray = content.split("\r\n");
        if (strArray.length > 0) {
            return strArray;
        }
        return new String[]{content};
    }

    public ISelection getSelection() {
        return this.fTreeViewer.getSelection();
    }

    public void setExpandedElements(Object[] elements) {
        this.fTreeViewer.setExpandedElements(elements);
    }

    public Object[] getExpandedElements() {
        return this.fTreeViewer.getExpandedElements();
    }

    public void setSelection(MapElement selection) {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
        }
    }

    public void setSelection(ISelection selection) {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setSelection(selection, true);
        }
    }

    public void expandElement(MapElement element) {
        this.fTreeViewer.setExpandedState((Object)element, true);
    }

    public void enableRefresh() {
        this.fTreeViewer.getTree().setRedraw(true);
    }

    public void disableRefresh() {
        this.fTreeViewer.getTree().setRedraw(false);
    }

    public void refreshElement(MapElement element) {
        this.fTreeViewer.refresh((Object)element, false);
    }

    public void refresh(boolean updateDelta) {
        if (!this.fFinishedSetup) {
            return;
        }
        if (this.isVisible() && this.fRootLayout != null) {
            try {
                this.fRootLayout.refresh(updateDelta);
                if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
                    if (!((IMemoryBlockExtension)this.getMemoryBlock()).supportsChangeManagement() && this.fErrorOccurred) {
                        this.fRootLayout.setMonitored(false);
                    }
                } else {
                    this.fRootLayout.setMonitored(false);
                }
            }
            catch (DebugException e) {
                Throwable throwable = e.getStatus().getException();
                if (throwable instanceof MemoryMapException) {
                    this.handleMapError((MemoryMapException)throwable);
                } else {
                    this.handleDebugError(e);
                }
                this.firePropertyChangedEvent(new PropertyChangeEvent((Object)this, "org.eclipse.jface.text", null, null));
                return;
            }
            if (!this.fErrorOccurred && !this.fContentProvider.isDisposed() && this.fTreeViewer != null) {
                this.displayTreeViewer();
                this.refreshTree();
            }
        } else if (this.fRootLayout != null) {
            this.fRootLayout.resetDeltas();
            this.setMonitored(false);
        }
    }

    @Override
    protected void fillContextMenu(IMenuManager menu) {
        if (!this.fFinishedSetup) {
            return;
        }
        boolean showChangeGroupsMenu = this.shouldRetrieveGroups();
        boolean showSetGroupsMenu = this.shouldRetrieveGroups();
        boolean showExpandAction = false;
        menu.add((IContributionItem)new Separator());
        if (this.fErrorOccurred) {
            menu.add((IAction)this.getAction("com.ibm.debug.memorymap.OpenMapFileAction"));
            menu.add((IAction)this.getAction("com.ibm.debug.memorymap.RebuildMapAction"));
            menu.add((IContributionItem)new Separator());
            menu.add((IAction)this.fCopyAction);
            menu.add((IAction)this.fPrintAction);
            return;
        }
        TreeItem[] selected = this.getSelectedTreeItems();
        if (selected != null && selected.length == 1 && selected[0].getData() instanceof MemoryMap) {
            MemoryMap element = (MemoryMap)selected[0].getData();
            if (this.getMemoryBlock().supportsValueModification() && element.isEditable()) {
                this.fEditValueAction.setEnabled(true);
                this.fEditValueAction.setEditColumn(1);
            } else {
                this.fEditValueAction.setEnabled(false);
            }
            if (element.isStructure() || element.isMap()) {
                this.fBuildSingleElementAction.setText(NLS.bind((String)MemoryMapLabels.ExpandMapAction_expand_selected, (Object)element.getName()));
                this.fBuildSingleElementAction.setExpansionRoot(element);
                showExpandAction = true;
            }
        } else {
            this.fEditValueAction.setEnabled(false);
        }
        menu.add((IAction)this.fEditValueAction);
        menu.add((IAction)this.fFindFieldAction);
        menu.add((IAction)this.fShowTypeAction);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fChooseColumnsAction);
        if (this.fTreeViewer.getTree().getColumn(2).getWidth() > 0) {
            MenuManager offsetMode = new MenuManager(MemoryMapLabels.ChooseOffsetDisplayMsg);
            menu.add((IContributionItem)offsetMode);
            fDecimalModeAction.update();
            fHexModeAction.update();
            offsetMode.add((IAction)fDecimalModeAction);
            offsetMode.add((IAction)fHexModeAction);
        }
        this.fChangeGroupMenu.removeAll();
        this.fSetGroupMenu.removeAll();
        if (selected != null && this.areMapElements(selected)) {
            MapElement[] selectedElements = new MapElement[selected.length];
            int i = 0;
            while (i < selected.length) {
                selectedElements[i] = (MapElement)selected[i].getData();
                ++i;
            }
            if (this.areMemoryMaps(selected)) {
                menu.add((IAction)this.fEditDescriptionAction);
                this.fEditDescriptionAction.setEnabled(this.fEditDescriptionAction.setSelectedItems(selected));
                if (this.showRepresentationMenu(selected)) {
                    MemoryMap[] maps = new MemoryMap[selected.length];
                    int i2 = 0;
                    while (i2 < selected.length) {
                        maps[i2] = (MemoryMap)selected[i2].getData();
                        ++i2;
                    }
                    menu.add((IContributionItem)new Separator());
                    menu.add((IContributionItem)this.fRepresentationMenu);
                    this.fRepresentationMenu.removeAll();
                    if (!this.containsType(maps, "STRUCTURE") && !this.containsType(maps, "MAP")) {
                        this.fHex.update(maps);
                        this.fRepresentationMenu.add((IAction)this.fHex);
                    }
                    if (this.isOfTypeHexAsciiEbcdicCharacter(maps)) {
                        this.fAscii.update(maps);
                        this.fEbcdic.update(maps);
                        this.fRepresentationMenu.add((IAction)this.fAscii);
                        this.fRepresentationMenu.add((IAction)this.fEbcdic);
                    } else if (this.isOfTypeIntFloat(maps)) {
                        this.fDecimal.update(maps);
                        this.fBinary.update(maps);
                        this.fRepresentationMenu.add((IAction)this.fDecimal);
                        this.fRepresentationMenu.add((IAction)this.fBinary);
                    }
                    this.fRestore.update(maps);
                    this.fRepresentationMenu.add((IContributionItem)new Separator());
                    this.fRepresentationMenu.add((IAction)this.fRestore);
                    menu.add((IContributionItem)new Separator());
                }
                i = 0;
                while (showSetGroupsMenu && i < selectedElements.length) {
                    if (selectedElements[i].getParent() instanceof MemoryMapParent) {
                        showSetGroupsMenu = false;
                    }
                    ++i;
                }
            } else if (this.containsFillerElement(selected)) {
                showSetGroupsMenu = false;
            }
            if (showChangeGroupsMenu) {
                this.fShowWholeMapAction.update();
                this.fChangeGroupMenu.add((IAction)this.fShowWholeMapAction);
                this.fChangeGroupMenu.add((IContributionItem)new Separator());
                showChangeGroupsMenu = this.hasGroups();
                Iterator<String> groupsIterator = this.getGroups();
                while (groupsIterator.hasNext()) {
                    ChangeGroupAction changeGroupAction = new ChangeGroupAction(this, groupsIterator.next(), 2);
                    this.fChangeGroupMenu.add((IAction)changeGroupAction);
                }
            }
            if (showSetGroupsMenu) {
                SetGroupAction allGroupsAction = new SetGroupAction(this, selectedElements, "ALL", 2);
                this.fSetGroupMenu.add((IAction)allGroupsAction);
                this.fSetGroupMenu.add((IContributionItem)new Separator());
                showSetGroupsMenu = this.hasGroups();
                Iterator<String> groupsIterator = this.getGroups();
                while (groupsIterator.hasNext()) {
                    SetGroupAction setGroupAction = new SetGroupAction(this, selectedElements, groupsIterator.next(), 2);
                    this.fSetGroupMenu.add((IAction)setGroupAction);
                }
            }
        } else if (showChangeGroupsMenu) {
            this.fShowWholeMapAction.update();
            this.fChangeGroupMenu.add((IAction)this.fShowWholeMapAction);
            this.fChangeGroupMenu.add((IContributionItem)new Separator());
            Iterator<String> groupsIterator = this.getGroups();
            showChangeGroupsMenu = groupsIterator.hasNext();
            showSetGroupsMenu = false;
            while (groupsIterator.hasNext()) {
                String group = groupsIterator.next();
                ChangeGroupAction action = new ChangeGroupAction(this, group, 2);
                this.fChangeGroupMenu.add((IAction)action);
            }
        }
        if (showChangeGroupsMenu) {
            menu.add((IContributionItem)this.fChangeGroupMenu);
        }
        menu.add((IContributionItem)new Separator());
        if (selected != null && this.shouldRetrieveGroups()) {
            menu.add((IAction)this.fManageGroupsAction);
        }
        if (showSetGroupsMenu) {
            menu.add((IContributionItem)this.fSetGroupMenu);
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.getAction("com.ibm.debug.memorymap.RebuildMapAction"));
        menu.add((IAction)this.fBuildAllAction);
        OpenMapFileAction openMapFileAction = (OpenMapFileAction)this.getAction("com.ibm.debug.memorymap.OpenMapFileAction");
        if (showExpandAction) {
            menu.add((IAction)this.fBuildSingleElementAction);
        }
        menu.add((IContributionItem)new Separator());
        if (selected != null && this.areMapElements(selected)) {
            this.fOpenMapFileMenu.removeAll();
            HashSet<MemoryMapLayout> mapLayouts = new HashSet<MemoryMapLayout>();
            int i = 0;
            while (i < selected.length) {
                MemoryMapLayout layout = ((MapElement)selected[i].getData()).getLayout();
                boolean mappingFileExists = false;
                Iterator iter = mapLayouts.iterator();
                while (!mappingFileExists && iter.hasNext()) {
                    Path selectedLayoutPath;
                    Path existingLayoutPath = new Path(((MemoryMapLayout)iter.next()).getMappingFile());
                    if (!existingLayoutPath.equals((Object)(selectedLayoutPath = new Path(layout.getMappingFile())))) continue;
                    mappingFileExists = true;
                }
                if (!mappingFileExists) {
                    mapLayouts.add(layout);
                }
                ++i;
            }
            MemoryMapLayout[] tempLayouts = mapLayouts.toArray(new MemoryMapLayout[mapLayouts.size()]);
            if (tempLayouts.length == 1) {
                openMapFileAction.setLayoutPath(tempLayouts[0].getMappingFile());
                menu.add((IAction)openMapFileAction);
            } else {
                int i3 = 0;
                while (i3 < tempLayouts.length) {
                    this.fOpenMapFileMenu.add((IAction)new OpenMapFileAction(tempLayouts[i3].getMappingFile(), false));
                    ++i3;
                }
                menu.add((IContributionItem)this.fOpenMapFileMenu);
            }
        } else {
            openMapFileAction.setLayoutPath(this.fFile.getAbsolutePath());
            menu.add((IAction)openMapFileAction);
        }
        menu.add((IAction)this.getAction("com.ibm.debug.memorymap.ExportMapAction"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fCopyAction);
        menu.add((IAction)this.fPrintAction);
        menu.add((IAction)this.fCollapseAllAction);
    }

    public String getLabel() {
        if (this.getMemoryBlock() == null) {
            return "";
        }
        StringBuffer label = new StringBuffer("");
        if (this.getMemoryBlock() instanceof IMemoryBlockExtension) {
            String expression = ((IMemoryBlockExtension)this.getMemoryBlock()).getExpression();
            if (expression == null) {
                expression = "";
            }
            label.append(expression);
            if (expression.startsWith("&")) {
                label.insert(0, "&");
            }
            try {
                if (this.isVisible() && ((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress() != null) {
                    label.append(" : 0x");
                    label.append(((IMemoryBlockExtension)this.getMemoryBlock()).getBigBaseAddress().toString(16).toUpperCase());
                }
            }
            catch (DebugException debugException) {}
        } else {
            long address = this.getMemoryBlock().getStartAddress();
            label.append(Long.toHexString(address).toUpperCase());
        }
        label.append(" <");
        if (this.fErrorOccurred || this.fRootLayout == null) {
            label.append(this.fFile.getName());
        } else {
            String currentGroup = this.getCurrentGroup();
            if (currentGroup == null) {
                label.append(this.fRootLayout.getName());
            } else {
                label.append(this.fRootLayout.getName()).append(" : ").append(currentGroup);
            }
        }
        label.append(">");
        return label.toString();
    }

    @Override
    public void dispose() {
        super.dispose();
        MemoryMapPlugin.getInstance().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
        }
        if (this.fTreeViewer != null) {
            this.fTreeViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            if (this.fTreeViewer.getControl() != null && !this.fTreeViewer.getControl().isDisposed()) {
                this.fTreeViewer.getControl().dispose();
            }
        }
        super.dispose();
    }

    @Override
    public void refresh() {
        this.refreshTree();
    }

    public void refreshTree() {
        if (this.fFinishedSetup && this.fTreeViewer != null) {
            Object[] expandedElements = this.fTreeViewer.getExpandedElements();
            this.firePropertyChangedEvent(new PropertyChangeEvent((Object)this, "org.eclipse.jface.text", null, null));
            this.fTreeViewer.refresh();
            this.fTreeViewer.setExpandedElements(expandedElements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mappingFileChanged() {
        Object object = fLock;
        synchronized (object) {
            fPreserveGroups = false;
        }
        this.recreateMap();
        object = fLock;
        synchronized (object) {
            fPreserveGroups = MemoryMapPlugin.getInstance().getPreferenceStore().getBoolean("com.ibm.debug.memorymap.prsv_grps");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebuildMap() {
        if (this.shouldRetrieveGroups()) {
            Object object = fLock;
            synchronized (object) {
                fConfirmPreserveGroups = MemoryMapPlugin.getInstance().getPreferenceStore().getBoolean("com.ibm.debug.memorymap.rebuild_prompt");
                fPreserveGroups = MemoryMapPlugin.getInstance().getPreferenceStore().getBoolean("com.ibm.debug.memorymap.prsv_grps");
                if (this.fMapPropertyModified && fConfirmPreserveGroups) {
                    ResizeableConfirmationDialog dlg = new ResizeableConfirmationDialog(CommonUtils.getShell(), MemoryMapLabels.MemoryMapRendering_5, null, MemoryMapLabels.MemoryMapRendering_6, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0, MemoryMapLabels.MemoryMapRendering_7, false);
                    if (dlg.open() < 0) {
                        return;
                    }
                    fConfirmPreserveGroups = !dlg.getToggleState();
                    Object object2 = fLock;
                    synchronized (object2) {
                        fPreserveGroups = dlg.getReturnCode() == 2;
                    }
                    MemoryMapPlugin.getInstance().getPreferenceStore().setValue("com.ibm.debug.memorymap.rebuild_prompt", fConfirmPreserveGroups);
                    object2 = fLock;
                    synchronized (object2) {
                        MemoryMapPlugin.getInstance().getPreferenceStore().setValue("com.ibm.debug.memorymap.prsv_grps", fPreserveGroups);
                    }
                }
                if (!this.fMapPropertyModified) {
                    Object object3 = fLock;
                    synchronized (object3) {
                        fPreserveGroups = false;
                    }
                }
            }
        }
        this.recreateMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recreateMap() {
        this.fErrorOccurred = false;
        String currentGroup = this.fCurrentGroup;
        this.fCurrentGroup = null;
        Object object = fLock;
        synchronized (object) {
            if (!fPreserveGroups) {
                this.clearCache();
                this.removeAllGroups();
                this.fMapPropertyModified = false;
            }
        }
        if (this.fTreeViewer != null) {
            Object[] expandedElements = this.fTreeViewer.getExpandedElements();
            int i = 0;
            while (i < expandedElements.length) {
                if (expandedElements[i] instanceof MemoryMap) {
                    this.fOldExpandedElements.add(expandedElements[i]);
                }
                ++i;
            }
        }
        super.rebuildMap();
        this.setUpContentProvider();
        this.fTreeViewer.refresh();
        this.restoreExpansion();
        if (currentGroup != null && this.containsGroup(currentGroup)) {
            this.setCurrentGroup(currentGroup);
        }
        if (!this.fErrorOccurred) {
            this.fBuildAllAction.setExpansionRoot((MemoryMap)this.fRootLayout.getRootElement());
            this.firePropertyChangedEvent(new PropertyChangeEvent((Object)this, "org.eclipse.jface.text", null, null));
            this.displayTreeViewer();
        }
    }

    private void setUpContentProvider() {
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
        }
        this.fContentProvider = new MemoryMapContentProvider(this);
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        }
    }

    private void setUpMap() {
        this.fDebugException = null;
        IMemoryBlock memoryBlock = this.getMemoryBlock();
        this.createMapRoot(memoryBlock);
        if (this.fRootLayout == null || this.fErrorOccurred) {
            return;
        }
        this.setMonitored(false);
        if (this.fRootLayout.getAddress() != null && this.fTreeViewer != null) {
            this.fTreeViewer.refresh();
        }
        this.fBuildAllAction.setExpansionRoot((MemoryMap)this.fRootLayout.getRootElement());
    }

    @Override
    protected MemoryMapLayout createMapRoot(IMemoryBlock memoryBlock) {
        super.createMapRoot(memoryBlock);
        if (this.fTreeViewer != null && this.fFinishedSetup) {
            this.fTreeViewer.setInput((Object)this.fMapParent);
            this.fTreeViewer.refresh();
            this.restoreExpansion();
        }
        return this.fRootLayout;
    }

    private boolean areMapElements(TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            if (!(items[i].getData() instanceof MapElement)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean areMemoryMaps(TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            if (!(items[i].getData() instanceof MemoryMap)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean showRepresentationMenu(TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            String type;
            Object obj = items[i].getData();
            if (!(!(obj instanceof MemoryMap) || (type = ((MemoryMap)obj).getType()).equals("16_BIT_INT") || type.equals("16_BIT_UINT") || type.equals("16_BIT_HINT") || type.equals("32_BIT_INT") || type.equals("32_BIT_UINT") || type.equals("32_BIT_HINT") || type.equals("32_BIT_FLOAT") || type.equals("64_BIT_INT") || type.equals("64_BIT_FLOAT") || type.equals("CHARACTER") || type.equals("HEX") || type.equals("ASCII") || type.equals("EBCDIC") || type.equals("STRUCTURE") || type.equals("MAP") || type.equals("BITMASK"))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean containsFillerElement(TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            if (items[i].getData() instanceof FillerMapElement) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean containsType(MemoryMap[] selected, String type) {
        int i = 0;
        while (i < selected.length) {
            if (selected[i].getType().equals(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isOfTypeHexAsciiEbcdicCharacter(MemoryMap[] maps) {
        int i = 0;
        while (i < maps.length) {
            if (!("ASCII".equals(maps[i].getType()) || "EBCDIC".equals(maps[i].getType()) || "CHARACTER".equals(maps[i].getType()) || "HEX".equals(maps[i].getType()))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isOfTypeIntFloat(MemoryMap[] maps) {
        int i = 0;
        while (i < maps.length) {
            if ("ASCII".equals(maps[i].getType()) || "EBCDIC".equals(maps[i].getType()) || "CHARACTER".equals(maps[i].getType()) || "HEX".equals(maps[i].getType()) || "STRUCTURE".equals(maps[i].getType()) || "MAP".equals(maps[i].getType()) || "BIT".equals(maps[i].getType()) || "PADDING".equals(maps[i].getType())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void restoreExpansion() {
        expandedElementsIterator = this.fOldExpandedElements.listIterator();
        items = this.fTreeViewer.getTree().getItems();
        if (items.length != 0 && items[0] != null && items[0].getData() instanceof MemoryMap) ** GOTO lbl55
        return;
lbl-1000:
        // 1 sources

        {
            obj = expandedElementsIterator.next();
            if (!(obj instanceof MemoryMap)) continue;
            temp /* !! */  = map = (MemoryMap)obj;
            mapsToCheck = new ArrayList<MemoryMap>();
            mapsToCheck.add(map);
            while (!(temp /* !! */ .getParent() instanceof MemoryMapParent)) {
                temp /* !! */  = temp /* !! */ .getParent();
                mapsToCheck.add(temp /* !! */ );
            }
            treeMap = (MemoryMap)items[0].getData();
            if (mapsToCheck.size() == 1) {
                if (!treeMap.getName().equals(map.getName()) || !treeMap.getType().equals(map.getType()) || treeMap.getLength() != map.getLength() || treeMap.getOffset() != map.getOffset()) continue;
                this.fNewExpandedElements.add(treeMap);
                continue;
            }
            parentsListIterator = mapsToCheck.listIterator(mapsToCheck.size());
            add = true;
            while (add && parentsListIterator.hasPrevious()) {
                object = parentsListIterator.previous();
                if (!(object instanceof MemoryMap)) continue;
                oldMap = (MemoryMap)object;
                if (oldMap.getParent() instanceof MemoryMapParent) {
                    if (treeMap.getName().equals(oldMap.getName()) && treeMap.getType().equals(oldMap.getType()) && treeMap.getLength() == oldMap.getLength() && treeMap.getOffset() == oldMap.getOffset()) continue;
                    add = false;
                    continue;
                }
                try {
                    children = treeMap.getChildren(true);
                    exists = false;
                    i = 0;
                    while (!exists && i < children.length) {
                        if (children[i] instanceof MemoryMap && (child = (MemoryMap)children[i]).getName().equals(oldMap.getName()) && child.getType().equals(oldMap.getType()) && child.getLength() == oldMap.getLength() && child.getOffset() == oldMap.getOffset()) {
                            treeMap = child;
                            exists = true;
                        }
                        ++i;
                    }
                    if (exists) continue;
                    add = false;
                }
                catch (DebugException e) {
                    throwable = e.getStatus().getException();
                    if (throwable instanceof MemoryMapException) {
                        this.handleMapError((MemoryMapException)throwable);
                        continue;
                    }
                    this.handleDebugError(e);
                }
            }
            if (!add) continue;
            this.fNewExpandedElements.add(treeMap);
lbl55:
            // 6 sources

            ** while (expandedElementsIterator.hasNext())
        }
lbl56:
        // 1 sources

        if (this.fNewExpandedElements.size() > 0) {
            this.fTreeViewer.setExpandedElements(this.fNewExpandedElements.toArray());
        } else {
            this.fTreeViewer.setExpandedElements(new Object[]{this.fRootLayout.getRootElement()});
        }
        this.fOldExpandedElements.clear();
        this.fNewExpandedElements.clear();
    }

    public void resetRendering() throws DebugException {
        try {
            if (this.fFinishedSetup && this.fMapParent != null) {
                StructuredSelection selection = new StructuredSelection((Object)this.fMapParent.getChildren(true)[0]);
                this.fTreeViewer.setSelection((ISelection)selection, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void retrieveGroupingInfo(boolean shouldRetreive) {
        this.fExtractGroups = shouldRetreive;
    }

    private void doubleClick(Tree tree, Event e) {
        TreeItem item = null;
        TreeItem[] selections = this.getSelectedTreeItems();
        boolean found = false;
        if (selections != null) {
            int i = 0;
            while (i < selections.length) {
                item = selections[i];
                if (item.getBounds(4).contains(e.x, e.y)) {
                    this.fEditValueAction.setEditColumn(4);
                    found = true;
                    break;
                }
                if (item.getBounds(1).contains(e.x, e.y)) {
                    this.fEditValueAction.setEditColumn(1);
                    found = true;
                    break;
                }
                ++i;
            }
        }
        if (found && item.getData() instanceof MapElement) {
            MapElement element = (MapElement)item.getData();
            if (!element.isEditable() && this.fEditValueAction.getCurrentEditColumn() == 1) {
                tree.setRedraw(false);
                this.fTreeViewer.setExpandedState((Object)element, element.hasChildren() & !this.fTreeViewer.getExpandedState((Object)element));
                tree.setRedraw(true);
            } else {
                this.fEditValueAction.run();
            }
        }
    }
}

