/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap;

import com.ibm.debug.memorymap.MemoryMap;
import com.ibm.debug.memorymap.MemoryMapLayout;
import com.ibm.debug.memorymap.utils.MemoryMapException;
import java.math.BigInteger;
import java.util.Set;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;
import org.w3c.dom.Node;

public class MemoryMapPartitionElement
extends MemoryMap {
    public MemoryMapPartitionElement(MemoryMapLayout layout, MemoryMap parent, BigInteger address, int offset, int length, String type, Set<String> groups, Node node) throws MemoryMapException {
        super(layout, parent, "", address, offset, length, type, groups, node);
        this.setName(this.buildName());
        this.fMemoryBlockSegments = parent.fMemoryBlockSegments;
    }

    private String buildName() {
        int offset = this.getOffset() - this.fParent.getOffset();
        int numOfDigits = Integer.toString(this.getParent().getLength()).length();
        StringBuffer name = new StringBuffer("[");
        name.append(this.padWithZeros(Integer.toString(offset), numOfDigits)).append("...");
        name.append(this.padWithZeros(Integer.toString(offset + this.getLength() - 1), numOfDigits)).append("]");
        return name.toString();
    }

    private String padWithZeros(String number, int max) {
        int numLength = max - number.length();
        StringBuffer buf = new StringBuffer(number);
        int i = 0;
        while (i < numLength) {
            buf.insert(0, '0');
            ++i;
        }
        return buf.toString();
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public MemoryByte[] getBytes() throws DebugException {
        if (this.memoryIsOutOfSync()) {
            MemoryByte[] parentBytes = ((MemoryMap)this.fParent).getBytes();
            int index = 0;
            if (parentBytes != null) {
                int i = 0;
                while (i < this.fParent.fChildren.size()) {
                    MemoryMapPartitionElement child = (MemoryMapPartitionElement)this.fParent.fChildren.get(i);
                    child.fMemory = new MemoryByte[child.getLength()];
                    System.arraycopy(parentBytes, index, child.fMemory, 0, child.getLength());
                    index += child.getLength();
                    ++i;
                }
            }
        }
        return this.fMemory;
    }
}

