/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap;

import com.ibm.debug.memorymap.AbstractMemoryMapRendering;
import com.ibm.debug.memorymap.ErrorMapElement;
import com.ibm.debug.memorymap.MapElement;
import com.ibm.debug.memorymap.MemoryBlockSegment;
import com.ibm.debug.memorymap.MemoryMap;
import com.ibm.debug.memorymap.MemoryMapBuilder;
import com.ibm.debug.memorymap.MemoryMapParent;
import com.ibm.debug.memorymap.MemoryMapPlugin;
import com.ibm.debug.memorymap.MemoryMapSelection;
import com.ibm.debug.memorymap.SparseMapPartitioner;
import com.ibm.debug.memorymap.utils.MemoryMapException;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapMessages;
import com.ibm.debug.memorymap.utils.MemoryMapRenderingMgr;
import com.ibm.debug.memorymap.utils.MemoryMapUtils;
import com.ibm.debug.pdt.internal.common.CommonUtils;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MemoryMapLayout {
    protected int fLength;
    private BigInteger fAddress;
    private MemoryByte[] fMemoryBytes;
    private IMemoryBlock fMemoryBlock;
    private MapElement fRootElement;
    protected String fMappingFile;
    protected ArrayList<MemoryMapLayout> fChildLayouts;
    private String fLayoutType;
    private String fReferenceName;
    private MemoryMapLayout fReferenceLayout;
    private int fReferenceOffsetIndex;
    private int fReferenceLength;
    private BigInteger fReferenceAddress;
    private ArrayList<MapElement> _elements;
    private String fName;
    private MemoryByte[] fHistory;
    private boolean fIsMonitored;
    protected AbstractMemoryMapRendering fRendering;
    private MemoryBlockSegment[] fMemoryBlockSegments;
    private int fNumberOfUsedBytesInLayout;
    private Node fReferenceNode;
    private int fNeededSegmentCount = 0;
    private int fRefreshIndex = 0;
    private int fPartitionSize = 0;
    public static final int IN_SYNC = 0;
    public static final int NEEDS_REFRESH = 1;
    public static final int IS_STALE = 2;

    public MemoryMapLayout(AbstractMemoryMapRendering rendering, String layoutType, int layoutLength, int offset, MapElement parent, BigInteger address, IMemoryBlock memoryBlock, String mappingFile, Set<String> groups) throws MemoryMapException {
        this.fRendering = rendering;
        this.fAddress = address;
        this._elements = new ArrayList();
        this.fChildLayouts = new ArrayList();
        this.fLayoutType = layoutType;
        this.fReferenceName = null;
        this.fReferenceLayout = null;
        this.fReferenceAddress = null;
        this.fReferenceOffsetIndex = 0;
        this.fMemoryBlock = memoryBlock;
        this.fIsMonitored = false;
        File file = new File(mappingFile);
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fMappingFile = file.getAbsolutePath().trim();
        this.createRootElement(layoutLength, offset, parent, groups, file);
        MemoryMapRenderingMgr.addRendering(this.fMappingFile, rendering);
        this.partitionMemoryBlock();
    }

    protected final void finalize() {
    }

    protected void partitionMemoryBlock() {
        this.fPartitionSize = MemoryMapPlugin.getInstance().getPreferenceStore().getInt("com.ibm.debug.memorymap.mbsz");
        this.fMemoryBlockSegments = SparseMapPartitioner.partitionBlock(this.fLength, this.fAddress);
        if (this.fMemoryBlockSegments.length == 1) {
            this.fPartitionSize = this.fMemoryBlockSegments[0].getLength();
        }
        this.fMemoryBytes = null;
        this.fNumberOfUsedBytesInLayout = 0;
        this.fRefreshIndex = 1;
    }

    protected void createRootElement(int layoutLength, int offset, MapElement parent, Set<String> groups, File file) throws MemoryMapException {
        Element rootNode = null;
        rootNode = MemoryMapUtils.openLayout(file, this.fLayoutType, layoutLength);
        String stringLength = rootNode.getAttribute("length");
        this.fName = rootNode.getAttribute("Header");
        this.fLength = MemoryMapBuilder.parseInt(stringLength);
        this.fRootElement = new MemoryMap(this, parent, this.fName, this.fAddress, offset, this.fLength, this.fLayoutType, groups, rootNode);
        parent.addChild(this.fRootElement);
        this.fNeededSegmentCount = 0;
    }

    private void shiftAddress(BigInteger oldAddress) {
        if (!oldAddress.equals(this.fAddress)) {
            BigInteger delta = this.fAddress.subtract(oldAddress);
            int i = 0;
            while (i < this.fMemoryBlockSegments.length) {
                this.fMemoryBlockSegments[i].updateAddress(delta);
                ++i;
            }
        }
    }

    public int getSegmentRetrievalStatus(MemoryBlockSegment segment) {
        if (this.fRefreshIndex == segment.getRefreshIndex()) {
            return 0;
        }
        int diff = Math.abs(segment.getRefreshIndex() - this.fRefreshIndex);
        if (diff == 1) {
            return 1;
        }
        return 2;
    }

    public HashSet<MemoryBlockSegment> findMatchingSegments(BigInteger address, int length) {
        HashSet<MemoryBlockSegment> matchingSegments = new HashSet<MemoryBlockSegment>();
        boolean prevInRange = false;
        int numberOfBytesAvailable = 0;
        int offsetInLayout = address.subtract(this.fAddress).intValue();
        if (offsetInLayout >= 0 && offsetInLayout < this.fLength) {
            int offsetOfFirstMatch = offsetInLayout / this.fPartitionSize;
            if (offsetOfFirstMatch > 0) {
                --offsetOfFirstMatch;
            }
            int i = offsetOfFirstMatch;
            while (i < this.fMemoryBlockSegments.length) {
                MemoryBlockSegment segment = this.fMemoryBlockSegments[i];
                int numberOfBytesCovered = segment.getNumberOfBytesCovered(address, length);
                numberOfBytesAvailable += numberOfBytesCovered;
                if (numberOfBytesCovered != 0) {
                    if (!segment.isNeeded()) {
                        this.incrementNeededSegmentCount(segment);
                    }
                    segment.setNeeded(true);
                    prevInRange = true;
                    if (this.getSegmentRetrievalStatus(segment) == 2) {
                        ++this.fNeededSegmentCount;
                        segment.setRefreshIndex(this.fRefreshIndex - 1);
                    }
                    matchingSegments.add(segment);
                } else if (prevInRange) break;
                ++i;
            }
        }
        if (numberOfBytesAvailable != length) {
            matchingSegments.clear();
        }
        return matchingSegments;
    }

    public void refresh(boolean updateDelta) throws DebugException {
        boolean addressChanged = false;
        this.aboutToRefresh();
        if ("MAP".equals(this.fLayoutType)) {
            BigInteger oldAddress = this.fAddress;
            addressChanged = this.updateAddress();
            if (addressChanged) {
                this.shiftAddress(oldAddress);
                this.setMonitored(false);
                this.fRootElement.updateAddress(this.fAddress.subtract(oldAddress));
            }
        }
        if (this.fMemoryBytes != null) {
            ++this.fRefreshIndex;
            this.fHistory = new MemoryByte[this.fMemoryBytes.length];
            int i = 0;
            while (i < this.fHistory.length) {
                if (this.fMemoryBytes[i] != null) {
                    byte flags = this.fMemoryBytes[i].getFlags();
                    byte value = this.fMemoryBytes[i].getValue();
                    this.fHistory[i] = new MemoryByte(value, flags);
                }
                ++i;
            }
            this.retrieveUsedSegments();
            if (this.fHistory.length == this.fMemoryBytes.length && (!updateDelta || addressChanged)) {
                i = 0;
                while (i < this.fHistory.length && i < this.fMemoryBytes.length) {
                    boolean changeBitOn = false;
                    boolean knownBitOn = false;
                    if (this.fHistory[i] != null) {
                        changeBitOn = this.fHistory[i].isChanged();
                        knownBitOn = this.fHistory[i].isHistoryKnown();
                    }
                    if (!updateDelta) {
                        if (changeBitOn) {
                            this.fMemoryBytes[i].setChanged(true);
                        }
                        if (knownBitOn) {
                            this.fMemoryBytes[i].setHistoryKnown(true);
                        } else {
                            this.fMemoryBytes[i].setHistoryKnown(false);
                        }
                    } else if (!this.fIsMonitored || addressChanged) {
                        this.fMemoryBytes[i].setHistoryKnown(false);
                        this.fMemoryBytes[i].setChanged(false);
                    }
                    ++i;
                }
            }
        }
        this.refreshChildLayouts(updateDelta);
    }

    private void aboutToRefresh() {
        int i = 0;
        while (i < this.fChildLayouts.size()) {
            this.fChildLayouts.get(i).aboutToRefresh();
            ++i;
        }
        this.resetDeltas();
    }

    private void incrementNeededSegmentCount(MemoryBlockSegment segement) {
        this.fNumberOfUsedBytesInLayout += segement.getLength();
    }

    public int getRefreshIndex() {
        return this.fRefreshIndex;
    }

    private void retrieveUsedSegments() throws DebugException {
        IMemoryBlock memoryBlock = this.getMemoryBlock();
        int totalBytesCopied = 0;
        MemoryByte[] layoutBytes = null;
        boolean blockManagesChanges = false;
        if (this.fMemoryBlock instanceof IMemoryBlockExtension) {
            blockManagesChanges = ((IMemoryBlockExtension)this.fMemoryBlock).supportsChangeManagement();
        }
        if (this.shouldRetrieveEntireBlock()) {
            MemoryByte[] oldBytes = this.fMemoryBytes;
            MemoryByte[] cachedBytes = this.getBytes(memoryBlock, this.fAddress, this.fLength);
            layoutBytes = new MemoryByte[this.fLength];
            int i = 0;
            while (i < cachedBytes.length) {
                MemoryByte newByte;
                MemoryByte temp = cachedBytes[i];
                layoutBytes[i] = newByte = new MemoryByte(temp.getValue(), temp.getFlags());
                ++i;
            }
            int index = 0;
            int i2 = 0;
            while (i2 < this.fMemoryBlockSegments.length) {
                MemoryBlockSegment segment = this.fMemoryBlockSegments[i2];
                if (segment.hasBeenRetrieved() && oldBytes != null) {
                    int blockStartIndex = segment.getStartIndex();
                    int end = blockStartIndex + segment.getLength();
                    segment.setStartIndex(index);
                    int k = blockStartIndex;
                    while (k < end) {
                        MemoryByte newByte = layoutBytes[index];
                        layoutBytes[index] = oldBytes[k];
                        this.updateByteValue(blockManagesChanges, layoutBytes[index], newByte);
                        ++index;
                        ++k;
                    }
                } else {
                    segment.setNeeded(true);
                    segment.setRetrieved();
                    segment.setStartIndex(index);
                    index += segment.getLength();
                }
                ++i2;
            }
            this.fNumberOfUsedBytesInLayout = this.fLength;
            this.fMemoryBytes = layoutBytes;
            this.fNeededSegmentCount = 0;
        } else {
            int max_block_size = MemoryMapPlugin.getInstance().getPreferenceStore().getInt("com.ibm.debug.memorymap.mxsz");
            int indexToCopy = 0;
            MemoryByte[] oldArray = this.fMemoryBytes;
            layoutBytes = new MemoryByte[this.fNumberOfUsedBytesInLayout];
            int lastIndexInOldArray = 0;
            int i = 0;
            while (i < this.fMemoryBlockSegments.length) {
                if (totalBytesCopied == this.fNumberOfUsedBytesInLayout) break;
                MemoryBlockSegment segment = this.fMemoryBlockSegments[i];
                int blockLength = segment.getLength();
                int status = this.getSegmentRetrievalStatus(segment);
                if (!segment.isNeeded() && !segment.hasBeenRetrieved()) {
                    ++i;
                    continue;
                }
                if (status == 1) {
                    MemoryByte[] tempBytes;
                    BigInteger address = segment.getStartAddress();
                    int start = i + 1;
                    int consolidationLength = segment.getLength();
                    while (start < this.fMemoryBlockSegments.length) {
                        int nextBlockLength;
                        MemoryBlockSegment nextSegment = this.fMemoryBlockSegments[start];
                        if (!this.shouldRetrieveSegment(nextSegment) || consolidationLength + (nextBlockLength = nextSegment.getLength()) > max_block_size) break;
                        ++start;
                        consolidationLength += nextBlockLength;
                    }
                    if ((tempBytes = this.getBytes(memoryBlock, address, consolidationLength)) != null && tempBytes.length == consolidationLength) {
                        while (i < start) {
                            segment = this.fMemoryBlockSegments[i];
                            segment.setRetrieved();
                            segment.setStartIndex(totalBytesCopied);
                            ++i;
                            totalBytesCopied += segment.getLength();
                            --this.fNeededSegmentCount;
                        }
                    } else {
                        Exception exception = new Exception(NLS.bind((String)MemoryMapMessages.MemoryMapLayoutCannotRetrBytes, (Object)address.toString(16)));
                        throw new DebugException(UIJob.errorStatus((Throwable)exception));
                    }
                    int j = 0;
                    while (j < consolidationLength) {
                        MemoryByte newByte;
                        MemoryByte temp = tempBytes[j];
                        layoutBytes[indexToCopy] = newByte = new MemoryByte(temp.getValue(), temp.getFlags());
                        ++indexToCopy;
                        ++j;
                    }
                    continue;
                }
                if (segment.hasBeenRetrieved()) {
                    lastIndexInOldArray = segment.getStartIndex();
                    segment.setStartIndex(totalBytesCopied);
                    if (oldArray != null) {
                        System.arraycopy(oldArray, lastIndexInOldArray, layoutBytes, totalBytesCopied, segment.getLength());
                        lastIndexInOldArray += blockLength;
                    }
                    totalBytesCopied += blockLength;
                    indexToCopy += blockLength;
                }
                ++i;
            }
            if (this.fMemoryBytes != null && this.fMemoryBytes.length == layoutBytes.length) {
                int k = 0;
                while (k < this.fMemoryBytes.length) {
                    MemoryByte newByte = layoutBytes[k];
                    this.updateByteValue(blockManagesChanges, this.fMemoryBytes[k], newByte);
                    ++k;
                }
            } else {
                this.fMemoryBytes = layoutBytes;
            }
        }
        int k = 0;
        while (k < this.fMemoryBytes.length) {
            this.fMemoryBytes[k].setHistoryKnown(true);
            ++k;
        }
        if (this.fNeededSegmentCount < 0) {
            this.fNeededSegmentCount = 0;
        }
    }

    private void updateByteValue(boolean blockManagesChanges, MemoryByte oldByte, MemoryByte newByte) {
        if (oldByte != null && newByte != null) {
            if (blockManagesChanges || !this.fIsMonitored) {
                oldByte.setValue(newByte.getValue());
                oldByte.setFlags(newByte.getFlags());
            } else {
                if (oldByte.getValue() != newByte.getValue()) {
                    oldByte.setFlags(newByte.getFlags());
                    oldByte.setChanged(true);
                }
                oldByte.setValue(newByte.getValue());
                oldByte.setHistoryKnown(true);
                oldByte.setReadable(newByte.isReadable());
                oldByte.setWritable(newByte.isWritable());
            }
        }
    }

    private boolean shouldRetrieveSegment(MemoryBlockSegment segment) {
        int status = this.getSegmentRetrievalStatus(segment);
        if (!segment.isNeeded()) {
            return false;
        }
        return status == 1;
    }

    private boolean shouldRetrieveEntireBlock() {
        int max_block_size = MemoryMapPlugin.getInstance().getPreferenceStore().getInt("com.ibm.debug.memorymap.mxsz");
        int needed_count = 0;
        int i = 0;
        while (i < this.fMemoryBlockSegments.length) {
            MemoryBlockSegment seg = this.fMemoryBlockSegments[i];
            if (this.getSegmentRetrievalStatus(seg) == 1) {
                ++needed_count;
            }
            ++i;
        }
        return this.fLength <= max_block_size && (double)this.fMemoryBlockSegments.length * 0.75 <= (double)needed_count;
    }

    public MemoryByte[] copyBytes(int length, BigInteger address) throws DebugException {
        this.refreshBytes();
        if (this.fAddress.add(BigInteger.valueOf(this.fLength)).compareTo(address.add(BigInteger.valueOf(length))) < 0) {
            throw new DebugException(UIJob.errorStatus((Throwable)new Exception(NLS.bind((String)MemoryMapMessages.MemoryMapLayoutCannotRetrBytes, (Object)address.toString(16)))));
        }
        MemoryByte[] bytes = new MemoryByte[length];
        int lengthRetrieved = 0;
        int i = 0;
        while (i < this.fMemoryBlockSegments.length) {
            MemoryBlockSegment segment = this.fMemoryBlockSegments[i];
            if (length == lengthRetrieved) break;
            int bytesAvailableToCopy = segment.getNumberOfBytesCovered(address, length - lengthRetrieved);
            if (bytesAvailableToCopy > 0 && segment.hasBeenRetrieved()) {
                int offset = address.subtract(segment.getStartAddress()).intValue();
                if (length - lengthRetrieved + segment.getStartIndex() + offset <= this.fMemoryBytes.length) {
                    System.arraycopy(this.fMemoryBytes, segment.getStartIndex() + offset, bytes, lengthRetrieved, bytesAvailableToCopy);
                    lengthRetrieved += bytesAvailableToCopy;
                    address = address.add(BigInteger.valueOf(bytesAvailableToCopy));
                }
            }
            ++i;
        }
        if (length != lengthRetrieved) {
            throw new DebugException(UIJob.errorStatus((Throwable)new Exception(NLS.bind((String)MemoryMapMessages.MemoryMapLayoutCannotRetrBytes, (Object)address.toString(16)))));
        }
        return bytes;
    }

    protected void refreshBytes() throws DebugException {
        if (this.fNeededSegmentCount > 0) {
            this.retrieveUsedSegments();
        }
    }

    private MemoryByte[] getBytes(IMemoryBlock memoryBlock, BigInteger address, int numberOfBytes) throws DebugException {
        MemoryByte[] _bytes = null;
        if (memoryBlock instanceof IMemoryBlockExtension) {
            _bytes = ((IMemoryBlockExtension)memoryBlock).getBytesFromAddress(address, (long)numberOfBytes);
        } else {
            byte[] rawBytes = memoryBlock.getBytes();
            _bytes = new MemoryByte[numberOfBytes];
            int index = 0;
            if (address.intValue() + numberOfBytes >= rawBytes.length) {
                Status status = new Status(4, "com.ibm.debug.memorymap", 0, MemoryMapMessages.memory_map_error_insufficient_memory_allocation, null);
                DebugException de = new DebugException((IStatus)status);
                throw de;
            }
            int k = address.intValue();
            while (k < address.intValue() + numberOfBytes) {
                _bytes[index] = new MemoryByte(rawBytes[k], 2);
                ++index;
                ++k;
            }
        }
        return _bytes;
    }

    public ArrayList<MapElement> findElementsByAddresses(MemoryMapSelection[] addresses) {
        int i;
        this._elements.clear();
        if (!this.fChildLayouts.isEmpty()) {
            i = 0;
            while (i < this.fChildLayouts.size()) {
                int j = 0;
                while (j < addresses.length) {
                    if (this.fChildLayouts.get(i).isReferenceAddress(addresses[j])) {
                        this._elements.add(this.fChildLayouts.get(i).getRootElement());
                    }
                    ++j;
                }
                ++i;
            }
        }
        i = 0;
        while (i < addresses.length) {
            MapElement[] foundElements;
            if (this.fRootElement.containsAddress(addresses[i]) && (foundElements = this.findMapElements(this.fRootElement, addresses[i])) != null && foundElements.length != 0) {
                int j = 0;
                while (j < foundElements.length) {
                    this._elements.add(foundElements[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (!this.fChildLayouts.isEmpty()) {
            i = 0;
            while (i < this.fChildLayouts.size()) {
                this._elements.addAll(this.fChildLayouts.get(i).findElementsByAddresses(addresses));
                ++i;
            }
        }
        return this._elements;
    }

    private MapElement[] findMapElements(MapElement element, MemoryMapSelection selection) {
        ArrayList<MapElement> retElements = new ArrayList<MapElement>();
        if (element.containsAddress(selection)) {
            if (element.hasChildren() && !element.getChildrenAsList().isEmpty()) {
                if (selection.hasChildren() && element.getAddress().equals(selection.getStartAddress())) {
                    retElements.add(element);
                }
                try {
                    MapElement[] children = element.getChildren(false);
                    int i = 0;
                    while (i < children.length) {
                        MapElement[] child = this.findMapElements(children[i], selection);
                        if (child != null) {
                            int j = 0;
                            while (j < child.length) {
                                retElements.add(child[j]);
                                ++j;
                            }
                        } else {
                            retElements.remove(element);
                        }
                        ++i;
                    }
                }
                catch (DebugException debugException) {}
            } else {
                retElements.add(element);
                return retElements.toArray(new MapElement[retElements.size()]);
            }
            return retElements.toArray(new MapElement[retElements.size()]);
        }
        return null;
    }

    private void resetMemory() {
        if (this.fMemoryBytes != null) {
            int i = 0;
            while (i < this.fMemoryBytes.length) {
                this.fMemoryBytes[i].setChanged(false);
                ++i;
            }
        }
    }

    private boolean updateAddress() throws DebugException {
        BigInteger backupAddress = this.fAddress;
        if (this.fReferenceLayout != null) {
            byte[] currentAddress;
            MemoryMapLayout layout = this.fReferenceLayout;
            while (!layout.getLayoutType().equals("MAP")) {
                layout = layout.getRootElement().getParent().getLayout();
            }
            layout.findMatchingSegments(this.fReferenceAddress, this.fReferenceLength);
            MemoryByte[] layoutBytes = layout.copyBytes(this.fReferenceLength, this.fReferenceAddress);
            byte[] rawBytes = new byte[layoutBytes.length];
            int i = 0;
            while (i < layoutBytes.length) {
                rawBytes[i] = layoutBytes[i].getValue();
                ++i;
            }
            if (MemoryMapUtils.isMixedEndianness(layoutBytes)) {
                MemoryMapException e = new MemoryMapException("", NLS.bind((String)MemoryMapMessages.MemoryMapConstants_10, (Object[])new String[]{this.fName, new File(this.fMappingFile).getName()}), this.fMappingFile, 3);
                this.fRendering.handleMapError(e);
            }
            if ((currentAddress = this.fAddress.toByteArray()).length != rawBytes.length) {
                this.fAddress = this.convertMemoryToAddress(rawBytes, layoutBytes[0].isBigEndian());
            } else {
                int i2 = 0;
                while (i2 < currentAddress.length) {
                    if (rawBytes[i2] != currentAddress[i2]) {
                        this.fAddress = this.convertMemoryToAddress(rawBytes, layoutBytes[0].isBigEndian());
                    }
                    ++i2;
                }
            }
        } else {
            this.fAddress = this.fMemoryBlock instanceof IMemoryBlockExtension ? ((IMemoryBlockExtension)this.fMemoryBlock).getBigBaseAddress() : BigInteger.valueOf(this.fMemoryBlock.getStartAddress());
        }
        if (this.fAddress == null) {
            this.fAddress = backupAddress;
            Status status = new Status(4, "com.ibm.debug.memorymap", 0, MemoryMapMessages.MemoryMapLayout_Unable_to_refresh_base_address, null);
            throw new DebugException((IStatus)status);
        }
        if (backupAddress == null) {
            this.fRootElement.fAddress = this.fAddress;
        }
        return !this.fAddress.equals(backupAddress);
    }

    public BigInteger convertMemoryToAddress(byte[] bytes, boolean isBigEndian) {
        byte[] input;
        if (isBigEndian) {
            input = bytes;
        } else {
            input = new byte[bytes.length];
            int j = 0;
            int i = bytes.length - 1;
            while (i >= 0) {
                input[j] = bytes[i];
                ++j;
                --i;
            }
        }
        BigInteger address = new BigInteger(1, input);
        return address;
    }

    private void refreshChildLayouts(boolean updateDelta) throws DebugException {
        if (!this.fChildLayouts.isEmpty()) {
            int i = 0;
            while (i < this.fChildLayouts.size()) {
                if (this.fChildLayouts.get((int)i).fAddress != null) {
                    this.fChildLayouts.get(i).updateAddressReference();
                    this.fChildLayouts.get(i).refresh(updateDelta);
                }
                ++i;
            }
        }
    }

    public void updateMemoryValue(BigInteger address, byte[] bytes) {
        try {
            if (this.fMemoryBlock instanceof IMemoryBlockExtension) {
                IMemoryBlockExtension extendedMemoryBlock = (IMemoryBlockExtension)this.fMemoryBlock;
                if (extendedMemoryBlock.getBigBaseAddress() == null) {
                    ErrorDialog.openError((Shell)CommonUtils.getShell(), (String)MemoryMapMessages.memory_map_error_edit, null, (IStatus)new Status(4, "com.ibm.debug.memorymap", 0, NLS.bind((String)MemoryMapMessages.MemoryMapLayout_Failed_to_edit_the_selected_field, (Object)""), null));
                    return;
                }
                BigInteger offset = address.subtract(extendedMemoryBlock.getBigBaseAddress());
                extendedMemoryBlock.setValue(offset, bytes);
            } else {
                long offset = address.longValue() - this.fMemoryBlock.getStartAddress();
                this.fMemoryBlock.setValue(offset, bytes);
            }
        }
        catch (DebugException e) {
            ErrorDialog.openError((Shell)CommonUtils.getShell(), (String)MemoryMapMessages.memory_map_error_edit, null, (IStatus)new Status(4, "com.ibm.debug.memorymap", 0, NLS.bind((String)MemoryMapMessages.MemoryMapLayout_Failed_to_edit_the_selected_field, (Object)e.getMessage()), null));
        }
    }

    public MapElement getRootElement() {
        return this.fRootElement;
    }

    public String getMappingFile() {
        return this.fMappingFile;
    }

    public IMemoryBlock getMemoryBlock() {
        return this.fMemoryBlock;
    }

    public BigInteger getAddress() {
        return this.fAddress;
    }

    public String getAddressInHexString() {
        if (this.fAddress == null) {
            return "";
        }
        return NLS.bind((String)MemoryMapLabels.hex_string_prefix, (Object)this.fAddress.toString(16).toUpperCase());
    }

    public int getLength() {
        return this.fLength;
    }

    public void addChildLayout(MemoryMapLayout layout) {
        this.fChildLayouts.add(layout);
    }

    public void removeChildLayout(MemoryMapLayout layout) {
        this.fChildLayouts.remove(layout);
    }

    public boolean isReferenceAddress(MemoryMapSelection selection) {
        if (this.fReferenceAddress == null) {
            return false;
        }
        return selection.getStartAddress().compareTo(this.fReferenceAddress) == 0;
    }

    protected MemoryByte[] getMemoryBytes(int offset, int length) throws DebugException {
        BigInteger address = this.fAddress.add(BigInteger.valueOf(offset));
        MemoryByte[] layoutBytes = this.copyBytes(length, address);
        return layoutBytes;
    }

    public BigInteger getReferenceAddress() {
        return this.fReferenceAddress;
    }

    public String getReferenceName() {
        return this.fReferenceName;
    }

    public void setMapReference(MemoryMapLayout layout, String name, int offset, int length) {
        if (offset >= 0 && length >= 0) {
            this.fReferenceLayout = layout;
            this.fReferenceName = name;
            this.fReferenceOffsetIndex = offset;
            this.fReferenceLength = length;
            while (!layout.getLayoutType().equals("MAP")) {
                layout = layout.getRootElement().getParent().getLayout();
            }
            this.fReferenceAddress = layout.getAddress().add(BigInteger.valueOf(offset));
        }
    }

    public void updateAddressReference() {
        BigInteger oldAddress = this.fAddress;
        if (this.fReferenceAddress != null && this.fReferenceLayout != null && this.fReferenceLength >= 0) {
            MemoryMapLayout layout = this.fReferenceLayout;
            while (!layout.getLayoutType().equals("MAP")) {
                layout = layout.getRootElement().getParent().getLayout();
            }
            this.fReferenceAddress = layout.getAddress().add(BigInteger.valueOf(this.fReferenceOffsetIndex));
        }
        if (this.fLayoutType.equals("STRUCTURE")) {
            this.fAddress = this.fReferenceAddress;
            this.shiftAddress(oldAddress);
        }
    }

    public String getName() {
        return this.fName;
    }

    public int getReferenceOffsetIndex() {
        return this.fReferenceOffsetIndex;
    }

    public void resetDeltas() {
        this.resetMemory();
        if (!this.fChildLayouts.isEmpty()) {
            int i = 0;
            while (i < this.fChildLayouts.size()) {
                this.fChildLayouts.get(i).resetDeltas();
                ++i;
            }
        }
    }

    public void setMonitored(boolean monitored) {
        int i;
        this.fIsMonitored = monitored;
        if (this.fMemoryBytes != null) {
            i = 0;
            while (i < this.fMemoryBytes.length) {
                if (this.fMemoryBytes[i] != null) {
                    this.fMemoryBytes[i].setHistoryKnown(this.fIsMonitored);
                }
                ++i;
            }
        }
        if (!this.fChildLayouts.isEmpty()) {
            i = 0;
            while (i < this.fChildLayouts.size()) {
                this.fChildLayouts.get(i).setMonitored(monitored);
                ++i;
            }
        }
    }

    public boolean isMonitored() {
        return this.fIsMonitored;
    }

    public MemoryByte[] getHistory() {
        return this.fHistory;
    }

    public AbstractMemoryMapRendering getRendering() {
        return this.fRendering;
    }

    public int getReferenceLength() {
        return this.fReferenceLength;
    }

    public MemoryMapLayout[] getChildLayouts() {
        return this.fChildLayouts.toArray(new MemoryMapLayout[this.fChildLayouts.size()]);
    }

    public String getLayoutType() {
        return this.fLayoutType;
    }

    public MapElement[] findElementsByAttributes(String childName, String childType, int childLength, int childOffset) {
        ArrayList<MapElement> foundElements = new ArrayList<MapElement>();
        String name = null;
        name = this.fRootElement.getParent() instanceof MemoryMapParent || "STRUCTURE".equals(this.fLayoutType) ? this.fRootElement.getName() : this.fRootElement.getLayout().getReferenceName();
        if (!(childName != null && !childName.equals(name) || childType != null && !childType.equals(((MemoryMap)this.fRootElement).getType()) || childLength >= 0 && childLength != this.fRootElement.getLayout().getReferenceLength() || childOffset >= 0 && childOffset != this.fRootElement.getOffset())) {
            foundElements.add(this.fRootElement);
        }
        try {
            MapElement[] children = this.fRootElement.getChildren(false);
            int i = 0;
            while (i < children.length) {
                MapElement[] childFoundElements = this.findChildElementsByAttributes(children[i], childName, childType, childLength, childOffset);
                int j = 0;
                while (j < childFoundElements.length) {
                    foundElements.add(childFoundElements[j]);
                    ++j;
                }
                ++i;
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return foundElements.toArray(new MapElement[0]);
    }

    private MapElement[] findChildElementsByAttributes(MapElement parent, String childName, String childType, int childLength, int childOffset) {
        ArrayList<MapElement> foundElements = new ArrayList<MapElement>();
        if (parent instanceof MemoryMap) {
            int length;
            String type = ((MemoryMap)parent).getType();
            String name = null;
            if (parent.isMap()) {
                name = parent.getLayout().getReferenceName();
                length = parent.getLayout().getReferenceLength();
            } else {
                name = parent.getName();
                length = parent.getLength();
            }
            if (!(childName != null && !childName.equals(name) || childType != null && !childType.equals(type) || childLength >= 0 && childLength != length || childOffset >= 0 && childOffset != parent.getOffset())) {
                foundElements.add(parent);
            }
        } else if (!(!(parent instanceof ErrorMapElement) || childName != null && !childName.equals(parent.getName()) || childType != null && !childType.equals(((ErrorMapElement)parent).getType()) || childLength >= 0 && childLength != parent.getLength() || childOffset >= 0 && childOffset != parent.getOffset())) {
            foundElements.add(parent);
        }
        if (parent instanceof MemoryMap && !((MemoryMap)parent).getType().equals("MAP")) {
            try {
                MapElement[] children = parent.getChildren(false);
                int i = 0;
                while (i < children.length) {
                    MapElement[] childFoundElements = this.findChildElementsByAttributes(children[i], childName, childType, childLength, childOffset);
                    int j = 0;
                    while (j < childFoundElements.length) {
                        foundElements.add(childFoundElements[j]);
                        ++j;
                    }
                    ++i;
                }
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
        return foundElements.toArray(new MapElement[0]);
    }

    public Node getReferenceNode() {
        return this.fReferenceNode;
    }

    public void setReferenceNode(Node referenceNode) {
        this.fReferenceNode = referenceNode;
    }

    public HashSet<MemoryBlockSegment> getSegments() {
        return new HashSet<MemoryBlockSegment>(Arrays.asList(this.fMemoryBlockSegments));
    }
}

