/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap;

import com.ibm.debug.memorymap.AbstractMemoryMapRendering;
import com.ibm.debug.memorymap.ErrorMapElement;
import com.ibm.debug.memorymap.MapElement;
import com.ibm.debug.memorymap.MemoryBlockSegment;
import com.ibm.debug.memorymap.MemoryMap;
import com.ibm.debug.memorymap.MemoryMapLayout;
import com.ibm.debug.memorymap.MemoryMapParent;
import com.ibm.debug.memorymap.ORGParent;
import com.ibm.debug.memorymap.utils.CachedMapElement;
import com.ibm.debug.memorymap.utils.MemoryMapException;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapMessages;
import com.ibm.debug.memorymap.utils.MemoryMapUtils;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MemoryMapBuilder {
    private MemoryMap fParent;
    private Node fNode;
    private BigInteger fAddress;
    private Set<String> addedGroups;
    private int fStartOffset;

    public MemoryMapBuilder(MemoryMap parent, Node node, BigInteger address, int startOffset) {
        this.fParent = parent;
        this.fNode = node;
        this.fAddress = address;
        this.fStartOffset = startOffset;
    }

    public void buildChildren() throws MemoryMapException {
        Node childNode = this.fNode.getFirstChild();
        int currentOffset = this.fStartOffset;
        boolean incrementOffset = !this.fParent.isUnion();
        MemoryMapLayout existingLayout = this.checkForExistingLayout();
        MemoryMapLayout parentLayout = this.fParent.getLayout();
        AbstractMemoryMapRendering rendering = parentLayout.getRendering();
        BigInteger rootLayoutAddress = parentLayout.getAddress();
        int parentOffset = this.fParent.getOffset();
        this.addedGroups = new HashSet<String>();
        int numOrphanBits = 0;
        boolean parentIsBitmask = this.fParent.isBitmask();
        if (this.fParent.isStructure()) {
            MapElement parent = this.fParent.getParent();
            while (!parent.getType().equals("MAP")) {
                parent = parent.getParent();
            }
            rootLayoutAddress = parent.getLayout().getAddress();
        }
        while (childNode != null) {
            short nodeType = childNode.getNodeType();
            if (nodeType == 1) {
                String childNodeName = childNode.getNodeName();
                if (childNodeName.equals("FIELD")) {
                    NamedNodeMap attributes = childNode.getAttributes();
                    String childName = MemoryMapBuilder.getAttribute(attributes, "Header");
                    String childType = MemoryMapBuilder.getAttribute(attributes, "Type");
                    String childLayout = MemoryMapBuilder.getAttribute(attributes, "layout");
                    String childFileName = MemoryMapBuilder.getAttribute(attributes, "filename");
                    String length = MemoryMapBuilder.getAttribute(attributes, "length");
                    int childLength = 0;
                    if (length != null) {
                        try {
                            childLength = MemoryMapBuilder.parseInt(length);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (childName == null) {
                        childName = "";
                    }
                    String offset_mode = MemoryMapBuilder.getAttribute(attributes, "offset_mode");
                    String offset = MemoryMapBuilder.getAttribute(attributes, "offset");
                    BigInteger childAddress = null;
                    String childTag = MemoryMapUtils.reconstructTag(childNode);
                    String mappingFile = parentLayout.getMappingFile();
                    if (offset != null) {
                        boolean offsetIsAbsolute;
                        int offsetValue = -1;
                        try {
                            offsetValue = MemoryMapBuilder.parseInt(offset);
                        }
                        catch (NumberFormatException e) {
                            throw new MemoryMapException(childTag, MemoryMapMessages.MalformedOffsetErr, mappingFile, 2);
                        }
                        boolean bl = offsetIsAbsolute = offset_mode == null || offset_mode.equals("absolute");
                        if (offsetIsAbsolute && offsetValue < 0) {
                            throw new MemoryMapException(childTag, MemoryMapMessages.MalformedAbsOffsetErr, mappingFile, 2);
                        }
                        currentOffset = offsetIsAbsolute && this.fParent.isStructure() && this.fParent.isExternalMapOrStructure() ? parentOffset + offsetValue : (offsetIsAbsolute ? offsetValue : (currentOffset += offsetValue));
                    }
                    childAddress = parentIsBitmask ? this.fAddress.add(BigInteger.valueOf(currentOffset / 8)) : rootLayoutAddress.add(BigInteger.valueOf(currentOffset));
                    String groupAttr = MemoryMapBuilder.getAttribute(attributes, "Groups");
                    Set<String> childGroups = this.getGroupsForChild(existingLayout, groupAttr);
                    this.attributeSanityCheck(childGroups, childName, childType, childLength, childNode, mappingFile);
                    HashSet<MemoryBlockSegment> childSegments = null;
                    if (!("STRUCTURE".equals(childType) || "UNION".equals(childType) || "PADDING".equals(childType) || "BIT".equals(childType) || (childSegments = parentLayout.findMatchingSegments(childAddress, childLength)).size() != 0)) {
                        this.throwOutOfRangeError(childNode, parentLayout);
                    }
                    if (childType != null && childLength > 0) {
                        childGroups = this.setChildGroups(childGroups, existingLayout, childName, childType, childLength, parentOffset, currentOffset);
                    }
                    this.addedGroups.addAll(childGroups);
                    if (parentIsBitmask) {
                        int parentLength = this.fParent.getLength();
                        BigInteger endChildAddress = childAddress.add(BigInteger.valueOf(childLength / 8));
                        BigInteger endParentAddress = this.fAddress.add(BigInteger.valueOf(parentLength));
                        if ((currentOffset + childLength) / 8 > parentLength || endChildAddress.compareTo(endParentAddress) > 0) {
                            this.throwOutOfRangeError(childNode, parentLayout);
                        }
                        MemoryMap childMemoryMap = null;
                        if (childType.equals("BIT")) {
                            childMemoryMap = new MemoryMap(parentLayout, this.fParent, childName, childAddress, currentOffset, childLength, childType, childGroups, childNode);
                            this.fParent.addChild(childMemoryMap);
                        } else if (childType.equals("PADDING")) {
                            childMemoryMap = new MemoryMap(parentLayout, this.fParent, childName, childAddress, currentOffset, childLength, childType, childGroups, childNode);
                            this.fParent.addChild(childMemoryMap);
                        }
                        if (childMemoryMap != null) {
                            currentOffset += childLength;
                            this.checkForCachedDescription(childNode, childMemoryMap, rendering);
                        }
                    } else if (childType.equals("BIT")) {
                        String errorMsg = NLS.bind((String)MemoryMapMessages.memory_map_error_error_missing_bit_mask, (Object)childName);
                        childMemoryMap = new ErrorMapElement(parentLayout, this.fParent, childName, errorMsg, childAddress, currentOffset, childLength, childType, childGroups, null);
                        MemoryMapException mme = new MemoryMapException(childTag, errorMsg, mappingFile, 2);
                        Status status = new Status(4, "com.ibm.debug.memorymap", 0, mme.getMessage(), (Throwable)mme);
                        rendering.registerDebugException(new DebugException((IStatus)status));
                        this.fParent.addChild(childMemoryMap);
                        if (numOrphanBits == 8) {
                            numOrphanBits = 0;
                            ++currentOffset;
                        }
                        this.checkForCachedDescription(childNode, childMemoryMap, rendering);
                    } else {
                        boolean childIsMap = false;
                        childIsMap = childType.equals("MAP");
                        if (childIsMap || childType.equals("STRUCTURE")) {
                            childMemoryMap = null;
                            String layoutFileName = this.getLayoutFileName(childLayout == null ? childFileName : childLayout);
                            File file = new File(layoutFileName);
                            if (childIsMap || childFileName != null) {
                                if (!(file.exists() && file.isFile() && file.canRead())) {
                                    String errorMsg = NLS.bind((String)MemoryMapMessages.memory_map_utils_error_could_not_parse, (Object)layoutFileName);
                                    throw new MemoryMapException(childTag, errorMsg, mappingFile, 2);
                                }
                                if (childIsMap) {
                                    childAddress = this.getAddressForMap(childNode, layoutFileName, childLength, currentOffset, childGroups, childName, childAddress);
                                }
                                if (childAddress != null) {
                                    MemoryMapLayout layout = new MemoryMapLayout(rendering, childType, childLength, currentOffset, this.fParent, childAddress, parentLayout.getMemoryBlock(), layoutFileName, childGroups);
                                    parentLayout.addChildLayout(layout);
                                    layout.setMapReference(parentLayout, childName, currentOffset, childLength);
                                    layout.setReferenceNode(childNode);
                                    childMemoryMap = (MemoryMap)layout.getRootElement();
                                }
                            } else {
                                childMemoryMap = new MemoryMap(parentLayout, this.fParent, childName, childAddress, currentOffset, childLength, childType, childGroups, childNode);
                                this.fParent.addChild(childMemoryMap);
                                if (!this.fParent.isMap() && !((MemoryMap)childMemoryMap).fExplicitGroups.isEmpty()) {
                                    this.addedGroups.addAll(((MemoryMap)childMemoryMap).fExplicitGroups);
                                }
                            }
                            if (childMemoryMap != null) {
                                this.checkForCachedDescription(((MemoryMap)childMemoryMap).getNode(), childMemoryMap, rendering);
                            }
                        } else {
                            childMemoryMap = new MemoryMap(parentLayout, this.fParent, childName, childAddress, currentOffset, childLength, childType, childGroups, childNode);
                            this.fParent.addChild(childMemoryMap);
                            this.checkForCachedDescription(((MemoryMap)childMemoryMap).getNode(), childMemoryMap, rendering);
                            if (!childType.equals("BITMASK") || !childType.equals("PADDING") && !this.fParent.isMap()) {
                                this.addedGroups.addAll(((MemoryMap)childMemoryMap).fExplicitGroups);
                            }
                            if (childSegments != null) {
                                ((MemoryMap)childMemoryMap).setMemoryBlockSegments(childSegments);
                            }
                        }
                        if (incrementOffset) {
                            currentOffset += childLength;
                        }
                    }
                } else if (childNodeName.equals("ORG_GROUP")) {
                    currentOffset = this.handleORGNode(childNode, currentOffset, existingLayout, parentLayout, rootLayoutAddress);
                } else if (rendering.shouldRetrieveGroups() && childNodeName.equals("GROUP")) {
                    this.addGroupToRendering(childNode, rendering);
                }
            }
            childNode = childNode.getNextSibling();
        }
    }

    private int handleORGNode(Node childNode, int currentOffset, MemoryMapLayout existingLayout, MemoryMapLayout parentLayout, BigInteger rootLayoutAddress) throws MemoryMapException {
        AbstractMemoryMapRendering rendering = parentLayout.getRendering();
        String field = MemoryMapBuilder.getAttribute(childNode.getAttributes(), "FIELD");
        String header = MemoryMapBuilder.getAttribute(childNode.getAttributes(), "Header");
        String groups = MemoryMapBuilder.getAttribute(childNode.getAttributes(), "Groups");
        TreeSet<String> groupSet = new TreeSet();
        String childTag = null;
        if (field == null) {
            childTag = MemoryMapUtils.reconstructTag(childNode);
            throw new MemoryMapException(childTag, MemoryMapMessages.MalformedOrgOffsetErr, parentLayout.getMappingFile(), 5);
        }
        if (header == null) {
            header = "";
        }
        if (groups != null && rendering.shouldRetrieveGroups() && (groupSet = this.getGroupsForChild(existingLayout, groups)) == null) {
            childTag = MemoryMapUtils.reconstructTag(childNode);
            String errorMsg = NLS.bind((String)MemoryMapMessages.MemoryMap_1, (Object)childNode.getAttributes().getNamedItem("Groups").getNodeValue());
            StringBuffer message = new StringBuffer(errorMsg);
            throw new MemoryMapException(childTag, message.toString(), parentLayout.getMappingFile(), 1);
        }
        if (field.toUpperCase().startsWith("*NONE") || field.equals("*")) {
            ORGParent org = new ORGParent(parentLayout, this.fParent, header, rootLayoutAddress.add(BigInteger.valueOf(currentOffset)), currentOffset, childNode, groupSet);
            this.fParent.addChild(org);
            org.build();
            currentOffset = org.getLastOffset();
        } else {
            MapElement rootElement = parentLayout.getRootElement();
            while (!(rootElement.getParent() instanceof MemoryMapParent)) {
                rootElement = rootElement.getParent();
            }
            if (field.startsWith("*")) {
                int index = field.indexOf("*") + 1;
                boolean offsetIsValid = true;
                if (index + 1 < field.length()) {
                    String remainder = field.substring(index).trim();
                    if (remainder.length() > 1 && remainder.charAt(0) == '+' || remainder.charAt(0) == '-') {
                        String expression = remainder.substring(1);
                        int offset = MemoryMapBuilder.evaluate(expression, rootElement);
                        currentOffset = remainder.charAt(0) == '+' ? (currentOffset += offset) : (currentOffset -= offset);
                        if (currentOffset < 0) {
                            offsetIsValid = false;
                        }
                    } else {
                        offsetIsValid = false;
                    }
                    if (!offsetIsValid) {
                        childTag = MemoryMapUtils.reconstructTag(childNode);
                        throw new MemoryMapException(childTag, MemoryMapMessages.MalformedOrgOffsetErr, parentLayout.getMappingFile(), 5);
                    }
                    ORGParent org = new ORGParent(parentLayout, this.fParent, header, rootLayoutAddress.add(BigInteger.valueOf(currentOffset)), currentOffset, childNode, groupSet);
                    this.fParent.addChild(org);
                    org.build();
                    currentOffset = org.getLastOffset();
                }
            } else {
                ORGParent org = null;
                MapElement orgElement = MemoryMapUtils.findMapField(rootElement, field);
                if (orgElement != null) {
                    int offsetToUse = orgElement.getOffset();
                    BigInteger addressToUse = orgElement.getAddress();
                    if (orgElement.getParent().isORGParent() && (orgElement.getName().equals(orgElement.getParent().getName()) || ((ORGParent)orgElement.getParent()).getORGField().equalsIgnoreCase("*NONE") && orgElement == orgElement.getParent().fChildren.get(0))) {
                        MapElement grandparent = orgElement.getParent().getParent();
                        org = new ORGParent(orgElement.fMapLayout, grandparent, header, addressToUse, offsetToUse, childNode, groupSet);
                        List<Object> grandParentChildren = grandparent.fChildren;
                        int startIndex = grandParentChildren.indexOf(orgElement.getParent());
                        MapElement mapElement = (MapElement)grandParentChildren.get(startIndex);
                        ++startIndex;
                        while (startIndex < grandParentChildren.size()) {
                            if (!mapElement.isORGParent() || !mapElement.getAddress().equals(addressToUse)) break;
                            mapElement = (MapElement)grandParentChildren.get(startIndex);
                            ++startIndex;
                        }
                        grandParentChildren.add(startIndex, org);
                    } else {
                        List<Object> parentChildren = orgElement.getParent().fChildren;
                        org = new ORGParent(orgElement.getLayout(), orgElement.getParent(), header, addressToUse, offsetToUse, childNode, groupSet);
                        parentChildren.add(parentChildren.indexOf(orgElement) + 1, org);
                    }
                    org.build();
                    currentOffset = org.getLastOffset();
                    this.fParent.addORGChild(org);
                    org.setORGedElement(orgElement);
                } else {
                    int offset = MemoryMapBuilder.evaluate(field, rootElement);
                    if (offset < 0) {
                        childTag = MemoryMapUtils.reconstructTag(childNode);
                        String errorMsg = NLS.bind((String)MemoryMapMessages.NegativeOffset, (Object)field);
                        throw new MemoryMapException(childTag, errorMsg, parentLayout.getMappingFile(), 2);
                    }
                    org = new ORGParent(parentLayout, this.fParent, header, rootLayoutAddress.add(BigInteger.valueOf(offset)), offset, childNode, groupSet);
                    this.fParent.addChild(org);
                    org.build();
                    currentOffset = org.getLastOffset();
                }
            }
        }
        return currentOffset;
    }

    private void throwOutOfRangeError(Node childNode, MemoryMapLayout parentLayout) throws MemoryMapException {
        StringBuffer message = new StringBuffer(MemoryMapMessages.memory_map_error_insufficient_memory_allocation);
        String parentNodeAsString = MemoryMapUtils.reconstructTag(this.fNode);
        if (this.fParent.getParent() instanceof MemoryMapParent) {
            message.append("\n").append(MemoryMapMessages.memory_map_error_element_out_of_range).append("\n").append(MemoryMapUtils.reconstructTag(childNode));
        }
        throw new MemoryMapException(parentNodeAsString, message.toString(), parentLayout.getMappingFile(), 2);
    }

    private void attributeSanityCheck(Set<String> childGroups, String childName, String childType, int childLength, Node node, String mappingFile) throws MemoryMapException {
        if (childLength <= 0) {
            StringBuffer message = new StringBuffer(MemoryMapMessages.memory_map_error_insufficient_memory_allocation);
            throw new MemoryMapException(MemoryMapUtils.reconstructTag(node), message.toString(), mappingFile, 2);
        }
        if (childType == null) {
            StringBuffer message = new StringBuffer(NLS.bind((String)MemoryMapMessages.memory_map_error_malformed_file_parse2, (Object)mappingFile));
            throw new MemoryMapException(MemoryMapUtils.reconstructTag(node), message.toString(), mappingFile, 2);
        }
        if (childGroups == null) {
            StringBuffer message = new StringBuffer(NLS.bind((String)MemoryMapMessages.MemoryMap_1, (Object)node.getAttributes().getNamedItem("Groups").getNodeValue()));
            throw new MemoryMapException(MemoryMapUtils.reconstructTag(node), message.toString(), mappingFile, 1);
        }
    }

    public static String getAttribute(NamedNodeMap attributes, String attributeName) {
        String attrValue = null;
        Node attr = attributes.getNamedItem(attributeName);
        if (attr != null && (attrValue = attr.getNodeValue().trim()).length() <= 0) {
            attrValue = null;
        }
        return attrValue;
    }

    public static int parseInt(String value) {
        int radix = 10;
        if (value.startsWith("0x")) {
            radix = 16;
            value = value.substring(2);
        }
        return Integer.parseInt(value, radix);
    }

    public static int evaluate(String exp, MapElement parent) {
        exp = exp.trim();
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<String> ops = new ArrayList<String>();
        int lastIndex = 0;
        int i = 0;
        while (i < exp.length()) {
            char nextChar = exp.charAt(i);
            if (nextChar == '+' || nextChar == '-') {
                fields.add(exp.substring(lastIndex, i).trim());
                ops.add(nextChar == '+' ? "+" : "-");
                lastIndex = i + 1;
            }
            ++i;
        }
        String lastString = "";
        if (lastIndex < exp.length() && (lastString = exp.substring(lastIndex).trim()).length() > 0) {
            fields.add(lastString);
        }
        if (ops.size() == fields.size() - 1) {
            int totalOffset = -1;
            int opIndex = 0;
            int i2 = 0;
            while (i2 < fields.size()) {
                int offsetToadd;
                block10: {
                    offsetToadd = 0;
                    String field = (String)fields.get(i2);
                    try {
                        offsetToadd = MemoryMapBuilder.parseInt(field);
                    }
                    catch (NumberFormatException e) {
                        MapElement map = MemoryMapUtils.findMapField(parent, field);
                        if (map == null) break block10;
                        offsetToadd = map.getOffset();
                    }
                }
                if (i2 != 0) {
                    totalOffset = ((String)ops.get(opIndex)).toString().equals("+") ? (totalOffset += offsetToadd) : (totalOffset -= offsetToadd);
                    ++opIndex;
                } else if (i2 == 0) {
                    totalOffset = offsetToadd;
                }
                ++i2;
            }
            return totalOffset < 0 ? -1 : totalOffset;
        }
        return -1;
    }

    private BigInteger getAddressForMap(Node childNode, String layoutFileName, int childLength, int currentOffset, Set<String> groups, String childName, BigInteger childAddress) {
        MemoryByte[] childBytes = null;
        MemoryMapLayout parentLayout = this.fParent.getLayout();
        try {
            parentLayout.findMatchingSegments(childAddress, childLength);
            parentLayout.refreshBytes();
            childBytes = parentLayout.copyBytes(childLength, childAddress);
        }
        catch (DebugException e) {
            this.addErrorChild(childLength, currentOffset, groups, childName, childAddress, parentLayout, childNode);
            return null;
        }
        byte[] _bytes = new byte[childBytes.length];
        boolean allReadable = true;
        int i2 = 0;
        while (i2 < childBytes.length) {
            _bytes[i2] = childBytes[i2].getValue();
            if (!childBytes[i2].isReadable()) {
                allReadable = false;
            }
            ++i2;
        }
        BigInteger address = null;
        String map_type = "MAP";
        if (!allReadable) {
            StringBuffer addressBuffer = new StringBuffer();
            String paddedStr = DebugUITools.getPreferenceStore().getString("org.eclipse.debug.ui.memory.paddedStr");
            int i1 = 0;
            while (i1 < _bytes.length) {
                addressBuffer.append(paddedStr);
                ++i1;
            }
            String label = NLS.bind((String)MemoryMapLabels.memory_map_label_layout, (Object[])new String[]{map_type, "", addressBuffer.toString(), layoutFileName});
            ErrorMapElement errorElm = new ErrorMapElement(parentLayout, this.fParent, childName, label, childAddress, currentOffset, childLength, map_type, groups, childNode);
            ErrorMapElement errorChild = new ErrorMapElement(parentLayout, errorElm, childName, MemoryMapMessages.memory_map_error_address_exception, childAddress, currentOffset, childLength, map_type, groups, null);
            errorElm.addChild(errorChild);
            this.fParent.addChild(errorElm);
        } else if (MemoryMapUtils.isMixedEndianness(childBytes)) {
            String mappingFile = NLS.bind((String)MemoryMapMessages.MemoryMapConstants_10, (Object)new File(layoutFileName).getName());
            ErrorMapElement errorMapElement = new ErrorMapElement(parentLayout, this.fParent, childName, mappingFile, childAddress, currentOffset, childLength, map_type, groups, childNode);
            this.fParent.addChild(errorMapElement);
        } else {
            address = parentLayout.convertMemoryToAddress(_bytes, childBytes[0].isBigEndian());
        }
        return address;
    }

    private void addErrorChild(int childLength, int currentOffset, Set<String> groups, String childName, BigInteger childAddress, MemoryMapLayout parentLayout, Node childNode) {
        this.fParent.addChild(new ErrorMapElement(parentLayout, this.fParent, childName, NLS.bind((String)MemoryMapMessages.MemoryMapLayout_Failed_to_build_memory_map, (Object)MemoryMapMessages.memory_map_error_insufficient_memory_allocation), childAddress, currentOffset, childLength, "MAP", groups, childNode));
    }

    private MemoryMapLayout checkForExistingLayout() {
        MemoryMapLayout existingLayout = null;
        try {
            MemoryMapLayout[] layouts = this.fParent.getLayout().getRendering().getAllLayouts(false, true);
            int i = 0;
            while (i < layouts.length) {
                Path existingLayoutPath;
                Path layoutPath = new Path(this.fParent.getLayout().getMappingFile());
                if (layoutPath.equals((Object)(existingLayoutPath = new Path(layouts[i].getMappingFile()))) && layouts[i] != this.fParent.getLayout()) {
                    existingLayout = layouts[i];
                    break;
                }
                ++i;
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return existingLayout;
    }

    private void addGroupToRendering(Node childNode, AbstractMemoryMapRendering rendering) throws MemoryMapException {
        NamedNodeMap cAttributes = childNode.getAttributes();
        StringBuffer group = new StringBuffer("<");
        group.append("GROUP").append(" ").append("Name").append(" = \"");
        String groupName = MemoryMapBuilder.getAttribute(cAttributes, "Name");
        if (groupName != null && groupName.equalsIgnoreCase("ALL")) {
            group.append(groupName).append("\">");
            StringBuffer message = new StringBuffer(NLS.bind((String)MemoryMapMessages.MemoryMapConstants_9, (Object)"ALL"));
            throw new MemoryMapException(group.toString(), message.toString(), this.fParent.getLayout().getMappingFile(), 1);
        }
        if (groupName != null && !rendering.isRemovedGroup(groupName)) {
            rendering.addGroup(groupName);
        }
    }

    private Set<String> getGroupsForChild(MemoryMapLayout existingLayout, String groupAttr) {
        HashSet<String> childGroups = new HashSet<String>();
        if (groupAttr != null && this.fParent.getLayout().getRendering().shouldRetrieveGroups() && existingLayout == null) {
            String[] childGroupsArray = this.parseGroups(groupAttr);
            if (childGroupsArray != null) {
                int k = 0;
                while (k < childGroupsArray.length) {
                    childGroups.add(childGroupsArray[k]);
                    ++k;
                }
            } else {
                childGroups = null;
            }
        }
        return childGroups;
    }

    private void checkForCachedDescription(Node node, MapElement element, AbstractMemoryMapRendering rendering) {
        Object description = rendering.getCachedProperty(element.getId(), "description");
        if (description == null) {
            description = MemoryMapBuilder.getAttribute(node.getAttributes(), "description");
        }
        if (description != null) {
            element.fDescription = description.toString();
        }
    }

    private String[] parseGroups(String nodeValue) {
        if (nodeValue.equals("")) {
            return new String[]{nodeValue};
        }
        if (nodeValue.startsWith(",") || nodeValue.endsWith(",")) {
            return null;
        }
        String[] groups = nodeValue.split(",");
        ArrayList<String> groupList = new ArrayList<String>();
        AbstractMemoryMapRendering rendering = this.fParent.getLayout().getRendering();
        int i = 0;
        while (i < groups.length) {
            groups[i] = groups[i].trim();
            if (groups[i].equalsIgnoreCase("ALL")) {
                String[] retString = new String[]{groups[i]};
                return retString;
            }
            if (rendering.containsGroup(groups[i])) {
                groupList.add(groups[i]);
            } else if (!rendering.isRemovedGroup(groups[i]) && !rendering.containsGroup(groups[i])) {
                return null;
            }
            ++i;
        }
        return groupList.toArray(new String[0]);
    }

    private Set<String> setChildGroups(Set<String> childGroups, MemoryMapLayout existingLayout, String childName, String childType, int childLength, int parentOffset, int currentOffset) {
        int childOffset = this.fParent.isMap() ? currentOffset : (this.fParent.getType().equals("BITMASK") ? parentOffset + currentOffset / 8 : currentOffset);
        if (existingLayout != null) {
            MapElement[] children = existingLayout.findElementsByAttributes(childName, childType, childLength, childOffset);
            childGroups = new HashSet<String>();
            int j = 0;
            while (j < children.length) {
                childGroups.addAll(children[j].getExplicitGroups());
                ++j;
            }
        } else {
            Set<String> groups = this.findOldGroups(childName, childType, childLength, childOffset);
            if (groups != null) {
                childGroups = groups;
            }
        }
        return childGroups;
    }

    private String getLayoutFileName(String childLayout) {
        Object layoutFileName;
        if (childLayout == null || childLayout.trim().equals("")) {
            layoutFileName = this.fParent.getLayout().getMappingFile();
        } else {
            Path childPath = new Path(childLayout);
            if (childPath.isAbsolute()) {
                layoutFileName = childLayout;
            } else {
                Path pathToLayout = new Path(this.fParent.getLayout().getMappingFile());
                pathToLayout = pathToLayout.removeLastSegments(1);
                pathToLayout = pathToLayout.addTrailingSeparator();
                layoutFileName = pathToLayout.toOSString();
                layoutFileName = (String)layoutFileName + childLayout;
            }
        }
        return layoutFileName;
    }

    private Set<String> findOldGroups(String childName, String childType, int childLength, int childOffset) {
        CachedMapElement id = new CachedMapElement(childName, childType, childLength, childOffset, new Path(this.fParent.getLayout().getMappingFile()));
        return this.castToStringSet(this.fParent.getLayout().getRendering().getCachedProperty(id, "Groups"));
    }

    private Set<String> castToStringSet(Object handle) {
        return handle != null && handle instanceof Set ? (Set)handle : null;
    }

    public Set<String> getAddedGroups() {
        return this.addedGroups;
    }
}

