/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap;

import com.ibm.debug.memorymap.MemoryMapPlugin;
import com.ibm.debug.memorymap.MemoryMapRenderingFile;
import com.ibm.debug.memorymap.MemoryMapRenderingFolder;
import com.ibm.debug.memorymap.utils.MemoryMapUtils;
import com.ibm.debug.pdt.internal.core.util.PDTCoreUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.ui.memory.AbstractMemoryRenderingBindingsProvider;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.PlatformUI;

public class MemoryMapBindingProvider
extends AbstractMemoryRenderingBindingsProvider {
    private static final int MAX_RECENTLY_USED_MAP_FILES = 5;
    private LinkedList<MemoryMapRenderingFile.Memento> fRecentlySelectedMappingFiles = new LinkedList();
    private ArrayList<MemoryMapRenderingFile> fMemoryMapFiles = new ArrayList();
    private MemoryMapRenderingFolder fDefaultDirInfo;

    public MemoryMapBindingProvider() {
        this.setupDefaultDirectory();
        MemoryMapPlugin.getInstance().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("com.ibm.debug.memorymap.memoryMapLocation")) {
                    MemoryMapBindingProvider.this.setupDefaultDirectory();
                    MemoryMapBindingProvider.this.fDefaultDirInfo.updateFileList();
                    MemoryMapBindingProvider.this.updateRenderingTypesList();
                    MemoryMapBindingProvider.this.fireBindingsChanged();
                }
            }
        });
        this.restoreRecentlySelectedMappingFilesList();
    }

    public synchronized IMemoryRenderingType[] getRenderingTypes(IMemoryBlock block) {
        this.updateRenderingTypesList();
        return this.fMemoryMapFiles.toArray(new IMemoryRenderingType[this.fMemoryMapFiles.size()]);
    }

    public IMemoryRenderingType[] getDefaultRenderingTypes(IMemoryBlock block) {
        return new IMemoryRenderingType[0];
    }

    public IMemoryRenderingType getPrimaryRenderingType(IMemoryBlock block) {
        return null;
    }

    public void markBindingsAsStale() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MemoryMapBindingProvider.this.updateRenderingTypesList();
                MemoryMapBindingProvider.this.fireBindingsChanged();
            }
        });
    }

    private void setupDefaultDirectory() {
        File file;
        String preferredLocation = MemoryMapPlugin.getInstance().getPreferenceStore().getString("com.ibm.debug.memorymap.memoryMapLocation");
        boolean locIsRemote = MemoryMapPlugin.getInstance().getPreferenceStore().getBoolean("map_location_is_remote");
        if (!(locIsRemote || (file = new File(preferredLocation)).exists() && file.canRead())) {
            preferredLocation = null;
        }
        if (preferredLocation == null || preferredLocation.length() == 0) {
            preferredLocation = MemoryMapUtils.getDefaultMapLocation();
            locIsRemote = false;
        }
        String prefix = "file:/";
        if (preferredLocation != null && preferredLocation.startsWith(prefix)) {
            preferredLocation = preferredLocation.substring(prefix.length());
        }
        if (this.fDefaultDirInfo == null) {
            this.fDefaultDirInfo = new MemoryMapRenderingFolder(preferredLocation, this);
        } else {
            this.fDefaultDirInfo.setNewDirectory(preferredLocation);
        }
        this.fDefaultDirInfo.setRemote(locIsRemote);
    }

    private void updateRenderingTypesList() {
        this.fMemoryMapFiles.clear();
        if (!this.fDefaultDirInfo.isRemote()) {
            this.fDefaultDirInfo.updateFileList();
        }
        this.fMemoryMapFiles.add(this.fDefaultDirInfo);
        for (MemoryMapRenderingFile.Memento mappingMemento : this.fRecentlySelectedMappingFiles) {
            this.fMemoryMapFiles.add(new MemoryMapRenderingFile(mappingMemento, this));
        }
    }

    void updateRecentlySelectedMappingFilesList(MemoryMapRenderingFile.Memento memento) {
        if (PDTCoreUtils.isEmpty((String)memento.getFileName())) {
            return;
        }
        boolean wasAlreadyInList = this.fRecentlySelectedMappingFiles.remove(memento);
        this.fRecentlySelectedMappingFiles.addFirst(memento);
        if (!wasAlreadyInList && this.fRecentlySelectedMappingFiles.size() > 5) {
            this.fRecentlySelectedMappingFiles.removeLast();
        }
        this.saveRecentlySelectedMappingFilesList();
    }

    private void saveRecentlySelectedMappingFilesList() {
        IPreferenceStore store = MemoryMapPlugin.getInstance().getPreferenceStore();
        store.setValue("com.ibm.debug.memorymap.MemoryMapBindingProvider.fRecentlySelectedMappingFiles.size", this.fRecentlySelectedMappingFiles.size());
        int ordinal = 1;
        for (MemoryMapRenderingFile.Memento used : this.fRecentlySelectedMappingFiles) {
            used.persist(store, ordinal++);
        }
    }

    private void restoreRecentlySelectedMappingFilesList() {
        IPreferenceStore store = MemoryMapPlugin.getInstance().getPreferenceStore();
        int size = store.getInt("com.ibm.debug.memorymap.MemoryMapBindingProvider.fRecentlySelectedMappingFiles.size");
        int ordinal = 1;
        while (ordinal <= size) {
            this.fRecentlySelectedMappingFiles.addLast(new MemoryMapRenderingFile.Memento(store, ordinal));
            ++ordinal;
        }
    }
}

