/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap;

import com.ibm.debug.memorymap.MapElement;
import com.ibm.debug.memorymap.MemoryBlockSegment;
import com.ibm.debug.memorymap.MemoryMapBuilder;
import com.ibm.debug.memorymap.MemoryMapLayout;
import com.ibm.debug.memorymap.MemoryMapPartitionElement;
import com.ibm.debug.memorymap.MemoryMapPlugin;
import com.ibm.debug.memorymap.MemoryMapSelection;
import com.ibm.debug.memorymap.ORGParent;
import com.ibm.debug.memorymap.utils.MemoryMapException;
import com.ibm.debug.memorymap.utils.MemoryMapFileWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.MemoryByte;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MemoryMap
extends MapElement {
    public static final String PREFIX = "memory_map.";
    public static final int PARTITION_LENGTH = 16;
    private static final int BREAKUP_LENGTH = 18;
    private String fType;
    protected Node fNode;
    protected MemoryByte[] fMemory;
    protected boolean fIsBuilt;
    protected boolean fBuildInProgress = false;
    protected boolean fContainsORGElement = false;
    protected TreeMap<Integer, ORGParent> fOrgsToIndices;
    private String fDisplayType = "DEFAULT";
    protected HashSet<MemoryBlockSegment> fMemoryBlockSegments;
    private MemoryMapSelection fLastSelection;
    private boolean fContainedLastSelection;

    public MemoryMap(MemoryMapLayout layout, MapElement parent, String name, BigInteger address, int offset, int length, String type, Set<String> groups, Node node) throws MemoryMapException {
        super(layout, parent, name, address, length, groups);
        this.fOffset = offset;
        this.fType = type;
        this.fNode = node;
        this.fIsBitmask = this.fType.equals("BITMASK");
        this.fIsBit = this.fType.equals("BIT");
        this.fIsStructure = this.fType.equals("STRUCTURE");
        this.fIsUnion = this.fType.equals("UNION");
        this.fIsMap = this.fType.equals("MAP");
        this.fIsPadding = this.fType.equals("PADDING");
        boolean bl = this.fIsExternalMapOrStructure = (this.fIsMap || this.fIsStructure) && this.fMapLayout != this.fParent.fMapLayout;
        if (this.fIsBitmask) {
            this.buildChildrenAndAddGroups();
        }
        this.setupDisplayType();
        this.fMemoryBlockSegments = new HashSet();
    }

    protected final void finalize() {
    }

    public void setupDisplayType() {
        this.fDisplayType = this.fType.equals("HEX") || this.fType.equals("16_BIT_HINT") || this.fType.equals("32_BIT_HINT") ? "HEX" : (this.fType.equals("ASCII") ? "ASCII" : (this.fType.equals("EBCDIC") ? "EBCDIC" : (this.fType.equals("CHARACTER") ? "HEX" : (this.isBitmask() ? "BINARY" : (!this.isPadding() || !this.isBit() || !this.isUnionMapOrStructure() ? "DECIMAL" : "DEFAULT")))));
        this.setDisplayType(this.fDisplayType);
    }

    public void setDisplayType(String displayType) {
        this.fDisplayType = displayType;
        if (this.hasChildren()) {
            try {
                MapElement[] children = this.getChildren(false);
                int i = 0;
                while (i < children.length) {
                    if (children[i] instanceof MemoryMap) {
                        if ("DEFAULT".equals(displayType)) {
                            ((MemoryMap)children[i]).setupDisplayType();
                        } else {
                            ((MemoryMap)children[i]).setDisplayType(displayType);
                        }
                    }
                    ++i;
                }
            }
            catch (DebugException debugException) {
                // empty catch block
            }
        }
    }

    public String getDisplayType() {
        Object obj;
        if (this.isMap() || this.isStructure() || this.isZeroLengthField()) {
            this.fDisplayType = "UNKNOWN";
        }
        ListIterator iter = this.fChildren.listIterator();
        if (!this.isBitmask() && iter.hasNext() && (obj = iter.next()) instanceof MemoryMap) {
            String displayType = ((MemoryMap)obj).getDisplayType();
            while (iter.hasNext()) {
                Object child = iter.next();
                if (!(child instanceof MemoryMap) || displayType.equals(((MemoryMap)child).getDisplayType())) continue;
                this.fDisplayType = "UNKNOWN";
                return this.fDisplayType;
            }
            this.fDisplayType = displayType;
        }
        return this.fDisplayType;
    }

    public Node getNode() {
        return this.fNode;
    }

    protected boolean memoryIsOutOfSync() {
        boolean outOfSync = this.fMemory == null || this.fMemoryBlockSegments.size() == 0;
        for (MemoryBlockSegment segment : this.fMemoryBlockSegments) {
            if (this.fMapLayout.getSegmentRetrievalStatus(segment) == 0) continue;
            outOfSync = true;
            break;
        }
        return outOfSync;
    }

    public MemoryByte[] getBytes() throws DebugException {
        if (this.memoryIsOutOfSync()) {
            if (this.fParent.isBitmask() && this.isBit()) {
                this.fMemory = ((MemoryMap)this.fParent).getBytes();
                this.fMemoryBlockSegments = ((MemoryMap)this.fParent).fMemoryBlockSegments;
            } else if (!this.isPadding() && !this.isUnionMapOrStructure()) {
                HashSet<MemoryBlockSegment> neededSegments = this.fMapLayout.findMatchingSegments(this.fAddress, this.fLength);
                if (this.fMemoryBlockSegments.size() == 0) {
                    this.fMemoryBlockSegments = neededSegments;
                }
                try {
                    if (this.fMemory == null) {
                        this.fMemory = this.fMapLayout.copyBytes(this.fLength, this.fAddress);
                    } else {
                        this.fMapLayout.refreshBytes();
                    }
                    this.setAllAsRefreshed();
                }
                catch (DebugException e) {
                    this.fMemory = null;
                    MemoryMapPlugin.logException((Exception)((Object)e));
                    throw e;
                }
            }
        }
        return this.fMemory;
    }

    protected void setAllAsRefreshed() {
        for (MemoryBlockSegment segment : this.fMemoryBlockSegments) {
            segment.setRefreshIndex(this.fMapLayout.getRefreshIndex());
        }
    }

    @Override
    public boolean isEditable() {
        if (this.isUnionMapOrStructure() || this.isBitmask() || this.isPadding()) {
            return false;
        }
        if (!(this.fType.equals("16_BIT_INT") || this.fType.equals("16_BIT_UINT") || this.fType.equals("16_BIT_HINT") || this.fType.equals("32_BIT_INT") || this.fType.equals("32_BIT_UINT") || this.fType.equals("32_BIT_HINT") || this.fType.equals("32_BIT_FLOAT") || this.fType.equals("64_BIT_INT") || this.fType.equals("64_BIT_FLOAT") || this.fType.equals("CHARACTER") || this.fType.equals("HEX") || this.fType.equals("ASCII") || this.fType.equals("EBCDIC") || this.fType.equals("BIT"))) {
            return false;
        }
        if ((this.fType.equals("HEX") || this.fType.equals("ASCII") || this.fType.equals("EBCDIC") || this.fType.equals("CHARACTER")) && this.fLength > 18) {
            return false;
        }
        try {
            this.getBytes();
        }
        catch (DebugException e) {
            return false;
        }
        if (this.fMemory == null || this.fLength == 0) {
            return false;
        }
        int i = 0;
        while (i < this.fMemory.length) {
            if (!this.fMemory[i].isWritable()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean hasChanged() {
        boolean hasChanged = false;
        if (this.hasChildren() && !this.isBitmask()) {
            int i = 0;
            while (i < this.fChildren.size()) {
                MapElement child = (MapElement)this.fChildren.get(i);
                if (child instanceof MemoryMap) {
                    MemoryMap memoryMap = (MemoryMap)child;
                    if (memoryMap.fMemory != null) {
                        hasChanged = this.checkMemoryForChange(memoryMap.fMemory);
                    } else if (memoryMap.hasChildren()) {
                        hasChanged = child.hasChanged();
                    }
                    if (hasChanged) {
                        return hasChanged;
                    }
                }
                ++i;
            }
            return hasChanged;
        }
        try {
            this.getBytes();
        }
        catch (DebugException e) {
            return false;
        }
        if (this.fMemory != null) {
            return this.checkMemoryForChange(this.fMemory);
        }
        return false;
    }

    private boolean checkHistoryKnown(MemoryByte[] memory) {
        if (memory == null) {
            return false;
        }
        int i = 0;
        while (i < memory.length) {
            if (!memory[i].isHistoryKnown()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkMemoryForChange(MemoryByte[] memory) {
        if (memory == null) {
            return false;
        }
        int i = 0;
        while (i < memory.length) {
            if (!memory[i].isHistoryKnown()) {
                return false;
            }
            if (memory[i].isChanged()) {
                if (this.isBit()) {
                    return this.isBitChanged(i);
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public MapElement[] getChildren(boolean buildChildren) throws DebugException {
        if (this.hasChildren() && !this.fIsBuilt && buildChildren) {
            try {
                this.getChildren();
            }
            catch (Exception e) {
                String message = e.getMessage();
                if (message == null) {
                    message = "";
                }
                DebugException de = new DebugException((IStatus)new Status(4, "com.ibm.debug.memorymap", 0, message, (Throwable)e));
                this.fMapLayout.getRendering().registerDebugException(de);
                throw de;
            }
        }
        return super.getChildren(buildChildren);
    }

    @Override
    public boolean hasChildren() {
        if (this.fLength == 0) {
            return false;
        }
        if (this.isUnionMapOrStructure() || this.isORGParent()) {
            return true;
        }
        return super.hasChildren() || this.elementIsTooLong();
    }

    @Override
    public BigInteger getAddress() {
        if (this.isMap()) {
            this.fAddress = this.fMapLayout.getAddress();
            return this.fAddress;
        }
        if (this.isBit()) {
            this.fAddress = this.fParent.getAddress().add(BigInteger.valueOf(this.fOffset / 8));
            return this.fAddress;
        }
        if (this.isPadding() && this.fParent instanceof MemoryMap && this.fParent.isBitmask()) {
            this.fAddress = this.fParent.getAddress().add(BigInteger.valueOf(this.fOffset / 8));
            return this.fAddress;
        }
        return this.fAddress;
    }

    @Override
    public String getType() {
        return this.fType;
    }

    public boolean isUnionMapOrStructure() {
        return this.isMap() || this.isUnion() || this.isStructure();
    }

    @Override
    public int getOffset() {
        if (this.isMap() || this.isStructure() && this.isExternalMapOrStructure()) {
            return this.fMapLayout.getReferenceOffsetIndex();
        }
        if (this.fParent instanceof MemoryMap) {
            if (this.isBit()) {
                return ((MemoryMap)this.fParent).getOffset() + this.fOffset / 8;
            }
            if (this.isPadding() && this.fParent.isBitmask()) {
                return ((MemoryMap)this.fParent).getOffset() + this.fOffset / 8;
            }
        }
        return this.fOffset;
    }

    public int getBitOffset() {
        return this.fOffset;
    }

    public int getOffsetInLayout() {
        return this.getOffset();
    }

    private boolean elementIsTooLong() {
        return this.fLength > 18 && (this.fType.equals("HEX") || this.fType.equals("ASCII") || this.fType.equals("EBCDIC") || this.fType.equals("CHARACTER"));
    }

    private void getChildren() throws MemoryMapException, DebugException {
        if (this.fIsBuilt || this.fBuildInProgress) {
            return;
        }
        this.fBuildInProgress = true;
        if (this.elementIsTooLong()) {
            this.partitionElements();
            this.fIsBuilt = true;
        } else {
            try {
                this.buildChildrenAndAddGroups();
            }
            catch (MemoryMapException e) {
                this.fChildren = Collections.emptyList();
                this.fBuildInProgress = false;
                throw e;
            }
        }
        this.fBuildInProgress = false;
    }

    private void buildChildrenAndAddGroups() throws MemoryMapException {
        this.fChildren = new ArrayList();
        int startOffset = this.getOffset();
        if (this.isMap() || this.isBitmask()) {
            startOffset = 0;
        }
        MemoryMapBuilder builder = this.fMapLayout.getRendering().getMapBuilder(this, this.fAddress, this.fNode, startOffset);
        builder.buildChildren();
        if (!this.isMap()) {
            this.addGroupsToChildren(this);
            this.addGroupsToParent(builder.getAddedGroups());
        }
        this.fIsBuilt = true;
    }

    private void partitionElements() throws MemoryMapException {
        if (this.fChildren.size() > 0) {
            return;
        }
        int i = 0;
        while (i + 16 < this.fLength) {
            this.createAndAddPartition(i, 16);
            i += 16;
        }
        if (i < this.fLength) {
            int length = this.fLength - i;
            this.createAndAddPartition(i, length);
        }
    }

    private void createAndAddPartition(int offset, int length) throws MemoryMapException {
        MemoryMapPartitionElement map = new MemoryMapPartitionElement(this.fMapLayout, this, this.fAddress.add(BigInteger.valueOf(offset)), this.fOffset + offset, length, this.fType, this.fExplicitGroups, this.fNode);
        this.addChild(map);
    }

    public boolean isMonitored() {
        boolean isMonitored = false;
        if (this.hasChildren()) {
            if (!this.fIsBuilt) {
                return false;
            }
            int i = 0;
            while (i < this.fChildren.size()) {
                MapElement child = (MapElement)this.fChildren.get(i);
                if (child instanceof MemoryMap) {
                    MemoryMap memoryMap = (MemoryMap)child;
                    if (memoryMap.fMemory != null ? !(isMonitored = this.checkHistoryKnown(memoryMap.fMemory)) : memoryMap.hasChildren() && memoryMap.isBuilt() && !(isMonitored = memoryMap.isMonitored())) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
        try {
            this.getBytes();
        }
        catch (DebugException e) {
            return false;
        }
        if (this.fMemory == null || this.fLength == 0) {
            return false;
        }
        return this.checkHistoryKnown(this.fMemory);
    }

    protected void addGroupsToChildren(MapElement element) {
        ListIterator<Object> iterator = element.fChildren.listIterator();
        while (iterator.hasNext()) {
            MapElement child = (MapElement)iterator.next();
            child.fExplicitGroups.addAll(this.fExplicitGroups);
            if (!child.hasChildren()) continue;
            this.addGroupsToChildren(child);
        }
    }

    protected void addGroupsToParent(Set<String> groups) {
        this.fImplicitGroups.addAll(groups);
        if (this.fParent != null && this.fParent instanceof MemoryMap) {
            ((MemoryMap)this.fParent).addGroupsToParent(groups);
        }
    }

    public boolean isBuilt() {
        return this.fIsBuilt;
    }

    public void exportFromXML(MemoryMapFileWriter writer, int numTabs) {
        this.exportSingleNode(writer, this.fNode, numTabs + 1);
    }

    private void exportSingleNode(MemoryMapFileWriter writer, Node node, int numTabs) {
        NodeList children = node.getChildNodes();
        StringBuffer nodeBuffer = new StringBuffer();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                boolean hasChildren;
                NamedNodeMap attributes = child.getAttributes();
                nodeBuffer.append("<");
                nodeBuffer.append(child.getNodeName()).append(" ");
                int k = 0;
                while (k < attributes.getLength()) {
                    Node attribute = attributes.item(k);
                    nodeBuffer.append(attribute.getNodeName()).append(" = \"");
                    nodeBuffer.append(attribute.getNodeValue()).append("\" ");
                    ++k;
                }
                boolean bl = hasChildren = child.getChildNodes().getLength() > 0;
                if (hasChildren) {
                    nodeBuffer.append(">\r\n");
                    writer.append(numTabs, nodeBuffer.toString());
                    this.exportSingleNode(writer, child, numTabs + 1);
                    String closingTag = new StringBuffer("</").append(child.getNodeName()).append(">\r\n").toString();
                    writer.append(numTabs, closingTag);
                } else {
                    nodeBuffer.append("/>\r\n");
                    writer.append(numTabs, nodeBuffer.toString());
                }
                nodeBuffer = new StringBuffer();
            }
            ++i;
        }
    }

    @Override
    public boolean containsAddress(MemoryMapSelection selection) {
        if (selection == this.fLastSelection) {
            return this.fContainedLastSelection;
        }
        boolean containsAddress = super.containsAddress(selection);
        if (!containsAddress) {
            int i = 0;
            while (i < this.fChildren.size()) {
                MapElement child = (MapElement)this.fChildren.get(i);
                containsAddress = child.containsAddress(selection);
                if (containsAddress) break;
                ++i;
            }
        }
        this.fContainedLastSelection = containsAddress;
        this.fLastSelection = selection;
        return containsAddress;
    }

    public String toString() {
        return this.fName + "  " + this.fOffset;
    }

    @Override
    public String getTagForExport(boolean preserveDirectoryStructure) {
        StringBuffer buffer = new StringBuffer(super.getTagForExport(preserveDirectoryStructure));
        int index = buffer.lastIndexOf(">") - 1;
        Node node = null;
        if (this.isExternalMapOrStructure()) {
            node = this.fMapLayout.getReferenceNode();
        }
        if (node == null) {
            node = this.fNode;
        }
        if (this.fNode.getAttributes().getNamedItem("offset") != null) {
            buffer.insert(index, "  offset = \"" + this.fNode.getAttributes().getNamedItem("offset").getNodeValue() + "\"");
        }
        if (this.fNode.getAttributes().getNamedItem("offset_mode") != null) {
            buffer.insert(index, " offset_mode = \"" + this.fNode.getAttributes().getNamedItem("offset_mode").getNodeValue() + "\"");
        }
        return buffer.toString();
    }

    protected boolean isBitChanged(int i) {
        Object newBits;
        int locateByte = this.getOffsetInLayout();
        MemoryByte[] history = this.fMapLayout.getHistory();
        if (history == null || this.fMemory == null) {
            return false;
        }
        if (history.length == 0 || locateByte >= history.length) {
            return false;
        }
        byte oldValue = history[locateByte].getValue();
        byte newValue = this.fMemory[i].getValue();
        Object oldBits = Integer.toBinaryString(oldValue);
        if (((String)oldBits).length() < 8) {
            oldBits = "00000000".substring(1, 8 - ((String)oldBits).length() + 1) + (String)oldBits;
        }
        if (((String)oldBits).length() > 8) {
            oldBits = ((String)oldBits).substring(((String)oldBits).length() - 8);
        }
        if (((String)(newBits = Integer.toBinaryString(newValue))).length() < 8) {
            newBits = "00000000".substring(1, 8 - ((String)newBits).length() + 1) + (String)newBits;
        }
        if (((String)newBits).length() > 8) {
            newBits = ((String)newBits).substring(((String)newBits).length() - 8);
        }
        int offset = this.getBitOffset();
        int j = 0;
        while (j < this.fLength && offset + j < ((String)newBits).length()) {
            if (((String)newBits).charAt(offset + j) != ((String)oldBits).charAt(offset + j)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public boolean containsORGElement() {
        return this.fContainsORGElement;
    }

    public ORGParent getORGChild(int i) {
        if (this.fOrgsToIndices != null) {
            return this.fOrgsToIndices.get(i);
        }
        return null;
    }

    public void addORGChild(ORGParent org) {
        int index = this.fChildren.size();
        Integer key = index;
        if (this.fContainsORGElement) {
            while (this.fOrgsToIndices.containsKey(key)) {
                key = key + 1;
            }
        }
        this.fContainsORGElement = true;
        if (this.fOrgsToIndices == null) {
            this.fOrgsToIndices = new TreeMap();
        }
        this.fOrgsToIndices.put(key, org);
    }

    public ArrayList<ORGParent> getExternalOrgChildren() {
        ArrayList<ORGParent> list = new ArrayList<ORGParent>();
        if (this.fOrgsToIndices != null) {
            Iterator<Integer> iter = this.fOrgsToIndices.keySet().iterator();
            list.add(this.fOrgsToIndices.get(iter.next()));
        }
        return list;
    }

    public void setMemoryBlockSegments(HashSet<MemoryBlockSegment> memoryBlockSegments) {
        if (memoryBlockSegments != null && memoryBlockSegments.size() > 0) {
            this.fMemoryBlockSegments = memoryBlockSegments;
        }
    }
}

