/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap;

import java.math.BigInteger;

public class MemoryBlockSegment {
    private boolean fIsNeeded;
    private boolean fHasBeenRetrieved;
    private BigInteger fStartAddress;
    private int fLength;
    private int fStartIndex;
    private BigInteger fEnd;
    private int fLastRefreshIndex;

    public MemoryBlockSegment(BigInteger startAddress, int length) {
        this.fStartAddress = startAddress;
        this.fEnd = this.fStartAddress.add(BigInteger.valueOf(length));
        this.fLength = length;
        this.fLastRefreshIndex = -1;
        this.fStartIndex = -1;
    }

    public int getLength() {
        return this.fLength;
    }

    public BigInteger getStartAddress() {
        return this.fStartAddress;
    }

    public void updateAddress(BigInteger delta) {
        this.fStartAddress = this.fStartAddress.add(delta);
        this.fEnd = this.fStartAddress.add(BigInteger.valueOf(this.fLength));
    }

    public boolean hasBeenRetrieved() {
        return this.fHasBeenRetrieved;
    }

    public boolean isNeeded() {
        return this.fIsNeeded;
    }

    public void setNeeded(boolean b) {
        this.fIsNeeded = b;
    }

    public void setRetrieved() {
        this.fHasBeenRetrieved = true;
    }

    public boolean containsAddress(BigInteger address) {
        return this.fStartAddress.compareTo(address) <= 0 && this.fEnd.compareTo(address) > 0;
    }

    public int getNumberOfBytesCovered(BigInteger address, int length) {
        int numberOfBytes = 0;
        if (length >= 0) {
            BigInteger end = address.add(BigInteger.valueOf(length));
            if (this.fStartAddress.compareTo(address) <= 0 && this.fEnd.compareTo(end) >= 0) {
                numberOfBytes = Math.min(length, this.fLength);
            } else if (this.fStartAddress.compareTo(address) >= 0) {
                if (this.fEnd.compareTo(end) >= 0) {
                    numberOfBytes = end.subtract(this.fStartAddress).intValue();
                } else if (this.fEnd.compareTo(end) < 0) {
                    numberOfBytes = this.fLength;
                }
            } else if (this.fEnd.compareTo(end) < 0) {
                numberOfBytes = this.fStartAddress.compareTo(address) >= 0 ? this.fLength : this.fEnd.subtract(address).intValue();
            }
        }
        return numberOfBytes < 0 ? 0 : numberOfBytes;
    }

    public boolean isInRange(BigInteger address, int length) {
        return this.getNumberOfBytesCovered(address, length) > 0;
    }

    public String toString() {
        return "Address " + this.fStartAddress.toString() + ", Length: " + this.fLength + " Needed: " + this.isNeeded() + " Retrieved: " + this.fHasBeenRetrieved;
    }

    public void reset() {
        this.fHasBeenRetrieved = false;
    }

    public int getStartIndex() {
        return this.fStartIndex;
    }

    public void setStartIndex(int startIndex) {
        this.fStartIndex = startIndex;
    }

    public int getRefreshIndex() {
        return this.fLastRefreshIndex;
    }

    public void setRefreshIndex(int refreshIndex) {
        if (refreshIndex > this.fLastRefreshIndex) {
            this.fLastRefreshIndex = refreshIndex;
        }
    }
}

