/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap;

import com.ibm.debug.memorymap.MemoryMap;
import com.ibm.debug.memorymap.MemoryMapLayout;
import com.ibm.debug.memorymap.MemoryMapParent;
import com.ibm.debug.memorymap.MemoryMapPlugin;
import com.ibm.debug.memorymap.MemoryMapSelection;
import com.ibm.debug.memorymap.utils.CachedMapElement;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapProperty;
import com.ibm.debug.memorymap.utils.MemoryMapUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.osgi.util.NLS;

public abstract class MapElement {
    private static final List<Object> EMPTY_LIST = Collections.emptyList();
    protected MapElement fParent;
    protected List<Object> fChildren;
    protected BigInteger fAddress;
    protected int fLength;
    protected int fOffset;
    protected MemoryMapLayout fMapLayout;
    protected String fName;
    protected String fPath;
    protected Set<String> fExplicitGroups;
    protected Set<String> fImplicitGroups;
    protected String fDescription;
    protected boolean fIsExternalMapOrStructure;
    protected boolean fIsBit;
    protected boolean fIsBitmask;
    protected boolean fIsPadding;
    protected boolean fIsMap;
    protected boolean fIsUnion;
    protected boolean fIsStructure;

    public MapElement(MemoryMapLayout layout, MapElement parent, String name, BigInteger address, int length, Set<String> groups) {
        this.fMapLayout = layout;
        this.fParent = parent;
        this.fChildren = EMPTY_LIST;
        this.fLength = length;
        this.fExplicitGroups = groups;
        this.fImplicitGroups = new HashSet<String>();
        this.fName = name;
        this.fAddress = address;
        this.setPath();
    }

    private void setPath() {
        if (this.fParent != null) {
            StringBuffer buf = new StringBuffer(this.fParent.getPath());
            if (!this.fParent.getPath().equals("/")) {
                buf.append("/");
            }
            buf.append(this.fName);
            this.fPath = buf.toString();
        }
        if (this instanceof MemoryMapParent) {
            this.fPath = "/";
        }
    }

    public MapElement[] getChildren(boolean buildChildren) throws DebugException {
        List<Object> list = this.getChildrenAsList();
        return list.toArray(new MapElement[list.size()]);
    }

    public List<Object> getChildrenAsList() {
        List<Object> list = null;
        if (this.fChildren == null) {
            list = Collections.emptyList();
        } else {
            list = new ArrayList<Object>(this.fChildren);
            if (this.fMapLayout != null && this.fMapLayout.getRendering().getCurrentGroup() != null) {
                ListIterator<Object> iterator = list.listIterator();
                while (iterator.hasNext()) {
                    MapElement element;
                    Object obj = iterator.next();
                    if (!(obj instanceof MapElement) || (element = (MapElement)obj).getGroups() == null || element.getGroups().contains("ALL") || element.getGroups().contains(this.fMapLayout.getRendering().getCurrentGroup())) continue;
                    iterator.remove();
                }
            }
        }
        return list;
    }

    public void addChild(MapElement child) {
        if (this.fChildren == EMPTY_LIST) {
            this.fChildren = new ArrayList<Object>();
            this.fChildren.add(child);
        } else if (!this.fChildren.contains(child)) {
            this.fChildren.add(child);
        }
    }

    public void setName(String name) {
        this.fName = name;
    }

    public void removeChild(MapElement child) {
        this.fChildren.remove(child);
    }

    public MapElement getParent() {
        return this.fParent;
    }

    public boolean hasChildren() {
        return !this.fChildren.isEmpty();
    }

    public abstract boolean hasChanged();

    public BigInteger getAddress() {
        if (this.fAddress == null) {
            return BigInteger.valueOf(0L);
        }
        return this.fAddress;
    }

    protected void updateAddress(BigInteger delta) {
        this.fAddress = this.fAddress.add(delta);
        int i = 0;
        while (i < this.fChildren.size()) {
            MapElement child = (MapElement)this.fChildren.get(i);
            if (child.getLayout() == this.fMapLayout) {
                child.updateAddress(delta);
            }
            ++i;
        }
    }

    public String getName() {
        return this.fName;
    }

    public String getPath() {
        return this.fPath;
    }

    public int getLength() {
        return this.fLength;
    }

    public String getDescription() {
        return this.fDescription == null ? "" : this.fDescription;
    }

    public void setDescription(String newDesc) {
        this.fDescription = newDesc;
        this.cacheElementProperties();
    }

    public String getTagForExport(boolean preserveDirectoryStructure) {
        StringBuffer tag = new StringBuffer("<");
        tag.append("FIELD").append(" ");
        int length = this.fLength;
        String name = this.fName;
        if (this.isMap()) {
            length = this.fMapLayout.getReferenceLength();
            name = this.fMapLayout.getReferenceName();
        }
        tag.append(" ");
        tag.append("Header").append(" = ").append("\"").append(name).append("\"");
        tag.append(" ");
        tag.append("length").append(" = ").append("\"").append(length).append("\"");
        tag.append(" ");
        tag.append("Type").append(" = ").append("\"").append(this.getType()).append("\"");
        tag.append(" ");
        if (this.getDescription().length() > 0) {
            tag.append("description").append(" = ").append("\"").append(this.fDescription).append("\"");
            tag.append(" ");
        }
        if (!this.fExplicitGroups.isEmpty()) {
            String groups = this.fExplicitGroups.toString();
            groups = groups.replaceAll("[\\]\\[]", "");
            tag.append("Groups").append(" = ").append("\"").append(groups).append("\"");
            tag.append(" ");
        }
        if (this.isExternalMapOrStructure()) {
            if (this.getType().equals("MAP")) {
                tag.append("layout");
            } else {
                tag.append("filename");
            }
            tag.append(" = ").append("\"").append(this.getMappingFile(preserveDirectoryStructure)).append("\"");
            tag.append(" ");
        }
        tag.append(">");
        return tag.toString();
    }

    public abstract int getOffset();

    public abstract boolean isEditable();

    public abstract String getType();

    public boolean containsAddress(MemoryMapSelection selection) {
        if (selection == null || selection.getStartAddress() == null) {
            return false;
        }
        return selection.getStartAddress().compareTo(this.getAddress()) >= 0 && selection.getStartAddress().compareTo(this.getAddress().add(BigInteger.valueOf(this.fLength))) < 0 || selection.getStartAddress().add(BigInteger.valueOf(selection.getLength())).compareTo(this.getAddress()) > 0 && selection.getStartAddress().add(BigInteger.valueOf(selection.getLength())).compareTo(this.getAddress().add(BigInteger.valueOf(this.fLength))) <= 0 || selection.getStartAddress().compareTo(this.getAddress()) < 0 && selection.getStartAddress().add(BigInteger.valueOf(selection.getLength())).compareTo(this.getAddress().add(BigInteger.valueOf(this.fLength))) > 0;
    }

    public MemoryMapLayout getLayout() {
        return this.fMapLayout;
    }

    public String getAddressInHexString() {
        return NLS.bind((String)MemoryMapLabels.hex_string_prefix, (Object)this.getAddress().toString(16).toUpperCase());
    }

    public Set<String> getGroups() {
        HashSet<String> groups = new HashSet<String>(this.fExplicitGroups);
        groups.addAll(this.fImplicitGroups);
        if (groups.contains("ALL")) {
            groups = new HashSet();
            groups.add("ALL");
        }
        return groups;
    }

    public void addGroup(String group, boolean addToAncestors) {
        if ("ALL".equals(group)) {
            this.clearExplicitGroups();
            this.clearImplicitGroups();
        } else {
            this.removeFromExplicitGroups("ALL");
            this.removeFromImplicitGroups("ALL");
            this.removeFromAncestors("ALL");
        }
        if (!this.getGroups().contains("ALL")) {
            this.addToExplicitGroups(group);
        }
        if (this instanceof MemoryMap && this.isMap()) {
            return;
        }
        if (addToAncestors) {
            MapElement map = this.fParent;
            while (!(map instanceof MemoryMapParent) && !"MAP".equals(((MemoryMap)map).getType())) {
                if (!map.getGroups().contains("ALL")) {
                    if ("ALL".equals(group)) {
                        map.clearImplicitGroups();
                    }
                    map.addToImplicitGroups(group);
                }
                map = map.fParent;
            }
        }
        ListIterator<Object> iter = this.fChildren.listIterator();
        while (iter.hasNext()) {
            ((MapElement)iter.next()).addGroup(group, false);
        }
    }

    public void removeGroup(String group) {
        this.removeFromExplicitGroups(group);
        this.removeFromImplicitGroups(group);
        ListIterator<Object> childrenIterator = this.fChildren.listIterator();
        while (childrenIterator.hasNext()) {
            ((MapElement)childrenIterator.next()).removeGroup(group);
        }
        if (this instanceof MemoryMap && this.isMap()) {
            return;
        }
        this.removeFromAncestors(group);
        if ("ALL".equals(group)) {
            Iterator<String> groupsIterator = this.fMapLayout.getRendering().getGroups();
            while (groupsIterator.hasNext()) {
                String temp = groupsIterator.next();
                if (!this.containsGroup(temp)) continue;
                this.addToImplicitGroups(temp);
            }
        }
    }

    public boolean isZeroLengthField() {
        return this.fLength == 0;
    }

    private void removeFromAncestors(String group) {
        MapElement map = this.fParent;
        while (!(map instanceof MemoryMapParent)) {
            boolean found = false;
            ListIterator<Object> childrenIterator = map.fChildren.listIterator();
            while (!found && childrenIterator.hasNext()) {
                if (!((MapElement)childrenIterator.next()).containsGroup(group)) continue;
                found = true;
            }
            if (!found) {
                map.removeFromImplicitGroups(group);
            }
            map = map.fParent;
        }
    }

    private boolean containsGroup(String group) {
        if (this.getGroups().contains(group)) {
            return true;
        }
        ListIterator<Object> iter = this.fChildren.listIterator();
        while (iter.hasNext()) {
            if (!((MapElement)iter.next()).containsGroup(group)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getExplicitGroups() {
        return new HashSet<String>(this.fExplicitGroups);
    }

    public boolean isORGParent() {
        return false;
    }

    private void addToExplicitGroups(String group) {
        this.fExplicitGroups.add(group);
        this.cacheElementProperties();
    }

    private void removeFromExplicitGroups(String group) {
        this.fExplicitGroups.remove(group);
        this.cacheElementProperties();
    }

    private void clearExplicitGroups() {
        this.fExplicitGroups.clear();
        this.cacheElementProperties();
    }

    private void addToImplicitGroups(String group) {
        this.fImplicitGroups.add(group);
    }

    private void removeFromImplicitGroups(String group) {
        this.fImplicitGroups.remove(group);
    }

    private void clearImplicitGroups() {
        this.fImplicitGroups.clear();
    }

    private void cacheElementProperties() {
        boolean shouldCache;
        boolean bl = shouldCache = !MemoryMapPlugin.getInstance().getPreferenceStore().getBoolean("com.ibm.debug.memorymap.do_export");
        if (shouldCache && this.fMapLayout.getRendering().supportsCaching()) {
            MemoryMapProperty properties = new MemoryMapProperty();
            properties.addToCache("description", this.getDescription());
            properties.addToCache("Groups", this.fExplicitGroups);
            this.fMapLayout.getRendering().addToCache(this.getId(), properties);
        }
    }

    protected CachedMapElement getId() {
        CachedMapElement id = new CachedMapElement(this.fName, this.getType(), this.fLength, this.getOffset(), new Path(this.fMapLayout.getMappingFile()));
        return id;
    }

    private String getMappingFile(boolean preserveDirectoryStructure) {
        IPath path = Path.fromOSString((String)this.fMapLayout.getMappingFile());
        if (preserveDirectoryStructure && this.fParent.fMapLayout != this.fMapLayout) {
            return MemoryMapUtils.makeRelative(path, Path.fromOSString((String)this.fParent.getLayout().getMappingFile()));
        }
        return path.lastSegment();
    }

    public boolean isBit() {
        return this.fIsBit;
    }

    public boolean isBitmask() {
        return this.fIsBitmask;
    }

    public boolean isExternalMapOrStructure() {
        return this.fIsExternalMapOrStructure;
    }

    public boolean isMap() {
        return this.fIsMap;
    }

    public boolean isPadding() {
        return this.fIsPadding;
    }

    public boolean isStructure() {
        return this.fIsStructure;
    }

    public boolean isUnion() {
        return this.fIsUnion;
    }
}

