/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap;

import com.ibm.debug.memorymap.MapElement;
import com.ibm.debug.memorymap.MemoryMap;
import com.ibm.debug.memorymap.MemoryMapLayout;
import java.math.BigInteger;
import java.util.Set;
import org.w3c.dom.Node;

public class ErrorMapElement
extends MapElement {
    private String fErrorMsg;
    private String fType;
    private Node fNode;

    public ErrorMapElement(MemoryMapLayout layout, MapElement parent, String name, String errorMsg, BigInteger address, int offset, int length, String type, Set<String> groups, Node node) {
        super(layout, parent, name, address, length, groups);
        this.fOffset = offset;
        this.fErrorMsg = errorMsg;
        this.fType = type;
        this.fNode = node;
    }

    public String getLabel() {
        return this.fErrorMsg;
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public int getOffset() {
        if (this.fParent instanceof MemoryMap) {
            MemoryMap parent = (MemoryMap)this.fParent;
            if ("BIT".equals(this.fType)) {
                if (parent.isBitmask()) {
                    return parent.getOffset() + this.fOffset / 8;
                }
                return this.fOffset;
            }
            if (this.isPadding()) {
                if (parent.isBitmask()) {
                    return ((MemoryMap)this.fParent).getOffset() + this.fOffset / 8;
                }
                return this.fOffset;
            }
        }
        return this.fOffset;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public String getType() {
        return this.fType;
    }

    @Override
    public String getTagForExport(boolean preserveDirectoryStructure) {
        StringBuffer buffer = new StringBuffer(super.getTagForExport(preserveDirectoryStructure));
        if (this.fNode != null) {
            int index = buffer.lastIndexOf(">") - 1;
            if (this.fNode.getAttributes().getNamedItem("offset") != null) {
                buffer.insert(index, "  offset\" = " + this.fNode.getAttributes().getNamedItem("offset").getNodeValue() + "\"");
            }
            if (this.fNode.getAttributes().getNamedItem("offset_mode") != null) {
                buffer.insert(index, " offset_mode\" = " + this.fNode.getAttributes().getNamedItem("offset_mode").getNodeValue() + "\"");
            }
        }
        return buffer.toString();
    }
}

