/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.debug.memorymap;

import com.ibm.debug.memorymap.MapElement;
import com.ibm.debug.memorymap.MappingFileChangeListener;
import com.ibm.debug.memorymap.MemoryMap;
import com.ibm.debug.memorymap.MemoryMapBuilder;
import com.ibm.debug.memorymap.MemoryMapLayout;
import com.ibm.debug.memorymap.MemoryMapParent;
import com.ibm.debug.memorymap.MemoryMapRendering;
import com.ibm.debug.memorymap.MemoryMapSelection;
import com.ibm.debug.memorymap.actions.ExportMapAction;
import com.ibm.debug.memorymap.actions.OpenMapFileAction;
import com.ibm.debug.memorymap.actions.RebuildMapAction;
import com.ibm.debug.memorymap.renderer.MemoryMapRenderer;
import com.ibm.debug.memorymap.utils.CachedMapElement;
import com.ibm.debug.memorymap.utils.MemoryMapException;
import com.ibm.debug.memorymap.utils.MemoryMapLabels;
import com.ibm.debug.memorymap.utils.MemoryMapMessages;
import com.ibm.debug.memorymap.utils.MemoryMapProperty;
import com.ibm.debug.memorymap.utils.MemoryMapRenderingMgr;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.memory.AbstractMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingSynchronizationService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.JFacePreferences;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Node;

public abstract class AbstractMemoryMapRendering
extends AbstractMemoryRendering
implements MappingFileChangeListener,
IMenuListener,
IPropertyChangeListener {
    protected RootMapLayout fRootLayout;
    protected DebugException fDebugException;
    protected String fMappingFile;
    private Hashtable<CachedMapElement, MemoryMapProperty> fCachedFields;
    private String fEncoding;
    protected MemoryMapParent fMapParent;
    protected SortedSet<String> fGroups;
    protected SortedSet<String> fRecentlyRemovedGroups;
    protected String fCurrentGroup;
    protected MemoryMapRenderer fRenderTool;
    private LinkedHashMap<String, Action> fActionRegistry;
    protected boolean fErrorOccurred = false;
    private ArrayList<MapElement> fLastSelectedElements;
    protected TextViewer fMapErrorTextViewer;
    protected TextViewer fDebugErrorTextViewer;
    protected Composite fMapErrorComposite;
    private Composite fButtonComposite;
    private Button fIgnoreErrorButton;
    private Button fOpenLayoutButton;
    private Button fConfirmButton;
    private Button fRecreateMapButton;

    public AbstractMemoryMapRendering(String renderingId, File file) {
        super(renderingId);
        this.fMappingFile = file.getPath();
        this.fEncoding = "ISO-8859-1";
        this.fCachedFields = new Hashtable();
        this.fActionRegistry = new LinkedHashMap();
        this.fRenderTool = new MemoryMapRenderer(this);
        this.fGroups = new TreeSet<String>();
        this.fRecentlyRemovedGroups = new TreeSet<String>();
    }

    public abstract void refresh();

    public abstract boolean supportsGrouping();

    public abstract boolean supportsCaching();

    public abstract boolean shouldRetrieveGroups();

    public abstract void retrieveGroupingInfo(boolean var1);

    public abstract void handleDebugError(DebugException var1);

    public abstract void handleMapError(MemoryMapException var1);

    protected abstract void updateSelection(ArrayList<MapElement> var1);

    public abstract void setMappingFile(String var1);

    public void setCurrentGroup(String group) {
        this.fCurrentGroup = group;
        this.refresh();
    }

    public void setEncoding(String encoding) {
        this.fEncoding = encoding;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public void addToCache(CachedMapElement id, MemoryMapProperty property) {
        if (this.supportsCaching()) {
            this.fCachedFields.put(id, property);
        }
    }

    public Object getCachedProperty(CachedMapElement mapId, String propertyId) {
        MemoryMapProperty property = this.fCachedFields.get(mapId);
        if (property != null) {
            return property.getCachedProperty(propertyId);
        }
        return null;
    }

    public DebugException getDebugException() {
        return this.fDebugException;
    }

    public boolean addGroup(String group) {
        return this.fGroups.add(group);
    }

    public boolean containsGroup(String group) {
        return this.fGroups.contains(group);
    }

    public Iterator<String> getGroups() {
        return this.fGroups.iterator();
    }

    public boolean hasGroups() {
        return !this.fGroups.isEmpty();
    }

    public void removeAllGroups() {
        this.fGroups.clear();
        this.fRecentlyRemovedGroups.clear();
    }

    public void removeGroup(String group) {
        this.fGroups.remove(group);
        this.fRecentlyRemovedGroups.add(group);
        try {
            MapElement[] elements = this.fRootLayout.getRootElement().getChildren(false);
            int i = 0;
            while (i < elements.length) {
                if (elements[i].getGroups().contains(group)) {
                    elements[i].removeGroup(group);
                }
                ++i;
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
    }

    public String getCurrentGroup() {
        return this.fCurrentGroup;
    }

    public boolean isRemovedGroup(String group) {
        return this.fRecentlyRemovedGroups.contains(group);
    }

    public String getMappingFile() {
        return this.fMappingFile;
    }

    public void registerDebugException(DebugException e) {
        this.fDebugException = e;
    }

    protected void clearCache() {
        this.fCachedFields.clear();
    }

    protected void disposeOfLayouts() {
        if (this.fRootLayout == null) {
            return;
        }
        HashSet<String> removedFiles = new HashSet<String>();
        ArrayList<MemoryMapLayout> layoutsToRemove = new ArrayList<MemoryMapLayout>();
        layoutsToRemove.add(this.fRootLayout);
        int i = 0;
        while (i < layoutsToRemove.size()) {
            String layout = ((MemoryMapLayout)layoutsToRemove.get(i)).getMappingFile();
            MemoryMapRenderingMgr.removeRendering(layout, this);
            removedFiles.add(layout);
            MemoryMapLayout[] childLayouts = ((MemoryMapLayout)layoutsToRemove.get(i)).getChildLayouts();
            int k = 0;
            while (k < childLayouts.length) {
                if (!removedFiles.contains(childLayouts[k].getMappingFile())) {
                    layoutsToRemove.add(childLayouts[k]);
                }
                ++k;
            }
            ++i;
        }
    }

    public void dispose() {
        super.dispose();
        MenuManager popupMenuManager = this.getPopupMenuManager();
        if (popupMenuManager != null) {
            popupMenuManager.removeMenuListener((IMenuListener)this);
        }
        DebugUITools.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.getMemoryRenderingContainer().getMemoryRenderingSite().getSynchronizationService().removePropertyChangeListener((IPropertyChangeListener)this);
        JFacePreferences.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.desynchronizeSelection();
        this.disposeOfLayouts();
        this.fRootLayout = null;
    }

    protected void createPopupMenu(Control control) {
        super.createPopupMenu(control);
        this.getPopupMenuManager().addMenuListener((IMenuListener)this);
    }

    protected void createPopupMenuActions() {
        this.addActionToRegistry("com.ibm.debug.memorymap.RebuildMapAction", new RebuildMapAction(this));
        this.addActionToRegistry("com.ibm.debug.memorymap.ExportMapAction", new ExportMapAction(this));
        this.addActionToRegistry("com.ibm.debug.memorymap.OpenMapFileAction", new OpenMapFileAction(this.fMappingFile, true));
    }

    protected void addActionToRegistry(String id, Action action) {
        this.fActionRegistry.put(id, action);
    }

    protected void removeAction(String id) {
        this.fActionRegistry.remove(id);
    }

    protected Action getAction(String id) {
        Action action = this.fActionRegistry.get(id);
        if (action != null) {
            return action;
        }
        return null;
    }

    public void menuAboutToShow(IMenuManager manager) {
        this.fillContextMenu(manager);
    }

    protected void fillContextMenu(IMenuManager menu) {
        Iterator<String> actions = this.fActionRegistry.keySet().iterator();
        while (actions.hasNext()) {
            menu.add((IAction)this.fActionRegistry.get(actions.next()));
        }
    }

    public void rebuildMap() {
        if (this.fRootLayout != null) {
            this.fRootLayout.recreateMap();
        } else {
            this.fErrorOccurred = false;
            this.createMapRoot(this.getMemoryBlock());
        }
    }

    protected MemoryMapLayout createMapRoot(IMemoryBlock memoryBlock) {
        BigInteger rootAddress;
        if (memoryBlock instanceof IMemoryBlockExtension) {
            try {
                rootAddress = ((IMemoryBlockExtension)memoryBlock).getBigBaseAddress();
            }
            catch (DebugException e) {
                rootAddress = BigInteger.valueOf(0L);
                this.handleDebugError(e);
                this.fErrorOccurred = true;
            }
        } else {
            rootAddress = BigInteger.valueOf(memoryBlock.getStartAddress());
        }
        if (rootAddress == null) {
            this.fErrorOccurred = true;
            this.fRootLayout = null;
            return null;
        }
        this.fMapParent = new MemoryMapParent(rootAddress);
        try {
            this.fRootLayout = new RootMapLayout(this, "MAP", 4, 0, this.fMapParent, rootAddress, this.getMemoryBlock(), this.fMappingFile, new HashSet<String>());
        }
        catch (MemoryMapException e) {
            this.fRootLayout = null;
            this.handleMapError(e);
            this.fErrorOccurred = true;
            return null;
        }
        return this.fRootLayout;
    }

    public void becomesHidden() {
        super.becomesHidden();
        this.desynchronizeSelection();
    }

    public void becomesVisible() {
        super.becomesVisible();
        if (this.fErrorOccurred) {
            return;
        }
        IMemoryBlock memoryBlock = this.getMemoryBlock();
        if (!memoryBlock.getDebugTarget().isDisconnected() && !memoryBlock.getDebugTarget().isTerminated()) {
            this.synchronizeSelection();
        }
    }

    public MemoryMapBuilder getMapBuilder(MemoryMap parent, BigInteger startAddress, Node node, int startOffset) {
        return new MemoryMapBuilder(parent, node, startAddress, startOffset);
    }

    protected void fireSelectedAddressesChanged(MemoryMapSelection[] selections) {
        this.firePropertyChangedEvent(new PropertyChangeEvent((Object)this, "memorymapSelections", null, (Object)selections));
        this.firePropertyChangedEvent(new PropertyChangeEvent((Object)this, "selectedAddress", null, (Object)selections[0].getStartAddress()));
    }

    protected void synchronizeSelection() {
        IMemoryRenderingSynchronizationService syncService = this.getMemoryRenderingContainer().getMemoryRenderingSite().getSynchronizationService();
        if (syncService != null && this.fRootLayout != null) {
            BigInteger selectedAddress;
            MemoryMapSelection[] selections = (MemoryMapSelection[])syncService.getProperty(this.getMemoryBlock(), "memorymapSelections");
            if (selections != null) {
                ArrayList<MemoryMapSelection> validSelections = new ArrayList<MemoryMapSelection>();
                int i = 0;
                while (i < selections.length) {
                    if (selections[i].getSynchronizedRenderings().length > 0) {
                        validSelections.add(selections[i]);
                        selections[i].addRendering((IMemoryRendering)this);
                    }
                    ++i;
                }
                if (validSelections.size() > 0) {
                    ArrayList<MapElement> matchingElements = this.fRootLayout.findElementsByAddresses(validSelections.toArray(new MemoryMapSelection[0]));
                    this.fLastSelectedElements = matchingElements;
                    this.updateSelection(matchingElements);
                    return;
                }
            }
            if ((selectedAddress = (BigInteger)syncService.getProperty(this.getMemoryBlock(), "selectedAddress")) != null) {
                MemoryMapSelection[] selection = new MemoryMapSelection[]{new MemoryMapSelection(this, selectedAddress, 1L, false)};
                ArrayList<MapElement> matchingElements = this.fRootLayout.findElementsByAddresses(selection);
                this.updateSelection(matchingElements);
            }
        }
    }

    protected void desynchronizeSelection() {
        MemoryMapSelection[] selections;
        IMemoryRenderingSynchronizationService syncService = this.getMemoryRenderingContainer().getMemoryRenderingSite().getSynchronizationService();
        if (syncService != null && (selections = (MemoryMapSelection[])syncService.getProperty(this.getMemoryBlock(), "memorymapSelections")) != null && selections.length > 0) {
            int i = 0;
            while (i < selections.length) {
                selections[i].removeRendering((IMemoryRendering)this);
                ++i;
            }
        }
    }

    protected boolean isSelected(MemoryMapSelection[] selections) {
        if (this.fLastSelectedElements != null && this.fLastSelectedElements.size() == selections.length) {
            int i = 0;
            while (i < selections.length) {
                boolean containsAddress = false;
                int j = 0;
                while (!containsAddress && j < this.fLastSelectedElements.size()) {
                    MapElement selectedElement = this.fLastSelectedElements.get(j);
                    if (selectedElement.equals(selectedElement.getLayout().getRootElement())) {
                        if (selectedElement.getLayout().isReferenceAddress(selections[i])) {
                            containsAddress = true;
                        }
                    } else if (selectedElement.containsAddress(selections[i]) && !selectedElement.hasChildren()) {
                        containsAddress = true;
                    }
                    ++j;
                }
                if (!containsAddress) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() != this && this.isVisible()) {
            MemoryMapSelection[] values;
            if (event.getProperty().equals("selectedAddress") && event.getNewValue() instanceof BigInteger && !(event.getSource() instanceof MemoryMapRendering)) {
                MemoryMapSelection[] selections;
                values = new MemoryMapSelection[]{new MemoryMapSelection(this, (BigInteger)event.getNewValue(), 1L, false)};
                IMemoryRenderingSynchronizationService syncService = this.getMemoryRenderingContainer().getMemoryRenderingSite().getSynchronizationService();
                if (syncService != null && (selections = (MemoryMapSelection[])syncService.getProperty(this.getMemoryBlock(), "memorymapSelections")) != null) {
                    int i = 0;
                    while (i < selections.length) {
                        selections[i].clearSynchronizedRenderings();
                        ++i;
                    }
                }
                if (this.isSelected(values) || this.fRootLayout == null) {
                    return;
                }
                ArrayList<MapElement> items = this.fRootLayout.findElementsByAddresses(values);
                this.fLastSelectedElements = items;
                this.updateSelection(items);
            }
            if (event.getProperty().equals("memorymapSelections") && event.getNewValue() instanceof MemoryMapSelection[]) {
                values = (MemoryMapSelection[])event.getNewValue();
                int i = 0;
                while (i < values.length) {
                    values[i].addRendering((IMemoryRendering)this);
                    ++i;
                }
                if (this.fRootLayout == null) {
                    return;
                }
                ArrayList<MapElement> items = this.fRootLayout.findElementsByAddresses(values);
                this.fLastSelectedElements = items;
                this.updateSelection(items);
            }
        }
        if ((event.getProperty().equals("org.eclipse.debug.ui.memory.paddedStr") || event.getProperty().equals("org.eclipse.debug.ui.changedDebugElement") || event.getProperty().equals("ERROR_COLOR")) && this.isVisible()) {
            this.refresh();
        }
        if (event.getProperty().equals("org.eclipse.debug.ui.defaultAsciiCodePage")) {
            this.fRenderTool.updateASCIICodePage();
            if (this.isVisible()) {
                this.refresh();
            }
        }
        if (event.getProperty().equals("org.eclipse.debug.ui.defaultEbcdicCodePage")) {
            this.fRenderTool.updateEBCDICCodePage();
            if (this.isVisible()) {
                this.refresh();
            }
        }
    }

    protected void setupSynchronization() {
        IMemoryRenderingSynchronizationService syncService = this.getMemoryRenderingContainer().getMemoryRenderingSite().getSynchronizationService();
        if (syncService != null) {
            syncService.addPropertyChangeListener((IPropertyChangeListener)this, null);
        }
        this.synchronizeSelection();
        DebugUITools.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFacePreferences.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected MemoryMapSelection[] getSelectionsFromItem(Item[] selected) {
        ArrayList<MemoryMapSelection> addresses = new ArrayList<MemoryMapSelection>();
        int i = 0;
        while (i < selected.length) {
            MapElement selectedElement;
            BigInteger address;
            if (selected[i].getData() instanceof MapElement && (address = (selectedElement = (MapElement)selected[i].getData()).getLayout().getRootElement() == selectedElement ? selectedElement.getLayout().getReferenceAddress() : selectedElement.getAddress()) != null && selectedElement instanceof MemoryMap) {
                MemoryMap memoryMap = (MemoryMap)selectedElement;
                if (memoryMap.isMap()) {
                    addresses.add(new MemoryMapSelection(this, address, memoryMap.getLayout().getReferenceLength(), true));
                } else if (memoryMap.isORGParent()) {
                    addresses.add(new MemoryMapSelection(this, address, 1L, true));
                } else if (memoryMap.getParent().isBitmask()) {
                    addresses.add(new MemoryMapSelection(this, address, memoryMap.getLength() / 8, true));
                } else {
                    addresses.add(new MemoryMapSelection(this, address, selectedElement.getLength(), memoryMap.hasChildren()));
                }
            }
            ++i;
        }
        return addresses.toArray(new MemoryMapSelection[0]);
    }

    private void findLayout(List<MemoryMapLayout> layouts, MemoryMapLayout layout, boolean buildLayouts, boolean getUniqueLayouts) throws DebugException {
        layouts.add(layout);
        MapElement element = layout.getRootElement();
        if (element instanceof MemoryMap) {
            MemoryMap map = (MemoryMap)element;
            if (buildLayouts) {
                this.buildLayout(map, map);
            }
        }
        MemoryMapLayout[] childLayouts = layout.getChildLayouts();
        int i = 0;
        while (i < childLayouts.length) {
            boolean addChildLayout = true;
            if (getUniqueLayouts) {
                ListIterator<MemoryMapLayout> layoutIterator = layouts.listIterator();
                while (layoutIterator.hasNext()) {
                    Path childLayoutPath;
                    Path existingLayoutPath = new Path(layoutIterator.next().getMappingFile());
                    if (!existingLayoutPath.equals((Object)(childLayoutPath = new Path(childLayouts[i].getMappingFile())))) continue;
                    addChildLayout = false;
                }
            }
            if (addChildLayout) {
                this.findLayout(layouts, childLayouts[i], buildLayouts, getUniqueLayouts);
            }
            ++i;
        }
    }

    private void buildLayout(MemoryMap rootElement, MemoryMap parent) throws DebugException {
        MapElement[] children = parent.getChildren(true);
        if (parent == rootElement || !parent.isMap()) {
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof MemoryMap) {
                    this.buildLayout(rootElement, (MemoryMap)children[i]);
                }
                ++i;
            }
        }
    }

    public MemoryMapLayout[] getAllLayouts(boolean buildLayouts, boolean getUniqueLayouts) throws DebugException {
        ArrayList<MemoryMapLayout> layouts = new ArrayList<MemoryMapLayout>();
        if (this.fRootLayout != null) {
            this.findLayout(layouts, this.fRootLayout, buildLayouts, getUniqueLayouts);
        }
        return layouts.toArray(new MemoryMapLayout[layouts.size()]);
    }

    private void updateLabelsForErrorPage(MemoryMapException mme) {
        this.fErrorOccurred = true;
        StyledText styleText = this.fMapErrorTextViewer.getTextWidget();
        if (styleText != null) {
            StringBuilder errorMsg = new StringBuilder();
            errorMsg.append(mme.getMappingFile()).append(": \n\n");
            String field = mme.getField();
            if (field.length() != 0) {
                errorMsg.append(mme.getField()).append("\n\n");
            }
            errorMsg.append(mme.getMessage());
            styleText.setText(NLS.bind((String)MemoryMapMessages.MemoryMapTab_Unable_to_create_memory_map, (Object)errorMsg.toString()));
        }
        this.fOpenLayoutButton.setText(NLS.bind((String)MemoryMapLabels.MemoryMapRendering_4, (Object)new File(mme.getMappingFile()).getName()));
        OpenMapFileAction action = (OpenMapFileAction)this.getAction("com.ibm.debug.memorymap.OpenMapFileAction");
        if (action == null) {
            action = new OpenMapFileAction(this.fMappingFile, true);
        }
        action.setLayoutPath(mme.getMappingFile());
        this.fOpenLayoutButton.pack(true);
        if (mme.getType() == 1) {
            this.fButtonComposite.setVisible(true);
            this.fOpenLayoutButton.setVisible(true);
            this.fOpenLayoutButton.setSelection(true);
            this.fRecreateMapButton.setSelection(false);
            this.fIgnoreErrorButton.setVisible(true);
            this.fIgnoreErrorButton.setSelection(false);
        } else if (mme.getType() == 2) {
            this.fButtonComposite.setVisible(true);
            this.fOpenLayoutButton.setVisible(true);
            this.fOpenLayoutButton.setSelection(true);
            this.fRecreateMapButton.setSelection(false);
            this.fIgnoreErrorButton.setVisible(false);
            this.fIgnoreErrorButton.setSelection(false);
        } else if (mme.getType() == 3) {
            this.fButtonComposite.setVisible(false);
        } else {
            this.fIgnoreErrorButton.setSelection(false);
            this.fIgnoreErrorButton.setVisible(false);
        }
        if (this.getPopupMenuManager() == null) {
            this.createPopupMenu((Control)this.fMapErrorComposite);
        }
        if (styleText != null) {
            styleText.setMenu(this.getPopupMenuManager().createContextMenu((Control)styleText));
        }
    }

    protected Control createDebugErrorPage(DebugException e, Composite parent) {
        StyledText styleText;
        if (this.fDebugErrorTextViewer == null) {
            this.fDebugErrorTextViewer = new TextViewer(parent, 2880);
            this.fDebugErrorTextViewer.setDocument((IDocument)new Document());
            styleText = this.fDebugErrorTextViewer.getTextWidget();
            styleText.setEditable(false);
            styleText.setEnabled(true);
        }
        this.fErrorOccurred = true;
        styleText = this.fDebugErrorTextViewer.getTextWidget();
        if (styleText != null) {
            styleText.setText(NLS.bind((String)MemoryMapMessages.MemoryMapTab_Unable_to_create_memory_map, (Object)e.getMessage()));
        }
        if (this.getPopupMenuManager() == null) {
            this.createPopupMenu(this.fDebugErrorTextViewer.getControl());
        }
        if (styleText != null) {
            styleText.setMenu(this.getPopupMenuManager().createContextMenu((Control)styleText));
        }
        return this.fDebugErrorTextViewer.getControl();
    }

    protected Composite createMapErrorPage(MemoryMapException mme, Composite parent) {
        if (this.fMapErrorComposite == null) {
            StyledText styleText = null;
            this.fMapErrorComposite = new Composite(parent, 0);
            this.fMapErrorComposite.setLayout((Layout)new FillLayout(512));
            this.fMapErrorTextViewer = new TextViewer(this.fMapErrorComposite, 2880);
            this.fMapErrorTextViewer.setDocument((IDocument)new Document());
            styleText = this.fMapErrorTextViewer.getTextWidget();
            styleText.setEditable(false);
            styleText.setEnabled(true);
            this.fButtonComposite = new ScrolledComposite(this.fMapErrorComposite, 768);
            Composite wrapper = new Composite(this.fButtonComposite, 0);
            wrapper.setBackground(this.fButtonComposite.getBackground());
            this.fOpenLayoutButton = new Button(wrapper, 16);
            this.fRecreateMapButton = new Button(wrapper, 16);
            this.fRecreateMapButton.setText(MemoryMapLabels.MemoryMapRendering_5);
            this.fIgnoreErrorButton = new Button(wrapper, 16);
            this.fIgnoreErrorButton.setText(MemoryMapLabels.MemoryMapRendering_0);
            this.fConfirmButton = new Button(wrapper, 0);
            this.fConfirmButton.setText(MemoryMapLabels.MemoryMapRendering_3);
            this.fConfirmButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (AbstractMemoryMapRendering.this.fOpenLayoutButton.getSelection()) {
                        Action openFileAction = AbstractMemoryMapRendering.this.getAction("com.ibm.debug.memorymap.OpenMapFileAction");
                        if (openFileAction != null) {
                            openFileAction.run();
                        }
                        AbstractMemoryMapRendering.this.fOpenLayoutButton.setSelection(false);
                        AbstractMemoryMapRendering.this.fRecreateMapButton.setSelection(true);
                    } else if (AbstractMemoryMapRendering.this.fIgnoreErrorButton.getSelection()) {
                        AbstractMemoryMapRendering.this.retrieveGroupingInfo(false);
                        AbstractMemoryMapRendering.this.rebuildMap();
                    } else if (AbstractMemoryMapRendering.this.fRecreateMapButton.getSelection()) {
                        AbstractMemoryMapRendering.this.rebuildMap();
                    }
                }
            });
            wrapper.setLayout((Layout)new GridLayout(1, true));
            wrapper.setSize(wrapper.computeSize(-1, -1));
            ((ScrolledComposite)this.fButtonComposite).setContent((Control)wrapper);
        }
        this.updateLabelsForErrorPage(mme);
        return this.fMapErrorComposite;
    }

    protected class RootMapLayout
    extends MemoryMapLayout {
        public RootMapLayout(AbstractMemoryMapRendering rendering, String layoutType, int layoutLength, int offset, MapElement parent, BigInteger address, IMemoryBlock memoryBlock, String mappingFile, Set<String> groups) throws MemoryMapException {
            super(rendering, layoutType, layoutLength, offset, parent, address, memoryBlock, mappingFile, groups);
        }

        private void recreateMap() {
            AbstractMemoryMapRendering.this.fErrorOccurred = false;
            this.fChildLayouts.clear();
            AbstractMemoryMapRendering.this.fMapParent.fChildren = new ArrayList();
            try {
                int oldLength = this.fLength;
                this.createRootElement(this.fLength, 0, this.getRootElement().getParent(), new TreeSet<String>(), new File(this.fMappingFile));
                if (oldLength != this.fLength) {
                    this.partitionMemoryBlock();
                }
            }
            catch (MemoryMapException e) {
                this.fRendering.handleMapError(e);
                AbstractMemoryMapRendering.this.fErrorOccurred = true;
            }
        }
    }
}

