/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lpex.jcl;

import com.ibm.lpex.core.LpexAction;
import com.ibm.lpex.core.LpexCommonParser;
import com.ibm.lpex.core.LpexDocumentLocation;
import com.ibm.lpex.core.LpexNls;
import com.ibm.lpex.core.LpexPaletteAttributes;
import com.ibm.lpex.core.LpexResources;
import com.ibm.lpex.core.LpexStringTokenizer;
import com.ibm.lpex.core.LpexView;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class JclParser
extends LpexCommonParser {
    private static final String COPYRIGHT = " Licensed Materials - Property of IBM. LPEX Editor. \ufffd Copyright IBM Corp. 1998, 2012  All rights reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ResourceBundle _profile = ResourceBundle.getBundle("com.ibm.lpex.jcl.Profile");
    private static ResourceBundle _resources = ResourceBundle.getBundle("com.ibm.lpex.jcl.resources");
    String[] _taskTags;
    public static final int OPTION_JES2 = 1;
    public static final int OPTION_JES3 = 2;
    public static final int OPTION_ESA = 4;
    public static final int OPTION_XA = 8;
    private static final String[] NATs = new String[]{"Cp273", "$#\u00c2\u00a7", "Cp277", "\u00c3\u2026\u00c3\u2020\u00c3\u02dc", "Cp278", "\u00c3\u2026\u00c3\u201e\u00c3\u2013", "Cp280", "$\u00c2\u00a3\u00c2\u00a7", "Cp284", "$\u00c3\u2018@", "Cp285", "\u00c2\u00a3#@", "Cp297", "$\u00c2\u00a3\u00c3\u00a0", "Cp871", "$#\u00c3\ufffd", "Cp930", "\u00c2\u00a5#@", "Cp935", "\u00c2\u00a5#@", "Cp1141", "$#\u00c2\u00a7", "Cp1142", "\u00c3\u2026\u00c3\u2020\u00c3\u02dc", "Cp1143", "\u00c3\u2026\u00c3\u201e\u00c3\u2013", "Cp1144", "$\u00c2\u00a3\u00c2\u00a7", "Cp1145", "$\u00c3\u2018@", "Cp1146", "\u00c2\u00a3#@", "Cp1147", "$\u00c2\u00a3\u00c3\u00a0", "Cp1149", "$#\u00c3\ufffd", "Cp1390", "\u00c2\u00a5#@", "Cp1388", "\u00c2\u00a5#@"};
    private static final HashMap<String, String> NATIONALS = new HashMap(NATs.length);
    private String NATIONAL;
    private static final String CLASS_JCL = "jcl";
    private static final String CLASS_COMMENT = "comment";
    private static final String CLASS_COMMENTTASK = "commentTask";
    private static final String CLASS_COMMAND = "command";
    private static final String CLASS_CONTROL = "control";
    private static final String CLASS_JOB = "job";
    private static final String CLASS_EXEC = "exec";
    private static final String CLASS_DD = "dd";
    private static final String CLASS_DLM = "dlm";
    private static final String CLASS_NULL = "null";
    private static final String CLASS_PROC = "proc";
    private static final String CLASS_PEND = "pend";
    private static final String CLASS_OUTPUT = "output";
    private static final String CLASS_JES2 = "jes2";
    private static final String CLASS_JES3 = "jes3";
    private static final String CLASS_XMIT = "xmit";
    private static final String CLASS_CNTL = "cntl";
    private static final String CLASS_ENDCNTL = "endcntl";
    private static final String CLASS_INSTREAM = "instream";
    private static final String CLASS_FWDLINK = "fwdLink";
    private static final String CLASS_BWDLINK = "bwdLink";
    private static final String CLASS_ERROR = "error";
    private static final String CLASS_LIB = "lib";
    private static final String CLASS_COND = "cond";
    private static final String CLASS_SPLIT = "split";
    private long classJcl;
    private long classComment;
    private long classCommentTask;
    private long classCommand;
    private long classControl;
    private long classJob;
    private long classExec;
    private long classDd;
    private long classDlm;
    private long classNull;
    private long classProc;
    private long classPend;
    private long classOutput;
    private long classJes2;
    private long classJes3;
    private long classXmit;
    private long classCntl;
    private long classEndcntl;
    private long classInstream;
    private long classFwdlink;
    private long classBwdlink;
    private long classError;
    private long classLib;
    private long classCond;
    private long classSplit;
    private long classAll;
    private static final char STYLE_COMMENT = 'c';
    private static final char STYLE_COMMENTTASK = '$';
    private static final char STYLE_JOBNAME = 'j';
    private static final char STYLE_STEPNAME = 's';
    private static final char STYLE_PROCNAME = 'r';
    private static final char STYLE_PROCSTEPNAME = 'p';
    private static final char STYLE_DDNAME = 'd';
    private static final char STYLE_OPERATION = 'o';
    private static final char STYLE_KEYWORD = 'k';
    private static final char STYLE_SUBKEYWORD = 'b';
    private static final char STYLE_KEYWORDSYM = 'y';
    private static final char STYLE_SYMBOLIC = 'x';
    private static final char STYLE_VALUE = 'v';
    private static final char STYLE_INSTREAM = 'i';
    private static final char STYLE_COMMAND = 'n';
    private static final char STYLE_CONTROL = 'l';
    private static final char STYLE_QUOTEDSTRING = 'q';
    private static final char STYLE_DELIMITER = '*';
    private static final char STYLE_LEFTPAREN = '(';
    private static final char STYLE_RIGHTPAREN = ')';
    private static final char STYLE_COMMA = ',';
    private static final char STYLE_EQUALSIGN = '=';
    private static final char STYLE_PERIOD = '.';
    private char STYLE_ERROR = (char)101;
    private static final String JCL_BASICSTYLE = "//______________________________________________________________________zzzzzzzz";
    private static final String DEFAULT_DLM = "/*";
    private static final int DDKEY_STAR = 1;
    private static final int DDKEY_DATA = 2;
    private static final int DDKEY_DUMMY = 3;
    private static final int DDKEY_DYNAM = 4;
    private static final int DDKEY_DISP = 5;
    private static final int DDKEY_DSN = 6;
    private static final int DDKEY_DSNAME = 7;
    private static final int DDKEY_LIKE = 8;
    private static final int DDKEY_SYSOUT = 9;
    private static final int DDKEY_UNIT = 10;
    private static final int DDKEY_VOL = 11;
    private static final int DDKEY_VOLUME = 12;
    private static final int DDKEY_SPACE = 13;
    private static final int DDKEY_DDNAME = 14;
    private static final int DDKEY_LABEL = 15;
    private static final int DDKEY_EXPDT = 16;
    private static final int DDKEY_RETPD = 17;
    private static final int DDKEY_DLM = 18;
    private static final int DDKEY_DCB = 19;
    private static final int DDKEY_LRECL = 20;
    private static final int DDKEY_BLKSIZE = 21;
    private static final int DDKEY_BUFL = 22;
    private static final int DDKEY_RECFM = 23;
    private static final int DDKEY_DSORG = 24;
    private static final int DDKEY_TERM = 25;
    private static final int DDKEY_ACCODE = 26;
    private static final int DDKEY_AVGREC = 27;
    private static final int DDKEY_BURST = 28;
    private static final int DDKEY_CHARS = 29;
    private static final int DDKEY_CHKPT = 30;
    private static final int DDKEY_CNTL = 31;
    private static final int DDKEY_OUTPUT = 32;
    private static final int DDKEY_REFDD = 33;
    private static final int DDKEY_DATACLAS = 34;
    private static final int DDKEY_MGMTCLAS = 35;
    private static final int DDKEY_STORCLAS = 36;
    private static final int DDKEY_DSID = 37;
    private static final int DDKEY_FCB = 38;
    private static final int DDKEY_FLASH = 39;
    private static final int DDKEY_FREE = 40;
    private static final int DDKEY_HOLD = 41;
    private static final int DDKEY_MODIFY = 42;
    private static final int DDKEY_MSVGP = 43;
    private static final int DDKEY_OUTLIM = 44;
    private static final int DDKEY_BUFIN = 45;
    private static final int DDKEY_INTVL = 46;
    private static final int DDKEY_LIMCT = 47;
    private static final int DDKEY_NTM = 48;
    private static final int DDKEY_PROTECT = 49;
    private static final int DDKEY_RECORG = 50;
    private static final int DDKEY_SUBSYS = 51;
    private static final int DDKEY_UCS = 52;
    private static final int DDKEY_BFALN = 53;
    private static final int DDKEY_BFTEK = 54;
    private static final int DDKEY_CPRI = 55;
    private static final int DDKEY_DEN = 56;
    private static final int DDKEY_PRTSP = 57;
    private static final int DDKEY_DIAGNS = 58;
    private static final int DDKEY_BUFMAX = 59;
    private static final int DDKEY_BUFNO = 60;
    private static final int DDKEY_GNCP = 61;
    private static final int DDKEY_BUFOUT = 62;
    private static final int DDKEY_BUFOFF = 63;
    private static final int DDKEY_BUFSIZE = 64;
    private static final int DDKEY_CYLOFL = 65;
    private static final int DDKEY_EROPT = 66;
    private static final int DDKEY_FUNC = 67;
    private static final int DDKEY_IPLTXID = 68;
    private static final int DDKEY_MODE = 69;
    private static final int DDKEY_NCP = 70;
    private static final int DDKEY_OPTCD = 71;
    private static final int DDKEY_PCI = 72;
    private static final int DDKEY_RESERVE = 73;
    private static final int DDKEY_KEYLEN = 74;
    private static final int DDKEY_RKP = 75;
    private static final int DDKEY_KEYOFF = 76;
    private static final int DDKEY_STACK = 77;
    private static final int DDKEY_THRESH = 78;
    private static final int DDKEY_TRTCH = 79;
    private static final int DDKEY_DEST = 80;
    private static final int DDKEY_QNAME = 81;
    private static final int DDKEY_SECMODEL = 82;
    private static final int DDKEY_AMP = 83;
    private static final int DDKEY_COPIES = 84;
    private static final int DDKEY_SEGMENT = 85;
    private static final int DDKEY_SPIN = 86;
    private static final int DDKEY_PATH = 87;
    private static final int DDKEY_PATHDISP = 88;
    private static final int DDKEY_PATHMODE = 89;
    private static final int DDKEY_PATHOPTS = 90;
    private static final int DDKEY_DSNTYPE = 91;
    private static final int DDKEY_FILEDATA = 92;
    private static final int DDKEY_LGSTREAM = 93;
    private static final int DDKEY_RLS = 94;
    private static final String[] DDKeyTable = new String[]{"*", "DATA", "DUMMY", "DYNAM", "DISP", "DSN", "DSNAME", "LIKE", "SYSOUT", "UNIT", "VOL", "VOLUME", "SPACE", "DDNAME", "LABEL", "EXPDT", "RETPD", "DLM", "DCB", "LRECL", "BLKSIZE", "BUFL", "RECFM", "DSORG", "TERM", "ACCODE", "AVGREC", "BURST", "CHARS", "CHKPT", "CNTL", "OUTPUT", "REFDD", "DATACLAS", "MGMTCLAS", "STORCLAS", "DSID", "FCB", "FLASH", "FREE", "HOLD", "MODIFY", "MSVGP", "OUTLIM", "BUFIN", "INTVL", "LIMCT", "NTM", "PROTECT", "RECORG", "SUBSYS", "UCS", "BFALN", "BFTEK", "CPRI", "DEN", "PRTSP", "DIAGNS", "BUFMAX", "BUFNO", "GNCP", "BUFOUT", "BUFOFF", "BUFSIZE", "CYLOFL", "EROPT", "FUNC", "IPLTXID", "MODE", "NCP", "OPTCD", "PCI", "RESERVE", "KEYLEN", "RKP", "KEYOFF", "STACK", "THRESH", "TRTCH", "DEST", "QNAME", "SECMODEL", "AMP", "COPIES", "SEGMENT", "SPIN", "PATH", "PATHDISP", "PATHMODE", "PATHOPTS", "DSNTYPE", "FILEDATA", "LGSTREAM", "RLS"};
    private static final String keytbl = "         *        AMP      BURST    CHARS    CHKPT    COPIES   DATA     DCB      DDNAME   DEST     DISP     DLM      DSID     DSNAME   DUMMY    DYNAM    FCB      FLASH    FREE     HOLD     LABEL    MODIFY   MSVGP    OUTLIM   OUTPUT   PROTECT  QNAME    SPACE    SUBSYS   SYSOUT   TERM     UCS      UNIT     VOLUME   ACCODE   CNTL     AVGREC   DATACLAS EXPDT    KEYLEN   KEYOFF   LIKE     LRECL    MGMTCLAS RECFM    RECORG   REFDD    RETPD    SECMODEL STORCLAS BFALN    BFTEK    BLKSIZE  BUFIN    BUFL     BUFMAX   BUFNO    BUFOFF   BUFOUT   BUFSIZE  CPRI     CYLOFL   DEN      DIAGNS   DSORG    EROPT    FUNC     GNCP     INTVL    IPLTXID  LIMCT    MODE     NCP      NTM      OPTCD    PCI      PRTSP    RESERVE  RKP      STACK    THRESH   TRTCH    SEGMENT  SPIN     PATH     PATHDISP PATHMODE PATHOPTS DSNTYPE  FILEDATA LGSTREAM RLS      ";
    private static final String lvl_mask = " S S F S SS S   SS  SSS S  FSS SFF                                         F F       SSS        ";
    private static final String mxp_mask = " 6 5 2 6 23 2   22  522 6  563 335                                         2 2       266        ";
    private int card;
    private static final int CARD_NONE = 0;
    private static final int CARD_FIRST = 1;
    private static final int CARD_PROC = 2;
    private static final int CARD_DATA = 4;
    private static final int CARD_JES3 = 8;
    private static final int CARD_LAST = 16;
    private static final int CARD_FINAL = 32;
    private static final int CARD_SPLIT = 64;
    private boolean fEjes2;
    private boolean fEjes3;
    private boolean fEesa;
    private boolean fExa;
    private String data_dlm;
    private long ulEClass;
    private long ulEClassAfterLast;
    private String oper;
    private int oper_offset;
    private int _currentElement;
    private StringBuilder Etxt = new StringBuilder();
    private String lotxt;
    private StringBuilder _currentStyle;
    private int Etxtl;
    private String name;
    private int cur_offset;
    private int value_offset;
    private int parm_key_offset;
    private int sub_key_offset;
    private String parm_key;
    private String sub_key;
    private String value;
    private int parm_num;
    private int sub_num;
    private int field_num;
    private boolean Esub_p;
    private boolean field_p;
    private boolean symbolic;
    private boolean insideQuotedString;
    private boolean endOfSubparameters;
    private boolean endOfFields;
    private boolean endOfCard;
    private char Estream_type;
    private String key_list;
    private int Ekey_num;
    private boolean _initialTotalParseDone;
    private static final String exec_key_limit1 = "ADDRSPC CCSID DYNAMNBR MEMLIMIT PERFORM RD REGION RLSTMOUT";
    private static final String exec_key_limit2 = "TIME DPRTY";

    public JclParser(LpexView lpexView) {
        super(lpexView);
        if (NATIONALS.isEmpty()) {
            int i = 0;
            while (i < NATs.length) {
                NATIONALS.put(NATs[i], NATs[i + 1]);
                i += 2;
            }
        }
    }

    protected void initParser() {
        int options;
        String tabs;
        String formatLineText = this.getProperty("view.formatLineText");
        if (formatLineText != null && formatLineText.length() > 0) {
            this.view.doCommand("set formatLineText " + formatLineText);
        }
        if ((tabs = this.getProperty("view.tabs")) != null) {
            this.view.doCommand("set tabs " + tabs);
        }
        this.setStyleAttributes();
        this.classJcl = this.view.registerClass(CLASS_JCL);
        this.classComment = this.view.registerClass(CLASS_COMMENT);
        this.classCommentTask = this.view.registerClass(CLASS_COMMENTTASK);
        this.classCommand = this.view.registerClass(CLASS_COMMAND);
        this.classControl = this.view.registerClass(CLASS_CONTROL);
        this.classJob = this.view.registerClass(CLASS_JOB);
        this.classExec = this.view.registerClass(CLASS_EXEC);
        this.classDd = this.view.registerClass(CLASS_DD);
        this.classDlm = this.view.registerClass(CLASS_DLM);
        this.classNull = this.view.registerClass(CLASS_NULL);
        this.classProc = this.view.registerClass(CLASS_PROC);
        this.classPend = this.view.registerClass(CLASS_PEND);
        this.classOutput = this.view.registerClass(CLASS_OUTPUT);
        this.classJes2 = this.view.registerClass(CLASS_JES2);
        this.classJes3 = this.view.registerClass(CLASS_JES3);
        this.classXmit = this.view.registerClass(CLASS_XMIT);
        this.classCntl = this.view.registerClass(CLASS_CNTL);
        this.classEndcntl = this.view.registerClass(CLASS_ENDCNTL);
        this.classInstream = this.view.registerClass(CLASS_INSTREAM);
        this.classFwdlink = this.view.registerClass(CLASS_FWDLINK);
        this.classBwdlink = this.view.registerClass(CLASS_BWDLINK);
        this.classError = this.view.registerClass(CLASS_ERROR);
        this.classLib = this.view.registerClass(CLASS_LIB);
        this.classCond = this.view.registerClass(CLASS_COND);
        this.classSplit = this.view.registerClass(CLASS_SPLIT);
        this.classAll = this.classJcl | this.classComment | this.classCommentTask | this.classCommand | this.classControl | this.classJob | this.classExec | this.classDd | this.classDlm | this.classNull | this.classProc | this.classPend | this.classOutput | this.classJes2 | this.classJes3 | this.classXmit | this.classCntl | this.classEndcntl | this.classInstream | this.classFwdlink | this.classBwdlink | this.classError | this.classLib | this.classCond | this.classSplit;
        this.defineActions();
        this._taskTags = LpexStringTokenizer.split((String)this.getProperty("view.taskTags"));
        if (this._taskTags.length == 0) {
            this._taskTags = null;
        }
        this.fEjes2 = ((options = this.getJclOptions()) & 1) != 0;
        this.fEjes3 = (options & 2) != 0;
        this.fEesa = (options & 4) != 0;
        boolean bl = this.fExa = (options & 8) != 0;
        if (!this.fEjes2 && !this.fEjes3 || this.fEjes2 && this.fEjes3) {
            this.fEjes3 = true;
            this.fEjes2 = false;
        }
        if (!this.fEesa && !this.fExa || this.fEesa && this.fExa) {
            this.fEesa = true;
            this.fExa = false;
        }
        this.updateResources();
    }

    private void updateResources() {
        Enumeration<String> e = _resources.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String storeKey = key;
            if (storeKey.startsWith(String.valueOf(this.getLanguage()) + ".")) {
                storeKey = storeKey.substring(this.getLanguage().length() + 1);
            }
            this.setProperty(storeKey, _resources.getString(key));
        }
    }

    private void defineActions() {
        this.defineFilterAction("jobs", CLASS_JOB);
        if (!this.view.keyAssigned("c-g.t")) {
            this.view.doDefaultCommand("set keyAction.c-g.t jobs");
        }
        if (!this.view.keyAssigned("c-g.p")) {
            this.view.doDefaultCommand("set keyAction.c-g.p jobs");
        }
        if (!this.view.keyAssigned("c-g.c")) {
            this.view.doDefaultCommand("set keyAction.c-g.c jobs");
        }
        this.defineFilterAction("execs", CLASS_EXEC);
        this.defineFilterAction("dds", CLASS_DD);
        this.defineFilterAction("procs", CLASS_PROC);
        this.defineFilterAction("errors", "error Message");
        this.defineFilterAction("tasks", CLASS_COMMENTTASK);
        this.view.defineAction("contextHome", new LpexAction(){

            public void doAction(LpexView v) {
                int i = JclParser.this.contextStartPosition(v);
                if (i > 0) {
                    int targetPosition = v.currentPosition() == i ? 1 : i;
                    v.doCommand("set inPrefix off");
                    if (targetPosition == 1) {
                        v.doAction(119);
                    } else {
                        v.doCommand("set scroll 0");
                        v.jump(v.currentElement(), targetPosition);
                    }
                }
            }

            public boolean available(LpexView v) {
                return v.defaultActionAvailable(82);
            }
        });
    }

    public ResourceBundle getProfile() {
        return _profile;
    }

    public String getLanguage() {
        return "JCL";
    }

    public int getJclOptions() {
        return 6;
    }

    protected void propertySet(String key) {
        if ("taskTags".equals(key)) {
            this._taskTags = LpexStringTokenizer.split((String)this.getProperty("view.taskTags"));
            if (this._taskTags.length == 0) {
                this._taskTags = null;
            }
            this.parseAll();
        }
    }

    private int contextStartPosition(LpexView v) {
        int element = v.currentElement();
        String text = v.elementText(element);
        if (text == null) {
            return 0;
        }
        int i = 0;
        int goodStart = 0;
        String style = v.elementStyle(element);
        if (style.startsWith("//")) {
            i = 2;
        } else if (text.startsWith("//*") && style.startsWith("ccc")) {
            i = 3;
            goodStart = 4;
        }
        while (i < text.length() && (text.charAt(i) == ' ' || text.charAt(i) == '\t')) {
            ++i;
        }
        if (goodStart != 0 && text.startsWith("*", i) && i - goodStart > 20) {
            i = goodStart;
        }
        return i + 1;
    }

    protected String getPopupItems(int popupLocation) {
        switch (popupLocation) {
            case 1: {
                return String.valueOf(this.getPopupItem("JCL.popup.jobs")) + " jobs " + this.getPopupItem("JCL.popup.execs") + " execs " + this.getPopupItem("JCL.popup.dds") + " dds " + this.getPopupItem("JCL.popup.procs") + " procs " + "popup.errors" + " errors separator " + "popup.tasks" + " tasks";
            }
        }
        return null;
    }

    protected String getPopupItem(String key) {
        StringBuilder item = new StringBuilder();
        String value = key;
        if (_resources.containsKey(value)) {
            value = _resources.getString(value);
        }
        item.append('\"');
        item.append(value);
        item.append('\"');
        return item.toString();
    }

    public void setStyleAttributes() {
        String toBground = LpexPaletteAttributes.background((LpexView)this.lpexView());
        this.setStyle("_iz*(),=.jsrpd", LpexPaletteAttributes.convert((String)this.ATTRIBUTES_DEFAULT, (String)"255 255 255", (String)toBground));
        this.setStyle("c", LpexPaletteAttributes.convert((String)"0 112 112 255 255 255", (String)"255 255 255", (String)toBground));
        this.setStyle("$", LpexPaletteAttributes.convert((String)"0 160 160 255 255 255", (String)"255 255 255", (String)toBground));
        String parseAfterEveryKey = this.getProperty("view.parseAfterEveryKey");
        boolean discreet = "on".equals(parseAfterEveryKey) || "bidi".equals(parseAfterEveryKey) && LpexNls.isBidi();
        this.setStyle("e", LpexPaletteAttributes.convert((String)(discreet ? "0 0 170 255 255 255 255 0 0 squiggle" : "-1 -1 -1 255 255 255 255 0 0 squiggle"), (String)"255 255 255", (String)toBground));
        this.setStyle("kby", LpexPaletteAttributes.convert((String)"0 0 255 255 255 255", (String)"255 255 255", (String)toBground));
        this.setStyle("q", LpexPaletteAttributes.convert((String)"128 0 128 255 255 255", (String)"255 255 255", (String)toBground));
        this.setStyle("/", LpexPaletteAttributes.convert((String)"192 192 192 255 255 255", (String)"255 255 255", (String)toBground));
        this.setStyle("on", LpexPaletteAttributes.convert((String)"128 0 0 255 255 255", (String)"255 255 255", (String)toBground));
        this.setStyle("xv", LpexPaletteAttributes.convert((String)"0 0 0 255 255 255", (String)"255 255 255", (String)toBground));
        this.setStyle("l", LpexPaletteAttributes.convert((String)"128 0 128 255 255 255", (String)"255 255 255", (String)toBground));
    }

    public String getCommentStyleCharacters() {
        return "c$";
    }

    public void parseAll() {
        this.ulEClassAfterLast = 0L;
        this.ulEClass = 0L;
        this.doParse(1, this.view.elements(), this._initialTotalParseDone);
        this._initialTotalParseDone = true;
    }

    public void parseElement(int element) {
        int Start = this.evaluateBeginElement(element);
        int End = this.evaluateEndElement(element);
        this.doParse(Start, End, true);
    }

    private int evaluateBeginElement(int elem) {
        if (elem > 1) {
            --elem;
        }
        while (elem > 1 && this.view.show(elem)) {
            --elem;
        }
        long classes = this.view.elementClasses(elem);
        while (elem > 1) {
            int tryElem = elem - 1;
            while (tryElem > 1 && this.view.show(tryElem)) {
                --tryElem;
            }
            long tryClasses = this.view.elementClasses(tryElem);
            if ((classes & this.classBwdlink) == 0L && (tryClasses & (this.classInstream | this.classFwdlink)) == 0L) {
                this.ulEClass = tryClasses;
                break;
            }
            classes = tryClasses;
            elem = tryElem;
        }
        if (elem == 1) {
            this.ulEClass = 0L;
        }
        return elem;
    }

    private int evaluateEndElement(int element) {
        this.ulEClassAfterLast = 0L;
        int elements = this.view.elements();
        int endElem = element;
        while (endElem < elements) {
            long classes = this.view.elementClasses(endElem);
            if ((classes & this.classFwdlink) == 0L && !this.view.show(endElem + 1) && (this.view.parsePending(endElem + 1) & 1) == 0 && (this.view.elementClasses(endElem + 1) & (this.classInstream | this.classBwdlink)) == 0L) {
                this.ulEClassAfterLast = classes;
                break;
            }
            ++endElem;
        }
        return endElem;
    }

    private void initializeNATIONAL() {
        this.NATIONAL = NATIONALS.get(this.view.nls().getSourceEncoding());
        if (this.NATIONAL == null) {
            this.NATIONAL = "$#@";
        }
    }

    private void doParse(int Start, int End, boolean removeMessages) {
        this.initializeNATIONAL();
        this.STYLE_ERROR = (char)("off".equals(this.getProperty("view.useErrorStyle")) ? 95 : 101);
        int hNext = 1;
        if (removeMessages) {
            this.removeMessages(Start, End);
        }
        this._currentElement = Start;
        int EEndLine = End;
        this.data_dlm = DEFAULT_DLM;
        this.Ekey_num = 0;
        this.card = 0;
        do {
            if (!this.view.show(this._currentElement)) {
                this.card |= 0x11;
                this.card &= 0xFFFFFFB1;
                this.value_offset = 0;
                this.sub_key_offset = 0;
                this.parm_key_offset = 0;
                this.oper_offset = 0;
                if ((this.ulEClass & this.classFwdlink) != 0L) {
                    this.card &= 0xFFFFFFFE;
                    if ((this.ulEClass & this.classJes3) != 0L) {
                        this.card |= 8;
                    }
                    if ((this.ulEClass & this.classSplit) != 0L) {
                        this.card |= 0x40;
                    }
                }
                if ((this.ulEClass & this.classProc) != 0L && (this.ulEClass & this.classPend) == 0L) {
                    this.card |= 2;
                }
                if ((this.ulEClass & this.classInstream) != 0L) {
                    this.card |= 4;
                }
                this.ulEClass = 0L;
                if ((this.card & 1) != 0) {
                    this.field_num = 0;
                    this.sub_num = 0;
                    this.parm_num = 0;
                    this.symbolic = false;
                    this.field_p = false;
                    this.Esub_p = false;
                    this.insideQuotedString = false;
                    this.endOfFields = false;
                    this.endOfSubparameters = false;
                    this.endOfCard = false;
                }
                String pLine = this.view.elementText(this._currentElement);
                this.Etxtl = pLine.length();
                this.Etxt.setLength(80);
                int i = 0;
                while (i < pLine.length() && i < 80) {
                    this.Etxt.setCharAt(i, pLine.charAt(i));
                    ++i;
                }
                while (i < 80) {
                    this.Etxt.setCharAt(i, ' ');
                    ++i;
                }
                this._currentStyle = new StringBuilder(JCL_BASICSTYLE);
                i = 71;
                while (i < 80) {
                    this.Etxt.setCharAt(i, ' ');
                    ++i;
                }
                if (this.empty(this.Etxt.toString()) && (this.card & 4) == 0) {
                    this.Etxt.setCharAt(0, '/');
                    this.Etxt.setCharAt(1, '/');
                }
                this.lotxt = this.Etxt.toString();
                this.name = this.Etxt.charAt(2) == ' ' ? "" : this.extractToken(this.Etxt.substring(2));
                this.parseCard();
                boolean inQuote = false;
                while (this.cur_offset < 80) {
                    if (this.Etxt.charAt(this.cur_offset) == '\'') {
                        inQuote = !inQuote;
                        this._currentStyle.setCharAt(this.cur_offset, 'q');
                    } else if (inQuote) {
                        this._currentStyle.setCharAt(this.cur_offset, 'q');
                    }
                    ++this.cur_offset;
                }
                if ((this.card & 2) != 0) {
                    this.ulEClass |= this.classProc;
                }
                this.view.setElementStyle(this._currentElement, this.Etxtl <= 80 ? this._currentStyle.substring(0, this.Etxtl) : this._currentStyle.toString());
                if ((this.card & 1) == 0) {
                    this.ulEClass |= this.classBwdlink;
                }
                if ((this.card & 0x10) == 0) {
                    this.ulEClass |= this.classFwdlink;
                }
                if (this.insideQuotedString) {
                    this.ulEClass |= this.classSplit;
                }
                this.view.setElementClasses(this._currentElement, this.view.elementClasses(this._currentElement) & (this.classAll ^ 0xFFFFFFFFFFFFFFFFL) | this.ulEClass);
                if ((this.card & 0x10) != 0) {
                    this.card = (this.card & 0x20) != 0 ? (this.card &= 0xFFFFFFDF) : (this.card |= 0x20);
                }
            }
            if (this._currentElement == EEndLine) {
                boolean fLaterPROC;
                boolean fExpectedPROC = (this.card & 2) != 0 && (this.ulEClass & this.classPend) == 0L;
                boolean bl = fLaterPROC = (this.ulEClassAfterLast & this.classProc) != 0L;
                if (((this.card & 0x10) == 0 || (this.card & 4) != 0 || (this.card & 0x20) != 0 || fExpectedPROC != fLaterPROC) && (hNext = EEndLine + 1) <= this.view.elements()) {
                    int hNext1 = hNext;
                    hNext = this.evaluateEndElement(hNext1);
                    this.removeMessages(hNext1, hNext);
                    EEndLine = hNext;
                }
            }
            if (this._currentElement == EEndLine) continue;
            hNext = this._currentElement + 1;
        } while (this._currentElement != EEndLine && (this._currentElement = hNext) <= this.view.elements());
    }

    private boolean parseCard() {
        String jcl_id = this.lotxt.substring(0, 2);
        if ((this.card & 4) != 0) {
            if (jcl_id.equals(this.data_dlm) && (this.fEjes3 || this.Etxt.charAt(2) == ' ')) {
                return this.dlm_proc();
            }
            if (!jcl_id.equals("//") || this.Estream_type == 'D' || this.fEjes3 && !this.data_dlm.equals(DEFAULT_DLM)) {
                return this.instream_proc();
            }
        }
        if (this.fEjes2 && jcl_id.equals(DEFAULT_DLM) && (this.card & 1) != 0) {
            return this.jes2_proc();
        }
        if (this.fEjes3 && jcl_id.equals(DEFAULT_DLM) && (this.card & 1) != 0) {
            if (!this.jes3_proc()) {
                return true;
            }
        } else if (this.Etxt.toString().startsWith("//*")) {
            if (this.fEjes3 && ((this.card & 1) != 0 || (this.card & 8) != 0) && !this.jes3_proc()) {
                return true;
            }
            return this.comment_proc();
        }
        if (!jcl_id.equals("//")) {
            int i = 0;
            while (i < 72) {
                this._currentStyle.setCharAt(i, '!');
                ++i;
            }
            if ((this.card & 1) == 0) {
                return this.setError(1, 80, "CONTEXPECTED");
            }
            this.Estream_type = (char)42;
            this.data_dlm = DEFAULT_DLM;
            return this.instream_proc();
        }
        this.ulEClass |= this.classJcl;
        this.cur_offset = 3;
        if ((this.card & 1) != 0) {
            if (this.Etxt.toString().startsWith("//") && this.empty(this.Etxt.substring(2))) {
                return this.null_proc();
            }
            if (this.name.length() > 0) {
                this.cur_offset = this.setFonts(this.cur_offset, this.name.length(), 'd');
            }
            this.oper = this.Etxt.substring(this.cur_offset - 1);
            if (this.empty(this.oper)) {
                return this.setError(1, this.cur_offset, "OPERATIONMISSING");
            }
            this.cur_offset += this.verify(this.oper, " ") - 1;
            this.oper_offset = this.cur_offset;
            this.oper = this.extractToken(this.Etxt.substring(this.oper_offset - 1));
            this.cur_offset = this.setFonts(this.cur_offset, this.oper.length(), 'o');
            String opnds = this.Etxt.substring(this.cur_offset - 1);
            if (!this.empty(opnds)) {
                this.cur_offset += this.verify(opnds, " ") - 1;
            }
        } else {
            this.oper_offset = 0;
            if ((this.card & 0x40) != 0) {
                if (!this.Etxt.toString().startsWith("//             ")) {
                    return this.setError(1, 72, "QUOTEDCONTEXPECTED");
                }
                this.cur_offset = 16;
            } else {
                if (!this.Etxt.toString().startsWith("// ") || this.Etxt.toString().startsWith("//              ")) {
                    return this.setError(1, 72, "PARMCONTEXPECTED");
                }
                String opnds = this.Etxt.substring(this.cur_offset - 1);
                if (!this.empty(opnds)) {
                    this.cur_offset += this.verify(opnds, " ") - 1;
                }
            }
        }
        if (this.oper.equals("DD")) {
            this.dd_proc();
        } else if (this.oper.equals("JOB")) {
            this.job_proc();
        } else if (this.oper.equals("EXEC")) {
            this.exec_proc();
        } else if (this.oper.equals("PROC")) {
            this.proc_proc();
        } else if (this.oper.equals("PEND")) {
            this.pend_proc();
        } else if (this.oper.equals("OUTPUT")) {
            this.output_proc();
        } else if (this.oper.equals("XMIT")) {
            this.xmit_proc();
        } else if (this.oper.equals("CNTL")) {
            this.cntl_proc();
        } else if (this.oper.equals("ENDCNTL")) {
            this.endcntl_proc();
        } else if (this.fEesa && this.oper.equals("IF")) {
            this.if_then_proc();
        } else if (this.fEesa && this.oper.equals("ELSE")) {
            this.else_proc();
        } else if (this.fEesa && this.oper.equals("ENDIF")) {
            this.endif_proc();
        } else if (this.fEesa && this.oper.equals("INCLUDE")) {
            this.include_proc();
        } else if (this.fEesa && this.oper.equals("JCLLIB")) {
            this.jcllib_proc();
        } else if (this.fEesa && this.oper.equals("SET")) {
            this.set_proc();
        } else if (this.fEesa && this.oper.equals("COMMAND")) {
            this.command_proc(this.oper);
        } else if (this.fEjes2) {
            this.command_proc(this.oper);
        } else {
            return this.setError(this.oper_offset, this.oper.length(), "BADOPERATION");
        }
        return true;
    }

    private boolean job_proc() {
        this.ulEClass |= this.classJob;
        if ((this.card & 2) != 0) {
            return this.setError(1, 72, "JOBCARDINPROC");
        }
        if ((this.card & 1) != 0) {
            if (!this.isValidName(this.name)) {
                return this.setError(3, this.name.length(), "BADXXNAME", "JOB");
            }
            this.setFonts(3, this.name.length(), 'j');
            this.key_list = " ";
        }
        this.card &= 0xFFFFFFEF;
        do {
            if (!this.get_next()) {
                return true;
            }
            if (!this.empty(this.parm_key) && this.sub_num == 1 && this.field_num < 2) {
                if (this.indexStrBB(this.key_list, this.parm_key) != 0) {
                    return this.setError(this.parm_key_offset, this.parm_key.length(), "DUPLICATEKW");
                }
                this.key_list = String.valueOf(this.key_list) + this.parm_key + " ";
            }
            if (this.field_p && !this.empty(this.parm_key) && !this.parm_key.equals("COND")) {
                return this.setError(this.value_offset - 1, -1, "BADCHAR", "(");
            }
            if (!this.empty(this.sub_key)) {
                return this.setError(this.sub_key_offset - 1, -1, "BADCHAR", "=");
            }
            if (this.parm_key.equals("ADDRSPC")) {
                if (this.isValueIn(" VIRT REAL ")) continue;
                return this.setValueError("BADADDRSP");
            }
            if (this.parm_key.equals("CCSID")) {
                if (this.isNumber(this.value, 1, 65535)) continue;
                return this.setValueError("BADVALUE1TOXX", "65535");
            }
            if (this.parm_key.equals("CLASS")) {
                if (this.isValidClass(this.value)) continue;
                return this.setValueError("BADCLASS");
            }
            if (this.parm_key.equals("COND")) {
                if (this.sub_num > 8) {
                    return this.setError(this.cur_offset, -72, "CONDTESTS");
                }
                if (this.field_num == 0 && this.sub_num == 1 || this.field_num == 1) {
                    if (!this.isNumber(this.value, 0, 4095)) {
                        return this.setValueError("BADCONDCODE");
                    }
                    if ((this.field_num != 1 || !this.endOfFields) && !this.endOfSubparameters) continue;
                    return this.setError(this.cur_offset, -72, "CONDTESTOPERMISSING");
                }
                if (this.field_num == 0 && this.sub_num == 2 || this.field_num == 2) {
                    if (this.isValueIn(" GT GE EQ NE LT LE ")) continue;
                    return this.setValueError("BADCOND");
                }
                return this.setError(this.cur_offset, -72, "BADCONDPARM");
            }
            if (this.parm_key.equals("GROUP")) {
                if (this.value.length() == 0) {
                    return true;
                }
                if (this.isValidName(this.value)) continue;
                return this.setValueError("BADXXNAME", "GROUP");
            }
            if (this.parm_key.equals("JESLOG") || this.parm_key.equals("MEMLIMIT")) continue;
            if (this.parm_key.equals("MSGCLASS")) {
                if (this.isValidClass(this.value)) continue;
                return this.setValueError("MSGCLASS");
            }
            if (this.parm_key.equals("MSGLEVEL")) {
                if (this.sub_num == 1 && !this.isValueIn(" 0 1 2 ")) {
                    return this.setValueError("MSGLEVEL");
                }
                if (this.sub_num != 2 || this.isValueIn(" 0 1 ")) continue;
                return this.setValueError("MSGLEVELMSG");
            }
            if (this.parm_key.equals("NOTIFY")) {
                if (this.isValidTsoUserId(this.value)) continue;
                this.setValueError("BADTSOUSERID");
                continue;
            }
            if (this.parm_key.equals("PASSWORD")) {
                if (this.isValidPassword(this.value)) continue;
                return this.setValueError("BADPWD");
            }
            if (this.parm_key.equals("PERFORM")) {
                if (this.isNumber(this.value, 1, 999)) continue;
                return this.setValueError("BADPERFGROUP");
            }
            if (this.parm_key.equals("PRTY")) {
                if (this.fEjes2 && !this.isNumber(this.value, 0, 14)) {
                    return this.setValueError("PRIORITY", "14");
                }
                if (!this.fEjes3 || this.isNumber(this.value, 0, 15)) continue;
                return this.setValueError("PRIORITY", "15");
            }
            if (this.parm_key.equals("RD")) {
                if (this.isValueIn(" R RNC NR NC ")) continue;
                return this.setValueError("BADRD");
            }
            if (this.parm_key.equals("REGION")) {
                int c1 = 32;
                String tmpvalue = "";
                if (this.value.length() > 0) {
                    c1 = this.value.charAt(this.value.length() - 1);
                    tmpvalue = this.value.substring(0, this.value.length() - 1);
                }
                if (!(c1 == 75 && !this.isNumber(tmpvalue, 0, 2096128) || c1 == 77 && !this.isNumber(tmpvalue, 0, 2047)) && (c1 == 75 || c1 == 77)) continue;
                return this.setValueError("BADREGION");
            }
            if (this.parm_key.equals("RESTART")) {
                if (this.sub_num != 1 || this.value.equals("*") || this.isValidName(this.value) || this.isValidNameWithPeriod(this.value)) continue;
                return this.setValueError("BADRESTART");
            }
            if (this.parm_key.equals("SCHENV") || this.parm_key.equals("SECLABEL")) continue;
            if (this.parm_key.equals("TIME")) {
                if (this.sub_num == 1) {
                    if (this.value.length() <= 0) continue;
                    if (!this.isValueIn(" NOLIMIT MAXIMUM ")) {
                        if (this.isNumber(this.value, 0, 357912)) continue;
                        return this.setValueError("BADMINUTES");
                    }
                    if (this.endOfSubparameters) continue;
                    return this.setValueError("UNEXPECTEDPARM");
                }
                if (this.sub_num != 2 || this.isNumber(this.value, 0, 59)) continue;
                return this.setValueError("BADSECONDS");
            }
            if (this.parm_key.equals("TYPRUN")) {
                if (this.isValueIn(" HOLD SCAN ") || this.fEjes2 && this.isValueIn(" COPY JCLHOLD ")) continue;
                return this.setValueError(this.fEjes2 ? "BADTYPRUNJES2" : "BADTYPRUNJES3");
            }
            if (this.parm_key.equals("USER")) {
                if (this.value.length() == 0) {
                    return true;
                }
                if (this.isValidTsoUserId(this.value)) continue;
                this.setValueError("BADTSOUSERID");
                continue;
            }
            if (this.parm_key.equals("BYTES") || this.parm_key.equals("LINES")) {
                if (this.fExa) {
                    return this.setError(this.parm_key_offset, this.parm_key.length(), "BADJOBKWPARM");
                }
                if (this.sub_num == 1 && !this.isNumber(this.value, 0, 999999)) {
                    return this.setValueError("BADVALUE0TOXX", "999999");
                }
                if (this.sub_num != 2 || this.isValueIn(" CANCEL DUMP WARNING ")) continue;
                return this.setValueError("CANDUMPWARNEXPECTED");
            }
            if (this.parm_key.equals("CARDS") || this.parm_key.equals("PAGES")) {
                if (this.fExa) {
                    return this.setError(this.parm_key_offset, this.parm_key.length(), "BADJOBKWPARM");
                }
                if (this.sub_num == 1 && !this.isNumber(this.value, 0, 99999999)) {
                    return this.setValueError("BADVALUE0TOXX", "99999999");
                }
                if (this.sub_num != 2 || this.isValueIn(" CANCEL DUMP WARNING ")) continue;
                return this.setValueError("CANDUMPWARNEXPECTED");
            }
            if (!this.empty(this.parm_key)) {
                return this.setError(this.parm_key_offset, this.parm_key.length(), "BADJOBKWPARM");
            }
            if (this.parm_num != 2 || this.programmerNameLength(this.value) <= 20) continue;
            return this.setValueError("PROGRAMMERTOOLONG");
        } while (!this.endOfCard);
        this.setComments(this.cur_offset);
        return true;
    }

    private boolean exec_proc() {
        this.ulEClass |= this.classExec;
        if ((this.card & 1) != 0) {
            if (!this.empty(this.name) && !this.isValidName(this.name)) {
                return this.setError(3, this.name.length(), "BADEXECSTEP");
            }
            this.key_list = " ";
            this.setFonts(3, this.name.length(), 's');
        }
        this.card &= 0xFFFFFFEF;
        do {
            if (!this.get_next()) {
                return true;
            }
            String fullParm = this.parm_key;
            int i = this.parm_key.indexOf(46) + 1;
            if (i != 0) {
                int j = this.parm_key.length() - i;
                if (!this.isValidName(this.parm_key.substring(i))) {
                    return this.setError(this.parm_key_offset + i, j, "BADPROCSTEP");
                }
                this.parm_key = this.parm_key.substring(0, i - 1);
                i += this.parm_key_offset - 1;
                i = this.setFonts(i, 1, '.');
                i = this.setFonts(i, j, 'p');
            }
            if (!this.empty(this.parm_key)) {
                if (this.sub_num == 1 && this.field_num < 2) {
                    if (this.parm_key_offset != 0) {
                        String keyword = fullParm;
                        if (this.indexStrBB(this.key_list, keyword) != 0) {
                            return this.setError(this.parm_key_offset, keyword.length(), "DUPLICATEKW");
                        }
                        this.key_list = String.valueOf(this.key_list) + keyword + ' ';
                    }
                } else {
                    if (this.sub_num > 1 && this.indexStr(exec_key_limit1, this.parm_key) > 0) {
                        return this.setValueError("TOOMANYPARMS");
                    }
                    if (this.sub_num > 2 && this.indexStr(exec_key_limit2, this.parm_key) > 0) {
                        return this.setValueError("TOOMANYPARMS");
                    }
                }
            }
            if (this.parm_key.equals("PGM")) {
                if (this.symbolic) continue;
                if (this.sub_num != 1) {
                    return this.setError(this.parm_key_offset, this.parm_key.length(), "PGMNOTFIRST");
                }
                if (!this.empty(this.value) && this.value.charAt(0) == '*') {
                    if (this.isBackReference(this.value)) continue;
                    return this.setValueError("BADPROGRAMREF");
                }
                if (this.isValidName(this.value)) continue;
                return this.setValueError("PROGNAME");
            }
            if (this.parm_key.equals("PROC")) {
                if (this.symbolic) continue;
                if (this.sub_num != 1) {
                    return this.setError(this.parm_key_offset, this.parm_key.length(), "PROCNOTFIRST");
                }
                if (!this.isValidName(this.value)) {
                    return this.setValueError("PROCNAME");
                }
                this.value_offset = this.setFonts(this.value_offset, this.value.length(), 'r');
                continue;
            }
            if (this.parm_key.equals("ACCT")) continue;
            if (this.parm_key.equals("ADDRSPC")) {
                if (this.symbolic || this.isValueIn(" VIRT READ ")) continue;
                return this.setValueError("BADADDRSP");
            }
            if (this.parm_key.equals("COND")) {
                if (this.symbolic) continue;
                if (this.sub_num > 8) {
                    return this.setError(this.cur_offset, -72, "CONDTESTS");
                }
                if (this.field_num == 0 && this.sub_num == 1 || this.field_num == 1) {
                    if (!this.isValueIn(" EVEN ONLY ")) {
                        if (!this.isNumber(this.value, 0, 4095)) {
                            return this.setValueError("BADCONDCODE");
                        }
                        if ((this.field_num != 1 || !this.endOfFields) && !this.endOfSubparameters) continue;
                        return this.setError(this.cur_offset, -72, "CONDTESTOPERMISSING");
                    }
                    if (!this.field_p) continue;
                    return this.setError(this.value_offset - 1, this.value.length() + 1, "UNEXPECTEDSUBPARM");
                }
                if (this.field_num == 0 && this.sub_num == 2 || this.field_num == 2) {
                    if (this.isValueIn(" GT GE EQ NE LT LE ")) continue;
                    return this.setValueError("BADCOND");
                }
                if (this.field_num == 0 && this.sub_num == 3 || this.field_num == 3) {
                    i = this.value.indexOf(46) + 1;
                    if (i != 0) {
                        if (!this.isValidName(this.value.substring(i))) {
                            return this.setError(this.value_offset + i, this.value.length() - i, "BADPROCSTEP");
                        }
                        String name1 = this.value.substring(0, i - 1);
                        if (!this.isValidName(name1)) {
                            return this.setError(this.value_offset, i - 1, "STEPNAME");
                        }
                        int j = this.value_offset;
                        j = this.setFonts(j, i - 1, 's');
                        j = this.setFonts(j, 1, '.');
                        j = this.setFonts(j, this.value.length() - i, 'p');
                        continue;
                    }
                    if (!this.isValidName(this.value)) {
                        return this.setValueError("STEPNAME");
                    }
                    this.value_offset = this.setFonts(this.value_offset, this.value.length(), 's');
                    continue;
                }
                if ((this.field_num != 0 || this.sub_num <= 3) && this.field_num <= 3) continue;
                return this.setError(this.cur_offset, -72, "CONDSUBFIELDS");
            }
            if (this.parm_key.equals("DPRTY")) {
                if (this.symbolic || this.isNumber(this.value, 0, 15)) continue;
                return this.setValueError("PRIORITY", "15");
            }
            if (this.parm_key.equals("DYNAMNBR")) {
                if (this.symbolic || this.isNumber(this.value, 0, 3273)) continue;
                return this.setValueError("BADDYNAMNBR");
            }
            if (this.parm_key.equals("PARM")) continue;
            if (this.parm_key.equals("PERFORM")) {
                if (this.symbolic || this.isNumber(this.value, 1, 999)) continue;
                return this.setValueError("BADPERFGROUP");
            }
            if (this.parm_key.equals("RD")) {
                if (this.symbolic || this.isValueIn(" R RNC NR NC ")) continue;
                return this.setValueError("BADRD");
            }
            if (this.parm_key.equals("REGION")) {
                if (this.symbolic) continue;
                int c1 = 32;
                String tmpvalue = "";
                if (this.value.length() > 0) {
                    c1 = this.value.charAt(this.value.length() - 1);
                    tmpvalue = this.value.substring(0, this.value.length() - 1);
                }
                if (!(c1 == 75 && !this.isNumber(tmpvalue, 0, 2096128) || c1 == 77 && !this.isNumber(tmpvalue, 0, 2047)) && (c1 == 75 || c1 == 77)) continue;
                return this.setValueError("BADREGION");
            }
            if (this.parm_key.equals("TIME")) {
                if (this.symbolic) continue;
                if (this.sub_num == 1) {
                    if (this.value.length() <= 0) continue;
                    if (!this.isValueIn(" NOLIMIT MAXIMUM ")) {
                        if (this.isNumber(this.value, 0, 357912)) continue;
                        return this.setValueError("BADMINUTES");
                    }
                    if (this.endOfSubparameters) continue;
                    return this.setValueError("UNEXPECTEDPARM");
                }
                if (this.sub_num != 2 || this.isNumber(this.value, 0, 59)) continue;
                return this.setValueError("BADSECONDS");
            }
            if (!this.empty(this.parm_key)) {
                if (this.sub_num != 1 || this.field_num >= 2) continue;
                if (this.parm_key.length() > 8 || !this.isValidName(this.parm_key)) {
                    return this.setValueError("BADSYMPARMNAME");
                }
                i = this.parm_key_offset;
                i = this.setFonts(i, this.parm_key.length(), 'y');
                continue;
            }
            if (this.parm_num == 1) {
                if (!this.symbolic && !this.isValidName(this.value)) {
                    return this.setValueError("PROCNAME");
                }
                this.value_offset = this.setFonts(this.value_offset, this.value.length(), 'r');
                continue;
            }
            if (this.parm_num <= 1) continue;
            return this.setValueError("TOOMANYPOSPARMS");
        } while (!this.endOfCard);
        this.setComments(this.cur_offset);
        return true;
    }

    private boolean dd_proc() {
        String name1;
        int i;
        String key = "";
        this.ulEClass |= this.classDd;
        if ((this.card & 1) != 0) {
            i = this.name.indexOf(46) + 1;
            if (i != 0) {
                name1 = this.name.substring(0, i - 1);
                if (!this.isValidName(name1)) {
                    return this.setError(3, i, "BADPROCSTEP");
                }
                this.setFonts(3, i - 1, 'p');
                if (!this.isValidName(this.name.substring(i + 1 - 1))) {
                    return this.setError(3 + i, this.name.length() - i, "BADXXNAME", "DD");
                }
                this._currentStyle.setCharAt(i + 2 - 1, '.');
            } else if (!this.empty(this.name) && !this.isValidName(this.name)) {
                return this.setError(3, this.name.length(), "BADXXNAME", "DD");
            }
        }
        this.card &= 0xFFFFFFEF;
        block73: do {
            if (!this.get_next()) {
                return true;
            }
            if (this.field_num < 2) {
                int key_offset;
                if (!this.empty(this.sub_key) && (this.parm_key.equals("DCB") || this.parm_key.equals("LABEL"))) {
                    if (this.sub_num < 2 && !this.mux_test(this.parm_key)) {
                        return this.setError(this.parm_key_offset, this.parm_key.length(), "CONFLICTINGDDPARM");
                    }
                    key = this.sub_key;
                    key_offset = this.sub_key_offset;
                } else {
                    if (this.empty(this.parm_key)) {
                        key = this.value;
                        key_offset = this.value_offset;
                    } else {
                        key = this.parm_key;
                        key_offset = this.parm_key_offset;
                    }
                    if (this.sub_num < 2 && !this.mux_test(key)) {
                        return this.setError(key_offset, key.length(), "CONFLICTINGDDPARM");
                    }
                    if (this.Ekey_num != 0 && !this.dd_lvl_test(this.Ekey_num)) {
                        return false;
                    }
                }
                if (!(this.empty(this.sub_key) || this.sub_key.equals(key) || this.parm_key.equals("UNIT") || this.parm_key.equals("VOL") || this.parm_key.equals("VOLUME"))) {
                    return this.setError(this.sub_key_offset, this.sub_key.length(), "BADKWPARM");
                }
            }
            if (this.Ekey_num != 0) {
                switch (this.findJCLWord(DDKeyTable, key)) {
                    case 1: 
                    case 2: {
                        if (this.sub_num > 1) {
                            return this.setValueError("UNEXPECTEDPOSPARM");
                        }
                        this.ulEClass |= this.classInstream;
                        this.Estream_type = (char)(key.equals("*") ? 42 : 68);
                        break;
                    }
                    case 3: 
                    case 4: {
                        if (this.sub_num <= 1) continue block73;
                        return this.setValueError("UNEXPECTEDPOSPARM");
                    }
                    case 5: {
                        if (this.symbolic) continue block73;
                        if (this.sub_num == 1 && this.value.length() != 0 && !this.isValueIn(" NEW OLD SHR SHARE MOD ")) {
                            return this.setValueError("BADDISPSTATUS");
                        }
                        if (this.sub_num == 2 && this.value.length() != 0 && !this.isValueIn(" DELETE KEEP PASS CATLG UNCATLG ")) {
                            return this.setValueError("BADNORMALDISP");
                        }
                        if (this.sub_num != 3 || this.isValueIn(" DELETE KEEP CATLG UNCATLG ) ")) continue block73;
                        return this.setValueError("BADABNORMALDISP");
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        if (this.symbolic || this.isValidDsName(this.value)) continue block73;
                        return this.setValueError("BADDATASET");
                    }
                    case 9: {
                        if (this.symbolic) continue block73;
                        if (this.sub_num == 1) {
                            if (this.value.length() == 0 || this.value.equals("*") || this.value.equals("$") && this.fEjes2 || this.isValidClass(this.value)) continue block73;
                            this.setValueError("BADSYSOUTCLASS");
                            break;
                        }
                        if (this.sub_num == 2) {
                            if (this.value.length() == 0 || this.isValidName(this.value) || this.value.equals(")")) continue block73;
                            this.setValueError("BADSYSOUTWRITER");
                            break;
                        }
                        if (this.sub_num != 3 || this.isValidFormName(this.value)) continue block73;
                        return this.setValueError("BADSYSOUTFORM");
                    }
                    case 10: {
                        if (this.symbolic) break;
                        if (this.empty(this.sub_key)) {
                            if (this.sub_num == 1 && this.value.length() > 8) {
                                return this.setValueError("BADUNIT");
                            }
                            if (!(this.sub_num != 2 || this.empty(this.value) || this.value.equals("P") || this.isNumber(this.value, 1, 59))) {
                                return this.setValueError("BADUNITCOUNT");
                            }
                            if (this.sub_num != 3 || this.isValueIn(" DEFER ")) continue block73;
                            return this.setValueError("XXEXPECTED", "DEFER");
                        }
                        if (this.sub_key.equals("AFF")) {
                            if (this.isValidName(this.value)) continue block73;
                            return this.setValueError("BADXXNAME", "DD");
                        }
                        return this.setError(this.sub_key_offset, this.sub_key.length(), "BADSUBPARMKW");
                    }
                    case 11: 
                    case 12: {
                        if (this.symbolic) break;
                        if (this.empty(this.sub_key)) {
                            if (this.sub_num == 1 && !this.empty(this.value) && !this.isValueIn(" PRIVATE ")) {
                                return this.setValueError("XXEXPECTED", "PRIVATE");
                            }
                            if (this.sub_num == 2 && !this.empty(this.value) && !this.isValueIn(" RETAIN ")) {
                                this.setValueError("XXEXPECTED", "RETAIN");
                                break;
                            }
                            if (this.sub_num == 3 && !this.empty(this.value) && !this.isNumber(this.value, 1, 255)) {
                                return this.setValueError("BADVOLSEQ");
                            }
                            if (this.sub_num != 4 || this.empty(this.value) || this.isNumber(this.value, 1, 255)) continue block73;
                            return this.setValueError("BADVOLCOUNT");
                        }
                        if (this.sub_key.equals("SER")) {
                            if (this.value.length() <= 8 && (this.value.length() <= 6 || this.value.charAt(0) == '\'')) continue block73;
                            return this.setValueError("BADVOLSER");
                        }
                        if (this.sub_key.equals("REF")) {
                            if (this.isBackReference(this.value)) continue block73;
                            return this.setValueError("BADBACKREF");
                        }
                        return this.setError(this.sub_key_offset, this.sub_key.length(), "BADVOLSUBKW");
                    }
                    case 13: {
                        if (this.symbolic) break;
                        i = -1;
                        if (this.sub_num == 1 && this.value.length() != 0 && !this.isValueIn(" TRK CYL ABSTR ") && !this.isNumber(this.value, 1, 65535)) {
                            this.setValueError("TRKEXPECTED");
                            break;
                        }
                        if (this.sub_num == 2 && this.field_num == 1 && this.value.length() != 0 && !this.isNumber(this.value, 0, 99999999)) {
                            this.setValueError("BADPRIMSPACE");
                            break;
                        }
                        if (this.sub_num == 2 && this.field_num == 2 && this.value.length() != 0 && !this.isNumber(this.value, 0, 99999999) && !this.value.equals(")")) {
                            this.setValueError("BADSECONDSPACE");
                            break;
                        }
                        if (this.sub_num == 2 && this.field_num == 3 && !this.isNumber(this.value, 0, 99999999) && !this.value.equals(")")) {
                            return this.setValueError("BADDIRSPACE");
                        }
                        if (this.sub_num == 3) {
                            if (this.value.length() == 0 || this.isValueIn(" RLSE ")) continue block73;
                            this.setValueError("XXEXPECTED", "RLSE");
                            break;
                        }
                        if (this.sub_num == 4) {
                            if (this.value.length() == 0 || this.isValueIn(" CONTIG MXIG ALX ")) continue block73;
                            this.setValueError("CONTIGEXPECTED");
                            break;
                        }
                        if (this.sub_num != 5 || this.isValueIn(" ROUND ")) continue block73;
                        this.setValueError("XXEXPECTED", "ROUND");
                        break;
                    }
                    case 14: {
                        if (this.symbolic || this.isValidName(this.value)) continue block73;
                        return this.setValueError("BADXXNAME", "DD");
                    }
                    case 15: {
                        if (this.symbolic) break;
                        if (this.sub_num == 1 && !this.empty(this.value) && !this.isNumber(this.value, 1, 9999)) {
                            return this.setValueError("BADDATASETSEQ");
                        }
                        if (this.sub_num == 2 && !this.empty(this.value) && !this.isValueIn(" SL SUL AL AUL NSL NL BLP LTM ")) {
                            return this.setValueError("BADLABELTYPE");
                        }
                        if (this.sub_num == 3 && !this.empty(this.value) && !this.isValueIn(" PASSWORD NOPWREAD ")) {
                            return this.setValueError("PWDIFANY");
                        }
                        if (this.sub_num != 4 || this.empty(this.value) || this.isValueIn(" IN OUT ")) continue block73;
                        return this.setValueError("NOINOUT");
                    }
                    case 16: {
                        if (!this.symbolic) continue block73;
                        break;
                    }
                    case 17: {
                        if (this.symbolic || this.empty(this.value) || this.isNumber(this.value, 1, 9999)) continue block73;
                        return this.setValueError("BADRETENTION");
                    }
                    case 18: {
                        if (this.symbolic) break;
                        if (this.value.length() > 1 && this.value.charAt(0) == '\'' && this.value.charAt(this.value.length() - 1) == '\'' && this.value.length() > 2) {
                            this.value = this.value.substring(1, this.value.length() - 1);
                        }
                        if (this.value.length() > 1 && this.value.charAt(0) == '&' && this.value.charAt(1) == '&') {
                            this.value = this.value.substring(1);
                        }
                        if (this.value.length() > 2 && this.value.charAt(this.value.length() - 1) == '&' && this.value.charAt(this.value.length() - 2) == '&') {
                            this.value = this.value.substring(0, this.value.length() - 1);
                        }
                        if (this.value.length() != 2) {
                            return this.setValueError("BADDELIMITER");
                        }
                        this.data_dlm = this.value;
                        break;
                    }
                    case 19: {
                        if (this.symbolic) break;
                        if (!this.empty(this.value) && this.value.charAt(0) == '*') {
                            if (this.isBackReference(this.value)) continue block73;
                            return this.setValueError("BADBACKREF");
                        }
                        if (this.isValidDsName(this.value)) continue block73;
                        return this.setValueError("BADDATASET");
                    }
                    case 22: {
                        if (this.symbolic || this.isNumber(this.value, 1, 32760)) continue block73;
                        this.setValueError("BADVALUE1TOXX", "32760");
                        break;
                    }
                    case 20: {
                        if (this.symbolic || this.isNumber(this.value, 0, 32761)) continue block73;
                        this.setValueError("BADVALUE0TOXX", "32761");
                        break;
                    }
                    case 21: {
                        if (this.symbolic || this.isNumber(this.value, 0, 32760)) continue block73;
                        this.setValueError("BADVALUE0TOXX", "32760");
                        break;
                    }
                    case 23: {
                        if (this.symbolic || this.isValueIn(" U F FB FS FBS V VB VS VBS UA FA FBA FSA FBSA VA VBA VSA VBSA UM FM FBM FSM FBSM VM VBM VSM VBSM UT FT FBT FBST VT VBT VBST UTA FTA FBTA FBSTA VTA VBTA VBSTA UTM FTM FBTM FBSTM VTM VBTM VBSTM ")) continue block73;
                        this.setValueError("RECFORMAT");
                        break;
                    }
                    case 24: {
                        if (this.symbolic || this.isValueIn(" PS PO DA IS CX GS PSU POU DAU ISU ")) continue block73;
                        return this.setValueError("BADDATASETORG");
                    }
                    case 25: {
                        if (this.symbolic || this.isValueIn(" TS ")) continue block73;
                        return this.setValueError("TERMTSEXPECTED");
                    }
                    case 26: {
                        String TEST_ACCODE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
                        if (this.symbolic || !this.empty(this.value) && this.value.length() <= 8 && TEST_ACCODE.indexOf(this.value.charAt(0)) >= 0) continue block73;
                        return this.setValueError("BADACCODE");
                    }
                    case 27: {
                        if (this.symbolic || this.isValueIn(" U K M ")) continue block73;
                        return this.setValueError("NOTUKM");
                    }
                    case 28: {
                        if (this.symbolic || this.isValueIn(" YES Y NO N ")) continue block73;
                        return this.setValueError("NOTYESNO");
                    }
                    case 29: {
                        if (this.symbolic || this.isValidCode(this.value)) continue block73;
                        return this.setValueError("CHARTBL");
                    }
                    case 30: {
                        if (this.symbolic || this.isValueIn(" EOV ")) continue block73;
                        return this.setValueError("NOTEOV");
                    }
                    case 31: 
                    case 32: 
                    case 33: {
                        if (this.symbolic || this.isBackReference(this.value)) continue block73;
                        return this.setValueError("BADBACKREF");
                    }
                    case 34: 
                    case 35: 
                    case 36: {
                        if (this.symbolic || this.isValidName(this.value)) continue block73;
                        return this.setValueError("BADNAME");
                    }
                    case 37: {
                        if (this.symbolic) continue block73;
                        if (this.sub_num == 1 && !this.isValidName(this.value)) {
                            return this.setValueError("BADIDENTIFIER");
                        }
                        if (this.sub_num != 2 || this.isValueIn(" V ")) continue block73;
                        return this.setValueError("NOTV");
                    }
                    case 38: {
                        if (this.symbolic) break;
                        if (this.sub_num == 1 && !this.isValidCode(this.value)) {
                            return this.setValueError("BADXXNAME", "FCB");
                        }
                        if (this.sub_num != 2 || this.isValueIn(" ALIGN VERIFY ")) continue block73;
                        return this.setValueError("NOTALIGNVERIFY");
                    }
                    case 39: {
                        if (this.symbolic) break;
                        if (this.sub_num == 1 && !this.isValidCode(this.value)) {
                            return this.setValueError("BADOVERLAY");
                        }
                        if (this.sub_num != 2 || this.isNumber(this.value, 0, 255)) continue block73;
                        return this.setValueError("BADFLASHCOUNT");
                    }
                    case 40: {
                        if (this.symbolic || this.isValueIn(" END CLOSE ")) continue block73;
                        return this.setValueError("NOTENDCLOSE");
                    }
                    case 41: {
                        if (this.symbolic || this.isValueIn(" YES Y NO N ")) continue block73;
                        return this.setValueError("NOTYESNO");
                    }
                    case 42: {
                        if (this.symbolic) continue block73;
                        if (this.sub_num == 1 && !this.isValidCode(this.value)) {
                            return this.setValueError("BADMODULE");
                        }
                        if (this.sub_num != 2 || this.isValueIn(" 0 1 2 3 ")) continue block73;
                        return this.setValueError("NOT0TO3");
                    }
                    case 43: {
                        if (this.symbolic) break;
                        if (this.sub_num == 1 && !this.isValidName(this.value)) {
                            return this.setValueError("BADGROUPID");
                        }
                        if (this.sub_num != 2 || this.isValidName(this.value)) continue block73;
                        return this.setValueError("BADXXNAME", "DD");
                    }
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: {
                        if (this.symbolic || this.isNumber(this.value, 1, 0xFFFFFF)) continue block73;
                        return this.setValueError("NOTINTEGER");
                    }
                    case 49: {
                        if (this.symbolic || this.isValueIn(" YES Y ")) continue block73;
                        return this.setValueError("NOTYES");
                    }
                    case 50: {
                        if (this.symbolic || this.isValueIn(" KS ES RR LS ")) continue block73;
                        return this.setValueError("NOTKSES");
                    }
                    case 51: {
                        if (this.symbolic || this.sub_num != 1 || this.isValidCode(this.value)) continue block73;
                        return this.setValueError("BADXXNAME", "SUBSYS");
                    }
                    case 52: {
                        if (this.symbolic) break;
                        if (this.sub_num == 1 && !this.isValidCode(this.value)) {
                            return this.setValueError("BADUCSSET");
                        }
                        if (this.sub_num == 2 && !this.isValueIn(" FOLD ")) {
                            return this.setValueError("NOTFOLD");
                        }
                        if (this.sub_num != 3 || this.isValueIn(" VERIFY ")) continue block73;
                        return this.setValueError("NOTVERIFY");
                    }
                    case 53: {
                        if (this.symbolic || this.isValueIn(" F D ")) continue block73;
                        return this.setValueError("NOTFD");
                    }
                    case 54: {
                        if (this.symbolic || this.isValueIn(" R D S E A ")) continue block73;
                        return this.setValueError("BADBFTEK");
                    }
                    case 55: {
                        if (this.symbolic || this.isValueIn(" R E S ")) continue block73;
                        return this.setValueError("BADCPRI");
                    }
                    case 56: {
                        if (this.symbolic || this.isValueIn(" 1 2 3 4 ")) continue block73;
                        return this.setValueError("BADDENSITY");
                    }
                    case 57: {
                        if (this.symbolic || this.isValueIn(" 0 1 2 3 ")) continue block73;
                        return this.setValueError("SPACING");
                    }
                    case 58: {
                        if (this.symbolic || this.isValueIn(" TRACE ")) continue block73;
                        return this.setValueError("NOTTRACE");
                    }
                    case 59: {
                        if (this.symbolic || this.isNumber(this.value, 2, 15)) continue block73;
                        return this.setValueError("BADBUFMAX");
                    }
                    case 60: 
                    case 61: {
                        if (this.symbolic || this.isNumber(this.value, 1, 255)) continue block73;
                        return this.setValueError("BADVALUE1TOXX", "255");
                    }
                    case 62: {
                        if (this.symbolic || this.isNumber(this.value, 1, 15)) continue block73;
                        return this.setValueError("BADVALUE1TOXX", "15");
                    }
                    case 63: {
                        if (this.symbolic || this.isNumber(this.value, 1, 99) || this.isValueIn(" L ")) continue block73;
                        return this.setValueError("BADBUFOFF");
                    }
                    case 64: {
                        if (this.symbolic || this.isNumber(this.value, 31, 65535)) continue block73;
                        return this.setValueError("BADBUFSIZE");
                    }
                    case 65: {
                        if (this.symbolic || this.isNumber(this.value, 1, 99)) continue block73;
                        return this.setValueError("BADVALUE1TOXX", "99");
                    }
                    case 66: {
                        if (this.symbolic || this.isValueIn(" T ACC SKP ABE ")) continue block73;
                        return this.setValueError("BADEROPT");
                    }
                    case 67: {
                        if (this.symbolic || this.isValueIn(" I R P W WT RP RPD RW RWT PW PWXT RPW RPWXT RPWD RWX RWXT PWX RPWX RWX ")) continue block73;
                        return this.setValueError("BADFUNC");
                    }
                    case 68: {
                        if (this.symbolic || this.isValidName(this.value)) continue block73;
                        return this.setValueError("BADNAME");
                    }
                    case 69: {
                        if (this.symbolic || this.isValueIn(" C CO CR E EO ER ")) continue block73;
                        return this.setValueError("BADFUNC");
                    }
                    case 70: {
                        if (this.symbolic || this.isNumber(this.value, 1, 99)) continue block73;
                        return this.setValueError("BADVALUE1TOXX", "99");
                    }
                    case 71: {
                        break;
                    }
                    case 72: {
                        if (this.symbolic || this.isValueIn(" N R A X ")) continue block73;
                        return this.setValueError("NOTNRAX");
                    }
                    case 73: 
                    case 74: {
                        if (this.symbolic || this.sub_num < 3 && this.isNumber(this.value, 0, 255)) continue block73;
                        return this.setValueError("BADVALUE0TOXX", "255");
                    }
                    case 75: 
                    case 76: {
                        if (this.symbolic || this.isNumber(this.value, 0, 32760)) continue block73;
                        return this.setValueError("BADVALUE0TOXX", "32760");
                    }
                    case 77: {
                        if (this.symbolic || this.isValueIn(" 1 2 ")) continue block73;
                        return this.setValueError("NOT12");
                    }
                    case 78: {
                        if (this.symbolic || this.isNumber(this.value, 1, 99)) continue block73;
                        return this.setValueError("BADVALUE1TOXX", "99");
                    }
                    case 79: {
                        if (this.symbolic || this.isValueIn(" C E T ET ")) continue block73;
                        return this.setValueError("NOTCETET");
                    }
                    case 80: {
                        if (this.symbolic || this.isValidName(this.value)) continue block73;
                        return this.setValueError("BADNODE");
                    }
                    case 81: {
                        if (this.symbolic) break;
                        i = this.value.indexOf(46) + 1;
                        if (i != 0) {
                            if (!this.isValidName(this.value.substring(i + 1 - 1))) {
                                return this.setValueError("BADTCAMJOB");
                            }
                            name1 = this.value.substring(0, i - 1);
                            if (this.isValidName(name1)) continue block73;
                            return this.setValueError("BADXXNAME", "TPROCESS");
                        }
                        if (this.isValidName(this.name)) continue block73;
                        return this.setValueError("BADTCAMJOB");
                    }
                    case 82: {
                        if (this.symbolic || this.sub_num != 2 || this.isValueIn(" GENERIC ")) continue block73;
                        return this.setValueError("NOGENERIC");
                    }
                    case 83: {
                        break;
                    }
                    case 84: {
                        if (this.symbolic) break;
                        if (this.sub_num == 1 && !this.empty(this.value) && !this.isNumber(this.value, 1, 255)) {
                            return this.setValueError("COPYCNT");
                        }
                        if (this.sub_num <= 1 || this.isNumber(this.value, 1, 255)) continue block73;
                        return this.setValueError("BADVALUE1TOXX", "255");
                    }
                    case 85: {
                        if (this.fExa) {
                            return this.setError(this.parm_key_offset, this.parm_key.length(), "DDKW");
                        }
                        if (this.symbolic || this.isNumber(this.value, 0, 99999999)) continue block73;
                        return this.setValueError("BADPAGECOUNT");
                    }
                    case 86: {
                        if (this.fExa) {
                            return this.setError(this.parm_key_offset, this.parm_key.length(), "DDKW");
                        }
                        if (this.symbolic || this.isValueIn(" UNALLOC NO ")) continue block73;
                        return this.setValueError("NOTUNALLOC");
                    }
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: {
                        break;
                    }
                }
                continue;
            }
            if (this.symbolic || this.empty(key)) continue;
            if (!this.empty(this.parm_key)) {
                if (!key.equals(this.parm_key)) {
                    return this.setError(this.sub_key_offset, this.sub_key.length(), "UNKNOWNSUBPARM");
                }
                return this.setError(this.parm_key_offset, this.parm_key.length(), "DDKW");
            }
            return this.setValueError(this.parm_num == 1 ? "DDPOSPARM" : "TOOMANYPOSPARMS");
        } while (!this.endOfCard);
        this.setComments(this.cur_offset);
        return true;
    }

    private boolean dlm_proc() {
        this.ulEClass |= this.classJcl | this.classDlm;
        if (this.fEjes2 && this.data_dlm.equals(DEFAULT_DLM) && this.Etxt.charAt(2) != ' ') {
            return this.setError(1, 72, "JES2STMT");
        }
        this._currentStyle.setCharAt(0, '*');
        this._currentStyle.setCharAt(1, '*');
        this.data_dlm = DEFAULT_DLM;
        this.setComments(3);
        return true;
    }

    private boolean instream_proc() {
        this.ulEClass |= this.classInstream;
        int i = 0;
        while (i < 72) {
            this._currentStyle.setCharAt(i, 'i');
            ++i;
        }
        return true;
    }

    private boolean comment_proc() {
        this.ulEClass |= this.classJcl | this.classComment;
        if ((this.card & 0x40) != 0) {
            return this.setError(1, 72, "QUOTEDCONTEXPECTED");
        }
        if ((this.card & 1) == 0) {
            this.card &= 0xFFFFFFEF;
        }
        int i = 0;
        while (i < 72) {
            this._currentStyle.setCharAt(i, 'c');
            ++i;
        }
        if (this._taskTags != null) {
            String text = this.view.elementText(this._currentElement);
            int tt = 0;
            while (tt < this._taskTags.length) {
                String tag = this._taskTags[tt];
                if (tag != null && tag.length() != 0) {
                    int t = 0;
                    while ((t = text.indexOf(tag, t)) >= 0) {
                        int endColumn = t + tag.length();
                        if (endColumn > 72) break;
                        int x = t;
                        while (x < endColumn) {
                            this._currentStyle.setCharAt(x, '$');
                            ++x;
                        }
                        this.ulEClass |= this.classCommentTask;
                        t = endColumn;
                    }
                }
                ++tt;
            }
        }
        return true;
    }

    private boolean null_proc() {
        this.ulEClass |= this.classNull;
        return true;
    }

    private boolean proc_proc() {
        this.ulEClass |= this.classProc;
        if ((this.card & 1) != 0) {
            if (!this.isValidName(this.name)) {
                return this.setError(3, this.name.length(), "BADXXNAME", "PROC");
            }
            this.setFonts(3, this.name.length(), 'r');
            this.key_list = " ";
        }
        this.card &= 0xFFFFFFEF;
        do {
            if (!this.get_next()) {
                return true;
            }
            if (!this.empty(this.parm_key) && this.sub_num == 1 && this.field_num < 2) {
                if (this.indexStrBB(this.key_list, this.parm_key) != 0) {
                    return this.setError(this.parm_key_offset, this.parm_key.length(), "DUPLICATEKW");
                }
                this.key_list = String.valueOf(this.key_list) + this.parm_key + " ";
            }
            if (!this.empty(this.parm_key)) {
                if (this.parm_key_offset <= 1 || this.sub_num != 1 || this.field_num >= 2) continue;
                if (this.parm_key.length() > 8 || !this.isValidName(this.parm_key)) {
                    this.setError(this.parm_key_offset, this.parm_key.length(), "BADSYMPARMNAME");
                    continue;
                }
                this.parm_key_offset = this.setFonts(this.parm_key_offset, this.parm_key.length(), 'y');
                continue;
            }
            this.endOfCard = true;
        } while (!this.endOfCard);
        this.setComments(this.cur_offset);
        return true;
    }

    private void pend_proc() {
        this.ulEClass |= this.classPend;
        this.setComments(this.cur_offset);
    }

    private void output_proc() {
        this.ulEClass |= this.classOutput;
        int i = 79;
        while (i > 0 && this.Etxt.charAt(i) == ' ') {
            --i;
        }
        if (this.Etxt.charAt(i) == ',') {
            this.card &= 0xFFFFFFEF;
        }
    }

    private void xmit_proc() {
        this.ulEClass |= this.classXmit;
    }

    private void cntl_proc() {
        this.ulEClass |= this.classCntl;
        this.setComments(this.cur_offset);
    }

    private void endcntl_proc() {
        this.ulEClass |= this.classEndcntl;
        this.setComments(this.cur_offset);
    }

    private boolean command_proc(String operat) {
        this.ulEClass |= this.classCommand;
        if (!this.empty(this.name) && !operat.equals("COMMAND")) {
            return this.setError(3, this.name.length(), "NOOPERNAME");
        }
        int i = 2;
        while (i < 11) {
            this._currentStyle.setCharAt(i, 'n');
            ++i;
        }
        this.card &= 0xFFFFFFEF;
        if (!this.continuation_proc()) {
            return true;
        }
        this.setComments(this.cur_offset);
        return true;
    }

    private void if_then_proc() {
        this.ulEClass |= this.classCond;
        this.setComments(this.cur_offset);
    }

    private void else_proc() {
        this.ulEClass |= this.classCond;
        this.setComments(this.cur_offset);
    }

    private void endif_proc() {
        this.ulEClass |= this.classCond;
        this.setComments(this.cur_offset);
    }

    private void include_proc() {
        this.ulEClass |= this.classLib;
        this.setComments(this.cur_offset);
    }

    private void jcllib_proc() {
        this.ulEClass |= this.classLib;
        int i = 70;
        while (i >= this.cur_offset - 1 && this.Etxt.charAt(i) == ' ') {
            --i;
        }
        if (this.Etxt.charAt(i) == ',') {
            this.card &= 0xFFFFFFEF;
        }
    }

    private void set_proc() {
        this.ulEClass |= this.classCond;
        int i = 70;
        while (i >= this.cur_offset - 1 && this.Etxt.charAt(i) == ' ') {
            --i;
        }
        if (this.Etxt.charAt(i) == ',') {
            this.card &= 0xFFFFFFEF;
        }
    }

    private boolean jes2_proc() {
        this.ulEClass |= this.classJes2;
        if (this.Etxt.charAt(2) == '$') {
            this.ulEClass |= this.classCommand;
            int i = 0;
            while (i < 71) {
                this._currentStyle.setCharAt(i, 'n');
                ++i;
            }
            return true;
        }
        this.ulEClass |= this.classControl;
        int i = 0;
        while (i < 71) {
            this._currentStyle.setCharAt(i, 'l');
            ++i;
        }
        if (this.name.equals("JOBPARM") || this.name.equals("MESSAGE") || this.name.equals("NETACCT") || this.name.equals("NOTIFY") || this.name.equals("OUTPUT") || this.name.equals("PRIORITY") || this.name.equals("ROUTE") || this.name.equals("SETUP") || this.name.equals("SIGNOFF") || this.name.equals("SIGNON") || this.name.equals("XEQ")) {
            return true;
        }
        if (this.name.equals("XMIT")) {
            return true;
        }
        return this.setError(3, this.name.length(), "JES2CONTROL");
    }

    private boolean jes3_proc() {
        if (this.name.equals("SIGNOFF") || this.name.equals("SIGNON")) {
            this.ulEClass |= this.classJes3 | this.classControl;
            int i = 0;
            while (i < 71) {
                this._currentStyle.setCharAt(i, 'l');
                ++i;
            }
            return false;
        }
        if (this.name.length() > 1) {
            this.name = this.name.substring(1);
            if (!this.empty(this.name) && (this.card & 1) != 0) {
                if (this.name.length() > 1 && this.name.charAt(0) == '*' && "ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(this.name.charAt(1)) >= 0) {
                    this.ulEClass |= this.classJes3 | this.classCommand;
                    int i = 0;
                    while (i < 71) {
                        this._currentStyle.setCharAt(i, 'n');
                        ++i;
                    }
                    return false;
                }
                if (this.name.equals("DATASET") || this.name.equals("ENDDATASET") || this.name.equals("ENDPROCESS") || this.name.equals("FORMAT") || this.name.equals("MAIN") || this.name.equals("NET") || this.name.equals("NETACCT") || this.name.equals("OPERATOR") || this.name.equals("PROCESS") || this.name.equals("ROUTE")) {
                    this.ulEClass |= this.classJes3 | this.classControl;
                    int i = 0;
                    while (i < 71) {
                        this._currentStyle.setCharAt(i, 'l');
                        ++i;
                    }
                    return false;
                }
            }
        }
        if ((this.card & 8) != 0 && (this.card & 1) == 0) {
            this.ulEClass |= this.classJes3 | this.classControl;
            int i = 0;
            while (i < 71) {
                this._currentStyle.setCharAt(i, 'l');
                ++i;
            }
            return false;
        }
        return true;
    }

    private boolean get_next() {
        if (this.endOfSubparameters) {
            this.Esub_p = false;
            this.endOfSubparameters = false;
            this.endOfFields = true;
            this.sub_num = 0;
        }
        if (this.endOfFields) {
            this.field_p = false;
            this.endOfFields = false;
            this.field_num = 0;
        }
        if (!this.insideQuotedString) {
            if (this.field_num > 0) {
                ++this.field_num;
            } else if (this.sub_num > 0) {
                ++this.sub_num;
            } else {
                this.sub_key = "";
                this.sub_key_offset = 1;
                this.parm_key = "";
                this.parm_key_offset = 1;
                ++this.parm_num;
            }
            this.value = "";
            this.symbolic = false;
        }
        int cur = this.cur_offset;
        this.endOfCard = false;
        this.value_offset = 1;
        boolean skip_amper = false;
        String split_value = "";
        int sym_lng = 0;
        block6: while (this.value_offset <= 1) {
            char c = this.Etxt.charAt(cur - 1);
            while (this.insideQuotedString || ",=() ".indexOf(c) < 0) {
                char fc;
                char c1;
                if (c == '&') {
                    if (skip_amper) {
                        skip_amper = false;
                    } else {
                        c1 = this.Etxt.charAt(cur);
                        if (c1 == '&') {
                            skip_amper = true;
                        } else if (!this.parm_key.equals("PARM") && !this.parm_key.equals("PARM.PGM")) {
                            if ("ABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(c1) >= 0 || this.isNational(c1)) {
                                this._currentStyle.setCharAt(cur - 1, 'x');
                                c = c1;
                                ++cur;
                                sym_lng = 1;
                                this.symbolic = true;
                            } else if (!this.insideQuotedString || c1 != '\'') {
                                return this.setError(this.cur_offset, cur - this.cur_offset + 1, "BADSYMPARMNAME");
                            }
                        }
                    }
                }
                if (this.insideQuotedString) {
                    fc = 'q';
                    this.Etxt.setCharAt(cur - 1, this.lotxt.charAt(cur - 1));
                    if (c == '\'') {
                        c1 = this.Etxt.charAt(cur);
                        this.insideQuotedString = false;
                        if (c1 != ',' && c1 != '=' && c1 != '(' && c1 != ')' && c1 != ' ' && c1 != '\'' && c1 != '&') {
                            return this.setError(this.cur_offset, cur - this.cur_offset + 1, "NODELIMITER");
                        }
                    } else if (cur > 71) {
                        if (this.fEesa) {
                            this.cur_offset = cur + 1;
                            this.endOfCard = true;
                            return true;
                        }
                        return this.setError(1, cur, "QUOTE");
                    }
                } else if (c == '\'') {
                    this.insideQuotedString = true;
                    fc = 'q';
                } else {
                    fc = 'v';
                }
                if (sym_lng > 0) {
                    if ("ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890.".indexOf(c) >= 0 || this.isNational(c)) {
                        fc = 'x';
                        sym_lng = c == '.' ? 0 : ++sym_lng;
                        if (sym_lng > 9 && ("ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".indexOf(c) >= 0 || this.isNational(c))) {
                            return this.setError(this.cur_offset, cur - this.cur_offset + 1, "SYMPARMLEN");
                        }
                    } else {
                        sym_lng = 0;
                    }
                }
                if (c == '.' && fc == 'v') {
                    fc = '.';
                }
                this._currentStyle.setCharAt(cur - 1, fc);
                c = this.Etxt.charAt(++cur - 1);
            }
            String token = this.Etxt.substring(this.cur_offset - 1, cur - 1);
            switch (c) {
                case '(': {
                    if (!this.empty(token)) {
                        int i = this.Etxt.substring(cur - 1).indexOf(41) + 1;
                        if (i == 0) {
                            return this.setError(this.cur_offset, 72, "NOCHAR", ")");
                        }
                        token = String.valueOf(token) + this.Etxt.substring(cur - 1, cur - 1 + i);
                        char c1 = this.Etxt.charAt((cur += i) - 1);
                        if (c1 == ',' || c1 == ' ' || c1 == ')' && this.Esub_p) continue block6;
                        return this.setError(this.cur_offset, token.length(), "NODELIMITER");
                    }
                    if (this.field_num > 0) {
                        return this.setError(cur, 1, "BADCHAR", "(");
                    }
                    if (this.Esub_p) {
                        this.field_num = 1;
                        this.field_p = true;
                        this._currentStyle.setCharAt(cur - 1, ')');
                    } else {
                        this.sub_num = 1;
                        this.Esub_p = true;
                        this._currentStyle.setCharAt(cur - 1, '(');
                    }
                    this.cur_offset = ++cur;
                    break;
                }
                case '=': {
                    if (this.field_num > 0) {
                        return this.setError(cur, 1, "BADCHAR", "=");
                    }
                    if (this.sub_num > 0) {
                        this.sub_key = token;
                        this.sub_key_offset = this.cur_offset;
                        this.cur_offset = this.setFonts(this.cur_offset, token.length(), 'b');
                        this._currentStyle.setCharAt(cur - 1, '=');
                    } else {
                        this.parm_key = token;
                        this.parm_key_offset = this.cur_offset;
                        this.sub_num = 1;
                        this.cur_offset = this.setFonts(this.cur_offset, token.length(), 'k');
                        this._currentStyle.setCharAt(cur - 1, '=');
                    }
                    this.cur_offset = ++cur;
                    break;
                }
                case ')': {
                    if (this.empty(this.value)) {
                        this.value = String.valueOf(split_value) + token;
                    }
                    if (this.field_p && !this.endOfFields) {
                        this.endOfFields = true;
                        this._currentStyle.setCharAt(cur - 1, ')');
                    } else if (this.Esub_p && !this.endOfSubparameters) {
                        this.endOfSubparameters = true;
                        this._currentStyle.setCharAt(cur - 1, '(');
                    } else {
                        return this.setError(cur, 1, "BADCHAR", ")");
                    }
                    char c1 = this.Etxt.charAt(++cur - 1);
                    if (c1 == ')' || c1 == ',' || c1 == ' ') continue block6;
                    return this.setError(this.cur_offset, 1, "NODELIMITER");
                }
                case ' ': 
                case ',': {
                    if (this.empty(this.value)) {
                        this.value = String.valueOf(split_value) + token;
                    }
                    this.value_offset = this.cur_offset;
                    if (this.sub_num > 0 && !this.Esub_p) {
                        this.endOfSubparameters = true;
                    }
                    if (this.sub_key_offset > 1 && this.empty(this.sub_key)) {
                        return this.setError(this.value_offset, -1, "NOSUBPARMKW");
                    }
                    if (this.parm_key_offset > 1 && this.empty(this.parm_key)) {
                        return this.setError(this.value_offset, -1, "PARMKWEXPECTED");
                    }
                    if (c == ',') {
                        this._currentStyle.setCharAt(cur - 1, ',');
                        this.cur_offset = ++cur;
                        if (this.Etxt.charAt(cur - 1) != ' ') continue block6;
                        this.endOfCard = true;
                        break;
                    }
                    this.cur_offset = cur;
                    this.endOfCard = true;
                    this.card |= 0x10;
                    if ((!this.field_p || this.endOfFields) && (!this.Esub_p || this.endOfSubparameters)) continue block6;
                    return this.setError(cur, 1, "NOCHAR", ")");
                }
                default: {
                    return this.setError(cur, 1, "NODELIMITER");
                }
            }
        }
        return true;
    }

    private int setFonts(int col, int len, char style) {
        int i = col;
        while (i <= col + len - 1) {
            this._currentStyle.setCharAt(i - 1, style);
            ++i;
        }
        return col + len;
    }

    private void setComments(int col) {
        if (!this.empty(this.Etxt.substring(--col))) {
            int i = col;
            while (i < 71) {
                if (this.Etxt.charAt(i) != ' ') {
                    this._currentStyle.setCharAt(i, 'c');
                }
                ++i;
            }
            if (this._taskTags != null) {
                String text = this.view.elementText(this._currentElement);
                int tt = 0;
                while (tt < this._taskTags.length) {
                    String tag = this._taskTags[tt];
                    if (tag != null && tag.length() != 0) {
                        int t = col;
                        while ((t = text.indexOf(tag, t)) >= 0) {
                            int endColumn = t + tag.length();
                            if (endColumn > 71) break;
                            int x = t;
                            while (x < endColumn) {
                                this._currentStyle.setCharAt(x, '$');
                                ++x;
                            }
                            this.ulEClass |= this.classCommentTask;
                            t = endColumn;
                        }
                    }
                    ++tt;
                }
            }
        }
    }

    private boolean setValueError(String msg) {
        return this.setError(this.value_offset, this.value.length(), msg, null);
    }

    private boolean setValueError(String msg, String arg) {
        return this.setError(this.value_offset, this.value.length(), msg, arg);
    }

    private boolean setError(int col, int len, String msg) {
        return this.setError(col, len, msg, null);
    }

    private boolean setError(int col, int lng, String msgId, String pcSubst) {
        this.ulEClass |= this.classError;
        if (lng < 0) {
            col = col <= (lng = 0 - lng) ? 1 : col - lng;
        } else if (lng == 0) {
            lng = 1;
        }
        boolean nb = false;
        int i = col;
        while (i < col + lng && i > 0 && i <= 80) {
            this._currentStyle.setCharAt(i - 1, this.STYLE_ERROR);
            if (this.Etxt.charAt(i - 1) != ' ') {
                nb = true;
            }
            ++i;
        }
        if (!nb) {
            i = col - 1 < 80 ? col - 1 : 80;
            while (i > 0 && this.Etxt.charAt(i - 1) == ' ') {
                this._currentStyle.setCharAt(i - 1, this.STYLE_ERROR);
                --col;
                ++lng;
                --i;
            }
        }
        if (col > this.Etxtl && (col = this.Etxtl) > 0) {
            this._currentStyle.setCharAt(col - 1, this.STYLE_ERROR);
        }
        msgId = "JCL." + msgId;
        this.addMessage(this._currentElement, pcSubst == null ? LpexResources.message((ResourceBundle)_resources, (String)msgId) : LpexResources.message((ResourceBundle)_resources, (String)msgId, (String)pcSubst));
        return false;
    }

    private boolean isValueIn(String list) {
        return list.indexOf(String.valueOf(' ') + this.value + ' ') >= 0;
    }

    private boolean isValidName(String token) {
        if (token.length() == 0 || token.length() > 8) {
            return false;
        }
        if (this.verifyNational(token, "ABCDEFGHIJKLMNOPQRSTUVWXYZ", "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789") == 0) {
            return true;
        }
        char c = token.charAt(0);
        if (!this.isNational(c) && Character.getType(c) != 1) {
            return false;
        }
        int i = 1;
        while (i < token.length()) {
            c = token.charAt(i);
            if (!this.isNational(c) && Character.getType(c) != 1 && Character.getType(c) != 9) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isValidNameWithPeriod(String token) {
        int i = token.indexOf(46);
        if (i < 0) {
            return this.isValidName(token);
        }
        return this.isValidName(token.substring(0, i)) && this.isValidName(token.substring(i + 1));
    }

    private boolean isValidCode(String token) {
        return token.length() != 0 && token.length() <= 4 && this.verifyNational(token, "ABCDEFGHIJKLMNOPQRSTUVWXYZ", "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789") == 0;
    }

    private boolean isValidFormName(String token) {
        return token.length() != 0 && token.length() <= 4 && this.verifyNational(token, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789") == 0;
    }

    private boolean isValidDsName(String token) {
        return true;
    }

    private boolean isBackReference(String token) {
        return true;
    }

    private boolean isValidClass(String token) {
        if (token.length() == 0 || token.length() > 8 || "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".indexOf(token.charAt(0)) < 0) {
            return false;
        }
        return this.verifyNational(token.substring(1, token.length()), "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789") == 0;
    }

    private boolean isNumber(String token, int min, int max) {
        if (token.length() == 0 || token.length() > 8 || this.verify(token, "0123456789") != 0) {
            return false;
        }
        int i = Integer.parseInt(token);
        return i >= min && i <= max;
    }

    private boolean isValidTsoUserId(String token) {
        if (token.equals("*") || token.equals("&SYSUID") || token.equals("&SYSUID.")) {
            return true;
        }
        return token.length() > 0 && token.length() < 8 && this.verifyNational(token, "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789") == 0;
    }

    private boolean isValidPassword(String token) {
        return token.length() == 0 || token.equals("*") || token.equals("????????") || token.length() <= 8 && this.isMixedAlphanumericNational(token);
    }

    private boolean mux_test(String token) {
        String key = token.equals("DSN") ? "DSNAME" : (token.equals("VOL") ? "VOLUME" : (token.length() < 9 ? token : "         "));
        int ix = this.indexStr(keytbl, key);
        this.Ekey_num = (ix - 1) / 9;
        if (this.Ekey_num == 0 || ix != this.Ekey_num * 9 - 8) {
            return true;
        }
        return true;
    }

    private boolean dd_lvl_test(int num) {
        char lvl = lvl_mask.charAt(num - 1);
        if (lvl == ' ') {
            if (this.Esub_p && !this.parm_key.equals("DCB") || this.field_p) {
                return this.setError(this.value_offset - 1, 1, "BADPARMVALUELIST");
            }
        } else {
            int mxp;
            int c = this.sub_num >= 6 ? 54 : (this.sub_num == 5 ? 53 : (this.sub_num == 4 ? 52 : (this.sub_num == 3 ? 51 : (this.sub_num == 2 ? 50 : (this.sub_num == 1 ? 49 : 48)))));
            if (c > (mxp = mxp_mask.charAt(num - 1))) {
                return this.setError(this.value_offset - 1, 1, "LISTPARMS");
            }
            if (lvl == 'S' && this.field_p) {
                return this.setError(this.value_offset - 1, 1, "SUBPARMVALUELIST");
            }
            if (lvl == 'F' && (num == 6 && this.sub_num == 1 && this.field_p || num == 8 && this.field_num > 2 && (this.sub_key.equals("PCI") || this.sub_key.equals("RESERVE")) || num == 8 && this.field_p && !this.sub_key.equals("PCI") && !this.sub_key.equals("RESERVE") || num == 28 && this.sub_num == 2 && this.field_num > 2 || num == 28 && this.sub_num != 2 && this.field_p || num == 34 && this.field_p && !this.sub_key.equals("SER"))) {
                return this.setError(this.value_offset - 1, 1, "SUBPARMVALUELIST");
            }
        }
        return true;
    }

    private String extractToken(String text) {
        StringTokenizer st = new StringTokenizer(text);
        return st.hasMoreTokens() ? st.nextToken() : "";
    }

    private int verify(String text, String charset) {
        int i = 0;
        while (i < text.length()) {
            if (charset.indexOf(text.charAt(i)) < 0) {
                return i + 1;
            }
            ++i;
        }
        return 0;
    }

    private boolean isMixedAlphanumericNational(String text) {
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (!this.isMixedAlphanumeric(c) && !this.isNational(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int verifyNational(String text, String charset) {
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (charset.indexOf(c) < 0 && !this.isNational(c)) {
                return i + 1;
            }
            ++i;
        }
        return 0;
    }

    private int verifyNational(String text, String charset0, String charset) {
        char c = text.charAt(0);
        if (charset0.indexOf(c) < 0 && !this.isNational(c)) {
            return 1;
        }
        int i = 1;
        while (i < text.length()) {
            c = text.charAt(i);
            if (charset.indexOf(c) < 0 && !this.isNational(c)) {
                return i + 1;
            }
            ++i;
        }
        return 0;
    }

    private boolean isMixedAlphanumeric(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    private boolean isNational(char c) {
        return c == this.NATIONAL.charAt(0) || c == this.NATIONAL.charAt(1) || c == this.NATIONAL.charAt(2);
    }

    private boolean empty(String text) {
        return text.length() == 0 || text.trim().length() == 0;
    }

    private int indexStr(String list, String str) {
        return list.indexOf(str) + 1;
    }

    private int indexStrBB(String list, String str) {
        return list.indexOf(String.valueOf(' ') + str + ' ') + 1;
    }

    private int findJCLWord(String[] table, String word) {
        int i = 0;
        while (i < table.length) {
            if (table[i].equals(word)) {
                return i + 1;
            }
            ++i;
        }
        return 0;
    }

    private int programmerNameLength(String programmerName) {
        int len = 0;
        int lastChar = programmerName.length() - 1;
        int i = 0;
        while (i <= lastChar) {
            if (programmerName.charAt(i) == '\'') {
                if (i != 0 && i != lastChar) {
                    if (programmerName.charAt(i + 1) == '\'') {
                        ++i;
                    }
                    ++len;
                }
            } else {
                ++len;
            }
            ++i;
        }
        return len;
    }

    protected void blockMarkWord() {
        this.view.doDefaultCommand("block clear");
        LpexDocumentLocation loc = this.view.documentLocation();
        LpexDocumentLocation s = this.tokenBegin(loc);
        if (s != null) {
            LpexDocumentLocation e = this.tokenEnd(loc);
            String style = this.view.elementStyle(s.element);
            char curStyle = style.charAt(loc.position - 1);
            while (curStyle == '.' && loc.position > 0) {
                curStyle = style.charAt(--loc.position - 1);
            }
            if (loc.position > 0) {
                if (loc.position != this.view.documentLocation().position) {
                    s = this.tokenBegin(loc);
                    e = this.tokenEnd(loc);
                }
                while (s.position > 1 && style.charAt(s.position - 2) == '.') {
                    LpexDocumentLocation start = this.tokenBegin(new LpexDocumentLocation(s.element, s.position - 2));
                    if (style.charAt(start.position - 1) != curStyle) break;
                    s = start;
                }
                while (e.position < style.length() && style.charAt(e.position) == '.') {
                    LpexDocumentLocation end = this.tokenEnd(new LpexDocumentLocation(e.element, e.position + 2));
                    if (style.charAt(end.position - 1) != curStyle) break;
                    e = end;
                }
                String type = this.view.query("current.block.defaultType");
                if ("element".equals(type)) {
                    type = "stream";
                }
                if ("stream".equals(type)) {
                    ++e.position;
                }
                this.view.jump(e);
                this.view.doDefaultCommand(s, "block set " + type);
                this.view.doDefaultCommand("block set");
                return;
            }
        }
        super.blockMarkWord();
    }

    private boolean continuation_proc() {
        int cur = this.cur_offset;
        this.endOfCard = false;
        char c = this.Etxt.charAt(cur - 1);
        while (this.insideQuotedString || c != ' ') {
            char fc;
            if (this.insideQuotedString) {
                fc = 'q';
                this.Etxt.setCharAt(cur - 1, this.lotxt.charAt(cur - 1));
                if (c == '\'') {
                    char c1 = this.Etxt.charAt(cur);
                    if (c1 != '\'') {
                        this._currentStyle.setCharAt(cur - 1, fc);
                        this.insideQuotedString = false;
                        this.cur_offset = cur + 1;
                        this.endOfCard = true;
                        this.card |= 0x10;
                        return true;
                    }
                    this._currentStyle.setCharAt(cur - 1, fc);
                    this._currentStyle.setCharAt(++cur - 1, fc);
                    c = this.Etxt.charAt(++cur - 1);
                    continue;
                }
                if (cur > 71) {
                    if (this.fEesa) {
                        this.cur_offset = cur + 1;
                        this.endOfCard = true;
                        return true;
                    }
                    return this.setError(1, cur, "QUOTE");
                }
            } else if (c == '\'') {
                this.insideQuotedString = true;
                fc = 'q';
            } else {
                fc = 'c';
            }
            this._currentStyle.setCharAt(cur - 1, fc);
            c = this.Etxt.charAt(++cur - 1);
        }
        this.endOfCard = true;
        this.card |= 0x10;
        return true;
    }
}

