/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.rse.debug;

import com.ibm.ftt.rse.debug.extensionpoints.IDebugEngineLauncher;
import com.ibm.ftt.rse.debug.subsystems.DebugSubSystem;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.osgi.framework.Bundle;

public class DebugSubSystemUtil {
    private static Map<String, IDebugEngineLauncher> _debugEngineLaunchers = new HashMap<String, IDebugEngineLauncher>();

    public static DebugSubSystem getDebugSubSystem(IHost host) {
        if (host != null) {
            ISubSystem[] sses = host.getSubSystems();
            int s = 0;
            while (s < sses.length) {
                ISubSystem ss = sses[s];
                if (ss instanceof DebugSubSystem) {
                    return (DebugSubSystem)ss;
                }
                ++s;
            }
        }
        return null;
    }

    public static String getDBMVersion(IHost host) {
        DebugSubSystem ss = DebugSubSystemUtil.getDebugSubSystem(host);
        if (ss != null) {
            return ss.getDBMVersion();
        }
        return null;
    }

    public static IDebugEngineLauncher getDebugEngineLauncher(String id) {
        IExtensionRegistry registry;
        IConfigurationElement[] elements;
        if ((_debugEngineLaunchers.isEmpty() || !_debugEngineLaunchers.containsKey(id)) && (elements = (registry = Platform.getExtensionRegistry()).getConfigurationElementsFor("com.ibm.ftt.rse.debug", "debugEngineLaunchers")) != null && elements.length > 0) {
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                if ("debugEngineLauncher".equals(element.getName())) {
                    Bundle bundle;
                    String nameSpace = element.getDeclaringExtension().getNamespaceIdentifier();
                    String engineLauncherClass = element.getAttribute("class");
                    String engineId = element.getAttribute("id");
                    if (!_debugEngineLaunchers.containsKey(engineId) && (bundle = Platform.getBundle((String)nameSpace)).getState() != 1) {
                        try {
                            Class dbEngineLauncherExtension = bundle.loadClass(engineLauncherClass);
                            IDebugEngineLauncher launcher = (IDebugEngineLauncher)dbEngineLauncherExtension.newInstance();
                            _debugEngineLaunchers.put(engineId, launcher);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                ++i;
            }
        }
        return _debugEngineLaunchers.get(id);
    }
}

