/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.apa.pdtools.connection;

import com.banknet.apa.pdtools.ApaPdtoolsPlugin;
import com.banknet.apa.pdtools.connection.ApaConnectionExtension;
import com.banknet.apa.pdtools.connection.Messages;
import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.internal.Constants;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.core.util.PDUtils;
import com.ibm.pdtools.common.component.jhost.comms.AuthDetails;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import com.ibm.pdtools.common.component.jhost.comms.IPDToolsConnectionRequestListener2;
import com.ibm.pdtools.common.component.jhost.comms.TheHost;
import com.ibm.pdtools.common.component.jhost.util.IHowIsGoing;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPage;

public class ApaConnectionRequestListener
implements IPDToolsConnectionRequestListener2 {
    Constants constants = new Constants();
    ApaConnectionExtension connextension;
    ZosConnect zosconnect = new ZosConnect();
    public static final String APA_CONNECTION_CONFIG = "APA";
    private int delayMs = 0;
    private HostDetails activeHost;
    DecimalFormat portdecfmt = new DecimalFormat("#####");

    public ApaConnectionRequestListener() {
        this.connextension = new ApaConnectionExtension();
    }

    public void connect(String arg0, List<String> arg1) {
        boolean apaConfigured = false;
        int i = 0;
        while (i < arg1.size()) {
            if (arg1.get(i).equalsIgnoreCase(APA_CONNECTION_CONFIG)) {
                apaConfigured = true;
                break;
            }
            ++i;
        }
        if (!apaConfigured) {
            return;
        }
        this.connect(arg0);
    }

    public void connect(String arg0) {
        final String hostid = arg0;
        if (this.zosconnect.getAHostById(arg0) != null) {
            return;
        }
        this.forceCancelZos(CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId"));
        if (ApaPdtoolsPlugin.getDefault().connectHostInProgress.length() <= 0) {
            ApaPdtoolsPlugin.getDefault().connectHostInProgress = hostid;
        } else if (ApaPdtoolsPlugin.getDefault().connectHostInProgress.equals(hostid)) {
            return;
        }
        CorePlugin.getDefault().connectedHosts.add(hostid);
        String logstr = "connect:  ADFz Connect Request " + arg0;
        System.out.println("ApaConnectionRequestListener - " + logstr);
        CorePlugin.getDefault().log.info(logstr);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ApaConnectionRequestListener.this.pdToolsConnect(hostid);
            }
        });
    }

    public void disconnect(String arg0) {
        HostDetails discHost = this.getHostById(arg0);
        if (this.zosconnect.getAHostById(arg0) != null && discHost != null) {
            String logstr = "disconnect:  ADFz Disconnect Request " + arg0;
            System.out.println("ApaConnectionRequestListener - " + logstr);
            CorePlugin.getDefault().log.info(logstr);
            ApaPdtoolsPlugin.getDefault().connectHostInProgress = "";
            CorePlugin.getDefault().connectedHosts.remove(arg0);
            this.connextension.disconnectZosJob();
        }
    }

    public HostDetails getHostById(String s) {
        for (HostDetails host : ConnectionUtilities.getSystemInformation()) {
            if (!host.getHostID().equals(s)) continue;
            return host;
        }
        return null;
    }

    public void pdToolsConnect(String arg0) {
        this.activeHost = this.getHostById(arg0);
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    WorkbenchPage workbenchPage;
                    try {
                        String logstr = "pdToolsConnect:  Establishing ADFz/APA Connection, connecting to APA:" + ApaConnectionRequestListener.this.activeHost.getHostname() + ":" + ApaConnectionRequestListener.this.activeHost.getPortNumber();
                        System.out.println("ApaConnectionRequestListener - " + logstr);
                        CorePlugin.getDefault().log.info(logstr);
                        ApaPdtoolsPlugin.getDefault().howIsGoing = PDUtils.convertIprogressToIHowIsGoing((IProgressMonitor)monitor);
                        ApaPdtoolsPlugin.getDefault().nbsio = ConnectionUtilities.newConnection((HostDetails)ApaConnectionRequestListener.this.activeHost, (String)ApaConnectionRequestListener.APA_CONNECTION_CONFIG, null, (IHowIsGoing)ApaPdtoolsPlugin.getDefault().howIsGoing);
                        CorePlugin.getDefault().session.socket = ApaPdtoolsPlugin.getDefault().nbsio.getSocket();
                        CorePlugin.getDefault().session.inputstream = CorePlugin.getDefault().session.socket.getInputStream();
                        CorePlugin.getDefault().session.outputstream = CorePlugin.getDefault().session.socket.getOutputStream();
                        int socketBufferSize = CorePlugin.getDefault().session.socket.getReceiveBufferSize() * 4;
                        CorePlugin.getDefault().session.responseArray = new byte[socketBufferSize];
                        ApaConnectionRequestListener.this.logServerProperties();
                        CorePlugin.getDefault().getPreferenceStore().setValue("activeConnectionId", ApaConnectionRequestListener.this.activeHost.getHostID());
                        ApaPdtoolsPlugin.getDefault().monitor = monitor;
                        CorePlugin.getDefault().getPreferenceStore().setValue("coreConnected", false);
                        ApaConnectionRequestListener.this.setLogonVars();
                        ApaConnectionRequestListener.this.zosconnect.logonZos();
                        if (ApaConnectionRequestListener.this.zosconnect.connrc == 0) {
                            ApaPdtoolsPlugin.getDefault().connectHostInProgress = "";
                            CorePlugin.getDefault().getPreferenceStore().setValue("coreConnected", true);
                            ApaConnectionRequestListener.this.zosconnect.loadModelsJob();
                        } else {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("ApaConnection.MessageDiaCorePlugin.getDefault().log.errorTitle.ConnectionFailed"), (String)(this).ApaConnectionRequestListener.this.zosconnect.errmsg);
                                }
                            });
                            logstr = "pdToolsConnect:  APA Connection Error Reason :  " + ApaConnectionRequestListener.this.zosconnect.connrsn + ", Message :  " + ApaConnectionRequestListener.this.zosconnect.errmsg;
                            System.out.println("ApaConnectionRequestListener - " + logstr);
                            CorePlugin.getDefault().log.error(logstr);
                            ApaConnectionRequestListener.this.disconnect(ApaConnectionRequestListener.this.activeHost.getHostID());
                        }
                    }
                    catch (Exception e) {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("ApaConnection.MessageDiaCorePlugin.getDefault().log.errorTitle.ConnectionFailed"), (String)("Error establishing connection to APA server, reference log for details\n" + (this).ApaConnectionRequestListener.this.zosconnect.errmsg));
                            }
                        });
                        String logstr = "pdToolsConnect:  Connection Exception :  " + e.getMessage();
                        System.out.println("ApaConnectionRequestListener - " + logstr);
                        CorePlugin.getDefault().log.error(logstr);
                        ApaConnectionRequestListener.this.disconnect(ApaConnectionRequestListener.this.activeHost.getHostID());
                        throw new InvocationTargetException(e);
                    }
                    IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (workbenchWindow != null && (workbenchPage = (WorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null && workbenchPage.getPerspective().getId().contains("banknet")) {
                        CorePlugin.getDefault().getPreferenceStore().setValue("stcRefresh", true);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            String logstr = "pdToolsConnect: InvocationTargetException :  " + String.valueOf(e);
            System.out.println("ApaConnectionRequestListener - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        catch (InterruptedException e) {
            String logstr = "pdToolsConnect: InterruptedException :  " + String.valueOf(e);
            System.out.println("ApaConnectionRequestListener - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    private void setLogonVars() {
        try {
            TheHost host = new TheHost(this.activeHost);
            AuthDetails auth = ConnectionUtilities.getLogin((TheHost)host, (IHowIsGoing)ApaPdtoolsPlugin.getDefault().howIsGoing);
            CorePlugin.getDefault().tsoid = auth.getUsername();
        }
        catch (Exception e) {
            String logstr = "setLogonVars: Exception retrieving ADFz AuthDetails :  " + String.valueOf(e);
            System.out.println("ApaConnectionRequestListener - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        this.zosconnect.shostAddress = this.activeHost.getHostname();
        this.zosconnect.scpuPort = this.constants.portdecfmt.format(this.activeHost.getPortNumber());
        this.zosconnect.sslConnect = this.activeHost.isSecured();
    }

    public void forceCancelZos(String hostid) {
        final String hostId = hostid;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                String logstr = "Forcing Termination of ADFz/APA Connection";
                System.out.println("ApaConnectionRequestListener - " + logstr);
                CorePlugin.getDefault().log.debug(logstr);
                if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0 && !ApaPdtoolsPlugin.getDefault().nbsio.isClosed()) {
                    CorePlugin.getDefault().session.doCmdResp("SHUTDOWN", CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
                }
                try {
                    if (ApaPdtoolsPlugin.getDefault().nbsio != null) {
                        ApaPdtoolsPlugin.getDefault().nbsio.closeConnection();
                    }
                    CorePlugin.getDefault().session.endSession();
                    ApaPdtoolsPlugin.getDefault().connectHostInProgress = "";
                }
                catch (Exception exception) {
                    System.out.println("forceCancelZos, Force zOS return code is " + String.valueOf(CorePlugin.getDefault().session.getDoCmdRespRc()));
                    CorePlugin.getDefault().log.debug("forceCancelZos, Force zOS return code is " + String.valueOf(CorePlugin.getDefault().session.getDoCmdRespRc()));
                    ApaConnectionRequestListener.this.zosconnect.setConnectLocal();
                    ApaConnectionRequestListener.this.zosconnect.connectZos();
                }
                CorePlugin.getDefault().connectedHosts.remove(hostId);
            }
        });
    }

    private void logServerProperties() {
        Object logstr = "**** ADFz HOST CONNECTION PROPERTIES ****";
        System.out.println("ApaConnectionRequestListener - " + (String)logstr);
        CorePlugin.getDefault().log.info((String)logstr);
        logstr = "com.ibm.pdtools.common.component.core Version: " + String.valueOf(Platform.getBundle((String)"com.ibm.pdtools.common.component.core").getVersion());
        System.out.println("ApaConnectionRequestListener - " + (String)logstr);
        CorePlugin.getDefault().log.info((String)logstr);
        logstr = "com.ibm.pdtools.common.component.jhost Version: " + String.valueOf(Platform.getBundle((String)"com.ibm.pdtools.common.component.jhost").getVersion());
        System.out.println("ApaConnectionRequestListener - " + (String)logstr);
        CorePlugin.getDefault().log.info((String)logstr);
        logstr = "Connection Name: " + this.activeHost.getConnectionName();
        System.out.println("ApaConnectionRequestListener - " + (String)logstr);
        CorePlugin.getDefault().log.info((String)logstr);
        logstr = "Description: " + this.activeHost.getDescription();
        System.out.println("ApaConnectionRequestListener - " + (String)logstr);
        CorePlugin.getDefault().log.info((String)logstr);
        logstr = "Default Encoding: " + this.activeHost.getHostDefaultEncoding();
        System.out.println("ApaConnectionRequestListener - " + (String)logstr);
        CorePlugin.getDefault().log.info((String)logstr);
        logstr = "Host ID: " + this.activeHost.getHostID();
        System.out.println("ApaConnectionRequestListener - " + (String)logstr);
        CorePlugin.getDefault().log.info((String)logstr);
        logstr = "Host Name: " + this.activeHost.getHostname();
        System.out.println("ApaConnectionRequestListener - " + (String)logstr);
        CorePlugin.getDefault().log.info((String)logstr);
        logstr = "Port Number: " + this.activeHost.getPortNumber();
        System.out.println("ApaConnectionRequestListener - " + (String)logstr);
        CorePlugin.getDefault().log.info((String)logstr);
        CorePlugin.getDefault().session.CommonServerPort = this.portdecfmt.format(this.activeHost.getPortNumber());
        Map hostprops = this.activeHost.getServerProperties();
        for (String key : hostprops.keySet()) {
            logstr = key + ": " + (String)hostprops.get(key);
            System.out.println("ApaConnectionRequestListener - " + (String)logstr);
            CorePlugin.getDefault().log.info((String)logstr);
            if (key.equals("SERVERNAME")) {
                CorePlugin.getDefault().session.CommonServerName = (String)hostprops.get(key);
                continue;
            }
            if (key.equals("SERVERVERSION")) {
                CorePlugin.getDefault().session.CommonServerVersion = (String)hostprops.get(key);
                continue;
            }
            if (!key.equals("RELEASE")) continue;
            CorePlugin.getDefault().session.CommonServerRelease = (String)hostprops.get(key);
        }
        logstr = "**** ADFz HOST CONNECTION PROPERTIES   END ****";
        System.out.println("ApaConnectionRequestListener - " + (String)logstr);
        CorePlugin.getDefault().log.info((String)logstr);
    }
}

