/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.apa.pdtools.connection;

import com.banknet.apa.pdtools.ApaPdtoolsPlugin;
import com.banknet.apa.pdtools.connection.ApaConnectionRequestListener;
import com.banknet.apa.pdtools.connection.Messages;
import com.banknet.core.CorePlugin;
import com.banknet.core.connection.IConnectionExtension;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.data.reports.ObservationReports;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.ZosSession;
import com.banknet.core.models.StcModel;
import com.ibm.pdtools.common.component.core.comms.ConnectionUtilities;
import com.ibm.pdtools.common.component.jhost.comms.HostDetails;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ApaConnectionExtension
implements IConnectionExtension {
    ZosConnect zosconnect = new ZosConnect();
    WorkbenchPage workbenchPage;
    ApaConnectionRequestListener connreq;
    Constants constants = new Constants();
    String connectionid = "";
    String connectionname = "";
    String servername = "";
    String portname = "";
    boolean isRemote = false;
    HostDetails host;
    Image imgConnect = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/obj/osprc_obj.gif").createImage();
    Image imgDisconnect = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/obj/osprct_obj.gif").createImage();
    public IMenuCreator connectionsMenuCreator = new IMenuCreator(){
        private Menu menu;

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            String actiontxt;
            MenuItem item;
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            for (HostDetails ApaConnectionExtension.this.host : ConnectionUtilities.getSystemInformation()) {
                if (!ConnectionUtilities.connectionExists((String)ApaConnectionExtension.this.host.getHostID())) continue;
                item = new MenuItem(this.menu, 32);
                actiontxt = Messages.getString("ConnectionExtension.Action.Start");
                actiontxt = actiontxt.replace("#connectionname", ApaConnectionExtension.this.host.getDescription());
                item.setText(actiontxt);
                item.setData((Object)ApaConnectionExtension.this.host.getHostID());
                item.setImage(ApaConnectionExtension.this.imgConnect);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MenuItem item = (MenuItem)e.widget;
                        String selhostid = (String)item.getData();
                        if ((this).ApaConnectionExtension.this.connreq == null) {
                            (this).ApaConnectionExtension.this.connreq = new ApaConnectionRequestListener();
                        }
                        (this).ApaConnectionExtension.this.connreq.connect(selhostid);
                    }
                });
                item.setEnabled(true);
            }
            item = new MenuItem(this.menu, 32);
            actiontxt = Messages.getString("ConnectionExtension.Action.Stop");
            item.setText(actiontxt);
            item.setData((Object)"stop");
            item.setImage(ApaConnectionExtension.this.imgDisconnect);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ApaConnectionExtension.this.disconnectZosJob();
                }
            });
            item.setEnabled(true);
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return this.menu;
        }
    };

    public ApaConnectionExtension() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            this.workbenchPage = (WorkbenchPage)workbenchWindow.getActivePage();
        }
    }

    public void createConnectionListener() {
    }

    public String getConnectionPartKey(String key) {
        String partkey = "";
        return partkey;
    }

    public void setConnectionStatus(IViewSite viewsite) {
    }

    public int zosRead(String command, IProgressMonitor monitor) {
        ByteBuffer tempBuffer;
        int numBytesRead = 0;
        int totalBytesRead = 0;
        int byteCounter = 0;
        float fbyteCounter = 0.0f;
        ZosSession cfr_ignored_0 = CorePlugin.getDefault().session;
        int headerLength = ZosSession.tcpipHeaderOffset;
        int maxDumpLength = 1000;
        int saveHeaderLength = 1000;
        int blockSize = 0;
        try {
            blockSize = CorePlugin.getDefault().session.socket.getReceiveBufferSize();
        }
        catch (SocketException socketException) {}
        byte[] tempArray = new byte[blockSize];
        DecimalFormat decfmt = new DecimalFormat("###,###,###,##0");
        if (monitor == null) {
            monitor = ApaPdtoolsPlugin.getDefault().monitor;
        }
        try {
            numBytesRead = ApaPdtoolsPlugin.getDefault().nbsio.readBytes(tempArray, 0, headerLength, ApaPdtoolsPlugin.getDefault().howIsGoing);
            tempBuffer = ByteBuffer.wrap(tempArray, 0, numBytesRead);
            totalBytesRead = numBytesRead;
        }
        catch (Exception exception) {
            CorePlugin.getDefault().session.doCmdResp_rc = -99;
            this.logMessage('I', "Command : " + command + " exception while reading z/OS Response Header.  Numbytes read : " + totalBytesRead);
            if (totalBytesRead > 0) {
                this.dumpMessage("zosREAD", tempArray, Integer.toString(totalBytesRead));
            }
            return -1;
        }
        if (numBytesRead < headerLength) {
            this.logMessage('I', "Command : " + command + " Unable to receive complete z/OS Response Header.  Bytes read: " + numBytesRead);
            if (totalBytesRead > 0) {
                this.dumpMessage("zosREAD", tempArray, Integer.toString(totalBytesRead));
            }
            return -1;
        }
        String sValue = new String(tempArray, 0, 10).trim();
        int firstDigitComplete = 0;
        int messageLength = Integer.parseInt(sValue);
        int respHeaderLen = Integer.parseInt(sValue) - headerLength;
        byte[] messageArray = new byte[messageLength];
        String qualifiedFName = CorePlugin.getDefault().session.queueFile(command);
        FileOutputStream foutWorkspace = null;
        FileChannel fcoutWorkspace = null;
        try {
            foutWorkspace = new FileOutputStream(qualifiedFName);
            fcoutWorkspace = foutWorkspace.getChannel();
        }
        catch (Exception exception) {
            this.logMessage('I', "Command : " + command + ".  Unable to allocate file " + qualifiedFName);
            return -1;
        }
        try {
            fcoutWorkspace.write(tempBuffer);
            System.arraycopy(tempArray, 0, messageArray, 0, headerLength);
        }
        catch (Exception exception) {
            this.logMessage('I', "Command : " + command + " Unable to persist z/OS Response Header ");
            try {
                foutWorkspace.close();
            }
            catch (Exception exception2) {
                this.logMessage('I', "Command : " + command + ".  Unable to close file " + qualifiedFName);
            }
            return -1;
        }
        int bytesToRead = 0;
        bytesToRead = respHeaderLen > blockSize ? blockSize : respHeaderLen;
        while (totalBytesRead < messageLength) {
            tempBuffer.clear();
            try {
                numBytesRead = ApaPdtoolsPlugin.getDefault().nbsio.readBytes(tempArray, 0, bytesToRead, ApaPdtoolsPlugin.getDefault().howIsGoing);
                if (numBytesRead < 0) break;
                tempBuffer = ByteBuffer.wrap(tempArray, 0, numBytesRead);
                fcoutWorkspace.write(tempBuffer);
                System.arraycopy(tempArray, 0, messageArray, totalBytesRead, numBytesRead);
                totalBytesRead += numBytesRead;
            }
            catch (InterruptedException interruptedException) {
                CorePlugin.getDefault().session.doCmdResp_rc = -99;
                this.logMessage('I', "Command : " + command + " was Interupted  while reading z/OS Response");
                try {
                    foutWorkspace.close();
                    return -1;
                }
                catch (Exception exception) {
                    this.logMessage('I', "Command : " + command + ".  Unable to close file " + qualifiedFName);
                }
            }
            catch (Exception exception) {
                this.logMessage('I', "Command : " + command + " Error Reading z/OS Response  ");
                try {
                    foutWorkspace.close();
                    return -1;
                }
                catch (Exception exception3) {
                    this.logMessage('I', "Command : " + command + ".  Unable to close file " + qualifiedFName);
                }
            }
            bytesToRead = messageLength - totalBytesRead > blockSize ? blockSize : messageLength - totalBytesRead;
            fbyteCounter = new Float(byteCounter += numBytesRead).floatValue();
            float frespHeaderLen = new Float(respHeaderLen).floatValue();
            int percentComplete = (int)(fbyteCounter / frespHeaderLen * 100.0f);
            int saveFirstDigit = firstDigitComplete;
            firstDigitComplete = percentComplete / 10;
            if (firstDigitComplete == saveFirstDigit || !(monitor != null & command.equalsIgnoreCase("GETOBSREPORTS") & respHeaderLen > 60)) continue;
            String cfr_ignored_1 = "\n" + decfmt.format(fbyteCounter) + Messages.getString("ZosConnectionUtilities.Job.SubTask.Of") + decfmt.format(frespHeaderLen) + Messages.getString("ZosConnectionUtilities.Job.SubTask.BytesDownloaded");
            monitor.subTask(Messages.getString("ConnectionExtension.Job.SubTask.Step2of3") + percentComplete + Messages.getString("ConnectionExtension.Job.SubTask.PctComplete") + "\n" + decfmt.format(fbyteCounter) + Messages.getString("ConnectionExtension.Job.SubTask.Of") + decfmt.format(frespHeaderLen) + Messages.getString("ConnectionExtension.Job.SubTask.BytesDownloaded"));
            monitor.worked(5);
        }
        try {
            fcoutWorkspace.close();
            fcoutWorkspace = null;
            foutWorkspace.close();
            foutWorkspace = null;
        }
        catch (Exception exception) {
            this.logMessage('I', "Command : " + command + ".  Unable to close files.");
        }
        ZosSession cfr_ignored_2 = CorePlugin.getDefault().session;
        ZosSession.headerBuffer.clear();
        if (messageArray.length >= saveHeaderLength) {
            this.dumpMessage("zosREAD", messageArray, Integer.toString(maxDumpLength));
            ZosSession cfr_ignored_3 = CorePlugin.getDefault().session;
            ZosSession.headerBuffer.put(messageArray, 0, saveHeaderLength);
        } else {
            this.dumpMessage("zosREAD", messageArray, Integer.toString(messageArray.length - 1));
            ZosSession cfr_ignored_4 = CorePlugin.getDefault().session;
            ZosSession.headerBuffer.put(messageArray, 0, messageArray.length - 1);
        }
        return totalBytesRead;
    }

    public int zosWrite(byte[] bnetMessage, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = ApaPdtoolsPlugin.getDefault().monitor;
        }
        int writeRC = 0;
        if (CorePlugin.getDefault().log.isDebugEnabled()) {
            this.dumpMessage("zosWrite", bnetMessage, Integer.toString(bnetMessage.length));
        }
        try {
            ApaPdtoolsPlugin.getDefault().nbsio.writeBytes(bnetMessage, 0, bnetMessage.length, ApaPdtoolsPlugin.getDefault().howIsGoing);
        }
        catch (Exception e) {
            this.logMessage('E', "zosWrite exception : " + String.valueOf(e));
            writeRC = -1;
        }
        return writeRC;
    }

    public void disconnectZosJob() {
        Job job0 = new Job(Messages.getString("DisconnectAction.Job.Title.DisconnectZos")){

            public IStatus run(IProgressMonitor monitor) {
                IStatus disconnectStatus = ApaConnectionExtension.this.disconnectZos(monitor);
                return disconnectStatus;
            }
        };
        job0.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("disconnectZos, Disconnect zOS job completed successfully");
                    CorePlugin.getDefault().log.debug("disconnectZos, Disconnect zOS job completed successfully");
                } else {
                    System.out.println("disconnectZos, Disconnect zOS job did not complete successfully");
                    CorePlugin.getDefault().log.debug("disconnectZos, Disconnect zOS job did not complete successfully");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("disconnectZos, Disconnect zOS return code is " + String.valueOf(CorePlugin.getDefault().session.getDoCmdRespRc()));
                        CorePlugin.getDefault().log.debug("disconnectZos, Disconnect zOS return code is " + String.valueOf(CorePlugin.getDefault().session.getDoCmdRespRc()));
                        if (CorePlugin.getDefault().connectedHosts.size() <= 0) {
                            (this).ApaConnectionExtension.this.zosconnect.setConnectLocal();
                            (this).ApaConnectionExtension.this.zosconnect.connectZos();
                        }
                    }
                });
            }
        });
        job0.schedule();
    }

    public IStatus disconnectZos(IProgressMonitor monitor) {
        monitor.beginTask(Messages.getString("DisconnectAction.Job.Monitor.DisconnectZos"), 100);
        CorePlugin.getDefault().connectedHosts.remove(CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId"));
        ObservationReports obsrpts = new ObservationReports();
        obsrpts.runCloseObsReports("*", monitor);
        obsrpts = null;
        if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
            CorePlugin.getDefault().session.doCmdResp("SHUTDOWN", CorePlugin.getDefault().getPreferenceStore().getString("dataSource"));
        }
        try {
            ApaPdtoolsPlugin.getDefault().nbsio.closeConnection();
            CorePlugin.getDefault().session.endSession();
        }
        catch (Exception exception) {
            return Status.CANCEL_STATUS;
        }
        System.out.println("Terminated ADFz/APA Connection");
        this.logMessage('I', "Terminated ADFz/APA Connection");
        CorePlugin.getDefault().getPreferenceStore().setValue("coreConnected", false);
        monitor.done();
        return Status.OK_STATUS;
    }

    public void forceCancelZos() {
        if (this.connreq == null) {
            this.connreq = new ApaConnectionRequestListener();
        }
        if (this.zosconnect.getAHostById(CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId")) == null) {
            return;
        }
        this.disconnectZosJob();
    }

    private void logMessage(char loglevel, String logstr) {
        System.out.println("ApaConnectionExtension - " + logstr);
        switch (loglevel) {
            case 'E': {
                CorePlugin.getDefault().log.error(logstr);
                break;
            }
            case 'I': {
                CorePlugin.getDefault().log.info(logstr);
                break;
            }
            case 'W': {
                CorePlugin.getDefault().log.warn(logstr);
                break;
            }
            default: {
                CorePlugin.getDefault().log.debug(logstr);
            }
        }
    }

    public void dumpMessage(String function, byte[] message, String dumpLength) {
        int byteCount = 0;
        int formatCount = 0;
        int messageOffset = 0;
        int messageLength = 0;
        if (dumpLength.equalsIgnoreCase("ALL")) {
            messageLength = message.length;
        } else {
            messageLength = Integer.parseInt(dumpLength);
            if (messageLength > message.length) {
                messageLength = message.length;
            }
        }
        if (message.length == 0) {
            System.out.println("No message to print");
            return;
        }
        System.out.println(function + " Message:");
        CorePlugin.getDefault().log.debug(function + " Message:");
        StringBuilder messageBuffer = new StringBuilder();
        String hexMessage = "";
        String asciiMessage = "";
        byteCount = 0;
        messageOffset = 0;
        while (byteCount < messageLength) {
            if (byteCount % 16 == 0) {
                if (byteCount != 0) {
                    messageBuffer.append(hexMessage);
                    messageBuffer.append("\t");
                    messageBuffer.append(asciiMessage);
                    CorePlugin.getDefault().log.debug(messageBuffer.toString());
                    System.out.println(messageBuffer.toString());
                    messageBuffer.setLength(0);
                }
                asciiMessage = "";
                hexMessage = String.format("%#06x ", messageOffset);
            }
            hexMessage = hexMessage.concat(String.format("%#04x ", message[byteCount]));
            asciiMessage = message[byteCount] > 31 && message[byteCount] < 127 ? asciiMessage.concat(String.valueOf((char)message[byteCount])) : asciiMessage.concat(".");
            ++byteCount;
            ++messageOffset;
        }
        if (byteCount % 16 > 0) {
            formatCount = 0;
            while (formatCount < 16 - byteCount % 16) {
                hexMessage = hexMessage.concat("     ");
                ++formatCount;
            }
        }
        messageBuffer.append(hexMessage);
        messageBuffer.append("\t");
        messageBuffer.append(asciiMessage);
        CorePlugin.getDefault().log.debug(messageBuffer.toString());
        System.out.println(messageBuffer.toString());
    }

    public void connectZos(String selconnid) {
        if (this.connreq == null) {
            this.connreq = new ApaConnectionRequestListener();
        }
        if (CorePlugin.getDefault().connectedHosts.size() > 0) {
            String cancelHostID = "";
            Iterator hosts = CorePlugin.getDefault().connectedHosts.iterator();
            if (hosts.hasNext()) {
                cancelHostID = (String)hosts.next();
                this.connreq.forceCancelZos(cancelHostID);
            }
        }
        try {
            this.connreq.connect(selconnid);
        }
        catch (Exception exception) {}
    }

    public String showSystemActions() {
        return "showactive";
    }

    public Action makeConnectionsAction() {
        Action connectionsAction = new Action(){

            public void run() {
            }
        };
        String actiontxt = Messages.getString("ConnectionExtension.Action.Connections");
        actiontxt = actiontxt.replace("#productname", CorePlugin.getDefault().productextension.getProductName());
        connectionsAction.setText(actiontxt);
        connectionsAction.setToolTipText(actiontxt);
        connectionsAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.apa.pdtools", (String)"icons/host.gif"));
        connectionsAction.setEnabled(true);
        connectionsAction.setMenuCreator(this.connectionsMenuCreator);
        return connectionsAction;
    }

    public Action makeAddSystemAction() {
        Action addSystemAction = new Action(){

            public void run() {
                ConnectionUtilities.openDialogForNewConnection();
            }
        };
        String actiontxt = Messages.getString("ConnectionExtension.Action.AddSystem");
        addSystemAction.setText(actiontxt);
        addSystemAction.setToolTipText(actiontxt);
        addSystemAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.apa.pdtools", (String)"icons/addSystem.gif"));
        addSystemAction.setEnabled(true);
        return addSystemAction;
    }

    private void addNewConnection() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ConnectionUtilities.openDialogForNewConnection();
            }
        });
    }

    public Action makeRemoveSystemAction(TreeViewer tv) {
        final TreeViewer tviewer = tv;
        Action removeSystemAction = new Action(){

            public void run() {
                ISelection selection = tviewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                String selconnid = ((StcModel)obj).connectionid;
                ApaConnectionExtension.this.zosconnect.setConnectLocal();
                ApaConnectionExtension.this.zosconnect.connectZos();
                ConnectionUtilities.deleteConnection((String)selconnid);
            }
        };
        removeSystemAction.setText(Messages.getString("ConnectionExtension.Action.RemoveSystem"));
        removeSystemAction.setToolTipText(Messages.getString("ConnectionExtension.Tooltip.RemoveSystem"));
        removeSystemAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        return removeSystemAction;
    }

    public Action makeDisconnectAction() {
        Action disconnectAction = new Action(){

            public void run() {
                try {
                    ApaConnectionExtension.this.disconnectZosJob();
                }
                catch (Exception exception) {}
            }
        };
        String actiontxt = Messages.getString("ConnectionExtension.Action.Stop");
        actiontxt = actiontxt.replace("#productname", CorePlugin.getDefault().productextension.getProductName());
        disconnectAction.setText(actiontxt);
        disconnectAction.setToolTipText(actiontxt);
        disconnectAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/obj/osprct_obj.gif"));
        disconnectAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/dlcl16/disconnected.gif"));
        disconnectAction.setEnabled(true);
        return disconnectAction;
    }

    public int checkServerExtension(IProgressMonitor monitor) {
        int numBytesRead;
        int rc;
        block5: {
            rc = 0;
            numBytesRead = 0;
            String command = "READY";
            byte[] responseArray = null;
            String[] commandArray = command.split(" ");
            String cfr_ignored_0 = commandArray[0];
            String fullFName = CorePlugin.getDefault().session.queueFile(command);
            try {
                File responseFile = new File(fullFName);
                responseArray = new byte[(int)responseFile.length()];
                DataInputStream dis = new DataInputStream(new FileInputStream(responseFile));
                dis.readFully(responseArray);
                dis.close();
            }
            catch (Exception exception) {}
            try {
                this.logMessage('I', "sendSystemMessage: Checking APA IS READY Message");
                numBytesRead = this.zosRead(command, CorePlugin.getDefault().session.monitor);
                String apaReadyMsg = null;
                apaReadyMsg = numBytesRead > 0 ? CorePlugin.getDefault().session.byteBufToString(0, numBytesRead) : "Connection Failed";
                if (apaReadyMsg.indexOf("APA IS READY.") >= 0) break block5;
                this.logMessage('E', "sendSystemMessage: APA IS READY Message Failed.");
                this.disconnectZos(monitor);
                return -1;
            }
            catch (Exception exception) {
                this.logMessage('E', "sendSystemMessage: APA IS READY Message Failed, Exception: ");
                return -1;
            }
        }
        this.logMessage('D', "sendSystemMessage: Bytes Received " + numBytesRead);
        this.logMessage('I', "sendSystemMessage: APA is ready to start receiving messages.");
        return rc;
    }

    public String getConnectionStatus(String connid) {
        Iterator hosts = CorePlugin.getDefault().connectedHosts.iterator();
        while (hosts.hasNext()) {
            if (!((String)hosts.next()).equals(connid)) continue;
            return "connected";
        }
        return "disconnected";
    }

    public boolean getConnectionAttrib(String connid) {
        HostDetails host;
        boolean hasAttrib = false;
        if (this.connreq == null) {
            this.connreq = new ApaConnectionRequestListener();
        }
        if ((host = this.connreq.getHostById(connid)) == null) {
            return hasAttrib;
        }
        hasAttrib = true;
        this.isRemote = false;
        this.connectionid = connid;
        this.connectionname = host.getDescription();
        this.servername = host.getHostname();
        this.portname = this.constants.portdecfmt.format(host.getPortNumber());
        this.isRemote = false;
        Iterator hosts = CorePlugin.getDefault().connectedHosts.iterator();
        while (hosts.hasNext()) {
            if (!((String)hosts.next()).equals(connid)) continue;
            this.isRemote = true;
            break;
        }
        return hasAttrib;
    }

    public String getConnectionId() {
        return this.connectionid;
    }

    public String getConnectionName() {
        return this.connectionname;
    }

    public String getServerName() {
        return this.servername;
    }

    public String getPortName() {
        return this.portname;
    }

    public boolean getIsConnectionRemote() {
        return this.isRemote;
    }

    public void establishSSL(String hostName, int port) {
    }

    public InputStream getSslInputStream() throws Exception {
        return null;
    }

    public OutputStream getSslOutputStream() throws Exception {
        return null;
    }

    public int getSslReceiveBufferSize() throws Exception {
        return 0;
    }

    public void closeSslSocket() throws Exception {
    }
}

