/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.apa;

import com.banknet.apa.Messages;
import com.banknet.core.CorePlugin;
import java.net.URI;
import java.net.URL;
import org.apache.logging.log4j.LogManager;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ApaPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.banknet.apa";
    private static ApaPlugin plugin;
    private String thisClassName = ((Object)((Object)this)).getClass().getName();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        try {
            if (PlatformUI.isWorkbenchRunning()) {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                page.setEditorAreaVisible(false);
            } else {
                IEclipsePreferences preferencesHelp = InstanceScope.INSTANCE.getNode("org.eclipse.help.base/");
                preferencesHelp.put("help_home", Messages.getString("Help.Home"));
                preferencesHelp.flush();
            }
        }
        catch (Exception exception) {}
        this.configureLog4j2();
        String logstr = "***** " + Platform.getResourceString((Bundle)this.getBundle(), (String)"%Plugin.name") + " Started *****";
        System.out.println(logstr);
        CorePlugin.getDefault().log.info(logstr);
        logstr = "Version : " + Platform.getResourceString((Bundle)this.getBundle(), (String)"%Plugin.version");
        System.out.println(logstr);
        CorePlugin.getDefault().log.info(logstr);
        logstr = "Locale :  " + Platform.getNL();
        System.out.println(logstr);
        CorePlugin.getDefault().log.info(logstr);
    }

    public void stop(BundleContext context) throws Exception {
        String logstr = "***** " + Platform.getResourceString((Bundle)this.getBundle(), (String)"%Plugin.name") + " Stopped *****";
        System.out.println(logstr);
        CorePlugin.getDefault().log.info(logstr);
        plugin = null;
        super.stop(context);
    }

    public static ApaPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return ApaPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void configureLog4j2() {
        try {
            String logxml = "log4j2.xml";
            if (CorePlugin.getDefault().getPreferenceStore().getString("logLevel").equalsIgnoreCase("debug")) {
                logxml = "log4j2Debug.xml";
            }
            System.setProperty("apaworkspace_loc", Platform.getLocation().toPortableString());
            URL url = this.getBundle().getResource(logxml);
            URL fileUrl = FileLocator.toFileURL((URL)url);
            URI uri = new URI(fileUrl.getProtocol(), fileUrl.getUserInfo(), fileUrl.getHost(), fileUrl.getPort(), fileUrl.getPath(), fileUrl.getQuery(), fileUrl.getRef());
            LogManager.getContext(null, (boolean)false, (URI)uri);
            CorePlugin.getDefault().log = LogManager.getLogger(((Object)((Object)this)).getClass());
        }
        catch (Exception e) {
            this.logInfo(this.thisClassName + ":configureLogging  Exception");
            this.logException(e);
        }
    }

    public void logException(Exception e) {
        String msg = e.getMessage() == null ? e.toString() : e.getMessage();
        this.getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, msg, (Throwable)e));
    }

    public void logInfo(String msg) {
        this.getLog().log((IStatus)new Status(1, PLUGIN_ID, 0, msg, null));
    }
}

