/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.views.reports;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.data.reports.ObservationReports;
import com.banknet.core.dialogs.StickyNotesDialog;
import com.banknet.core.dialogs.reports.ReportOptionsDialog;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.Utilities;
import com.banknet.core.internal.VersionCompatibilityExtension;
import com.banknet.core.models.ObservationsModel;
import com.banknet.core.models.ReportsModel;
import com.banknet.core.views.ObservationsView;
import com.banknet.core.views.reports.Messages;
import com.banknet.core.views.reports.ReportEditor;
import com.banknet.core.views.reports.ReportTextView;
import com.banknet.core.views.reports.ReportsViewContentProvider;
import com.banknet.core.views.reports.ReportsViewLabelProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReportsView
extends ViewPart
implements ISelectionListener {
    private VersionCompatibilityExtension compat = new VersionCompatibilityExtension();
    Constants constants = new Constants();
    Utilities util = new Utilities();
    ZosConnect zosconnect = new ZosConnect();
    ObservationReports obsrpts;
    ReportEditor rpteditor = new ReportEditor();
    private ReportsModel reportsmodel = null;
    private Tree tree;
    private TreeViewer viewer;
    public static final String ID = "com.banknet.core.ReportsView";
    private int nodecnt = 0;
    private DrillDownAdapter drillDownAdapter;
    private Action expandAllAction;
    private Action collapseAllAction;
    private Action webBrowserAction;
    private Action birtViewerAction;
    private Action exportPdfAction;
    private Action exportDocAction;
    private Action exportPptAction;
    private Action doubleClickAction;
    private Action downloadReportsAction;
    private Action downloadXmlAction;
    private Action downloadJsonAction;
    private Action downloadPdfAction;
    private Action stickyNotesAction;
    private Action reportOptionsAction;
    private Action viewReportAction;
    private Action selectionsAction;
    public ReportsView reportsview;
    public String rptreqnum = "";
    private int curreqnum;
    private boolean showoptions = false;
    String rptformat = "";
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);
    private ObservationsModel rptobs;
    private List<String> saveReportFnames = new ArrayList<String>();
    private List<ObservationsModel> selobservations = new ArrayList<ObservationsModel>();
    private List<ReportsModel> selreports = new ArrayList<ReportsModel>();
    private ReportsModel rptmodel;
    private static final String REPORTSMODEL_ELEMENTTYPE_CATEGORY = "category";
    private static final String REPORTSMODEL_ELEMENTTYPE_REPORT = "report";
    private String reqaction = "";
    private int keycode = 0;
    private final PerspectiveAdapter perspectiveListener = new PerspectiveAdapter(){

        public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspectiveDescriptor) {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            WorkbenchPage cfr_ignored_0 = (WorkbenchPage)ReportsView.this.getSite().getPage();
            ReportsView.this.getSite().getPage();
            perspectiveDescriptor.getId().contains("banknet");
            CorePlugin.getDefault().getPreferenceStore().getBoolean("obsLoaded");
        }

        public void perspectiveOpened(IWorkbenchPage page, IPerspectiveDescriptor perspectiveDescriptor) {
        }
    };
    private final IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals("activeLink")) {
                String activelink = CorePlugin.getDefault().getPreferenceStore().getString("activeLink");
                if (activelink.length() > 0) {
                    ReportsModel report = CorePlugin.getDefault().reports.get(CorePlugin.getDefault().reportId.indexOf(activelink));
                    ReportsView.this.showTextReport(report);
                    CorePlugin.getDefault().getPreferenceStore().setValue("activeLink", "");
                }
            } else if (event.getKey().equals("focusReport")) {
                if (CorePlugin.getDefault().getPreferenceStore().getString("focusReport").length() > 0) {
                    String[] focuskey = ReportsView.this.s1.split(CorePlugin.getDefault().getPreferenceStore().getString("focusReport"), -1);
                    String focushoststcid = focuskey[0];
                    int focusreqnum = new Integer(focuskey[1]);
                    String focusrptid = focuskey[2];
                    if (focushoststcid.equals(CorePlugin.getDefault().activeStc) & focusreqnum == CorePlugin.getDefault().selobs.reqnum) {
                        ReportsModel report = CorePlugin.getDefault().reports.get(CorePlugin.getDefault().reportId.indexOf(focusrptid));
                        ReportsView.this.viewer.setSelection((ISelection)new StructuredSelection((Object)report), true);
                        CorePlugin.getDefault().getPreferenceStore().setValue("focusReport", "");
                    }
                }
            } else if (!event.getKey().equals("obsReports")) {
                if (event.getKey().equals("obsLoaded")) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            String logstr = "obsloaded:  Heap Size " + Runtime.getRuntime().totalMemory();
                            System.out.println("ReportsView " + logstr);
                            CorePlugin.getDefault().log.info(logstr);
                            logstr = "obsloaded:  Heap Max Size " + Runtime.getRuntime().maxMemory();
                            System.out.println("ReportsView " + logstr);
                            CorePlugin.getDefault().log.info(logstr);
                        }
                    });
                } else if (event.getKey().equals("reportObs")) {
                    if (CorePlugin.getDefault().getPreferenceStore().getString("reportObs").length() > 0) {
                        String reportobs = CorePlugin.getDefault().getPreferenceStore().getString("reportObs");
                        ReportsView.this.viewer.setInput((Object)ReportsView.this.getReportsModel());
                        ReportsView.this.viewer.collapseAll();
                        ReportsModel report = CorePlugin.getDefault().reports.get(CorePlugin.getDefault().reportId.indexOf(reportobs));
                        ReportsView.this.viewer.setSelection((ISelection)new StructuredSelection((Object)report), true);
                        ReportsView.this.setPartName(String.valueOf(Messages.getString("ReportsView.View.Name.Reports")) + CorePlugin.getDefault().constants.reqdecfmt.format(CorePlugin.getDefault().selobs.reqnum) + ")");
                        CorePlugin.getDefault().getPreferenceStore().setValue("reportObs", "");
                    }
                } else if (event.getKey().equals("reportsRefresh")) {
                    ReportsView.this.viewer.refresh();
                    CorePlugin.getDefault().getPreferenceStore().setValue("reportsRefresh", false);
                }
            }
        }
    };
    public IMenuCreator selectallMenuCreator = new IMenuCreator(){
        private Menu menu;

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            MenuItem item = new MenuItem(this.menu, 32);
            item.setText(Messages.getString("ReportsView.Action.ClearSelections"));
            item.setToolTipText(Messages.getString("ReportsView.Tooltip.ClearSelections"));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReportsView.this.clearSelections(ReportsView.this.tree.getItems());
                    ReportsView.this.selreports = null;
                    ReportsView.this.selreports = new ArrayList();
                }
            });
            item.setEnabled(true);
            item = new MenuItem(this.menu, 32);
            item.setText(Messages.getString("ReportsView.Action.SelectAll"));
            item.setToolTipText(Messages.getString("ReportsView.Action.SelectAll"));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReportsView.this.viewer.expandAll();
                    ReportsView.this.checkAllItems(ReportsView.this.tree.getItems());
                }
            });
            item.setEnabled(true);
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return this.menu;
        }
    };

    public ReportsView() {
        try {
            IEclipsePreferences preferencesI = InstanceScope.INSTANCE.getNode("com.banknet.core");
            preferencesI.addPreferenceChangeListener(this.preferenceChangeListener);
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            workbenchWindow.addPerspectiveListener((IPerspectiveListener)this.perspectiveListener);
            this.reportsview = this;
        }
        catch (Exception ex) {
            String logstr = "class constructor:  Exception. " + ex;
            System.out.println("ReportsView " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
        }
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 4);
        GridLayout layout = new GridLayout(1, false);
        GridData gd4 = new GridData(4, 128, true, false, 1, 1);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)gd4);
        this.tree = new Tree(composite, 68386);
        GridData gd = new GridData(4, 4, true, true);
        this.tree.setLayoutData((Object)gd);
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem treeitem = (TreeItem)e.item;
                ReportsModel rptsmodel = (ReportsModel)treeitem.getData();
                if (treeitem.getChecked()) {
                    if (rptsmodel.elementtype.equals(ReportsView.REPORTSMODEL_ELEMENTTYPE_CATEGORY)) {
                        ((TreeItem)e.item).setChecked(false);
                        return;
                    }
                    ReportsView.this.doCheckedReport(treeitem);
                    ReportsView.this.viewer.setSelection((ISelection)new StructuredSelection((Object)rptsmodel), true);
                } else {
                    ReportsView.this.selreports.remove(rptsmodel);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, 750));
        this.tree.setLayout((Layout)tableLayout);
        this.viewer = new TreeViewer(this.tree);
        if (CorePlugin.getDefault().selobs != null) {
            this.reportsmodel = this.getReportsModel();
        }
        this.viewer.setAutoExpandLevel(2);
        new TreeColumn(this.tree, 0);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeItem[] selections = ReportsView.this.viewer.getTree().getSelection();
                int i = 0;
                while (i < selections.length) {
                    if (ReportsView.this.keycode == 131072 & ((ReportsModel)selections[i].getData()).elementtype.equals(ReportsView.REPORTSMODEL_ELEMENTTYPE_REPORT) && !selections[i].getChecked()) {
                        selections[i].setChecked(true);
                        ReportsView.this.doCheckedReport(selections[i]);
                    }
                    ++i;
                }
                ReportsView.this.keycode = 0;
            }
        });
        this.tree.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 131072) {
                    ReportsView.this.keycode = 131072;
                }
            }
        });
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.viewer.setContentProvider((IContentProvider)new ReportsViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ReportsViewLabelProvider());
        this.viewer.setInput((Object)this.reportsmodel);
        this.setDefaultSelected();
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        if (CorePlugin.getDefault().selobs != null) {
            this.setPartName(String.valueOf(Messages.getString("ReportsView.View.Name.Reports")) + CorePlugin.getDefault().constants.reqdecfmt.format(CorePlugin.getDefault().selobs.reqnum) + ")");
        }
        CorePlugin.getDefault().connectionextension.setConnectionStatus(this.getViewSite());
    }

    private void setDefaultSelected() {
        boolean foundReport = false;
        TreeItem[] tvitems = this.viewer.getTree().getItems();
        int i = 0;
        while (i < tvitems.length) {
            if (tvitems[i].getText().startsWith(String.valueOf(CorePlugin.getDefault().getPreferenceStore().getString("expandReport")) + " -")) {
                this.viewer.setSelection((ISelection)new StructuredSelection(tvitems[i].getData()));
                foundReport = true;
            } else {
                tvitems[i].setExpanded(false);
            }
            ++i;
        }
        if (tvitems.length > 0 & !foundReport) {
            this.viewer.setSelection((ISelection)new StructuredSelection(tvitems[0].getData()));
            tvitems[0].setExpanded(true);
        }
        CorePlugin.getDefault().getPreferenceStore().setValue("focusReport", "");
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        CorePlugin.getDefault().connectionextension.createConnectionListener();
    }

    public String getPartProperty(String key) {
        String partkey = CorePlugin.getDefault().connectionextension.getConnectionPartKey(key);
        if (partkey.length() > 0) {
            return partkey;
        }
        return super.getPartProperty(key);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ReportsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.downloadReportsAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.downloadXmlAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.downloadJsonAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.downloadPdfAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this.selreports.size() <= 0) {
            return;
        }
        manager.add((IAction)this.viewReportAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.reportOptionsAction);
        manager.add((IAction)this.stickyNotesAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.downloadReportsAction);
        this.downloadReportsAction.setText(String.valueOf(Messages.getString("ReportsView.Action.Download")) + Messages.getString("ReportsView.Action.Report"));
        manager.add((IAction)this.downloadXmlAction);
        this.downloadXmlAction.setText(String.valueOf(Messages.getString("ReportsView.Action.Download")) + Messages.getString("ReportsView.Action.Xml"));
        manager.add((IAction)this.downloadJsonAction);
        this.downloadJsonAction.setText(String.valueOf(Messages.getString("ReportsView.Action.Download")) + Messages.getString("ReportsView.Action.Json"));
        manager.add((IAction)this.downloadPdfAction);
        this.downloadPdfAction.setText(String.valueOf(Messages.getString("ReportsView.Action.Download")) + Messages.getString("ReportsView.Action.Pdf"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.selectionsAction);
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.viewReportAction);
        manager.add((IAction)this.reportOptionsAction);
        manager.add((IAction)this.stickyNotesAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.downloadReportsAction);
        manager.add((IAction)this.downloadXmlAction);
        manager.add((IAction)this.downloadJsonAction);
        manager.add((IAction)this.downloadPdfAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.selectionsAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.expandAllAction);
        manager.add((IAction)this.collapseAllAction);
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                ReportsModel rptsmodel = (ReportsModel)obj;
                if (rptsmodel.elementtype.equals(ReportsView.REPORTSMODEL_ELEMENTTYPE_REPORT)) {
                    ReportsView.this.showTextReport(rptsmodel);
                }
            }
        });
    }

    private void makeActions() {
        this.expandAllAction = new Action(){

            public void run() {
                ReportsView.this.viewer.expandAll();
            }
        };
        this.expandAllAction.setText(Messages.getString("ReportsView.Action.ExpandAll"));
        this.expandAllAction.setToolTipText(Messages.getString("ReportsView.Tooltip.ExpandAll"));
        this.expandAllAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/elcl16/expandall.gif"));
        this.expandAllAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/dlcl16/expandall.gif"));
        this.collapseAllAction = new Action(){

            public void run() {
                ReportsView.this.viewer.collapseAll();
            }
        };
        this.collapseAllAction.setText(Messages.getString("ReportsView.Action.CollapseAll"));
        this.collapseAllAction.setToolTipText(Messages.getString("ReportsView.Tooltip.CollapseAll"));
        this.collapseAllAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/elcl16/collapseall.gif"));
        this.collapseAllAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/dlcl16/collapseall.gif"));
        this.downloadReportsAction = new Action(){

            public void run() {
                int rc = 0;
                ReportsView.this.rptformat = ReportsView.this.constants.REPORT_FORMAT_PVML;
                rc = ReportsView.this.rpteditor.doSelObsReportEdits(ReportsView.this.selreports, ReportsView.this.rptformat);
                if (rc < 0) {
                    ReportsView.this.showMessage(ReportsView.this.rpteditor.msgtype, Messages.getString("ReportsView.Action.DownloadReports"), ReportsView.this.rpteditor.msgstr);
                    return;
                }
                ReportsView.this.reqaction = ReportsView.this.constants.ACTION_REPORTS;
                ReportsView.this.obsrpts = new ObservationReports();
                ReportsView.this.obsrpts.rptformat = ReportsView.this.rptformat;
                ReportsView.this.runReportsPing();
            }
        };
        this.downloadReportsAction.setText(Messages.getString("ReportsView.Action.DownloadReports"));
        this.downloadReportsAction.setToolTipText(Messages.getString("ReportsView.Action.DownloadReports"));
        this.downloadReportsAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/msBlue.gif"));
        this.downloadXmlAction = new Action(){

            public void run() {
                int rc = 0;
                ReportsView.this.rptformat = ReportsView.this.constants.REPORT_FORMAT_XML;
                rc = ReportsView.this.rpteditor.doSelObsReportEdits(ReportsView.this.selreports, ReportsView.this.rptformat);
                if (rc < 0) {
                    ReportsView.this.showMessage(ReportsView.this.rpteditor.msgtype, Messages.getString("ReportsView.Action.DownloadXml"), ReportsView.this.rpteditor.msgstr);
                    return;
                }
                ReportsView.this.reqaction = ReportsView.this.constants.ACTION_REPORTS;
                ReportsView.this.obsrpts = new ObservationReports();
                ReportsView.this.obsrpts.rptformat = ReportsView.this.rptformat;
                ReportsView.this.saveReportFnames = new ArrayList();
                String saveReportFname = "";
                File saveReportFile = ReportsView.this.getSaveReportFile(CorePlugin.getDefault().constants.reqdecfmt.format(CorePlugin.getDefault().selobs.reqnum), "", ReportsView.this.rptformat);
                if (saveReportFile != null) {
                    saveReportFile.getParentFile().mkdirs();
                    saveReportFname = saveReportFile.getPath();
                }
                if (saveReportFname.length() <= 0) {
                    return;
                }
                ReportsView.this.saveReportFnames.add(saveReportFname);
                ReportsView.this.runReportsPing();
            }
        };
        this.downloadXmlAction.setText(Messages.getString("ReportsView.Action.DownloadXml"));
        this.downloadXmlAction.setToolTipText(Messages.getString("ReportsView.Action.DownloadXml"));
        this.downloadXmlAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadXml.gif"));
        this.downloadJsonAction = new Action(){

            public void run() {
                int rc = 0;
                ReportsView.this.rptformat = ReportsView.this.constants.REPORT_FORMAT_JSON;
                rc = ReportsView.this.rpteditor.doSelObsReportEdits(ReportsView.this.selreports, ReportsView.this.rptformat);
                if (rc < 0) {
                    ReportsView.this.showMessage(ReportsView.this.rpteditor.msgtype, Messages.getString("ReportsView.Action.DownloadJson"), ReportsView.this.rpteditor.msgstr);
                    return;
                }
                ReportsView.this.reqaction = ReportsView.this.constants.ACTION_REPORTS;
                ReportsView.this.obsrpts = new ObservationReports();
                ReportsView.this.obsrpts.rptformat = ReportsView.this.rptformat;
                ReportsView.this.saveReportFnames = new ArrayList();
                String saveReportFname = "";
                File saveReportFile = ReportsView.this.getSaveReportFile(CorePlugin.getDefault().constants.reqdecfmt.format(CorePlugin.getDefault().selobs.reqnum), "", ReportsView.this.rptformat);
                if (saveReportFile != null) {
                    saveReportFile.getParentFile().mkdirs();
                    saveReportFname = saveReportFile.getPath();
                }
                if (saveReportFname.length() <= 0) {
                    return;
                }
                ReportsView.this.saveReportFnames.add(saveReportFname);
                ReportsView.this.runReportsPing();
            }
        };
        this.downloadJsonAction.setText(Messages.getString("ReportsView.Action.DownloadJson"));
        this.downloadJsonAction.setToolTipText(Messages.getString("ReportsView.Action.DownloadJson"));
        this.downloadJsonAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadJson.png"));
        this.downloadPdfAction = new Action(){

            public void run() {
                int rc = 0;
                ReportsView.this.rptformat = ReportsView.this.constants.REPORT_FORMAT_PDF;
                rc = ReportsView.this.rpteditor.doSelObsReportEdits(ReportsView.this.selreports, ReportsView.this.rptformat);
                if (rc < 0) {
                    ReportsView.this.showMessage(ReportsView.this.rpteditor.msgtype, Messages.getString("ReportsView.Action.DownloadPdf"), ReportsView.this.rpteditor.msgstr);
                    return;
                }
                ReportsView.this.reqaction = ReportsView.this.constants.ACTION_REPORTS;
                ReportsView.this.obsrpts = new ObservationReports();
                ReportsView.this.obsrpts.rptformat = ReportsView.this.rptformat;
                ReportsView.this.saveReportFnames = new ArrayList();
                String saveReportFname = "";
                File saveReportFile = ReportsView.this.getSaveReportFile(CorePlugin.getDefault().constants.reqdecfmt.format(CorePlugin.getDefault().selobs.reqnum), "", ReportsView.this.rptformat);
                if (saveReportFile != null) {
                    saveReportFile.getParentFile().mkdirs();
                    saveReportFname = saveReportFile.getPath();
                }
                if (saveReportFname.length() <= 0) {
                    return;
                }
                ReportsView.this.saveReportFnames.add(saveReportFname);
                ReportsView.this.runReportsPing();
            }
        };
        this.downloadPdfAction.setText(Messages.getString("ReportsView.Action.DownloadPdf"));
        this.downloadPdfAction.setToolTipText(Messages.getString("ReportsView.Action.DownloadPdf"));
        this.downloadPdfAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadPdf.gif"));
        this.stickyNotesAction = new Action(){

            public void run() {
                ObservationsModel obs = CorePlugin.getDefault().selobs;
                CorePlugin.getDefault().constants.reqdecfmt.format(obs.reqnum);
                int i = 0;
                while (i < ReportsView.this.selreports.size()) {
                    ReportsModel rpt = (ReportsModel)ReportsView.this.selreports.get(i);
                    String msgstrspm = ReportsView.this.rpteditor.editSpm(rpt);
                    if (msgstrspm.length() > 0) {
                        ReportsView.this.showMessage(ReportsView.this.rpteditor.msgtype, Messages.getString("ReportTextView.Action.StickyNotes"), msgstrspm);
                        return;
                    }
                    String notesTitle = String.valueOf(rpt.reportid) + ": " + rpt.reportname + " (" + CorePlugin.getDefault().activeStc + "/" + obs.reqnum + "/" + obs.jobname + ")";
                    IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
                    CorePlugin.getDefault();
                    String reportPath = String.valueOf(new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + obs.reqnum + File.separator + Platform.getNL() + File.separator).getAbsolutePath()) + File.separator;
                    StickyNotesDialog snd = new StickyNotesDialog(ReportsView.this.viewer.getControl().getShell());
                    snd.notesPath = reportPath;
                    snd.rpttitle = notesTitle;
                    snd.rptid = rpt.reportid;
                    snd.open();
                    snd = null;
                    ++i;
                }
                ReportsView.this.selectionsAction.run();
            }
        };
        this.stickyNotesAction.setText(Messages.getString("ReportTextView.Action.StickyNotes"));
        this.stickyNotesAction.setToolTipText(Messages.getString("ReportTextView.Tooltip.StickyNotes"));
        this.stickyNotesAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/stickyNote.gif"));
        this.stickyNotesAction.setEnabled(true);
        this.reportOptionsAction = new Action(){

            public void run() {
                int i = 0;
                while (i < ReportsView.this.selreports.size()) {
                    ReportsModel rpt = (ReportsModel)ReportsView.this.selreports.get(i);
                    String msgstrspm = ReportsView.this.rpteditor.editSpm(rpt);
                    if (msgstrspm.length() > 0) {
                        ReportsView.this.showMessage(ReportsView.this.rpteditor.msgtype, Messages.getString("ReportsView.Action.ReportOptions"), msgstrspm);
                        return;
                    }
                    ReportOptionsDialog rptopt = new ReportOptionsDialog(ReportsView.this.viewer.getControl().getShell());
                    rptopt.rptid = rpt.reportid;
                    int rptoptrc = rptopt.open();
                    if (rptoptrc != 0) {
                        // empty if block
                    }
                    rptopt = null;
                    ++i;
                }
                ReportsView.this.selectionsAction.run();
            }
        };
        this.reportOptionsAction.setText(Messages.getString("ReportsView.Action.ReportOptions"));
        this.reportOptionsAction.setToolTipText(Messages.getString("ReportsView.Tooltip.ReportOptions"));
        this.reportOptionsAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/elcl16/det_pane_hide.gif"));
        this.reportOptionsAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/dlcl16/det_pane_hide.gif"));
        this.reportOptionsAction.setEnabled(true);
        this.viewReportAction = new Action(){

            public void run() {
                int i = 0;
                while (i < ReportsView.this.selreports.size()) {
                    String msgstrspm = ReportsView.this.rpteditor.editSpm((ReportsModel)ReportsView.this.selreports.get(i));
                    if (msgstrspm.length() > 0) {
                        ReportsView.this.showMessage(ReportsView.this.rpteditor.msgtype, Messages.getString("ReportsView.Action.ViewReport"), msgstrspm);
                        return;
                    }
                    ReportsView.this.showTextReport((ReportsModel)ReportsView.this.selreports.get(i));
                    ++i;
                }
                ReportsView.this.selectionsAction.run();
            }
        };
        this.viewReportAction.setText(Messages.getString("ReportsView.Action.ViewReport"));
        this.viewReportAction.setToolTipText(Messages.getString("ReportsView.Action.ViewReport"));
        this.viewReportAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadReportsGreen.gif"));
        this.selectionsAction = new Action(){

            public void run() {
            }
        };
        this.selectionsAction.setText(Messages.getString("ReportsView.Action.Selections"));
        this.selectionsAction.setToolTipText(Messages.getString("ReportsView.Action.Selections"));
        this.selectionsAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/checkbox_checked.gif"));
        this.selectionsAction.setMenuCreator(this.selectallMenuCreator);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part != this) {
            if (!selection.isEmpty() && part.getSite().getId().endsWith("ObservationsView") | part.getSite().getId().endsWith("ObservationsSearchView")) {
                int selreqnum;
                if (part.getSite().getId().endsWith("ObservationsView")) {
                    ((IStructuredSelection)selection).getFirstElement();
                    CorePlugin.getDefault().selobs = (ObservationsModel)((IStructuredSelection)selection).getFirstElement();
                    this.viewer.setInput((Object)this.getReportsModel());
                    this.setDefaultSelected();
                    this.viewer.refresh();
                    this.setPartName(String.valueOf(Messages.getString("ReportsView.View.Name.Reports")) + CorePlugin.getDefault().constants.reqdecfmt.format(CorePlugin.getDefault().selobs.reqnum) + ")");
                    ObservationsView cfr_ignored_0 = (ObservationsView)part.getSite().getPart();
                }
                if (this.curreqnum != (selreqnum = CorePlugin.getDefault().selobs.reqnum.intValue())) {
                    this.curreqnum = selreqnum;
                    ObservationsModel cfr_ignored_1 = CorePlugin.getDefault().selobs;
                    this.selectionObservationsView(CorePlugin.getDefault().selobs);
                }
            }
        } else {
            selection.isEmpty();
        }
    }

    private void selectionObservationsView(ObservationsModel obs) {
        boolean rptfound = false;
        if (!obs.reportsAvail) {
            this.viewer.setInput(null);
        } else {
            this.viewer.setInput((Object)this.getReportsModel());
            this.selreports = new ArrayList<ReportsModel>();
            IWorkbenchPage page = this.reportsview.getSite().getPage();
            int cfr_ignored_0 = page.getViewReferences().length;
            int i = page.getViewReferences().length - 1;
            while (i > 0) {
                try {
                    String vid = page.getViewReferences()[i].getId().toLowerCase();
                    IViewPart prt = page.findView(page.getViewReferences()[i].getId());
                    IViewPart[] xx = page.getViewStack(prt);
                    if (vid.endsWith("reporttextview")) {
                        int j = 0;
                        while (j < xx.length) {
                            IViewPart prt2 = xx[j];
                            String focusstcid = ((ReportTextView)prt2).stcid;
                            int focusreqnum = ((ReportTextView)prt2).reqnum;
                            String focusreport = ((ReportTextView)prt2).rptid;
                            if (focusstcid.equals(CorePlugin.getDefault().activeStc) & focusreqnum == CorePlugin.getDefault().selobs.reqnum) {
                                ReportsModel report = CorePlugin.getDefault().reports.get(CorePlugin.getDefault().reportId.indexOf(focusreport));
                                this.viewer.setSelection((ISelection)new StructuredSelection((Object)report), true);
                                this.setExpandedSelection(focusreport);
                                rptfound = true;
                                break;
                            }
                            ++j;
                        }
                        if (rptfound) {
                            break;
                        }
                    }
                }
                catch (Exception exception) {}
                --i;
            }
            if (!rptfound) {
                this.setDefaultSelected();
            }
        }
        this.setPartName(String.valueOf(Messages.getString("ReportsView.View.Name.Reports")) + CorePlugin.getDefault().constants.reqdecfmt.format(CorePlugin.getDefault().selobs.reqnum) + ")");
        CorePlugin.getDefault().getPreferenceStore().setValue("reportsViewSel", "");
    }

    private void setExpandedSelection(String focusreport) {
        TreeItem[] tvitems = this.viewer.getTree().getItems();
        int i = 0;
        while (i < tvitems.length) {
            if (tvitems[i].getText().startsWith(focusreport.substring(0, 1))) {
                tvitems[i].setExpanded(true);
            } else {
                tvitems[i].setExpanded(false);
            }
            ++i;
        }
    }

    public void dispose() {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        }
        catch (Exception exception) {}
        IEclipsePreferences preferencesI = InstanceScope.INSTANCE.getNode("com.banknet.core");
        preferencesI.removePreferenceChangeListener(this.preferenceChangeListener);
        super.dispose();
        try {
            this.getSite().getPage().hideView((IViewPart)this);
        }
        catch (Exception ex) {
            System.out.println("ReportsView dispose ex " + ex);
        }
    }

    private void showTextReport(ReportsModel obj) {
        if (obj.parent.reportid.equalsIgnoreCase(CorePlugin.getDefault().constants.REPORT_CATEGORY_SPM)) {
            return;
        }
        String logstr = "showTextReport:  select item is " + CorePlugin.getDefault().selobs.reqnum + " : " + obj.reportid + " - " + obj.reportname;
        System.out.println("ReportsView " + logstr);
        CorePlugin.getDefault().log.debug(logstr);
        CorePlugin.getDefault().rptid = obj.reportid;
        CorePlugin.getDefault().rptname = obj.reportname;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            String rptid = String.valueOf(CorePlugin.getDefault().activeStc) + "|" + CorePlugin.getDefault().selobs.reqnum + "|" + obj.reportid;
            page.showView("com.banknet.core.ReportTextView", rptid, 1);
        }
        catch (Exception ex) {
            System.out.println("ex xx " + ex);
        }
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("E")) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
        }
    }

    public void setFocus() {
        if (this.getSite().getPage().getActivePart() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.viewer.getTree().getShell(), String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".views_ReportsListViewContext");
        }
        this.viewer.getControl().setFocus();
    }

    private ReportsModel getReportsModel() {
        ReportsModel root = new ReportsModel(0, "", "", "", "", "", "", "", false, null);
        root.counter = 0;
        CorePlugin.getDefault().reports = Collections.synchronizedList(new ArrayList());
        CorePlugin.getDefault().reportId = new ArrayList();
        Node firstNode = CorePlugin.getDefault().reportsdoc.getFirstChild();
        this.getCategoryNodes(firstNode, root);
        CorePlugin.getDefault().getPreferenceStore().setValue("reportsViewSel", "");
        CorePlugin.getDefault().setReportsModel(root);
        return root;
    }

    private void getCategoryNodes(Node node, ReportsModel root) {
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            ReportsModel parent1 = root;
            Node item = childNodes.item(i);
            String nodeName = item.getNodeName();
            item.getNodeValue();
            if (nodeName.equals(REPORTSMODEL_ELEMENTTYPE_CATEGORY)) {
                this.getReportNodes(item, parent1);
            }
            ++i;
        }
    }

    private void getReportNodes(Node node, ReportsModel root) {
        ReportsModel parent1 = root;
        boolean addparent = true;
        NodeList childNodes2 = node.getChildNodes();
        int ii = 0;
        while (ii < childNodes2.getLength()) {
            Node item2 = childNodes2.item(ii);
            String nodeName2 = item2.getNodeName();
            if (nodeName2.equals(REPORTSMODEL_ELEMENTTYPE_REPORT)) {
                NamedNodeMap atrs = item2.getAttributes();
                String rptid = "";
                String rptname = "";
                String spm = "";
                String moduleinfo = "";
                int jj = 0;
                while (jj < atrs.getLength()) {
                    if (((Attr)atrs.item(jj)).getNodeName().equals("code")) {
                        rptid = ((Attr)atrs.item(jj)).getNodeValue();
                    } else if (((Attr)atrs.item(jj)).getNodeName().equals("description")) {
                        rptname = ((Attr)atrs.item(jj)).getNodeValue();
                    } else if (((Attr)atrs.item(jj)).getNodeName().equals("spm")) {
                        spm = ((Attr)atrs.item(jj)).getNodeValue();
                    } else if (((Attr)atrs.item(jj)).getNodeName().equals("moduleinfo")) {
                        moduleinfo = ((Attr)atrs.item(jj)).getNodeValue();
                    }
                    ++jj;
                }
                String optionprefs = this.getOptionPrefs(rptid);
                String lcoptionprefs = optionprefs.toLowerCase();
                String sortoptions = "";
                String sortlabels = "";
                String optionslabels = this.getReportOptions(item2, "optionslabels");
                if (optionslabels.length() > 0) {
                    optionslabels = optionslabels.substring(0, optionslabels.length() - 1);
                }
                if (lcoptionprefs.indexOf("sequence") >= 0) {
                    sortoptions = this.getReportOptions(item2, "sortoptions");
                    sortlabels = this.getReportOptions(item2, "sortlabels");
                }
                boolean stickyNotes = false;
                IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
                CorePlugin.getDefault();
                File notesFile = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + CorePlugin.getDefault().selobs.reqnum + File.separator + Platform.getNL() + File.separator + rptid + "-stickyNotes.txt");
                if (notesFile.exists()) {
                    stickyNotes = true;
                }
                IPreferenceStore iPreferenceStore2 = CorePlugin.getDefault().getPreferenceStore();
                CorePlugin.getDefault();
                File file = new File(String.valueOf(iPreferenceStore2.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + CorePlugin.getDefault().selobs.reqnum + File.separator + Platform.getNL() + File.separator + rptid + "-base.txt");
                if (file.exists()) {
                    if (addparent) {
                        atrs = node.getAttributes();
                        String parentrptid = ((Attr)atrs.item(1)).getNodeValue();
                        String parentoptionprefs = CorePlugin.getDefault().getPreferenceStore().getString(parentrptid);
                        ReportsModel mother = new ReportsModel(this.nodecnt, node.getNodeName(), ((Attr)atrs.item(1)).getNodeValue(), ((Attr)atrs.item(0)).getNodeValue(), parentoptionprefs, "", "", "", stickyNotes, parent1);
                        mother.spm = spm;
                        mother.moduleinfo = moduleinfo;
                        parent1.child.add(mother);
                        parent1 = mother;
                        ++this.nodecnt;
                        addparent = false;
                        CorePlugin.getDefault().reports.add(mother);
                        CorePlugin.getDefault().reportId.add(parentrptid);
                    }
                    ReportsModel mother = new ReportsModel(this.nodecnt, nodeName2, rptid, rptname, optionprefs, optionslabels, sortoptions, sortlabels, stickyNotes, parent1);
                    mother.spm = spm;
                    mother.moduleinfo = moduleinfo;
                    parent1.child.add(mother);
                    ++this.nodecnt;
                    CorePlugin.getDefault().reports.add(mother);
                    CorePlugin.getDefault().reportId.add(rptid);
                    if (stickyNotes) {
                        parent1.stickyNotes = true;
                    }
                }
            }
            ++ii;
        }
    }

    private String getReportOptions(Node node, String req) {
        String options = "";
        String val = "";
        NodeList childNodes2 = node.getChildNodes();
        int ii = 0;
        while (ii < childNodes2.getLength()) {
            Node item2 = childNodes2.item(ii);
            String nodeName2 = item2.getNodeName();
            if (nodeName2.equals("reportOption")) {
                NamedNodeMap atrs = item2.getAttributes();
                Node valatr = atrs.getNamedItem("value");
                Node labelatr = atrs.getNamedItem("label");
                Node sortatr = atrs.getNamedItem("sort");
                if (req.equalsIgnoreCase("optionslabels")) {
                    val = String.valueOf(val) + valatr.getNodeValue() + "|" + labelatr.getNodeValue() + ",";
                } else if (valatr.getNodeValue().equalsIgnoreCase("sequence")) {
                    if (req.equalsIgnoreCase("sortoptions") && sortatr != null) {
                        val = this.getOptionValue(item2, req);
                        options = String.valueOf(options) + val + ",";
                    } else if (req.equalsIgnoreCase("sortlabels")) {
                        val = this.getOptionValue(item2, req);
                        options = String.valueOf(options) + val + ",";
                    }
                }
            }
            ++ii;
        }
        return val;
    }

    private String getOptionPrefs(String rptid) {
        String optionprefs = "";
        IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
        CorePlugin.getDefault();
        File optionsFile = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + CorePlugin.getDefault().selobs.reqnum + File.separator + Platform.getNL() + File.separator + rptid + "-options.txt");
        if (optionsFile.exists()) {
            BufferedReader rdoptions = null;
            try {
                rdoptions = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(optionsFile.getAbsolutePath()), "UTF-8"));
                optionprefs = rdoptions.readLine();
                if (optionprefs == null) {
                    optionprefs = "";
                }
                rdoptions.close();
                optionsFile = null;
            }
            catch (IOException iOException) {}
        } else {
            optionprefs = CorePlugin.getDefault().getPreferenceStore().getString(rptid);
        }
        return optionprefs;
    }

    private String getOptionValue(Node node, String req) {
        String vals = "";
        NodeList childNodes2 = node.getChildNodes();
        int ii = 0;
        while (ii < childNodes2.getLength()) {
            Node item2 = childNodes2.item(ii);
            String nodeName2 = item2.getNodeName();
            if (nodeName2.equals("optionValue")) {
                NamedNodeMap atrs = item2.getAttributes();
                Node valatr = atrs.getNamedItem("value");
                Node labelatr = atrs.getNamedItem("label");
                if (req.equalsIgnoreCase("sortoptions")) {
                    Node dfltatr = atrs.getNamedItem("default");
                    Node hdrcolatr = atrs.getNamedItem("sorthdrpi");
                    Node bodycolatr = atrs.getNamedItem("sortbodypi");
                    vals = String.valueOf(vals) + valatr.getNodeValue() + "|" + labelatr.getNodeValue() + "|" + dfltatr.getNodeValue() + "|" + hdrcolatr.getNodeValue() + "|" + bodycolatr.getNodeValue() + ",";
                } else {
                    vals = String.valueOf(vals) + valatr.getNodeValue() + "|" + labelatr.getNodeValue() + ",";
                }
            }
            ++ii;
        }
        if (vals.length() > 0) {
            vals = vals.substring(0, vals.length() - 1);
        }
        return vals;
    }

    private File getSaveReportFile(String sreqnum, String rptid, String rptformat) {
        Shell shell = this.viewer.getControl().getShell();
        boolean runSaveDialog = true;
        String titleText = Messages.getString("ReportsView.Dialog.Text.SaveReport");
        titleText = titleText.replace("#rptformat", rptformat.toUpperCase());
        String filename = String.valueOf(CorePlugin.getDefault().productextension.getProductPrefix()) + "_" + CorePlugin.getDefault().activeStc + "_" + sreqnum;
        if (rptid.length() > 0) {
            filename = String.valueOf(filename) + "_" + rptid;
        }
        filename = String.valueOf(filename) + "." + rptformat;
        File file = null;
        FileDialog dialog = null;
        while (runSaveDialog) {
            dialog = new FileDialog(shell, 8192);
            dialog.setFilterNames(new String[]{String.valueOf(rptformat.toUpperCase()) + " Documents (*." + rptformat + ")", "All Files (*.*)"});
            dialog.setFilterExtensions(new String[]{"*." + rptformat, "*.*"});
            dialog.setFilterPath(CorePlugin.getDefault().getPreferenceStore().getString("saveReportPath"));
            dialog.setFileName(filename);
            dialog.setText(titleText);
            filename = dialog.open();
            if (filename != null) {
                file = new File(filename);
                if (file.exists()) {
                    if (MessageDialog.openConfirm((Shell)shell, (String)Messages.getString("ReportsView.ConfirmDialog.ConfirmTitle.ReplaceFile"), (String)(String.valueOf(Messages.getString("ReportsView.ConfirmDialog.ConfirmMessage.Replace")) + filename + "?"))) {
                        runSaveDialog = false;
                        continue;
                    }
                    file = null;
                    dialog = null;
                    continue;
                }
                runSaveDialog = false;
                continue;
            }
            runSaveDialog = false;
        }
        CorePlugin.getDefault().getPreferenceStore().setValue("saveReportPath", dialog.getFilterPath());
        dialog = null;
        return file;
    }

    private void clearSelections(TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            TreeItem[] childitems = items[i].getItems();
            items[i].setChecked(false);
            if (childitems.length > 0) {
                this.clearSelections(childitems);
            }
            ++i;
        }
    }

    private void doCheckedReport(TreeItem item) {
        ReportsModel report = (ReportsModel)item.getData();
        int j = 0;
        while (j < this.selreports.size()) {
            if (this.selreports.get((int)j).parent.reportid.equals(CorePlugin.getDefault().constants.REPORT_CATEGORY_SPM) ? this.selreports.get((int)j).spmModule.equals(report.spmModule) : this.selreports.get((int)j).reportid == report.reportid) {
                return;
            }
            ++j;
        }
        this.selreports.add(report);
    }

    public void runReportsPing() {
        Job job0 = new Job(Messages.getString("ReportsView.Job.Title.PingApa")){

            public IStatus run(IProgressMonitor monitor) {
                CorePlugin.getDefault().session.monitor = monitor;
                monitor.beginTask(Messages.getString("ReportsView.Job.Monitor.Ping"), 100);
                ReportsView.this.zosconnect.pingZos(monitor);
                monitor.done();
                if (ReportsView.this.zosconnect.getConnectRc() != 0) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job0.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("ReportsView Ping Job completed successfully");
                } else {
                    System.out.println("ReportsView Ping Job did not complete successfully");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("ReportsView Ping rc is " + (this).ReportsView.this.zosconnect.getConnectRc());
                        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                            ReportsView.this.showMessage("info", Messages.getString("ReportsView.MessageDialog.infoTitle.ReportsDownload"), String.valueOf(Messages.getString("ReportsView.MessageDialog.errorMessage.DownloadFailed")) + CorePlugin.getDefault().session.getReason());
                        } else if ((this).ReportsView.this.zosconnect.getConnectRc() == 0) {
                            ReportsView.this.runGetSelObsReports();
                        } else {
                            ReportsView.this.showMessage("info", String.valueOf(Messages.getString("ReportsView.MessageDialog.infoTitle.Zos")) + CorePlugin.getDefault().productextension.getProductName() + Messages.getString("ReportsView.MessageDialog.infoTitle.ConnectionLost"), String.valueOf(Messages.getString("ReportsView.MessageDialog.infoMessage.RemoteConnectionLost")) + Messages.getString("ReportsView.Messaging.ReConnect"));
                            (this).ReportsView.this.zosconnect.setConnectLocal();
                        }
                    }
                });
            }
        });
        job0.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job0.schedule();
    }

    private void runGetSelObsReports() {
        Job downloadJob = new Job(Messages.getString("ReportsView.Job.Title.DownloadingReports")){

            public IStatus run(IProgressMonitor monitor) {
                CorePlugin.getDefault().session.monitor = monitor;
                String sreqnum = "";
                ReportsView.this.selreports.size();
                ReportsView.this.rptobs = CorePlugin.getDefault().selobs;
                ReportsView.this.obsrpts.obs = ReportsView.this.rptobs;
                sreqnum = CorePlugin.getDefault().constants.reqdecfmt.format(((ReportsView)ReportsView.this).rptobs.reqnum);
                if (ReportsView.this.rptformat.equals(ReportsView.this.constants.REPORT_FORMAT_XML) | ReportsView.this.rptformat.equals(ReportsView.this.constants.REPORT_FORMAT_JSON) | ReportsView.this.rptformat.equals(ReportsView.this.constants.REPORT_FORMAT_PDF)) {
                    ReportsView.this.obsrpts.saveReportFname = (String)ReportsView.this.saveReportFnames.get(0);
                }
                if (ReportsView.this.obsrpts.rptformat.equals(ReportsView.this.constants.REPORT_FORMAT_XML) | ReportsView.this.rptformat.equals(ReportsView.this.constants.REPORT_FORMAT_JSON) | ReportsView.this.rptformat.equals(ReportsView.this.constants.REPORT_FORMAT_PDF)) {
                    ReportsView.this.obsrpts.runCloseObsReports(sreqnum, monitor);
                }
                monitor.beginTask(String.valueOf(Messages.getString("ReportsView.Job.Monitor.Downloading")) + "1" + Messages.getString("ReportsView.Job.Monitor.Of") + "1" + Messages.getString("ReportsView.Job.Monitor.ReportsForObservation") + sreqnum + " ...", 100);
                ReportsView.this.obsrpts.cookie = ReportsView.this.obsrpts.getCookie(sreqnum, monitor);
                if (ReportsView.this.selreports.size() > 0) {
                    int i = 0;
                    while (i < ReportsView.this.selreports.size()) {
                        if (((ReportsModel)((ReportsView)ReportsView.this).selreports.get((int)i)).parent.reportid.equalsIgnoreCase(ReportsView.this.constants.REPORT_CATEGORY_MULTIADDR)) {
                            ReportsView.this.obsrpts.cookie = ReportsView.this.obsrpts.getDsns(ReportsView.this.obsrpts.cookie, sreqnum, "multiaddrdsns", monitor);
                        } else if (((ReportsModel)((ReportsView)ReportsView.this).selreports.get((int)i)).parent.reportid.equalsIgnoreCase(ReportsView.this.constants.REPORT_CATEGORY_VARIANCE)) {
                            ReportsView.this.obsrpts.cookie = ReportsView.this.obsrpts.getDsns(ReportsView.this.obsrpts.cookie, sreqnum, "variancedsns", monitor);
                        }
                        ReportsView.this.obsrpts.ccards.persistReportOptions(((ReportsModel)((ReportsView)ReportsView.this).selreports.get((int)i)).reportid, "model");
                        ++i;
                    }
                } else if (ReportsView.this.obsrpts.rptid.length() > 0) {
                    ReportsView.this.obsrpts.ccards.persistReportOptions(ReportsView.this.obsrpts.rptid, "model");
                }
                ReportsView.this.obsrpts.buildControlCards(ReportsView.this.selreports);
                ReportsView.this.obsrpts.parseRemoteReports(monitor, sreqnum);
                if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                    this.setName("");
                    ReportsView.this.obsrpts.getobsrc = CorePlugin.getDefault().session.getReturnCode();
                    ReportsView.this.obsrpts.getobsrsn = CorePlugin.getDefault().session.getReason();
                    if (ReportsView.this.obsrpts.getobsrsn.startsWith(CorePlugin.getDefault().productextension.getZosProductId())) {
                        ReportsView.this.obsrpts.getobsrsn = ReportsView.this.obsrpts.getobsrsn.substring(ReportsView.this.obsrpts.getobsrsn.indexOf(" ") + 1, ReportsView.this.obsrpts.getobsrsn.length());
                    }
                    ReportsView.this.obsrpts.runCloseObsReports(sreqnum, monitor);
                    return Status.CANCEL_STATUS;
                }
                if (!ReportsView.this.rptformat.equals(ReportsView.this.constants.REPORT_FORMAT_PVML) && CorePlugin.getDefault().getPreferenceStore().getBoolean("launchXml") | CorePlugin.getDefault().getPreferenceStore().getBoolean("launchPdf")) {
                    ReportsView.this.obsrpts.runLaunchProgram();
                }
                if (!(ReportsView.this.reqaction.equals(ReportsView.this.constants.ACTION_REPORTS) & ReportsView.this.obsrpts.rptformat.equals(ReportsView.this.constants.REPORT_FORMAT_PVML))) {
                    ReportsView.this.obsrpts.runCloseObsReports(sreqnum, monitor);
                }
                monitor.worked(100);
                if (monitor.isCanceled()) {
                    this.setName("");
                    return Status.CANCEL_STATUS;
                }
                if (ReportsView.this.reqaction.equals(ReportsView.this.constants.ACTION_VARIANCE) | ReportsView.this.reqaction.equals(ReportsView.this.constants.ACTION_CICSMASS)) {
                    monitor.done();
                    this.setName("");
                    return Status.OK_STATUS;
                }
                monitor.done();
                this.setName("");
                return Status.OK_STATUS;
            }
        };
        downloadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                event.getResult().isOK();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).ReportsView.this.obsrpts.getobsrc == 0 | (this).ReportsView.this.obsrpts.getobsrc == -98) {
                            if ((this).ReportsView.this.rptformat.equals((this).ReportsView.this.constants.REPORT_FORMAT_PVML)) {
                                int i = 0;
                                while (i < ReportsView.this.selreports.size()) {
                                    ReportsView.this.showTextReport((ReportsModel)ReportsView.this.selreports.get(i));
                                    ++i;
                                }
                            }
                            ReportsView.this.selectionsAction.run();
                        } else if ((this).ReportsView.this.obsrpts.getobsrc == -99) {
                            ReportsView.this.showMessage("I", Messages.getString("ReportsView.MessageDialog.infoTitle.DownloadReports"), String.valueOf(Messages.getString("ReportsView.MessageDialog.infoMessage.RemoteConnectionClosed")) + Messages.getString("ReportsView.Messaging.ReConnect"));
                            (this).ReportsView.this.zosconnect.setConnectLocal();
                        } else if ((this).ReportsView.this.obsrpts.getobsrc == 13) {
                            ReportsView.this.showMessage("E", Messages.getString("ReportsView.MessageDialog.errorTitle.DownloadReports"), String.valueOf(Messages.getString("ReportsView.MessageDialog.errorMessage.ReportsDownloadFor")) + (this).ReportsView.this.obsrpts.obs.reqnum + Messages.getString("ReportsView.MessageDialog.errorMessage.FailedCheckApa") + (this).ReportsView.this.obsrpts.getobsrsn);
                        } else {
                            ReportsView.this.showMessage("E", Messages.getString("ReportsView.MessageDialog.errorTitle.DownloadReports"), String.valueOf(Messages.getString("ReportsView.MessageDialog.errorMessage.ReportsDownloadFor2")) + (this).ReportsView.this.obsrpts.obs.reqnum + Messages.getString("ReportsView.MessageDialog.errorMessage.Failed") + (this).ReportsView.this.obsrpts.getobsrsn);
                        }
                    }
                });
            }
        });
        downloadJob.setRule(CorePlugin.getDefault().schedrule);
        downloadJob.setUser(true);
        downloadJob.setPriority(20);
        downloadJob.schedule();
    }

    private void checkAllItems(TreeItem[] items) {
        ReportsModel rptsmodel = (ReportsModel)this.tree.getData();
        int i = 0;
        while (i < items.length) {
            TreeItem[] childitems = items[i].getItems();
            rptsmodel = (ReportsModel)items[i].getData();
            if (rptsmodel.elementtype.equals(REPORTSMODEL_ELEMENTTYPE_REPORT)) {
                items[i].setChecked(true);
                this.selreports.add(rptsmodel);
            }
            if (childitems.length > 0) {
                this.checkAllItems(childitems);
            }
            ++i;
        }
    }
}

