/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.views.reports;

import com.banknet.core.CorePlugin;
import com.banknet.core.actions.DisposeReportsAction;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.data.reports.ObservationReports;
import com.banknet.core.data.reports.ReportHtmlBuilder;
import com.banknet.core.dialogs.StickyNotesDialog;
import com.banknet.core.dialogs.reports.Db2ExplainDialog;
import com.banknet.core.dialogs.reports.FindTextDialog;
import com.banknet.core.dialogs.reports.ReportDetailDialog;
import com.banknet.core.dialogs.reports.ReportOptionsDialog;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.Utilities;
import com.banknet.core.internal.pvmlExpandCollapse;
import com.banknet.core.internal.pvmlReader;
import com.banknet.core.internal.pvmlSort;
import com.banknet.core.models.ReportsModel;
import com.banknet.core.views.reports.Messages;
import com.banknet.core.views.reports.ReportEditor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ReportTextView
extends ViewPart {
    public static final String ID = "com.banknet.core.ReportTextView";
    public pvmlReader pv;
    public pvmlExpandCollapse pvec;
    public pvmlSort pvsort;
    private Utilities util = new Utilities();
    Constants constants = new Constants();
    ZosConnect zosconnect = new ZosConnect();
    ObservationReports obsrpts;
    ReportEditor rpteditor = new ReportEditor();
    ISelectionChangedListener textViewerListener;
    StyledText textViewer;
    StyledText reportLabel;
    StyledText printText;
    CLabel titleLabel;
    ScrolledComposite sc2;
    Composite client;
    SimpleDateFormat dtfmt = new SimpleDateFormat("MMM dd yyyy HH:mm:ss");
    String[] stra;
    String[] activelinksHeader;
    String[] activelinksBody;
    StringBuilder stylingHeader;
    StringBuilder stylingBody;
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);
    StringBuilder detailList = new StringBuilder();
    String[] detailOffsets;
    char extRptLinkType = (char)69;
    int seloffset = 0;
    String reportLocation = "";
    public String stcid = "";
    public String rptid = "";
    public String rptname = "";
    public String jobname = "";
    public String selectedRptid = "";
    public String reportTitle = "";
    public String reportDetailTitle = "";
    public String reportPath = "";
    public Integer reqnum = 0;
    String sreqnum = "";
    int linenum = 0;
    private Action saveAction;
    private Action printAction;
    private Action copyAction;
    private Action findAction;
    private Action selectAllAction;
    private Action disposeReportAction;
    private Action disposeReportsAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    private Action[] sortHdrActions;
    private Action[] sortBodyActions;
    private Action reportDetailAction;
    private Action spmAction;
    private Action moduleInfoAction;
    private Action testAction;
    private Action db2ExplainAction;
    private Action stickyNotesAction;
    private Action launchHtmlAction;
    private Action reportOptionsAction;
    private Action downloadReportAction;
    private MouseListener reportLabelMouseListener;
    private Listener reportLabelMouseMoveListener;
    private MouseListener textViewerMouseListener;
    private Listener textViewerMouseMoveListener;
    private Listener textViewerKeyDownListener;
    private FocusAdapter textViewerFocusListener;
    private SelectionListener textViewerSelectionListener;
    private IPartListener2 partListener;
    List<String> colorStyles = new ArrayList<String>();
    List<Color> colorCodes = new ArrayList<Color>();
    Cursor arrowCursor = new Cursor((Device)Display.getCurrent(), 0);
    Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
    FindTextDialog finddialog;
    public int searchloc = 0;
    public String searchtxt = "";
    ReportTextView rtv = this;
    String reporttext = "";
    ProgressBar progressBar;
    Composite barContainer;
    FontData displayFont10 = new FontData(Display.getCurrent().getSystemFont().getFontData()[0].getName(), 10, 0);
    FontData displayFont9 = new FontData(Display.getCurrent().getSystemFont().getFontData()[0].getName(), 9, 0);
    FontData defaultFont;
    Font clientFont;
    Color clientBackground;
    public List<StyleRange> listPrintStyles;
    public List<StyleRange> listHeaderStyles;
    public List<StyleRange> listBodyStyles;
    public StyleRange stylerange;
    public StyleRange printstylerange;
    String activelink = "";
    String ctxactivelink = "";
    public String printPVML = new String();
    String errorTitle = "";
    String errorMsg = "";
    String copyFromId = "";
    String copyToId = "";
    String optionsprefs = "";
    String contextheaderlink = "";
    String contextbodylink = "";
    String sortactivelink = "";
    String sortvalue = "";
    String sortpi = "";
    String[] sorts;
    int underlineStyle = 0;
    boolean doubleclicked = false;
    String lcmdopt = "";
    String rptformat = "";
    boolean isJavaReport = false;
    boolean isDb2Report = false;
    String rpttypTitle = "";
    String rptDetailOffset = "";
    boolean disposeAll = false;
    boolean rptDetailDone = false;
    String printTitle = "";
    String reqaction = "";
    private static final String ACTION_REPORTDETAIL = "reportdetail";
    ReportsModel report;
    String detailsuffix = "-detailbase";
    String db2suffix = "-db2";
    Image greenReportImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/msGreen.gif").createImage();
    private String saveReportFname = "";
    private final IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals("findText")) {
                if (ReportTextView.this.finddialog.rtv != null) {
                    ReportTextView.this.findText();
                }
            } else if (event.getKey().equals("obsReports")) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
        }
    };

    public ReportTextView() {
        String OSenv = System.getProperty("os.name").toLowerCase();
        String fontName = Messages.getString("ReportTextView.FontName");
        if (OSenv.startsWith("linux")) {
            fontName = Messages.getString("ReportTextView.FontName.Linux");
        } else if (OSenv.startsWith("mac")) {
            fontName = Messages.getString("ReportTextView.FontName.Mac");
        }
        int fontHeight = new Integer(Messages.getString("ReportTextView.FontHeight"));
        this.defaultFont = new FontData(fontName, fontHeight, 0);
        this.underlineStyle = new Integer(Messages.getString("ReportTextView.UnderlineStyle"));
        this.clientFont = new Font((Device)Display.getCurrent(), this.defaultFont);
        this.clientBackground = Display.getCurrent().getSystemColor(1);
        this.loadColors();
        IEclipsePreferences preferencesI = InstanceScope.INSTANCE.getNode("com.banknet.core");
        preferencesI.addPreferenceChangeListener(this.preferenceChangeListener);
    }

    public void createPartControl(Composite parent) {
        if (CorePlugin.getDefault().rptid.length() <= 0) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ReportTextView.this.dispose();
                }
            });
        }
        if (CorePlugin.getDefault().rptid.length() > 0) {
            this.reportTitle = String.valueOf(CorePlugin.getDefault().rptid) + ":  " + CorePlugin.getDefault().rptname + " (" + CorePlugin.getDefault().activeStc + "/" + CorePlugin.getDefault().constants.reqdecfmt.format(CorePlugin.getDefault().selobs.reqnum) + "/" + CorePlugin.getDefault().selobs.jobname + ")";
            this.rptname = CorePlugin.getDefault().rptname;
            this.printTitle = String.valueOf(CorePlugin.getDefault().rptid) + ":  " + CorePlugin.getDefault().rptname + " (" + CorePlugin.getDefault().activeStc + "/" + CorePlugin.getDefault().constants.reqdecfmt.format(CorePlugin.getDefault().selobs.reqnum) + "/" + CorePlugin.getDefault().selobs.jobname + ")";
        }
        this.setPartName(this.reportTitle);
        this.setTitleImage(this.greenReportImage);
        this.stcid = CorePlugin.getDefault().activeStc;
        this.rptid = CorePlugin.getDefault().rptid;
        if (CorePlugin.getDefault().selobs != null) {
            this.reqnum = CorePlugin.getDefault().selobs.reqnum;
        }
        this.sreqnum = CorePlugin.getDefault().constants.reqdecfmt.format(this.reqnum);
        if (CorePlugin.getDefault().selobs != null) {
            this.jobname = CorePlugin.getDefault().selobs.jobname;
        }
        IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
        CorePlugin.getDefault();
        this.reportPath = String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + this.stcid + File.separator + this.reqnum + File.separator + Platform.getNL() + File.separator;
        if (this.rptid.length() > 0) {
            this.copyReportFile("base0", "active");
            this.report = CorePlugin.getDefault().reports.get(CorePlugin.getDefault().reportId.indexOf(this.rptid));
        }
        this.client = new Composite(parent, 4);
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumWidth = 0;
        this.client.setLayoutData((Object)gd);
        this.client.setLayout((Layout)new GridLayout(1, false));
        this.client.setFont(this.clientFont);
        this.client.setBackground(this.clientBackground);
        this.titleLabel = new CLabel(this.client, 16384);
        this.titleLabel.setText(this.reportTitle);
        GridData gdxx = new GridData(4, 4, true, false);
        this.titleLabel.setLayoutData((Object)gdxx);
        this.titleLabel.setFont(this.clientFont);
        if (!CorePlugin.getDefault().getPreferenceStore().getBoolean("colorMonochrome")) {
            this.titleLabel.setBackground(new Color[]{this.constants.COLOR_ALT_ROW_GREEN, new Color(null, 199, 233, 193), new Color(null, 174, 222, 166), parent.getDisplay().getSystemColor(16)}, new int[]{33, 67, 100});
        }
        this.titleLabel.setVisible(false);
        this.reportLabel = new StyledText(this.client, 0);
        this.reportLabel.setText("");
        if (!CorePlugin.getDefault().getPreferenceStore().getBoolean("colorMonochrome")) {
            this.reportLabel.setForeground(Display.getCurrent().getSystemColor(10));
        }
        this.reportLabel.setEditable(false);
        Color bg2 = Display.getDefault().getSystemColor(1);
        this.reportLabel.setBackground(bg2);
        this.reportLabel.setFont(this.clientFont);
        GridData spec2 = new GridData();
        spec2.horizontalAlignment = 4;
        spec2.grabExcessHorizontalSpace = true;
        this.reportLabel.setLayoutData((Object)spec2);
        this.reportLabel.setVisible(false);
        this.textViewer = new StyledText(this.client, 770);
        this.textViewer.setCursor(this.arrowCursor);
        GridData spec = new GridData();
        spec.horizontalAlignment = 4;
        spec.grabExcessHorizontalSpace = true;
        spec.verticalAlignment = 4;
        spec.grabExcessVerticalSpace = true;
        this.textViewer.setLayoutData((Object)spec);
        this.textViewer.setEditable(false);
        Color bg = Display.getDefault().getSystemColor(1);
        this.textViewer.setBackground(bg);
        this.textViewer.setFont(this.clientFont);
        this.textViewer.setVisible(false);
        if (this.rptid.length() > 0) {
            this.loadReportJob();
            this.addReportListeners();
            this.makeActions();
            this.hookContextMenu();
            this.contributeToActionBars();
            this.activateContext();
        } else {
            try {
                if (PlatformUI.isWorkbenchRunning()) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (CorePlugin.getDefault().getPreferenceStore().getBoolean("obsLoaded")) {
                        page.hideView((IViewPart)this);
                    }
                }
            }
            catch (Throwable throwable) {}
        }
        CorePlugin.getDefault().connectionextension.setConnectionStatus(this.getViewSite());
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        CorePlugin.getDefault().connectionextension.createConnectionListener();
    }

    public String getPartProperty(String key) {
        String partkey = CorePlugin.getDefault().connectionextension.getConnectionPartKey(key);
        if (partkey.length() > 0) {
            return partkey;
        }
        return super.getPartProperty(key);
    }

    private void addReportListeners() {
        this.reportLabelMouseListener = new MouseListener(){

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                try {
                    int offset = ReportTextView.this.reportLabel.getOffsetAtLocation(new Point(e.x, e.y));
                    if (ReportTextView.this.doubleclicked) {
                        ReportTextView.this.doubleclicked = false;
                    } else if (ReportTextView.this.reportLabel.getStyleRangeAtOffset(offset) != null && ReportTextView.this.reportLabel.getStyleRangeAtOffset((int)offset).underline) {
                        ReportTextView.this.activelink = ReportTextView.this.getActiveLink(offset, ReportTextView.this.activelinksHeader);
                        ReportTextView.this.contextbodylink = "";
                        if (ReportTextView.this.activelink.length() > 0 && e.button == 3) {
                            ReportTextView.this.contextheaderlink = ReportTextView.this.activelink;
                        }
                    }
                }
                catch (Exception exception) {}
            }

            public void mouseDoubleClick(MouseEvent e) {
                ReportTextView.this.doubleclicked = true;
            }

            public void mouseClick(MouseEvent e) {
            }
        };
        this.reportLabel.addMouseListener(this.reportLabelMouseListener);
        this.reportLabelMouseMoveListener = new Listener(){

            public void handleEvent(Event e) {
                try {
                    ReportTextView.this.activelink = "";
                    ReportTextView.this.contextbodylink = "";
                    if (e.stateMask == 0) {
                        ReportTextView.this.reportLabel.setCursor(ReportTextView.this.arrowCursor);
                        ReportTextView.this.reportLabel.getSelection();
                        int offset = ReportTextView.this.reportLabel.getOffsetAtLocation(new Point(e.x, e.y));
                        if (ReportTextView.this.reportLabel.getStyleRangeAtOffset(offset) != null && ReportTextView.this.reportLabel.getStyleRangeAtOffset((int)offset).underline) {
                            ReportTextView.this.activelink = ReportTextView.this.getActiveLink(offset, ReportTextView.this.activelinksHeader);
                            if (ReportTextView.this.activelink.length() > 0) {
                                ReportTextView.this.reportLabel.setCursor(ReportTextView.this.handCursor);
                            }
                        }
                    }
                }
                catch (Exception exception) {}
            }
        };
        this.reportLabel.addListener(5, this.reportLabelMouseMoveListener);
        this.textViewerMouseListener = new MouseListener(){

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                int offset = 0;
                try {
                    offset = ReportTextView.this.textViewer.getOffsetAtLocation(new Point(e.x, e.y));
                }
                catch (Exception exception) {
                    offset = -1;
                }
                if (ReportTextView.this.doubleclicked) {
                    ReportTextView.this.doubleclicked = false;
                } else if (offset != -1 && ReportTextView.this.textViewer.getStyleRangeAtOffset(offset) != null && ReportTextView.this.textViewer.getStyleRangeAtOffset((int)offset).underline) {
                    ReportTextView.this.activelink = ReportTextView.this.getActiveLink(offset, ReportTextView.this.activelinksBody);
                    ReportTextView.this.contextheaderlink = "";
                    if (ReportTextView.this.activelink.length() > 0) {
                        if (e.button != 3) {
                            ReportTextView.this.runActiveLink(ReportTextView.this.activelink);
                        } else {
                            ReportTextView.this.contextbodylink = ReportTextView.this.activelink;
                        }
                    }
                }
                ReportTextView.this.getLineColumn();
            }

            public void mouseDoubleClick(MouseEvent e) {
                ReportTextView.this.doubleclicked = true;
            }
        };
        this.textViewer.addMouseListener(this.textViewerMouseListener);
        this.textViewerMouseMoveListener = new Listener(){

            public void handleEvent(Event e) {
                try {
                    ReportTextView.this.activelink = "";
                    ReportTextView.this.contextheaderlink = "";
                    if (e.stateMask == 0) {
                        ReportTextView.this.textViewer.setCursor(ReportTextView.this.arrowCursor);
                        ReportTextView.this.textViewer.getSelection();
                        int offset = ReportTextView.this.textViewer.getOffsetAtLocation(new Point(e.x, e.y));
                        if (ReportTextView.this.textViewer.getStyleRangeAtOffset(offset) != null && ReportTextView.this.textViewer.getStyleRangeAtOffset((int)offset).underline) {
                            ReportTextView.this.activelink = ReportTextView.this.getActiveLink(offset, ReportTextView.this.activelinksBody);
                            if (ReportTextView.this.activelink.length() > 0) {
                                ReportTextView.this.textViewer.setCursor(ReportTextView.this.handCursor);
                            }
                        }
                    }
                }
                catch (Exception exception) {}
            }
        };
        this.textViewer.addListener(5, this.textViewerMouseMoveListener);
        this.textViewerKeyDownListener = new Listener(){

            public void handleEvent(Event e) {
                ReportTextView.this.getLineColumn();
            }
        };
        this.textViewer.addListener(1, this.textViewerKeyDownListener);
        this.textViewerFocusListener = new FocusAdapter(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ReportTextView.this.getLineColumn();
            }
        };
        this.textViewer.addFocusListener((FocusListener)this.textViewerFocusListener);
        this.textViewerSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                switch (e.detail) {
                    case 1: {
                        ReportTextView.this.reportLabel.setHorizontalIndex(ReportTextView.this.textViewer.getHorizontalIndex());
                        break;
                    }
                    case 0x1000002: {
                        ReportTextView.this.reportLabel.setHorizontalIndex(ReportTextView.this.textViewer.getHorizontalIndex());
                        break;
                    }
                    case 0x1000001: {
                        ReportTextView.this.reportLabel.setHorizontalIndex(ReportTextView.this.textViewer.getHorizontalIndex());
                    }
                }
            }
        };
        this.textViewer.getHorizontalBar().addSelectionListener(this.textViewerSelectionListener);
        this.partListener = new IPartListener2(){

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partActivated(IWorkbenchPartReference partRef) {
                String vid = partRef.getId().toLowerCase();
                if (vid.contains("reporttextview")) {
                    String focuspage = partRef.getTitle();
                    IWorkbenchPart prt = partRef.getPart(false);
                    if (prt != null) {
                        if (focuspage.length() <= 0) {
                            ReportTextView.this.dispose();
                        } else {
                            String focushoststcid = ((ReportTextView)prt).stcid;
                            String focusreqnum = CorePlugin.getDefault().constants.reqdecfmt.format(((ReportTextView)prt).reqnum);
                            String focusrptid = ((ReportTextView)prt).rptid;
                            if (focusreqnum.equals(ReportTextView.this.sreqnum)) {
                                ReportTextView.this.downloadReportAction.setEnabled(true);
                                ReportTextView.this.reportOptionsAction.setEnabled(true);
                                if (!ReportTextView.this.stcid.equals(CorePlugin.getDefault().activeStc)) {
                                    ReportTextView.this.downloadReportAction.setEnabled(false);
                                    ReportTextView.this.reportOptionsAction.setEnabled(false);
                                }
                                String focuskey = String.valueOf(focushoststcid) + "|" + focusreqnum + "|" + focusrptid;
                                CorePlugin.getDefault().getPreferenceStore().setValue("focusReport", focuskey);
                            }
                        }
                    }
                }
            }
        };
        this.getViewSite().getPage().addPartListener(this.partListener);
    }

    private void getLineColumn() {
        int caretoffset = this.textViewer.getCaretOffset();
        int linenum = this.textViewer.getLineAtOffset(caretoffset);
        int colnum = this.textViewer.getOffsetAtLine(linenum) - caretoffset;
        colnum = Math.abs(colnum);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(String.valueOf(linenum) + " : " + colnum);
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext("com.banknet.core.ReportTextView.context");
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ReportTextView.this.fillContextMenu(manager);
            }
        });
        Menu menuHeader = menuMgr.createContextMenu((Control)this.reportLabel);
        this.reportLabel.setMenu(menuHeader);
        Menu menuBody = menuMgr.createContextMenu((Control)this.textViewer);
        this.textViewer.setMenu(menuBody);
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this.activelink.length() > 0) {
            int i;
            this.ctxactivelink = this.activelink;
            if (this.contextheaderlink.length() > 0) {
                i = 0;
                while (i < this.sortHdrActions.length) {
                    if (this.sortHdrActions[i] != null) {
                        manager.add((IAction)this.sortHdrActions[i]);
                    }
                    ++i;
                }
            }
            if (this.contextbodylink.length() > 0) {
                if (this.detailOffsets.length > 0 && this.activelink.charAt(0) != this.extRptLinkType) {
                    manager.add((IAction)this.reportDetailAction);
                    if (this.stcid.equals(CorePlugin.getDefault().activeStc)) {
                        this.reportDetailAction.setEnabled(true);
                        if (this.isDb2Report) {
                            manager.add((IAction)this.db2ExplainAction);
                        }
                    } else {
                        this.reportDetailAction.setEnabled(false);
                    }
                }
                if (this.sortBodyActions != null) {
                    manager.add((IContributionItem)new Separator());
                    i = 0;
                    while (i < this.sortBodyActions.length) {
                        if (this.sortBodyActions[i] != null) {
                            manager.add((IAction)this.sortBodyActions[i]);
                        }
                        ++i;
                    }
                }
                if (this.detailOffsets.length > 0 && this.activelink.charAt(0) != this.extRptLinkType) {
                    manager.add((IContributionItem)new Separator());
                    if (this.stcid.equals(CorePlugin.getDefault().activeStc)) {
                        if (this.report.moduleinfo.equals("1")) {
                            manager.add((IAction)this.moduleInfoAction);
                        }
                        if (this.report.spm.equals("1")) {
                            manager.add((IAction)this.spmAction);
                        }
                    }
                }
            }
        }
        this.textViewer.setCursor(this.arrowCursor);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler("com.banknet.core.ReportTextView.printCommand", (IAction)this.printAction);
        bars.setGlobalActionHandler("com.banknet.core.ReportTextView.copyCommand", (IAction)this.copyAction);
        bars.setGlobalActionHandler("com.banknet.core.ReportTextView.findCommand", (IAction)this.findAction);
        bars.setGlobalActionHandler("com.banknet.core.ReportTextView.saveCommand", (IAction)this.saveAction);
        bars.setGlobalActionHandler("com.banknet.core.ReportTextView.disposeReportCommand", (IAction)this.disposeReportAction);
        bars.setGlobalActionHandler("com.banknet.core.ReportTextView.disposeReportsCommand", (IAction)this.disposeReportsAction);
        bars.setGlobalActionHandler("com.banknet.core.ReportTextView.selectAllCommand", (IAction)this.selectAllAction);
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
        this.getViewSite().getActionBars().updateActionBars();
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.stickyNotesAction);
        manager.add((IAction)this.launchHtmlAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.printAction);
        manager.add((IAction)this.saveAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.findAction);
        manager.add((IAction)this.selectAllAction);
        manager.add((IAction)this.copyAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.expandAllAction);
        manager.add((IAction)this.collapseAllAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.disposeReportAction);
        manager.add((IAction)this.disposeReportsAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.reportOptionsAction);
        manager.add((IAction)this.downloadReportAction);
        manager.add((IAction)this.stickyNotesAction);
        manager.add((IAction)this.launchHtmlAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.printAction);
        manager.add((IAction)this.saveAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.findAction);
        manager.add((IAction)this.copyAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.expandAllAction);
        manager.add((IAction)this.collapseAllAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.disposeReportAction);
        manager.add((IAction)this.disposeReportsAction);
    }

    private void makeActions() {
        this.expandAllAction = new Action(){

            public void run() {
                ReportTextView.this.copyFromId = "base";
                ReportTextView.this.copyToId = "active";
                ReportTextView.this.copyReportJob();
            }
        };
        this.expandAllAction.setText(Messages.getString("ReportTextView.Action.ExpandAll"));
        this.expandAllAction.setToolTipText(Messages.getString("ReportTextView.Tooltip.ExpandAll"));
        this.expandAllAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/elcl16/expandall.gif"));
        this.expandAllAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/dlcl16/expandall.gif"));
        this.expandAllAction.setEnabled(true);
        CorePlugin.getDefault().getPreferenceStore().getString(this.rptid).toLowerCase();
        this.collapseAllAction = new Action(){

            public void run() {
                ReportTextView.this.copyFromId = "base0";
                ReportTextView.this.copyToId = "active";
                ReportTextView.this.copyReportJob();
            }
        };
        this.collapseAllAction.setText(Messages.getString("ReportTextView.Action.CollapseAll"));
        this.collapseAllAction.setToolTipText(Messages.getString("ReportTextView.Tooltip.CollapseAll"));
        this.collapseAllAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/elcl16/collapseall.gif"));
        this.collapseAllAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/dlcl16/collapseall.gif"));
        this.collapseAllAction.setEnabled(true);
        this.saveAction = new Action(){

            public void run() {
                try {
                    File file = ReportTextView.this.getSaveReport();
                    if (file != null) {
                        String savefile = file.getName().toLowerCase();
                        if (savefile.contains(".htm")) {
                            ReportTextView.this.saveasHtmlFile(file);
                        } else {
                            ReportTextView.this.saveasTextFile(file);
                        }
                        file = null;
                    }
                }
                catch (Exception e) {
                    String logstr = "saveAction:  exception " + e;
                    System.out.println("ReportTextView " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    MessageDialog.openError((Shell)ReportTextView.this.textViewer.getShell(), (String)Messages.getString("ReportTextView.MessageDialog.errorTitle.SaveError"), (String)e.getLocalizedMessage());
                }
                try {
                    ReportTextView.this.printText.dispose();
                }
                catch (Exception exception) {}
                ReportTextView.this.printText = null;
                System.gc();
            }
        };
        this.saveAction.setText(Messages.getString("ReportTextView.Action.SaveAs"));
        this.saveAction.setEnabled(true);
        this.saveAction.setActionDefinitionId("com.banknet.core.ReportTextView.saveCommand");
        this.saveAction.setToolTipText(Messages.getString("ReportTextView.Tooltip.SaveAs"));
        this.saveAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/saveas_edit.gif"));
        this.printAction = new Action(){

            public void run() {
                try {
                    ReportTextView.this.loadPrintText();
                    PrintDialog printdialog = new PrintDialog(ReportTextView.this.textViewer.getShell(), 0);
                    PrinterData printdata = printdialog.open();
                    StyledTextPrintOptions printoptions = new StyledTextPrintOptions();
                    printoptions.footer = "\t\t<page>";
                    String dt = ReportTextView.this.dtfmt.format(new Date());
                    printoptions.header = String.valueOf(CorePlugin.getDefault().productextension.getPrintHeader()) + "\t\n" + ReportTextView.this.reportTitle + "\t" + dt;
                    printoptions.printTextFontStyle = true;
                    printoptions.printTextForeground = true;
                    printoptions.printTextBackground = true;
                    printoptions.printLineBackground = true;
                    printoptions.jobName = ReportTextView.this.printTitle;
                    printoptions.printLineBackground = true;
                    if (printdata != null) {
                        Printer printer = new Printer(printdata);
                        Runnable runnable = ReportTextView.this.printText.print(printer, printoptions);
                        runnable.run();
                        runnable = null;
                        printer = null;
                    }
                    printdialog = null;
                    printdata = null;
                    printoptions = null;
                    ReportTextView.this.printText.dispose();
                    ReportTextView.this.printText = null;
                    System.gc();
                }
                catch (OutOfMemoryError oem) {
                    String logstr = "printAction:  out of memory exception " + oem;
                    System.out.println("ReportTextView " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    MessageDialog.openError((Shell)ReportTextView.this.textViewer.getShell(), (String)Messages.getString("ReportTextView.MessageDialog.errorTitle.OEM"), (String)(String.valueOf(Messages.getString("ReportTextView.MessageDialog.errorMessage.PrintReportOEM")) + ReportTextView.this.printTitle));
                    ReportTextView.this.clearObjs();
                    ReportTextView.this.dispose();
                }
                catch (Exception e) {
                    String logstr = "printAction:  exception " + e;
                    System.out.println("ReportTextView " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    MessageDialog.openError((Shell)ReportTextView.this.textViewer.getShell(), (String)Messages.getString("ReportTextView.MessageDialog.errorTitle.PrintError"), (String)e.getLocalizedMessage());
                }
            }
        };
        this.printAction.setText(Messages.getString("ReportTextView.Action.Print"));
        this.printAction.setActionDefinitionId("com.banknet.core.ReportTextView.printCommand");
        this.printAction.setToolTipText(Messages.getString("ReportTextView.Tooltip.Print"));
        this.printAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/print_edit.gif"));
        this.copyAction = new Action(){

            public void run() {
                if (ReportTextView.this.printText == null) {
                    if (ReportTextView.this.reportLabel.getSelectionCount() > 0) {
                        ReportTextView.this.reportLabel.copy();
                    } else {
                        ReportTextView.this.textViewer.copy();
                    }
                } else {
                    ReportTextView.this.printText.copy();
                    try {
                        ReportTextView.this.printText.dispose();
                    }
                    catch (Exception exception) {}
                    ReportTextView.this.printText = null;
                    System.gc();
                }
            }
        };
        this.copyAction.setText(Messages.getString("ReportTextView.Action.Copy"));
        this.copyAction.setActionDefinitionId("com.banknet.core.ReportTextView.copyCommand");
        this.copyAction.setToolTipText(Messages.getString("ReportTextView.Tooltip.Copy"));
        this.copyAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/copy_edit.gif"));
        this.selectAllAction = new Action(){

            public void run() {
                int linelimit = 200000;
                if (ReportTextView.this.textViewer.getLineCount() > linelimit) {
                    ReportTextView.this.showErrorMessage(Messages.getString("ReportTextView.MessageDialog.errorTitle.SelectAll"), String.valueOf(Messages.getString("ReportTextView.MessageDialog.errorMessage.TooManyLines")) + linelimit + ".");
                } else {
                    ReportTextView.this.textViewer.selectAll();
                    ReportTextView.this.loadPrintText();
                    ReportTextView.this.printText.selectAll();
                }
            }
        };
        this.selectAllAction.setText(Messages.getString("ReportTextView.Action.SelectAll"));
        this.selectAllAction.setActionDefinitionId("com.banknet.core.ReportTextView.selectAllCommand");
        this.selectAllAction.setToolTipText(Messages.getString("ReportTextView.Tooltip.SelectAll"));
        this.findAction = new Action(){

            public void run() {
                ReportTextView.this.searchtxt = "";
                ReportTextView.this.searchloc = 0;
                ReportTextView.this.finddialog = new FindTextDialog(ReportTextView.this.textViewer.getShell(), ReportTextView.this.rtv);
                ReportTextView.this.finddialog.open();
                ReportTextView.this.finddialog = null;
            }
        };
        this.findAction.setText(Messages.getString("ReportTextView.Action.Find"));
        this.findAction.setActionDefinitionId("com.banknet.core.ReportTextView.findCommand");
        this.findAction.setToolTipText(Messages.getString("ReportTextView.Tooltip.Find"));
        this.findAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/search_src.gif"));
        this.disposeReportAction = new Action(){

            public void run() {
                ReportTextView.this.dispose();
            }
        };
        this.disposeReportAction.setText(Messages.getString("ReportTextView.Action.CloseReport"));
        this.disposeReportAction.setActionDefinitionId("com.banknet.core.ReportTextView.disposeReportCommand");
        this.disposeReportAction.setToolTipText(Messages.getString("ReportTextView.Tooltip.CloseReport"));
        this.disposeReportAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/elcl16/participant_rem.gif"));
        this.disposeReportsAction = new Action(){

            public void run() {
                ReportTextView.this.disposeAllReports();
            }
        };
        this.disposeReportsAction.setText(Messages.getString("ReportTextView.Action.CloseAllReports"));
        this.disposeReportsAction.setActionDefinitionId("com.banknet.core.ReportTextView.disposeReportsCommand");
        this.disposeReportsAction.setToolTipText(Messages.getString("ReportTextView.Tooltip.CloseAllReports"));
        this.disposeReportsAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/elcl16/participant_remall.gif"));
        this.reportDetailAction = new Action(){

            public void run() {
                ReportTextView.this.lcmdopt = ReportTextView.this.constants.REPORT_LCMD_DETAIL;
                ReportTextView.this.rptformat = ReportTextView.this.constants.REPORT_FORMAT_PVML;
                ReportTextView.this.rpttypTitle = Messages.getString("ReportTextView.Action.ReportDetail");
                ReportTextView.this.getReportDetail();
            }
        };
        this.reportDetailAction.setText(Messages.getString("ReportTextView.Action.ReportDetail"));
        this.reportDetailAction.setToolTipText(Messages.getString("ReportTextView.Tooltip.ReportDetail"));
        this.reportDetailAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/msGreen.gif"));
        this.spmAction = new Action(){

            public void run() {
                if (ReportTextView.this.isJavaReport) {
                    ReportTextView.this.constants.getClass();
                    ReportTextView.this.lcmdopt = "++";
                } else {
                    ReportTextView.this.lcmdopt = ReportTextView.this.constants.REPORT_LCMD_SPM;
                }
                ReportTextView.this.rptformat = ReportTextView.this.constants.REPORT_FORMAT_PVML;
                ReportTextView.this.rpttypTitle = Messages.getString("ReportTextView.Action.SPM");
                ReportTextView.this.getReportDetail();
            }
        };
        this.spmAction.setText(Messages.getString("ReportTextView.Action.SPM"));
        this.spmAction.setToolTipText(Messages.getString("ReportTextView.Tooltip.SPM"));
        this.moduleInfoAction = new Action(){

            public void run() {
                ReportTextView.this.lcmdopt = ReportTextView.this.constants.REPORT_LCMD_MODULE;
                ReportTextView.this.rptformat = ReportTextView.this.constants.REPORT_FORMAT_PVML;
                ReportTextView.this.rpttypTitle = Messages.getString("ReportTextView.Action.ModuleInfo");
                ReportTextView.this.getReportDetail();
            }
        };
        this.moduleInfoAction.setText(Messages.getString("ReportTextView.Action.ModuleInfo"));
        this.moduleInfoAction.setToolTipText(Messages.getString("ReportTextView.Tooltip.ModuleInfo"));
        this.db2ExplainAction = new Action(){

            public void run() {
                ReportTextView.this.lcmdopt = ReportTextView.this.constants.REPORT_LCMD_DB2EXPLAIN;
                ReportTextView.this.rptformat = ReportTextView.this.constants.REPORT_FORMAT_PVML;
                ReportTextView.this.rpttypTitle = Messages.getString("ReportTextView.Action.Db2Explain");
                ReportTextView.this.getReportDetail();
            }
        };
        this.db2ExplainAction.setText(Messages.getString("ReportTextView.Action.Db2Explain"));
        this.db2ExplainAction.setToolTipText(Messages.getString("ReportTextView.Tooltip.Db2Explain"));
        this.stickyNotesAction = new Action(){

            public void run() {
                StickyNotesDialog snd = new StickyNotesDialog(ReportTextView.this.textViewer.getShell());
                snd.notesPath = ReportTextView.this.reportPath;
                snd.rpttitle = ReportTextView.this.printTitle;
                snd.rptid = ReportTextView.this.rptid;
                snd.open();
                snd = null;
            }
        };
        this.stickyNotesAction.setText(Messages.getString("ReportTextView.Action.StickyNotes"));
        this.stickyNotesAction.setToolTipText(Messages.getString("ReportTextView.Tooltip.StickyNotes"));
        this.stickyNotesAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/stickyNote.gif"));
        this.stickyNotesAction.setEnabled(true);
        this.launchHtmlAction = new Action(){

            public void run() {
                if (ReportTextView.this.buildHtml() >= 0) {
                    ReportTextView.this.launchHtmlJob();
                }
            }
        };
        this.launchHtmlAction.setText(Messages.getString("ReportTextView.Action.LaunchHtml"));
        this.launchHtmlAction.setToolTipText(Messages.getString("ReportTextView.Tooltip.LaunchHtml"));
        this.launchHtmlAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/preview.gif"));
        this.downloadReportAction = new Action(){

            public void run() {
                ReportTextView.this.obsrpts = new ObservationReports();
                ReportTextView.this.rptformat = ReportTextView.this.constants.REPORT_FORMAT_PVML;
                ReportTextView.this.runReportsPing();
            }
        };
        this.downloadReportAction.setText(Messages.getString("ReportTextView.Action.DownloadReport"));
        this.downloadReportAction.setToolTipText(Messages.getString("ReportTextView.Action.DownloadReport"));
        this.downloadReportAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/msBlue.gif"));
        this.reportOptionsAction = new Action(){

            public void run() {
                ReportOptionsDialog rptopt = new ReportOptionsDialog(ReportTextView.this.textViewer.getShell());
                rptopt.rptid = ReportTextView.this.rptid;
                int rptoptrc = rptopt.open();
                if (rptoptrc != 0) {
                    // empty if block
                }
                rptopt = null;
            }
        };
        this.reportOptionsAction.setText(Messages.getString("ReportTextView.Action.ReportOptions"));
        this.reportOptionsAction.setToolTipText(Messages.getString("ReportTextView.Tooltip.ReportOptions"));
        this.reportOptionsAction.setEnabled(true);
        this.reportOptionsAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/elcl16/det_pane_hide.gif"));
        this.reportOptionsAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/dlcl16/det_pane_hide.gif"));
        ReportsModel report = CorePlugin.getDefault().reports.get(CorePlugin.getDefault().reportId.indexOf(this.rptid));
        String string = report.parent.reportid;
        this.constants.getClass();
        if (string.equalsIgnoreCase("J")) {
            this.isJavaReport = true;
        } else if (report.parent.reportid.equalsIgnoreCase(this.constants.REPORT_CATEGORY_DB2)) {
            this.isDb2Report = true;
        }
        if (report.sortoptions.length() > 0) {
            this.loadSortActions(report.sortoptions);
        }
    }

    void loadSortActions(String sortstr) {
        String sortid = "";
        String sortlabel = "";
        String headerpi = "";
        String bodypi = "";
        this.sorts = sortstr.split(",");
        this.sortHdrActions = new Action[this.sorts.length];
        this.sortBodyActions = new Action[this.sorts.length];
        int i = 0;
        while (i < this.sorts.length) {
            String[] sortoptions = this.s1.split(this.sorts[i], -1);
            sortid = sortoptions[0];
            sortlabel = sortoptions[1];
            String cfr_ignored_0 = sortoptions[1];
            headerpi = "";
            if (sortoptions[3].length() > 0) {
                headerpi = sortoptions[3];
                this.sortHdrActions[i] = new Action(){

                    public void run() {
                        ReportTextView.this.sortactivelink = ReportTextView.this.ctxactivelink;
                        ReportTextView.this.sortvalue = this.getId();
                        int i = 0;
                        while (i < ReportTextView.this.sorts.length) {
                            String[] sortoptions = ReportTextView.this.s1.split(ReportTextView.this.sorts[i], -1);
                            if (sortoptions[0].equals(ReportTextView.this.sortvalue)) {
                                ReportTextView.this.sortpi = sortoptions[3];
                            }
                            ++i;
                        }
                        ReportTextView.this.sortvalue = "S-" + ReportTextView.this.sortvalue;
                        System.out.println(String.valueOf(this.getText()) + " sort: " + ReportTextView.this.sortactivelink);
                        if (ReportTextView.this.sortactivelink.length() > 0) {
                            ReportTextView.this.runActiveLink(ReportTextView.this.ctxactivelink);
                        }
                    }
                };
                this.sortHdrActions[i].setText(String.valueOf(Messages.getString("ReportTextView.Action.SortBy")) + sortlabel);
                this.sortHdrActions[i].setToolTipText(String.valueOf(Messages.getString("ReportTextView.Tooltip.SortBy")) + sortlabel);
                this.sortHdrActions[i].setDescription(headerpi);
                this.sortHdrActions[i].setId(sortid);
                this.sortHdrActions[i].setEnabled(true);
            }
            bodypi = "";
            if (sortoptions[4].length() > 0) {
                bodypi = sortoptions[4];
                this.sortBodyActions[i] = new Action(){

                    public void run() {
                        ReportTextView.this.sortactivelink = ReportTextView.this.ctxactivelink;
                        ReportTextView.this.sortvalue = this.getId();
                        int i = 0;
                        while (i < ReportTextView.this.sorts.length) {
                            String[] sortoptions = ReportTextView.this.s1.split(ReportTextView.this.sorts[i], -1);
                            if (sortoptions[0].equals(ReportTextView.this.sortvalue)) {
                                ReportTextView.this.sortpi = sortoptions[4];
                            }
                            ++i;
                        }
                        System.out.println(String.valueOf(this.getText()) + " sort: " + ReportTextView.this.sortactivelink);
                        if (ReportTextView.this.sortactivelink.length() > 0) {
                            ReportTextView.this.runActiveLink(ReportTextView.this.ctxactivelink);
                        }
                    }
                };
                this.sortBodyActions[i].setText(String.valueOf(Messages.getString("ReportTextView.Action.SortBy")) + sortlabel);
                this.sortBodyActions[i].setToolTipText(String.valueOf(Messages.getString("ReportTextView.Tooltip.SortBy")) + sortlabel);
                this.sortBodyActions[i].setDescription(bodypi);
                this.sortBodyActions[i].setId(sortid);
                this.sortBodyActions[i].setEnabled(true);
            }
            ++i;
        }
    }

    public void dispose() {
        IEclipsePreferences preferencesI = InstanceScope.INSTANCE.getNode("com.banknet.core");
        preferencesI.removePreferenceChangeListener(this.preferenceChangeListener);
        try {
            this.getViewSite().getPage().removePartListener(this.partListener);
        }
        catch (Exception exception) {}
        this.textViewer = null;
        this.reportLabel = null;
        this.stylerange = null;
        this.printstylerange = null;
        this.stylingHeader = null;
        this.stylingBody = null;
        this.listPrintStyles = null;
        this.listHeaderStyles = null;
        this.listBodyStyles = null;
        this.printPVML = null;
        this.rtv = null;
        this.arrowCursor.dispose();
        this.handCursor.dispose();
        this.clientFont.dispose();
        this.clientBackground.dispose();
        this.greenReportImage.dispose();
        super.dispose();
        try {
            this.getSite().getPage().hideView((IViewPart)this);
            this.getSite().getPage().setEditorAreaVisible(false);
        }
        catch (Exception exception) {}
        String focusreport = "";
        if (this.getSite().getPage() != null) {
            int i = this.getSite().getPage().getViewReferences().length - 1;
            while (i > 0) {
                IViewPart prt;
                String vid = this.getSite().getPage().getViewReferences()[i].getId().toLowerCase();
                if (vid.endsWith("reporttextview") && (ReportTextView)(prt = this.getSite().getPage().getViewReferences()[i].getView(false)) != null && ((ReportTextView)prt).rptid.length() > 0) {
                    String focusrptid;
                    String focusstcid = ((ReportTextView)prt).stcid;
                    String focusreqnum = ((ReportTextView)prt).reqnum.toString();
                    focusreport = focusrptid = ((ReportTextView)prt).rptid;
                    if (this.disposeAll) break;
                    String focuskey = String.valueOf(focusstcid) + "|" + focusreqnum + "|" + focusrptid;
                    CorePlugin.getDefault().getPreferenceStore().setValue("focusReport", focuskey);
                    break;
                }
                --i;
            }
        }
        if (focusreport.length() <= 0) {
            if (!this.disposeAll) {
                CorePlugin.getDefault().getPreferenceStore().setValue("focusReport", "");
            }
            System.gc();
        }
    }

    public void disposeAllReports() {
        this.disposeAll = true;
        DisposeReportsAction rpts = new DisposeReportsAction((IViewPart)this);
        rpts.run();
    }

    public void setFocus() {
        if (this.getSite().getPage().getActivePart() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.client.getShell(), String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".views_ReportViewContext");
        }
    }

    private String getActiveLink(int selectionOffset, String[] stra) {
        String activelink = "";
        int stylestart = 0;
        int stylelen = 0;
        int styleend = 0;
        if (stra == null) {
            return "";
        }
        int i = 0;
        while (i < stra.length) {
            String[] styleArray = this.s1.split(stra[i], -1);
            stylestart = new Integer(styleArray[0]);
            stylelen = new Integer(styleArray[1]);
            styleend = stylestart + stylelen;
            if (selectionOffset >= stylestart && selectionOffset <= styleend) {
                activelink = styleArray[2];
                return activelink;
            }
            ++i;
        }
        return activelink;
    }

    private void runActiveLink(String activelink) {
        String rptlink = activelink;
        if (rptlink.charAt(0) == 'E') {
            CorePlugin.getDefault().getPreferenceStore().setValue("activeLink", activelink.substring(1, 4));
        } else if (rptlink.charAt(0) != 'S') {
            this.loadReportJob();
        }
    }

    private void loadPrintText() {
        this.printText = new StyledText((Composite)this.textViewer.getShell(), 770);
        GridData spec = new GridData();
        spec.horizontalAlignment = 4;
        spec.grabExcessHorizontalSpace = true;
        spec.verticalAlignment = 4;
        spec.grabExcessVerticalSpace = true;
        this.printText.setLayoutData((Object)spec);
        this.printText.setEditable(false);
        Color bg = Display.getDefault().getSystemColor(1);
        this.printText.setBackground(bg);
        this.printText.setFont(this.clientFont);
        this.printText.setVisible(false);
        this.printText.setText(this.printPVML);
        this.printText.setStyleRanges(this.listPrintStyles.toArray(new StyleRange[this.listPrintStyles.size()]));
    }

    private void loadColors() {
        this.colorStyles.add("gr");
        this.colorCodes.add(new Color(null, 181, 181, 181));
        this.colorStyles.add("r");
        this.colorCodes.add(new Color(null, 238, 99, 99));
        this.colorStyles.add("t");
        this.colorCodes.add(new Color(null, 0, 160, 168));
        this.colorStyles.add("g");
        this.colorCodes.add(new Color(null, 34, 139, 34));
        this.colorStyles.add("y");
        this.colorCodes.add(new Color(null, 255, 185, 15));
        this.colorStyles.add("b");
        this.colorCodes.add(new Color(null, 0, 0, 205));
        this.colorStyles.add("lb");
        this.colorCodes.add(new Color(null, 110, 187, 255));
        this.colorStyles.add("p");
        this.colorCodes.add(new Color(null, 255, 182, 193));
        this.colorStyles.add("lp");
        this.colorCodes.add(new Color(null, 255, 160, 160));
        this.colorStyles.add("red");
        this.colorCodes.add(new Color(null, 255, 0, 0));
        this.colorStyles.add("green");
        this.colorCodes.add(Display.getCurrent().getSystemColor(5));
        this.colorStyles.add("yellow");
        this.colorCodes.add(Display.getCurrent().getSystemColor(7));
        this.colorStyles.add("blue");
        this.colorCodes.add(Display.getCurrent().getSystemColor(9));
        this.colorStyles.add("turquoise");
        this.colorCodes.add(new Color(null, 0, 160, 168));
        this.colorStyles.add("pink");
        this.colorCodes.add(Display.getCurrent().getSystemColor(11));
        this.colorStyles.add("gray");
        this.colorCodes.add(Display.getCurrent().getSystemColor(15));
        this.colorStyles.add("bl");
        this.colorCodes.add(Display.getCurrent().getSystemColor(2));
    }

    private Color getColorCode(String style) {
        int i = 0;
        while (i < this.colorStyles.size()) {
            if (this.colorStyles.get(i).equals(style)) {
                return this.colorCodes.get(i);
            }
            ++i;
        }
        return this.colorCodes.get(this.colorStyles.size() - 1);
    }

    private void findText() {
        String st = this.finddialog.rtv.textViewer.getText();
        if (!this.finddialog.caseCheck.getSelection()) {
            st = st.toLowerCase();
        }
        int startloc = 0;
        if (this.finddialog.finddir.equals("up")) {
            startloc = st.length();
        }
        int newloc = startloc;
        if (CorePlugin.getDefault().getPreferenceStore().getString("findText").length() <= 0) {
            return;
        }
        String findtext = this.finddialog.findText.getText().trim();
        if (!this.finddialog.caseCheck.getSelection()) {
            if (!findtext.equalsIgnoreCase(this.finddialog.rtv.searchtxt)) {
                this.finddialog.rtv.searchloc = startloc;
            }
        } else if (!findtext.equals(this.finddialog.rtv.searchtxt)) {
            this.finddialog.rtv.searchloc = startloc;
        }
        String dialogsearchtxt = this.finddialog.rtv.searchtxt = CorePlugin.getDefault().getPreferenceStore().getString("findText");
        if (!this.finddialog.caseCheck.getSelection()) {
            dialogsearchtxt = dialogsearchtxt.toLowerCase();
        }
        String searchtxtlc = this.finddialog.rtv.searchtxt;
        if (!this.finddialog.caseCheck.getSelection()) {
            searchtxtlc = searchtxtlc.toLowerCase();
        }
        if (this.finddialog.rtv.searchloc == startloc) {
            newloc = this.finddialog.finddir.equals("up") ? st.lastIndexOf(searchtxtlc, this.finddialog.rtv.searchloc) : st.indexOf(searchtxtlc, this.finddialog.rtv.searchloc);
            if (newloc < 0) {
                this.showMessage(Messages.getString("ReportTextView.MessageDialog.infoTitle.FindResults"), String.valueOf(Messages.getString("ReportTextView.MessageDialog.infoMessage.CannotFind")) + this.finddialog.rtv.searchtxt + "\"");
                this.finddialog.rtv.textViewer.setSelection(0);
                return;
            }
            this.finddialog.rtv.searchloc = newloc;
        } else {
            newloc = this.finddialog.finddir.equals("up") ? st.lastIndexOf(searchtxtlc, this.finddialog.rtv.searchloc - 1) : st.indexOf(searchtxtlc, this.finddialog.rtv.searchloc + 1);
            if (newloc < 0) {
                this.showMessage(Messages.getString("ReportTextView.MessageDialog.infoTitle.FindResults"), String.valueOf(Messages.getString("ReportTextView.MessageDialog.infoMessage.CannotFind")) + this.finddialog.rtv.searchtxt + "\"");
                newloc = this.finddialog.rtv.searchloc;
            }
            this.finddialog.rtv.searchloc = newloc;
        }
        this.finddialog.rtv.searchloc = newloc;
        this.finddialog.rtv.textViewer.setSelection(this.finddialog.rtv.searchloc, this.finddialog.rtv.searchloc + this.finddialog.rtv.searchtxt.length());
        this.finddialog.rtv.textViewer.setFocus();
        this.getLineColumn();
        CorePlugin.getDefault().getPreferenceStore().setValue("findText", "");
    }

    private void showMessage(String title, String message) {
        MessageDialog.openInformation((Shell)this.textViewer.getShell(), (String)title, (String)message);
    }

    private void showErrorMessage(String title, String message) {
        MessageDialog.openError((Shell)this.textViewer.getShell(), (String)title, (String)message);
    }

    public void loadReportJob() {
        Job jobA = new Job(Messages.getString("ReportTextView.Job.Title.LoadingReport")){

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(String.valueOf(Messages.getString("ReportTextView.Job.Task.Loading")) + ReportTextView.this.rptid + Messages.getString("ReportTextView.Job.Task.Report"), 100);
                ReportTextView.this.listPrintStyles = new ArrayList<StyleRange>();
                ReportTextView.this.listHeaderStyles = new ArrayList<StyleRange>();
                ReportTextView.this.listBodyStyles = new ArrayList<StyleRange>();
                ReportTextView.this.stylingHeader = new StringBuilder();
                ReportTextView.this.stylingBody = new StringBuilder();
                String reportLocation = new File(String.valueOf(CorePlugin.getDefault().getPreferenceStore().getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + ReportTextView.this.stcid + File.separator + ReportTextView.this.reqnum + File.separator + Platform.getNL() + File.separator + ReportTextView.this.rptid + "-active.txt").getAbsolutePath();
                String reportName = ReportTextView.this.rptid;
                String cfr_ignored_0 = String.valueOf(reportLocation) + reportName;
                ReportTextView.this.pv = new pvmlReader();
                ReportTextView.this.pv.rtv = ReportTextView.this.rtv;
                ReportTextView.this.pv.monitor = monitor;
                try {
                    if (ReportTextView.this.sortactivelink.length() > 0) {
                        monitor.beginTask(String.valueOf(Messages.getString("ReportTextView.Job.Task.Sorting")) + ReportTextView.this.rptid + Messages.getString("ReportTextView.Job.Task.Report"), 100);
                        ReportTextView.this.pvsort = new pvmlSort();
                        ReportTextView.this.pvsort.monitor = monitor;
                        ReportTextView.this.pvsort.sortPvml(ReportTextView.this.reqnum, ReportTextView.this.rptid, new Integer(ReportTextView.this.sortactivelink), ReportTextView.this.sortvalue, ReportTextView.this.sortpi, ReportTextView.this.stcid);
                        ReportTextView.this.activelink = ReportTextView.this.contextbodylink;
                        if (ReportTextView.this.contextheaderlink.length() > 0) {
                            ReportTextView.this.activelink = "0";
                        }
                        ReportTextView.this.contextheaderlink = "";
                        ReportTextView.this.contextbodylink = "";
                        ReportTextView.this.sortactivelink = "";
                        ReportTextView.this.sortvalue = "";
                        ReportTextView.this.sortpi = "";
                        ReportTextView.this.pvsort = null;
                        System.gc();
                    } else if (ReportTextView.this.activelink.length() > 0) {
                        ReportTextView.this.pvec = new pvmlExpandCollapse();
                        ReportTextView.this.pvec.pvmlExpand(ReportTextView.this.reqnum, ReportTextView.this.rptid, new Integer(ReportTextView.this.activelink));
                        ReportTextView.this.pvec = null;
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    monitor.beginTask(String.valueOf(Messages.getString("ReportTextView.Job.Task.Loading")) + ReportTextView.this.rptid + Messages.getString("ReportTextView.Job.Task.Report"), 100);
                    ReportTextView.this.pv.processReport(reportLocation, " " + ReportTextView.this.printTitle, false);
                }
                catch (OutOfMemoryError oem) {
                    String logstr = "loadReportJob:  pvmlReader processReport out of memory exception " + oem;
                    System.out.println("ReportTextView " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    ReportTextView.this.errorTitle = Messages.getString("ReportTextView.MessageDialog.errorTitle.OEM");
                    ReportTextView.this.errorMsg = String.valueOf(Messages.getString("ReportTextView.MessageDialog.errorMessage.LoadReportOEM")) + ReportTextView.this.printTitle;
                    return Status.CANCEL_STATUS;
                }
                catch (Exception ex) {
                    String logstr = "loadReportJob:  pvmlReader processReport exception " + ex;
                    System.out.println("ReportTextView " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                    ReportTextView.this.errorTitle = Messages.getString("ReportTextView.MessageDialog.errorTitle.Exception");
                    ReportTextView.this.errorMsg = String.valueOf(Messages.getString("ReportTextView.MessageDialog.errorMessage.ParsingError")) + ex;
                    return Status.CANCEL_STATUS;
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        jobA.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Job completed successfully");
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ReportTextView.this.loadReportData();
                        }
                    });
                } else {
                    System.out.println("Job did not complete successfully");
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if ((this).ReportTextView.this.errorMsg.length() > 0) {
                                MessageDialog.openError((Shell)(this).ReportTextView.this.textViewer.getShell(), (String)(this).ReportTextView.this.errorTitle, (String)(this).ReportTextView.this.errorMsg);
                                ReportTextView.this.clearObjs();
                                ReportTextView.this.dispose();
                            }
                        }
                    });
                }
            }
        });
        jobA.setUser(true);
        jobA.schedule();
    }

    private void loadReportData() {
        try {
            this.reportLabel.setText(this.pv.PVMLHeader.toString());
            if (this.activelink.length() > 0) {
                this.reportLabel.replaceStyleRanges(0, this.reportLabel.getText().length(), this.listHeaderStyles.toArray(new StyleRange[this.listHeaderStyles.size()]));
            } else {
                this.reportLabel.setStyleRanges(this.listHeaderStyles.toArray(new StyleRange[this.listHeaderStyles.size()]));
            }
            this.activelinksHeader = this.stylingHeader.toString().split(",");
            this.listHeaderStyles = null;
            this.pv.PVMLHeader = null;
            this.stylingHeader = null;
            String pvmlBody = this.pv.PVMLBody.toString();
            this.pv.PVMLBody = null;
            this.textViewer.setText(pvmlBody);
            if (this.activelink.length() > 0) {
                this.textViewer.replaceStyleRanges(0, this.textViewer.getText().length(), this.listBodyStyles.toArray(new StyleRange[this.listBodyStyles.size()]));
            } else {
                this.textViewer.setStyleRanges(this.listBodyStyles.toArray(new StyleRange[this.listBodyStyles.size()]));
            }
            this.activelinksBody = this.stylingBody.toString().split(",");
            this.listBodyStyles = null;
            this.stylingBody = null;
            this.printPVML = this.pv.PVMLPrint.toString();
            this.pv.PVMLPrint = null;
            if (this.detailList.length() > 0) {
                String detailListStr = this.detailList.toString();
                this.detailOffsets = detailListStr.split(",");
                this.detailList = null;
                this.detailList = new StringBuilder();
            }
            this.clearObjs();
            this.scrollLine();
            this.titleLabel.setVisible(true);
            this.reportLabel.setVisible(true);
            this.textViewer.setVisible(true);
            this.textViewer.redraw();
            this.textViewer.setFocus();
            this.client.layout(true);
        }
        catch (OutOfMemoryError oem) {
            String logstr = "loadReportData:  out of memory exception " + oem;
            System.out.println("ReportTextView " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            MessageDialog.openError((Shell)this.textViewer.getShell(), (String)Messages.getString("ReportTextView.MessageDialog.errorTitle.OEM"), (String)(String.valueOf(Messages.getString("ReportTextView.MessageDialog.errorMessage.LoadReportOEM")) + this.printTitle));
            this.clearObjs();
            this.dispose();
        }
        catch (Exception ex) {
            String logstr = "loadReportData:  report load exception " + ex;
            System.out.println("ReportTextView " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            this.clearObjs();
            this.dispose();
        }
    }

    public void setReportStyle(String listtype) throws Exception, OutOfMemoryError {
        if (listtype.equalsIgnoreCase("body")) {
            this.listBodyStyles.add(this.stylerange);
        } else if (listtype.equalsIgnoreCase("header")) {
            this.listHeaderStyles.add(this.stylerange);
        } else {
            this.listPrintStyles.add(this.printstylerange);
        }
    }

    public void setNewReportStyleRange() throws Exception, OutOfMemoryError {
        this.stylerange = new StyleRange();
    }

    public void setNewPrintStyleRange() throws Exception, OutOfMemoryError {
        this.printstylerange = new StyleRange();
    }

    public void setReportStyleRange(String fred, String sectiontype, int pageOffset, int printPageOffset, String detailOffset) throws Exception, OutOfMemoryError {
        String[] styleArray = this.s1.split(fred, -1);
        try {
            this.setNewReportStyleRange();
            this.setNewPrintStyleRange();
        }
        catch (OutOfMemoryError oem) {
            String logstr = "setReportStyleRange:  setNewReportStyleRange, setNewPrintStyleRange out of memory exception " + oem;
            System.out.println("ReportTextView " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            throw oem;
        }
        catch (Exception e) {
            String logstr = "setReportStyleRange:  setNewReportStyleRange, setNewPrintStyleRange exception " + e;
            System.out.println("ReportTextView " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            throw e;
        }
        this.stylerange.start = new Integer(styleArray[0]) + pageOffset;
        this.printstylerange.start = new Integer(styleArray[0]) + printPageOffset;
        this.stylerange.length = new Integer(styleArray[1]);
        this.printstylerange.length = new Integer(styleArray[1]);
        if (!CorePlugin.getDefault().getPreferenceStore().getBoolean("colorMonochrome")) {
            this.stylerange.foreground = this.getColorCode(styleArray[2]);
            this.printstylerange.foreground = this.getColorCode(styleArray[2]);
            if (styleArray[3].length() > 0) {
                this.stylerange.background = this.getColorCode(styleArray[3]);
                this.printstylerange.background = this.getColorCode(styleArray[3]);
            }
        }
        if (styleArray[4].equals("true")) {
            this.stylerange.underline = true;
            this.stylerange.underlineStyle = this.underlineStyle;
            this.printstylerange.underline = true;
            this.printstylerange.underlineStyle = this.underlineStyle;
        }
        if (styleArray[5].equals("true")) {
            this.stylerange.fontStyle = 1;
            this.printstylerange.fontStyle = 1;
        }
        if (styleArray[6].length() > 0) {
            if (sectiontype.equals("S")) {
                if (this.stylingHeader.length() > 0) {
                    this.stylingHeader.append(",");
                }
                this.stylingHeader.append(String.valueOf(this.stylerange.start) + "|" + this.stylerange.length + "|" + styleArray[6]);
            } else {
                if (this.stylingBody.length() > 0) {
                    this.stylingBody.append(",");
                }
                this.stylingBody.append(String.valueOf(this.stylerange.start) + "|" + this.stylerange.length + "|" + styleArray[6]);
                if (styleArray[6].equals(this.activelink)) {
                    this.linenum = this.stylerange.start;
                }
                if (detailOffset.length() > 0) {
                    this.detailList = this.detailList.append(String.valueOf(styleArray[6]) + "|" + detailOffset + ",");
                }
            }
        }
        try {
            if (sectiontype.equals("S")) {
                this.setReportStyle("header");
            } else {
                this.setReportStyle("body");
            }
            this.setReportStyle("print");
        }
        catch (OutOfMemoryError oem) {
            String logstr = "setReportStyleRange:  setReportStyleRange out of memory exception " + oem;
            System.out.println("ReportTextView " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            throw oem;
        }
        catch (Exception e) {
            String logstr = "setReportStyleRange:  setReportStyle exception " + e;
            System.out.println("ReportTextView " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            throw e;
        }
    }

    public void clearObjs() {
        this.pv = null;
        this.listHeaderStyles = null;
        this.listBodyStyles = null;
        this.contextheaderlink = "";
        this.contextbodylink = "";
        this.sortactivelink = "";
        this.sortvalue = "";
        System.gc();
    }

    private void scrollLine() {
        int incr = Math.abs(this.textViewer.getClientArea().height / this.textViewer.getVerticalBar().getIncrement() / 2);
        int curline = this.textViewer.getLineAtOffset(this.linenum);
        int scrollline = curline + incr;
        if (this.textViewer.getLineCount() <= scrollline) {
            scrollline = this.textViewer.getLineCount() - 1;
        }
        if (scrollline < 0) {
            scrollline = 0;
        }
        this.textViewer.setSelection(this.textViewer.getOffsetAtLine(scrollline));
        this.textViewer.setSelection(new Integer(this.linenum).intValue());
        this.getLineColumn();
    }

    public void copyReportJob() {
        Job jobCopyFile = new Job(Messages.getString("ReportTextView.Job.Title.CopyingReport")){

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(String.valueOf(Messages.getString("ReportTextView.Job.Task.Copying")) + ReportTextView.this.rptid + Messages.getString("ReportTextView.Job.Task.Report"), 100);
                ReportTextView.this.errorMsg = ReportTextView.this.copyReportFile(ReportTextView.this.copyFromId, ReportTextView.this.copyToId);
                if (ReportTextView.this.errorMsg.length() > 0) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        jobCopyFile.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Job completed successfully");
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            ReportTextView.this.loadReportJob();
                        }
                    });
                } else {
                    System.out.println("Job did not complete successfully");
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)(this).ReportTextView.this.textViewer.getShell(), (String)(this).ReportTextView.this.errorTitle, (String)(this).ReportTextView.this.errorMsg);
                        }
                    });
                }
            }
        });
        jobCopyFile.schedule();
    }

    public String copyReportFile(String fromid, String toid) {
        String errmsg = "";
        try {
            IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
            CorePlugin.getDefault();
            File filefrom = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + this.stcid + File.separator + this.reqnum + File.separator + Platform.getNL() + File.separator + this.rptid + "-" + fromid + ".txt");
            FileChannel srcChannel = new FileInputStream(filefrom).getChannel();
            IPreferenceStore iPreferenceStore2 = CorePlugin.getDefault().getPreferenceStore();
            CorePlugin.getDefault();
            File fileto = new File(String.valueOf(iPreferenceStore2.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + this.stcid + File.separator + this.reqnum + File.separator + Platform.getNL() + File.separator + this.rptid + "-" + toid + ".txt");
            FileChannel dstChannel = new FileOutputStream(fileto).getChannel();
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            srcChannel.close();
            dstChannel.close();
            this.activelink = "";
            this.linenum = 0;
        }
        catch (IOException e) {
            String logstr = "copyReportFile:  from " + fromid + " to " + toid + " IOException " + e;
            System.out.println("ReportTextView " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            this.errorMsg = "IOError copying " + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + this.reqnum + File.separator + this.rptid + "-" + fromid + ".txt" + " to " + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().activeSystemname + File.separator + CorePlugin.getDefault().activeStc + File.separator + this.reqnum + File.separator + this.rptid + "-" + toid + ".txt" + ": " + e;
        }
        catch (Exception e) {
            String logstr = "copyReportFile:  from " + fromid + " to " + toid + " IOException " + e;
            System.out.println("ReportTextView " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            this.errorMsg = "Error copying " + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + this.reqnum + File.separator + this.rptid + "-" + fromid + ".txt" + " to " + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().activeSystemname + File.separator + CorePlugin.getDefault().activeStc + File.separator + this.reqnum + File.separator + this.rptid + "-" + toid + ".txt" + ": " + e;
        }
        return errmsg;
    }

    private File getSaveReport() {
        boolean runSaveDialog = true;
        String filename = String.valueOf(CorePlugin.getDefault().productextension.getProductPrefix()) + "_" + this.stcid + "_" + this.sreqnum + "_" + this.rptid;
        File file = null;
        FileDialog dialog = null;
        while (runSaveDialog) {
            dialog = new FileDialog(this.textViewer.getShell(), 8192);
            dialog.setFilterNames(new String[]{"Text Documents (*.txt)", "Html Documents (*.html)", "All Files (*.*)"});
            dialog.setFilterExtensions(new String[]{"*.txt", "*.html", "*.*"});
            if (this.rptformat.equals(this.constants.REPORT_FORMAT_XML) | this.rptformat.equals(this.constants.REPORT_FORMAT_JSON) | this.rptformat.equals(this.constants.REPORT_FORMAT_PDF)) {
                dialog.setFilterNames(new String[]{String.valueOf(this.rptformat.toUpperCase()) + " Documents (*." + this.rptformat + ")", "All Files (*.*)"});
                dialog.setFilterExtensions(new String[]{"*." + this.rptformat, "*.*"});
            }
            dialog.setFilterPath(CorePlugin.getDefault().getPreferenceStore().getString("saveReportPath"));
            dialog.setFileName(filename);
            dialog.setText(Messages.getString("ReportTextView.Dialog.Text.SaveReport"));
            filename = dialog.open();
            if (filename != null) {
                file = new File(filename);
                if (file.exists()) {
                    if (MessageDialog.openConfirm((Shell)this.textViewer.getShell(), (String)Messages.getString("ReportTextView.ConfirmDialog.ConfirmTitle.ReplaceFile"), (String)(String.valueOf(Messages.getString("ReportTextView.ConfirmDialog.ConfirmMessage.Replace")) + filename + "?"))) {
                        runSaveDialog = false;
                        continue;
                    }
                    file = null;
                    dialog = null;
                    continue;
                }
                runSaveDialog = false;
                continue;
            }
            runSaveDialog = false;
        }
        CorePlugin.getDefault().getPreferenceStore().setValue("saveReportPath", dialog.getFilterPath());
        dialog = null;
        return file;
    }

    private void getReportDetail() {
        ArrayList<String> selreqnums = new ArrayList<String>();
        String detailOffset = "";
        String offsetlink = "";
        String selreqnumargs = "";
        this.rptDetailOffset = "";
        this.rptDetailDone = false;
        this.reportDetailTitle = String.valueOf(this.rptid) + ":  " + this.rptname + " " + this.rpttypTitle + " (" + CorePlugin.getDefault().constants.reqdecfmt.format(CorePlugin.getDefault().selobs.reqnum) + "/" + CorePlugin.getDefault().selobs.jobname + ")";
        int i = 0;
        while (i < this.detailOffsets.length) {
            String[] offsetArr = this.s1.split(this.detailOffsets[i], -1);
            offsetlink = offsetArr[0];
            if (offsetlink.equals(this.ctxactivelink)) {
                this.rptDetailOffset = detailOffset = offsetArr[1];
                break;
            }
            ++i;
        }
        int rc = this.rpteditor.doActiveReportEdits();
        if (rc < 0) {
            this.showMessage(this.rpteditor.msgtype, this.rpttypTitle, this.rpteditor.msgstr);
            return;
        }
        if (detailOffset.length() <= 0) {
            return;
        }
        selreqnumargs = String.valueOf(CorePlugin.getDefault().constants.reqdecfmt.format(this.reqnum)) + "," + this.rptid + "," + detailOffset;
        if (this.lcmdopt.length() > 0) {
            selreqnumargs = String.valueOf(selreqnumargs) + "," + this.lcmdopt;
        }
        selreqnums.add(selreqnumargs);
        this.reqaction = ACTION_REPORTDETAIL;
        this.obsrpts = new ObservationReports();
        this.obsrpts.detailoffset = detailOffset;
        this.obsrpts.detailReport = true;
        this.obsrpts.lcmdopt = this.lcmdopt;
        if (this.lcmdopt.length() > 0) {
            this.obsrpts.spmrptid = this.rptid;
            if (this.lcmdopt.equals(this.constants.REPORT_LCMD_DB2EXPLAIN)) {
                IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
                CorePlugin.getDefault();
                this.obsrpts.saveReportFname = String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + this.reqnum + File.separator + Platform.getNL() + File.separator + this.rptid + this.db2suffix + ".txt";
            }
        }
        this.runReportsPing();
    }

    private void getDetailTitle() {
        int offset = this.seloffset;
        int linenum = this.textViewer.getLineAtOffset(offset);
        String rptline = this.textViewer.getLine(linenum);
        int curline = linenum;
        int currcolnum = this.textViewer.getOffsetAtLine(linenum);
        int scrollline = curline + 1;
        if (this.textViewer.getLineCount() <= scrollline) {
            scrollline = this.textViewer.getLineCount() - 1;
        }
        if (scrollline < 0) {
            scrollline = 0;
        }
        int nextcolnum = this.textViewer.getOffsetAtLine(scrollline);
        int stylelen = nextcolnum - currcolnum - 1;
        if (curline == this.textViewer.getLineCount()) {
            stylelen = this.textViewer.getCharCount();
        }
        StyleRange[] rptlinestyles = this.textViewer.getStyleRanges(currcolnum, stylelen);
        int stylestart = 0;
        int prevstylestart = 0;
        int newstylestart = 0;
        int i = 0;
        while (i < rptlinestyles.length) {
            stylestart = new Integer(rptlinestyles[i].start);
            if (i == 0) {
                newstylestart = 1;
            } else {
                int tmpstart = stylestart - prevstylestart;
                newstylestart += tmpstart;
            }
            rptlinestyles[i].start = newstylestart;
            prevstylestart = stylestart;
            ++i;
        }
        System.out.println("activelink: " + this.activelink);
        System.out.println("rptline: " + rptline);
    }

    private void runDetailWindow() {
        IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
        CorePlugin.getDefault();
        File rptdetailFile = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + this.stcid + File.separator + this.reqnum + File.separator + Platform.getNL() + File.separator + this.rptid + this.detailsuffix + ".txt");
        IPreferenceStore iPreferenceStore2 = CorePlugin.getDefault().getPreferenceStore();
        CorePlugin.getDefault();
        File rptdb2File = new File(String.valueOf(iPreferenceStore2.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + this.stcid + File.separator + this.reqnum + File.separator + Platform.getNL() + File.separator + this.rptid + this.db2suffix + ".txt");
        if (rptdb2File.exists() && this.lcmdopt.equals(this.constants.REPORT_LCMD_DB2EXPLAIN)) {
            String explainTitle = String.valueOf(CorePlugin.getDefault().rptid) + ":  " + CorePlugin.getDefault().rptname + " (" + CorePlugin.getDefault().constants.reqdecfmt.format(CorePlugin.getDefault().selobs.reqnum) + "/" + CorePlugin.getDefault().selobs.jobname + ")";
            Db2ExplainDialog ded = new Db2ExplainDialog(this.textViewer.getShell(), this.stcid, this.reqnum, this.rptid, explainTitle);
            this.rptDetailDone = true;
            ded.open();
            ded = null;
        } else if (rptdetailFile.exists()) {
            ReportDetailDialog rdd = new ReportDetailDialog(this.textViewer.getShell(), this.stcid, this.rptid, this.reqnum, this.reportDetailTitle, this.lcmdopt, this.isJavaReport);
            this.rptDetailDone = true;
            rdd.open();
            Object var3_4 = null;
        }
    }

    private void saveasTextFile(File file) {
        this.loadPrintText();
        this.printText.setText(String.valueOf(this.titleLabel.getText()) + "\n" + this.printPVML);
        try {
            FileOutputStream outputStream2 = new FileOutputStream(file);
            PrintStream sysout = new PrintStream((OutputStream)outputStream2, true, "UTF-8");
            sysout.print(this.printText.getText().replace("\n", "\r\n"));
            outputStream2.close();
            outputStream2 = null;
            sysout = null;
        }
        catch (OutOfMemoryError oem) {
            String logstr = "saveAction:  out of memory exception " + oem;
            System.out.println("ReportTextView " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            MessageDialog.openError((Shell)this.textViewer.getShell(), (String)Messages.getString("ReportTextView.MessageDialog.errorTitle.OEM"), (String)(String.valueOf(Messages.getString("ReportTextView.MessageDialog.errorMessage.SaveReportOEM")) + this.printTitle));
            this.clearObjs();
            this.dispose();
        }
        catch (Exception e) {
            String logstr = "saveAction:  exception " + e;
            System.out.println("ReportTextView " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            MessageDialog.openError((Shell)this.textViewer.getShell(), (String)Messages.getString("ReportTextView.MessageDialog.errorTitle.SaveError"), (String)e.getLocalizedMessage());
        }
        try {
            this.printText.dispose();
        }
        catch (Exception exception) {}
        this.printText = null;
        System.gc();
    }

    private void saveasHtmlFile(File fileto) {
        if (this.buildHtml() < 0) {
            return;
        }
        try {
            File filefrom = new File(String.valueOf(this.reportPath) + this.rptid + ".html");
            FileChannel srcChannel = new FileInputStream(filefrom).getChannel();
            FileChannel dstChannel = new FileOutputStream(fileto).getChannel();
            dstChannel.transferFrom(srcChannel, 0L, srcChannel.size());
            srcChannel.close();
            dstChannel.close();
            this.ctxactivelink = "";
            this.activelink = "";
            this.linenum = 0;
        }
        catch (IOException e) {
            String logstr = "saveasHtml:  from " + this.reportPath + this.rptid + ".html" + " to " + fileto.getAbsolutePath() + " IOException " + e;
            System.out.println("ReportTextView " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    private int buildHtml() {
        int rc = 0;
        String errmsg = "";
        ReportHtmlBuilder htmlbuilder = new ReportHtmlBuilder();
        try {
            htmlbuilder.buildHtmlFile(this.reportPath, this.rptid, "-active", String.valueOf(this.rptid) + ".html", this.printTitle);
        }
        catch (OutOfMemoryError oem) {
            String logstr = "buildHtml:  Out of Memory exception building html: " + this.reportPath + this.rptid + ". " + oem;
            System.out.println("ReportTextView - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            errmsg = oem.getLocalizedMessage();
            rc = -1;
        }
        catch (IOException e) {
            String logstr = "buildHtml:  IO exception building html: " + this.reportPath + this.rptid + ". " + e;
            System.out.println("ReportTextView - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            errmsg = e.getLocalizedMessage();
            rc = -1;
        }
        catch (Exception e) {
            String logstr = "buildHtml:  Exception building html: " + this.reportPath + this.rptid + ". " + e;
            System.out.println("ReportTextView - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
            errmsg = e.getLocalizedMessage();
            rc = -1;
        }
        if (rc < 0) {
            MessageDialog.openError((Shell)this.textViewer.getShell(), (String)Messages.getString("ReportTextView.MessageDialog.errorTitle.ReportError"), (String)errmsg);
        }
        return rc;
    }

    public void launchHtmlJob() {
        try {
            String logstr = "launchHtmlJob:  launching html report " + this.reportPath + this.rptid + ".html";
            System.out.println("ReportsView " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
            File htmlFile = new File(String.valueOf(this.reportPath) + this.rptid + ".html");
            PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(htmlFile.toURI().toURL());
        }
        catch (Exception ex) {
            String logstr = "launchHtmlJob: Error launching html file " + this.reportPath + this.rptid + ".html" + ", Exception - " + ex;
            System.out.println("ReportTextView - " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
    }

    public void runReportsPing() {
        Job job0 = new Job(Messages.getString("ReportsView.Job.Title.PingApa")){

            public IStatus run(IProgressMonitor monitor) {
                CorePlugin.getDefault().session.monitor = monitor;
                monitor.beginTask(Messages.getString("ReportsView.Job.Monitor.Ping"), 100);
                ReportTextView.this.zosconnect.pingZos(monitor);
                monitor.done();
                if (ReportTextView.this.zosconnect.getConnectRc() != 0) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job0.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("ReportsView Ping Job completed successfully");
                } else {
                    System.out.println("ReportsView Ping Job did not complete successfully");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("ReportsView Ping rc is " + (this).ReportTextView.this.zosconnect.getConnectRc());
                        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                            ReportTextView.this.showMessage("info", Messages.getString("ReportsView.MessageDialog.infoTitle.ReportsDownload"), String.valueOf(Messages.getString("ReportsView.MessageDialog.errorMessage.DownloadFailed")) + CorePlugin.getDefault().session.getReason());
                        } else if ((this).ReportTextView.this.zosconnect.getConnectRc() == 0) {
                            ReportTextView.this.runGetObsReports();
                        } else {
                            ReportTextView.this.showMessage("info", String.valueOf(Messages.getString("ReportsView.MessageDialog.infoTitle.Zos")) + CorePlugin.getDefault().productextension.getProductName() + Messages.getString("ReportsView.MessageDialog.infoTitle.ConnectionLost"), String.valueOf(Messages.getString("ReportsView.MessageDialog.infoMessage.RemoteConnectionLost")) + Messages.getString("ReportsView.Messaging.ReConnect"));
                            (this).ReportTextView.this.zosconnect.setConnectLocal();
                        }
                    }
                });
            }
        });
        job0.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job0.schedule();
    }

    private void runGetObsReports() {
        Job downloadJob = new Job(Messages.getString("ReportsView.Job.Title.DownloadingReports")){

            public IStatus run(IProgressMonitor monitor) {
                CorePlugin.getDefault().session.monitor = monitor;
                String sreqnum = "";
                ReportTextView.this.obsrpts.obs = CorePlugin.getDefault().selobs;
                ReportTextView.this.obsrpts.rptformat = ReportTextView.this.rptformat;
                ReportTextView.this.obsrpts.rptid = ReportTextView.this.rptid;
                sreqnum = CorePlugin.getDefault().constants.reqdecfmt.format(ReportTextView.this.reqnum);
                if (ReportTextView.this.rptformat.equals(ReportTextView.this.constants.REPORT_FORMAT_XML) | ReportTextView.this.rptformat.equals(ReportTextView.this.constants.REPORT_FORMAT_JSON) | ReportTextView.this.rptformat.equals(ReportTextView.this.constants.REPORT_FORMAT_PDF)) {
                    ReportTextView.this.obsrpts.saveReportFname = ReportTextView.this.saveReportFname;
                    ReportTextView.this.obsrpts.runCloseObsReports(sreqnum, monitor);
                }
                String msgstr = Messages.getString("ReportsView.Job.Monitor.DownloadingReport");
                msgstr = msgstr.replace("#rptid", ReportTextView.this.rptid);
                monitor.beginTask(String.valueOf(msgstr) + sreqnum + " ...", 100);
                ReportTextView.this.obsrpts.cookie = ReportTextView.this.obsrpts.getCookie(sreqnum, monitor);
                if (ReportTextView.this.report.parent.reportid.equalsIgnoreCase(ReportTextView.this.constants.REPORT_CATEGORY_MULTIADDR)) {
                    ReportTextView.this.obsrpts.cookie = ReportTextView.this.obsrpts.getDsns(ReportTextView.this.obsrpts.cookie, sreqnum, "multiaddrdsns", monitor);
                } else if (ReportTextView.this.report.parent.reportid.equalsIgnoreCase(ReportTextView.this.constants.REPORT_CATEGORY_VARIANCE)) {
                    ReportTextView.this.obsrpts.cookie = ReportTextView.this.obsrpts.getDsns(ReportTextView.this.obsrpts.cookie, sreqnum, "variancedsns", monitor);
                }
                ReportTextView.this.buildControlCards();
                ReportTextView.this.obsrpts.ccards.persistReportOptions(ReportTextView.this.obsrpts.rptid, "model");
                ReportTextView.this.obsrpts.parseRemoteReports(monitor, sreqnum);
                if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                    this.setName("");
                    ReportTextView.this.obsrpts.getobsrc = CorePlugin.getDefault().session.getReturnCode();
                    ReportTextView.this.obsrpts.getobsrsn = CorePlugin.getDefault().session.getReason();
                    if (ReportTextView.this.obsrpts.getobsrsn.startsWith(CorePlugin.getDefault().productextension.getZosProductId())) {
                        ReportTextView.this.obsrpts.getobsrsn = ReportTextView.this.obsrpts.getobsrsn.substring(ReportTextView.this.obsrpts.getobsrsn.indexOf(" ") + 1, ReportTextView.this.obsrpts.getobsrsn.length());
                    }
                    ReportTextView.this.obsrpts.runCloseObsReports(sreqnum, monitor);
                    return Status.CANCEL_STATUS;
                }
                if (ReportTextView.this.rptformat.equals(ReportTextView.this.constants.REPORT_FORMAT_XML) | ReportTextView.this.rptformat.equals(ReportTextView.this.constants.REPORT_FORMAT_JSON) | ReportTextView.this.rptformat.equals(ReportTextView.this.constants.REPORT_FORMAT_PDF)) {
                    ReportTextView.this.obsrpts.runLaunchProgram();
                    ReportTextView.this.obsrpts.runCloseObsReports(sreqnum, monitor);
                }
                monitor.worked(100);
                if (monitor.isCanceled()) {
                    this.setName("");
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                this.setName("");
                return Status.OK_STATUS;
            }
        };
        downloadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                event.getResult().isOK();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).ReportTextView.this.obsrpts.getobsrc == 0 || (this).ReportTextView.this.obsrpts.getobsrc == -98) {
                            if ((this).ReportTextView.this.reqaction.equals(ReportTextView.ACTION_REPORTDETAIL)) {
                                (this).ReportTextView.this.reqaction = "";
                                ReportTextView.this.runDetailWindow();
                            } else {
                                (this).ReportTextView.this.copyFromId = "base0";
                                (this).ReportTextView.this.copyToId = "active";
                                ReportTextView.this.copyReportJob();
                            }
                        } else if ((this).ReportTextView.this.obsrpts.getobsrc == -99) {
                            ReportTextView.this.showMessage("I", Messages.getString("ReportsView.MessageDialog.infoTitle.DownloadReports"), String.valueOf(Messages.getString("ReportsView.MessageDialog.infoMessage.RemoteConnectionClosed")) + Messages.getString("ReportsView.Messaging.ReConnect"));
                            (this).ReportTextView.this.zosconnect.setConnectLocal();
                        } else if ((this).ReportTextView.this.obsrpts.getobsrc == 13) {
                            ReportTextView.this.showMessage("E", Messages.getString("ReportsView.MessageDialog.errorTitle.DownloadReports"), String.valueOf(Messages.getString("ReportsView.MessageDialog.errorMessage.ReportsDownloadFor")) + (this).ReportTextView.this.obsrpts.obs.reqnum + Messages.getString("ReportsView.MessageDialog.errorMessage.FailedCheckApa") + (this).ReportTextView.this.obsrpts.getobsrsn);
                        } else {
                            ReportTextView.this.showMessage("E", Messages.getString("ReportsView.MessageDialog.errorTitle.DownloadReports"), String.valueOf(Messages.getString("ReportsView.MessageDialog.errorMessage.ReportsDownloadFor2")) + (this).ReportTextView.this.obsrpts.obs.reqnum + Messages.getString("ReportsView.MessageDialog.errorMessage.Failed") + (this).ReportTextView.this.obsrpts.getobsrsn);
                        }
                    }
                });
            }
        });
        downloadJob.setRule(CorePlugin.getDefault().schedrule);
        downloadJob.setUser(true);
        downloadJob.setPriority(20);
        downloadJob.schedule();
    }

    private void buildControlCards() {
        this.obsrpts.ccards.obs = this.obsrpts.obs;
        this.obsrpts.ccards.obsReqnum = this.obsrpts.obs.reqnum;
        this.obsrpts.ccards.obsDsname = this.obsrpts.obs.dsname;
        this.obsrpts.ccards.lcmdopt = this.obsrpts.lcmdopt;
        this.obsrpts.ccards.rptformat = this.obsrpts.rptformat;
        this.obsrpts.ccards.multiaddrdsns = this.obsrpts.multiaddrdsns;
        this.obsrpts.ccards.variancedsns = this.obsrpts.variancedsns;
        this.obsrpts.ccards.wasServantSampling = this.obsrpts.obs.wasServantSampling;
        this.obsrpts.ccards.wasServantObsDsname = this.obsrpts.obs.wasServantObsDsname;
        this.obsrpts.ccards.importedObservation = this.obsrpts.obs.importedObservation;
        this.obsrpts.ccards.buildControlCards(this.obsrpts.rptid, this.obsrpts.detailoffset, this.obsrpts.cookie);
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("E")) {
            CorePlugin.getDefault().getWorkbench().getDisplay();
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
        } else {
            CorePlugin.getDefault().getWorkbench().getDisplay();
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
        }
    }
}

