/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.views;

import com.banknet.core.CorePlugin;
import com.banknet.core.internal.Constants;
import com.banknet.core.models.StcModel;
import com.banknet.core.views.Messages;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class StcTreeViewLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableFontProvider,
ITableColorProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    FontRegistry registry = new FontRegistry();
    Constants constants = new Constants();
    String defaultStc;
    IEclipsePreferences connpref;
    Image connectedImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/obj/osprc_obj.gif").createImage();
    Image disconnectedImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/obj/osprct_obj.gif").createImage();
    Image workspace_obj = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/obj/workspace_obj.gif").createImage();
    StyledString.Styler style = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            if (!CorePlugin.getDefault().getPreferenceStore().getBoolean("colorMonochrome")) {
                textStyle.foreground = Display.getCurrent().getSystemColor(15);
            }
        }
    };

    public Image getColumnImage(Object element, int columnIndex) {
        Image returnValue = null;
        if (columnIndex == 0) {
            returnValue = element instanceof StcModel ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/obj/osprct_obj.gif").createImage() : PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        return returnValue;
    }

    public Image getImage(Object element) {
        Image returnValue = null;
        StcModel stcitem = (StcModel)element;
        if (stcitem.modellevel.equalsIgnoreCase(this.constants.STCLEVEL_SYSTEM)) {
            String connstatus = CorePlugin.getDefault().connectionextension.getConnectionStatus(stcitem.connectionid);
            if (connstatus.equals("connected")) {
                returnValue = this.connectedImage;
            } else if (connstatus.equals("disconnected")) {
                returnValue = this.disconnectedImage;
            } else if (connstatus.equals("local")) {
                returnValue = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
        } else {
            returnValue = this.workspace_obj;
        }
        return returnValue;
    }

    public String getColumnText(Object element, int columnIndex) {
        StcModel stcitem = (StcModel)element;
        String stcid = stcitem.stcid;
        switch (columnIndex) {
            case 0: {
                return stcid;
            }
            case 1: {
                return ((StcModel)element).jobname;
            }
            case 2: {
                return ((StcModel)element).spxgname;
            }
        }
        return null;
    }

    public Font getFont(Object element, int columnIndex) {
        return null;
    }

    public String getText(Object element) {
        return this.getStyledText(element).toString();
    }

    public void dispose() {
        this.connectedImage.dispose();
        this.disconnectedImage.dispose();
        this.workspace_obj.dispose();
    }

    public StyledString getStyledText(Object element) {
        StyledString styledString = new StyledString();
        StcModel stcitem = (StcModel)element;
        if (stcitem.modellevel.equalsIgnoreCase(this.constants.STCLEVEL_SYSTEM)) {
            styledString.append(this.getConnectionName(stcitem));
        } else if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
            if (stcitem.connectionid.equals(CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId")) & stcitem.isRemoteStc) {
                styledString.append(((StcModel)element).stcid);
            } else {
                styledString.append(((StcModel)element).stcid, this.style);
            }
        } else {
            styledString.append(((StcModel)element).stcid);
        }
        StringBuilder stringBuilder = new StringBuilder("/instance/");
        CorePlugin.getDefault();
        this.connpref = InstanceScope.INSTANCE.getNode(stringBuilder.append("com.banknet.core").append("/connections/").append(stcitem.connectionid).toString());
        this.defaultStc = this.connpref.get(this.constants.CONNPREF_DEFAULT_STC, "");
        if (stcitem.stcid.equalsIgnoreCase(this.defaultStc)) {
            styledString.append(" (" + Messages.getString("StcTreeView.Label.Stc.Default") + ")", StyledString.COUNTER_STYLER);
        }
        return styledString;
    }

    private StyledString getConnectionName(StcModel stcitem) {
        StyledString styledString = new StyledString();
        if (stcitem.connectionid.length() > 0 && stcitem.connectionname.length() > 0) {
            styledString.append(stcitem.connectionname);
            styledString.append(" (" + stcitem.servername + ":" + stcitem.portname + ")", StyledString.DECORATIONS_STYLER);
        } else {
            styledString.append(stcitem.systemname);
        }
        return styledString;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        return null;
    }
}

