/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.views;

import com.banknet.core.CorePlugin;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.dialogs.reports.ReportViewerDialog;
import com.banknet.core.dialogs.spm.SpmRepositoryDialog;
import com.banknet.core.internal.Constants;
import com.banknet.core.models.StcModel;
import com.banknet.core.views.Messages;
import com.banknet.core.views.StcTreeViewContentProvider;
import com.banknet.core.views.StcTreeViewLabelProvider;
import java.io.File;
import java.util.Date;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.service.prefs.BackingStoreException;

public class StcTreeView
extends ViewPart {
    public static final String ID = "com.banknet.core.StcTreeView";
    ZosConnect zosconnect = new ZosConnect();
    Constants constants = new Constants();
    public TreeViewer tviewer;
    private Tree tree;
    private DrillDownAdapter drillDownAdapter;
    private Action action1;
    private Action action2;
    private Action doubleClickAction;
    private String newapaStc = "";
    private StcModel selstcmodel;
    private Action defaultStcAction;
    private Action spmAction;
    private Action reportViewerAction;
    public Action connectAction;
    public Action disconnectAction;
    public Action connectionsAction;
    public Action addSystemAction;
    public Action removeSystemAction;
    private final IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals("coreConnected")) {
                if (CorePlugin.getDefault().getPreferenceStore().getBoolean("coreConnected")) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                        }
                    });
                }
            } else if (CorePlugin.getDefault().getPreferenceStore().getBoolean("stcRefresh") | event.getKey().equals("showInactiveStcs")) {
                if (CorePlugin.getDefault().getStcModel() != null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            StcTreeView.this.refreshStc();
                        }
                    });
                }
            } else if (event.getKey().equals("coreDataPath")) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).StcTreeView.this.zosconnect.connectZos();
                    }
                });
            }
        }
    };

    public void init(IViewSite site) throws PartInitException {
        IEclipsePreferences preferencesI = InstanceScope.INSTANCE.getNode("com.banknet.core");
        preferencesI.addPreferenceChangeListener(this.preferenceChangeListener);
        super.init(site);
        CorePlugin.getDefault().connectionextension.createConnectionListener();
    }

    public void createPartControl(Composite parent) {
        this.tviewer = new TreeViewer(parent, 768);
        this.tviewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.tviewer.getControl(), String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".views_StcListViewContext");
        DelegatingStyledCellLabelProvider styledCellSTC = new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new StcTreeViewLabelProvider());
        TreeViewerColumn column = new TreeViewerColumn(this.tviewer, 0);
        column.getColumn().setWidth(300);
        column.getColumn().setText(Messages.getString("StcTreeView.StcColumn.StcId"));
        column.setLabelProvider((CellLabelProvider)styledCellSTC);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.tviewer);
        this.drillDownAdapter = new DrillDownAdapter(this.tviewer);
        this.tviewer.setAutoExpandLevel(2);
        this.tviewer.setUseHashlookup(true);
        this.tviewer.setContentProvider((IContentProvider)new StcTreeViewContentProvider());
        this.tviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                try {
                    StcTreeView.this.getViewSite().getActionBars().getStatusLineManager().setMessage("");
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    String selstc = ((StcModel)obj).stcid;
                    String cfr_ignored_0 = ((StcModel)obj).systemname;
                    String connectionid = ((StcModel)obj).connectionid;
                    String prevconnid = CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId");
                    CorePlugin.getDefault().getPreferenceStore().setValue("activeConnectionId", connectionid);
                    if (((StcModel)obj).modellevel.equals(StcTreeView.this.constants.STCLEVEL_STC)) {
                        if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
                            if (connectionid.equalsIgnoreCase(prevconnid)) {
                                if (CorePlugin.getDefault().activeStc.equalsIgnoreCase(selstc)) {
                                    CorePlugin.getDefault().getPreferenceStore().setValue("stcViewSel", String.valueOf(connectionid) + selstc + "_" + StcTreeView.this.constants.yyyymmddhhmmss.format(new Date()));
                                } else if (((StcModel)obj).isRemoteStc) {
                                    CorePlugin.getDefault().activeStc = ((StcModel)obj).stcid;
                                    StcTreeView.this.zosconnect.loadModelsJob();
                                }
                            }
                        } else if (connectionid.equalsIgnoreCase(prevconnid) && CorePlugin.getDefault().activeStc.equalsIgnoreCase(selstc)) {
                            CorePlugin.getDefault().getPreferenceStore().setValue("stcViewSel", String.valueOf(connectionid) + selstc + "_" + StcTreeView.this.constants.yyyymmddhhmmss.format(new Date()));
                        } else {
                            CorePlugin.getDefault().activeStc = ((StcModel)obj).stcid;
                            StcTreeView.this.zosconnect.loadModelsJob();
                        }
                    } else {
                        CorePlugin.getDefault().getPreferenceStore().setValue("stcViewSel", connectionid);
                    }
                }
                catch (Exception exception) {}
            }
        });
        this.refreshStc();
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        CorePlugin.getDefault().connectionextension.setConnectionStatus(this.getViewSite());
    }

    public String getPartProperty(String key) {
        String partkey = CorePlugin.getDefault().connectionextension.getConnectionPartKey(key);
        if (partkey.length() > 0) {
            return partkey;
        }
        return super.getPartProperty(key);
    }

    private void activateStcView() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        page.activate((IWorkbenchPart)this);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                StcTreeView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.tviewer.getControl());
        this.tviewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu("com.banknet.core.views.stctreeview.context", menuMgr, (ISelectionProvider)this.tviewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void fillContextMenu(IMenuManager manager) {
        ISelection selection = this.tviewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        String cfr_ignored_0 = ((StcModel)obj).stcid;
        String cfr_ignored_1 = ((StcModel)obj).systemname;
        String cfr_ignored_2 = ((StcModel)obj).connectionid;
        if (((StcModel)obj).modellevel.equals(this.constants.STCLEVEL_SYSTEM)) {
            String actiontxt = Messages.getString("StcTreeView.Action.Start");
            actiontxt = actiontxt.replace("#productname", String.valueOf(CorePlugin.getDefault().productextension.getProductName()) + " " + ((StcModel)obj).connectionname);
            this.connectAction.setText(actiontxt);
            actiontxt = Messages.getString("StcTreeView.Action.Stop");
            actiontxt = actiontxt.replace("#productname", String.valueOf(CorePlugin.getDefault().productextension.getProductName()) + " " + ((StcModel)obj).connectionname);
            this.disconnectAction.setText(actiontxt);
            manager.add((IAction)this.connectAction);
            manager.add((IAction)this.disconnectAction);
        } else {
            manager.add((IAction)this.defaultStcAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.spmAction);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        if (!CorePlugin.getDefault().connectionextension.showSystemActions().equals("hide")) {
            manager.add((IAction)this.connectionsAction);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.addSystemAction);
        }
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void makeActions() {
        this.defaultStcAction = new Action(){

            public void run() {
                ISelection selection = StcTreeView.this.tviewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                try {
                    StringBuilder stringBuilder = new StringBuilder("/instance/");
                    CorePlugin.getDefault();
                    IEclipsePreferences connpref = InstanceScope.INSTANCE.getNode(stringBuilder.append("com.banknet.core").append("/connections/").append(((StcModel)obj).connectionid).toString());
                    connpref.put(CorePlugin.getDefault().constants.CONNPREF_DEFAULT_STC, ((StcModel)obj).stcid);
                    connpref.flush();
                }
                catch (BackingStoreException be) {
                    String logstr = "defaultStcAction:  BackingStoreException saving defaultSTC: " + be.getMessage();
                    System.out.println("StcTreeView - " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                }
                catch (Exception ex) {
                    System.out.println("Exception saving defaultSTC: " + ex.getMessage());
                    String logstr = "defaultStcAction:  Exception saving defaultSTC: " + ex.getMessage();
                    System.out.println("StcTreeView - " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                }
                StcTreeView.this.tviewer.refresh();
            }
        };
        this.defaultStcAction.setText(Messages.getString("StcTreeView.Action.DefaultStc"));
        this.defaultStcAction.setToolTipText(Messages.getString("StcTreeView.Tooltip.DefaultStc"));
        this.reportViewerAction = new Action(){

            public void run() {
                Shell shell = StcTreeView.this.tviewer.getControl().getShell();
                IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
                CorePlugin.getDefault();
                ReportViewerDialog rvd = new ReportViewerDialog(shell, String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator);
                rvd.open();
                rvd = null;
            }
        };
        this.reportViewerAction.setText(Messages.getString("StcTreeView.Action.ReportViewer"));
        this.reportViewerAction.setToolTipText(Messages.getString("StcTreeView.Tooltip.ReportViewer"));
        this.reportViewerAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadReportsGreen.gif"));
        this.addSystemAction = CorePlugin.getDefault().connectionextension.makeAddSystemAction();
        this.removeSystemAction = CorePlugin.getDefault().connectionextension.makeRemoveSystemAction(this.tviewer);
        this.connectionsAction = CorePlugin.getDefault().connectionextension.makeConnectionsAction();
        this.disconnectAction = CorePlugin.getDefault().connectionextension.makeDisconnectAction();
        this.connectAction = new Action(){

            public void run() {
                ISelection selection = StcTreeView.this.tviewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                String selconnid = ((StcModel)obj).connectionid;
                CorePlugin.getDefault().connectionextension.connectZos(selconnid);
            }
        };
        String actiontxt = Messages.getString("StcTreeView.Action.Start");
        actiontxt = actiontxt.replace("#productname", CorePlugin.getDefault().productextension.getProductName());
        this.connectAction.setText(actiontxt);
        this.connectAction.setToolTipText(actiontxt);
        this.connectAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/obj/osprc_obj.gif"));
        this.connectAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/obj/osprc_obj.gif"));
        this.connectAction.setEnabled(true);
        this.disconnectAction = new Action(){

            public void run() {
                ISelection selection = StcTreeView.this.tviewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                String cfr_ignored_0 = ((StcModel)obj).connectionid;
                CorePlugin.getDefault().connectionextension.forceCancelZos();
            }
        };
        actiontxt = Messages.getString("StcTreeView.Action.Stop");
        actiontxt = actiontxt.replace("#productname", CorePlugin.getDefault().productextension.getProductName());
        this.disconnectAction.setText(actiontxt);
        this.disconnectAction.setToolTipText(actiontxt);
        this.disconnectAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/obj/osprct_obj.gif"));
        this.disconnectAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/obj/osprct_obj.gif"));
        this.disconnectAction.setEnabled(true);
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = StcTreeView.this.tviewer.getSelection();
                ((IStructuredSelection)selection).getFirstElement();
            }
        };
        this.spmAction = new Action(){

            public void run() {
                if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") < 0) {
                    StcTreeView.this.showMessage(Messages.getString("ObservationsView.MessageDialog.infoMessage.RemoteConnectionReqd"));
                } else {
                    SpmRepositoryDialog spm = new SpmRepositoryDialog(StcTreeView.this.tviewer.getControl().getShell());
                    spm.open();
                    Object var1_1 = null;
                }
            }
        };
        this.spmAction.setText(Messages.getString("ObservationsView.Action.SPM"));
        this.spmAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.SPM"));
        this.spmAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/eview16/history_view.gif"));
    }

    private void hookDoubleClickAction() {
        this.tviewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StcTreeView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.tviewer.getControl().getShell(), (String)Messages.getString("StcTreeView.View.Title"), (String)message);
    }

    public void setFocus() {
        if (this.getSite().getPage().getActivePart() != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.tviewer.getControl(), String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".views_StcListViewContext");
        }
        this.tviewer.getControl().setFocus();
    }

    public void dispose() {
        IEclipsePreferences preferencesI = InstanceScope.INSTANCE.getNode("com.banknet.core");
        preferencesI.removePreferenceChangeListener(this.preferenceChangeListener);
        super.dispose();
    }

    public void mysleep(Integer waitTime) {
        try {
            System.out.println("Waiting " + waitTime.toString());
            Thread.sleep(waitTime.intValue());
        }
        catch (Throwable throwable) {
            System.out.println("Wait time interrupted");
        }
    }

    private void setDefaultSelected() {
        String treesystem = "";
        String treestc = "";
        String selectedconnid = "";
        selectedconnid = CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId");
        String selectedstc = CorePlugin.getDefault().activeStc;
        String modellevel = "";
        if (this.tviewer.getTree().getItems().length <= 0) {
            return;
        }
        ISelection selection = this.tviewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        StcModel selmodel = (StcModel)obj;
        if (selmodel == null || selmodel.connectionid.equals(selectedconnid) & selmodel.stcid.equals(selectedstc)) {
            // empty if block
        }
        TreeItem[] systemitems = this.tviewer.getTree().getItems();
        int j = 0;
        while (j < systemitems.length) {
            treesystem = ((StcModel)systemitems[j].getData()).connectionid;
            if (!treesystem.equalsIgnoreCase(selectedconnid)) {
                systemitems[j].setExpanded(false);
            } else if (modellevel.equalsIgnoreCase(this.constants.STCLEVEL_SYSTEM)) {
                this.tviewer.setSelection((ISelection)new StructuredSelection(systemitems[j].getData()));
            } else {
                TreeItem[] stcitem = systemitems[j].getItems();
                int i = 0;
                while (i < stcitem.length) {
                    StructuredSelection ssel;
                    treestc = ((StcModel)stcitem[i].getData()).stcid;
                    if (treestc.equalsIgnoreCase(selectedstc)) {
                        systemitems[j].setExpanded(true);
                        ssel = new StructuredSelection(stcitem[i].getData());
                        this.tviewer.setSelection((ISelection)ssel);
                        break;
                    }
                    if (selectedstc.length() <= 0 && i == 0) {
                        CorePlugin.getDefault().activeStc = treestc;
                        systemitems[j].setExpanded(true);
                        ssel = new StructuredSelection(stcitem[i].getData());
                        this.tviewer.setSelection((ISelection)ssel);
                        break;
                    }
                    ++i;
                }
            }
            ++j;
        }
    }

    private void setDefaultSelectedTest() {
        ISelection selection = this.tviewer.getSelection();
        Object obj = ((IStructuredSelection)selection).getFirstElement();
        String selconnid = "";
        String selmodellevel = "";
        String selstc = "";
        String treestc = "";
        if (obj != null) {
            selconnid = ((StcModel)obj).connectionid;
            selmodellevel = ((StcModel)obj).modellevel;
            selstc = ((StcModel)obj).stcid;
        }
        if (this.tviewer.getTree().getItems().length > 0) {
            TreeItem[] systemitems = this.tviewer.getTree().getItems();
            int j = 0;
            while (j < systemitems.length) {
                System.out.println("system is " + systemitems[j].getText());
                System.out.println("connection name is " + ((StcModel)systemitems[j].getData()).connectionname);
                if (selconnid.length() <= 0) {
                    selconnid = ((StcModel)systemitems[j].getData()).connectionid;
                }
                if (selconnid.equals(((StcModel)systemitems[j].getData()).connectionid)) {
                    if (!systemitems[j].getExpanded()) {
                        systemitems[j].setExpanded(true);
                    }
                    TreeItem[] stcitem = systemitems[j].getItems();
                    if (selmodellevel.equals(this.constants.STCLEVEL_SYSTEM)) {
                        this.tviewer.setSelection((ISelection)new StructuredSelection(systemitems[j].getData()));
                    } else {
                        int i = 0;
                        while (i < stcitem.length) {
                            treestc = ((StcModel)stcitem[i].getData()).stcid;
                            if (selstc.length() <= 0) {
                                this.tviewer.setSelection((ISelection)new StructuredSelection(stcitem[0].getData()));
                                break;
                            }
                            if (selstc.equals(treestc)) {
                                this.tviewer.setSelection((ISelection)new StructuredSelection(stcitem[0].getData()));
                                break;
                            }
                            ++i;
                        }
                    }
                } else {
                    systemitems[j].setExpanded(false);
                }
                ++j;
            }
        }
    }

    private void refreshStc() {
        this.tviewer.setInput((Object)CorePlugin.getDefault().getStcModel());
        this.tviewer.getTree().getColumn(0).pack();
        this.setDefaultSelected();
        this.tviewer.refresh();
        CorePlugin.getDefault().getPreferenceStore().setValue("stcRefresh", false);
        CorePlugin.getDefault().getPreferenceStore().setValue("stcViewSel", String.valueOf(CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId")) + CorePlugin.getDefault().activeStc + "_" + this.constants.yyyymmddhhmmss.format(new Date()));
        this.getSite().getPage().bringToTop((IWorkbenchPart)this.getSite().getPage().findView("com.banknet.core.ObservationView"));
        this.getSite().getPage().activate((IWorkbenchPart)this.getSite().getPage().findView("com.banknet.core.ObservationsView"));
        this.getViewSite().getActionBars().getStatusLineManager().update(true);
    }

    private void clearSelections(TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            TreeItem[] childitems = items[i].getItems();
            items[i].setChecked(false);
            if (childitems.length > 0) {
                this.clearSelections(childitems);
            }
            ++i;
        }
    }
}

