/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.views;

import com.banknet.core.CorePlugin;
import com.banknet.core.data.HostProperties;
import com.banknet.core.models.StcModel;
import com.banknet.core.views.Messages;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class StcPropertiesView
extends ViewPart {
    public static final String ID = "com.banknet.core.StcPropertiesView";
    SimpleDateFormat hhmmss = new SimpleDateFormat("HH:mm:ss");
    SimpleDateFormat dtfmt = new SimpleDateFormat("yyyy-MM-ddHHmmssSS");
    HostProperties hostprop;
    boolean isStcView = true;
    private Table table;
    private final IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (event.getKey().equals("stcViewSel") | event.getKey().equals("coreConnected")) {
                StcPropertiesView.this.updateView();
            }
        }
    };

    public StcPropertiesView() {
        IEclipsePreferences preferencesI = InstanceScope.INSTANCE.getNode("com.banknet.core");
        preferencesI.addPreferenceChangeListener(this.preferenceChangeListener);
    }

    public void createPartControl(Composite parent) {
        GridData gd = new GridData(4, 4, true, true);
        this.table = new Table(parent, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.setLayoutData((Object)gd);
        TableColumn column = new TableColumn(this.table, 16384);
        column.setResizable(true);
        column.setToolTipText(Messages.getString("StcPropertiesView.PropertiesColumn.Tooltip.Property"));
        column.setText(Messages.getString("StcPropertiesView.PropertiesColumn.Property"));
        column = new TableColumn(this.table, 16384);
        column.setResizable(true);
        column.setToolTipText(Messages.getString("StcPropertiesView.PropertiesColumn.Tooltip.Value"));
        column.setText(Messages.getString("StcPropertiesView.PropertiesColumn.Value"));
        TableColumnLayout tableLayout = new TableColumnLayout();
        parent.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)this.table.getColumn(0), (ColumnLayoutData)new ColumnWeightData(40));
        tableLayout.setColumnData((Widget)this.table.getColumn(1), (ColumnLayoutData)new ColumnWeightData(60));
        this.updateView();
        CorePlugin.getDefault().connectionextension.setConnectionStatus(this.getViewSite());
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        CorePlugin.getDefault().connectionextension.createConnectionListener();
    }

    public String getPartProperty(String key) {
        String partkey = CorePlugin.getDefault().connectionextension.getConnectionPartKey(key);
        if (partkey.length() > 0) {
            return partkey;
        }
        return super.getPartProperty(key);
    }

    public void setFocus() {
        if (this.getSite().getPage().getActivePart() != null) {
            this.isStcView = false;
            if (false) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.table.getShell(), String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".views_SystemPropertiesViewContext");
            } else {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.table.getShell(), String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".views_StcPropertiesViewContext");
            }
        }
    }

    public void dispose() {
        IEclipsePreferences preferencesI = InstanceScope.INSTANCE.getNode("com.banknet.core");
        preferencesI.removePreferenceChangeListener(this.preferenceChangeListener);
        super.dispose();
    }

    private void updateView() {
        try {
            this.table.setRedraw(false);
            this.table.removeAll();
            String logstr = "updateView: StcProperties Active Stc " + CorePlugin.getDefault().activeStc;
            System.out.println("StcPropertiesView " + logstr);
            CorePlugin.getDefault().log.debug(logstr);
            StcModel stc = CorePlugin.getDefault().getStcModel();
            if (stc != null) {
                int j = 0;
                while (j < stc.getChildren().size()) {
                    StcModel systemitem = stc.getChildren().get(j);
                    if (systemitem.connectionid.equals(CorePlugin.getDefault().getPreferenceStore().getString("stcViewSel"))) {
                        this.setPartName(Messages.getString("StcPropertiesView.PartName.HostPropertiesView"));
                        this.addSystemTableItem(systemitem.connectionid);
                        break;
                    }
                    if (systemitem.connectionid.equalsIgnoreCase(CorePlugin.getDefault().hostproperties.connectionid)) {
                        this.setPartName(Messages.getString("StcPropertiesView.PartName.StcPropertiesView"));
                        int i = 0;
                        while (i < systemitem.getChildren().size()) {
                            StcModel stcitem = systemitem.getChildren().get(i);
                            if (stcitem.stcid.equalsIgnoreCase(CorePlugin.getDefault().activeStc)) {
                                this.addTableItem(stcitem);
                            }
                            ++i;
                        }
                    }
                    ++j;
                }
            }
            this.table.setRedraw(true);
        }
        catch (Exception exception) {}
    }

    private void addTableItem(StcModel stcitem) {
        this.isStcView = true;
        TableItem tableItem = new TableItem(this.table, 0);
        tableItem.setText(0, Messages.getString("StcPropertiesView.PropertiesText.DSNHLQ"));
        tableItem.setText(1, stcitem.dsnhlq);
        tableItem = new TableItem(this.table, 0);
        tableItem.setText(0, Messages.getString("StcPropertiesView.PropertiesText.Job"));
        tableItem.setText(1, stcitem.jobname);
        tableItem = new TableItem(this.table, 0);
        tableItem.setText(0, Messages.getString("StcPropertiesView.PropertiesText.Started"));
        try {
            if (stcitem.dtstart.length() > 0) {
                Date reqdate = this.dtfmt.parse(String.valueOf(stcitem.dtstart) + stcitem.tmstart);
                tableItem.setText(1, String.valueOf(stcitem.dtstart) + " " + this.hhmmss.format(reqdate));
            } else {
                tableItem.setText(1, " ");
            }
        }
        catch (Exception e) {
            String logstr = "updateView: dtstart " + stcitem.dtstart + stcitem.tmstart + "  parse exception: " + e;
            System.out.println("StcPropertiesView " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        tableItem = new TableItem(this.table, 0);
        tableItem.setText(0, Messages.getString("StcPropertiesView.PropertiesText.Sysplex"));
        tableItem.setText(1, stcitem.spxgname);
        tableItem = new TableItem(this.table, 0);
        tableItem.setText(0, Messages.getString("StcPropertiesView.PropertiesText.Version"));
        tableItem.setText(1, stcitem.version);
        if (CorePlugin.getDefault().productextension.showApar() & stcitem.apar.length() > 0) {
            tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, Messages.getString("StcPropertiesView.PropertiesText.Apar"));
            tableItem.setText(1, stcitem.apar);
        }
    }

    private void addSystemTableItem(String connectionid) {
        this.isStcView = false;
        try {
            this.hostprop = new HostProperties();
            this.hostprop.loadHostPropertiesFile(connectionid);
        }
        catch (Exception exception) {}
        HostProperties hostproperties = this.hostprop;
        this.table.removeAll();
        TableItem tableItem = new TableItem(this.table, 0);
        tableItem.setText(0, Messages.getString("HostPropertiesView.PropertiesText.ConnectionName"));
        tableItem.setText(1, hostproperties.connectionname);
        tableItem = new TableItem(this.table, 0);
        tableItem.setText(0, Messages.getString("HostPropertiesView.PropertiesText.ConnectionId"));
        tableItem.setText(1, hostproperties.connectionid);
        CorePlugin.getDefault().session.queueFile("SIGNON");
        if (CorePlugin.getDefault().session.ConnectionLastSignon.length() > 0) {
            tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, Messages.getString("HostPropertiesView.PropertiesText.ConnectionLastSignon"));
            tableItem.setText(1, CorePlugin.getDefault().session.ConnectionLastSignon);
        }
        tableItem = new TableItem(this.table, 0);
        tableItem.setText(0, Messages.getString("HostPropertiesView.PropertiesText.SystemName"));
        tableItem.setText(1, hostproperties.sSystemName);
        tableItem = new TableItem(this.table, 0);
        tableItem.setText(0, Messages.getString("HostPropertiesView.PropertiesText.OSName"));
        tableItem.setText(1, hostproperties.sOSName);
        tableItem = new TableItem(this.table, 0);
        tableItem.setText(0, Messages.getString("HostPropertiesView.PropertiesText.OSVersion"));
        tableItem.setText(1, hostproperties.sOSVersion);
        tableItem = new TableItem(this.table, 0);
        tableItem.setText(0, Messages.getString("HostPropertiesView.PropertiesText.OSRelease"));
        tableItem.setText(1, hostproperties.sOSRelease);
        tableItem = new TableItem(this.table, 0);
        tableItem.setText(0, Messages.getString("HostPropertiesView.PropertiesText.OSMod"));
        tableItem.setText(1, hostproperties.sOSMod);
        String connstatus = CorePlugin.getDefault().connectionextension.getConnectionStatus(connectionid);
        if (CorePlugin.getDefault().session == null | !connstatus.equals("connected")) {
            return;
        }
        if (CorePlugin.getDefault().session.CommonServerName.length() > 0) {
            tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, Messages.getString("HostPropertiesView.PropertiesText.CommonServer"));
            tableItem.setText(1, CorePlugin.getDefault().session.CommonServerName);
        }
        if (CorePlugin.getDefault().session.CommonServerVersion.length() > 0) {
            tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, Messages.getString("HostPropertiesView.PropertiesText.ServerVersion"));
            tableItem.setText(1, CorePlugin.getDefault().session.CommonServerVersion);
        }
        if (CorePlugin.getDefault().session.CommonServerRelease.length() > 0) {
            tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, Messages.getString("HostPropertiesView.PropertiesText.Release"));
            tableItem.setText(1, CorePlugin.getDefault().session.CommonServerRelease);
        }
        if (CorePlugin.getDefault().session.CommonServerPort.length() > 0) {
            tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, Messages.getString("HostPropertiesView.PropertiesText.PortNumber"));
            tableItem.setText(1, CorePlugin.getDefault().session.CommonServerPort);
        }
        if (CorePlugin.getDefault().session.LSTC_JOBN.length() > 0) {
            tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, Messages.getString("HostPropertiesView.PropertiesText.LstcJobn"));
            tableItem.setText(1, CorePlugin.getDefault().session.LSTC_JOBN);
        }
        if (CorePlugin.getDefault().session.LSTC_JOBI.length() > 0) {
            tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, Messages.getString("HostPropertiesView.PropertiesText.LstcJobi"));
            tableItem.setText(1, CorePlugin.getDefault().session.LSTC_JOBI);
        }
        if (CorePlugin.getDefault().session.LSTC_VERSION.length() > 0) {
            tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, Messages.getString("HostPropertiesView.PropertiesText.LstcVersion"));
            tableItem.setText(1, CorePlugin.getDefault().session.LSTC_VERSION);
        }
        if (CorePlugin.getDefault().productextension.showApar() & CorePlugin.getDefault().session.LSTC_APAR.length() > 0) {
            tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, Messages.getString("HostPropertiesView.PropertiesText.LstcApar"));
            tableItem.setText(1, CorePlugin.getDefault().session.LSTC_APAR);
        }
        if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
            tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, Messages.getString("HostPropertiesView.PropertiesText.DLGUI"));
            tableItem.setText(1, CorePlugin.getDefault().session.DLGUI);
            tableItem = new TableItem(this.table, 0);
            tableItem.setText(0, Messages.getString("HostPropertiesView.PropertiesText.COMPATGUI"));
            tableItem.setText(1, CorePlugin.getDefault().session.COMPATGUI);
        }
    }
}

