/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.views;

import com.banknet.core.CorePlugin;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.Utilities;
import com.banknet.core.models.ObservationsModel;
import com.banknet.core.views.Messages;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ObservationsViewLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableFontProvider,
ITableColorProvider {
    FontRegistry registry = new FontRegistry();
    Constants constants = new Constants();
    Utilities utilities = new Utilities();
    Image imgreport = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/msBlue14x14.gif").createImage();
    Image imgtagged = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/tagged14x14.gif").createImage();
    Image imgtransparent = this.utilities.createTransparentColumnSquareImage(Display.getCurrent(), 14);
    Image imgStickyNotes = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/stickyNote14x14.gif").createImage();
    DecimalFormat durfmt = new DecimalFormat("##.00");
    int rowcount = 0;
    List<String> colprefs = Arrays.asList(CorePlugin.getDefault().getPreferenceStore().getString("obsListColumns").split(","));
    String[] colidarr;

    public ObservationsViewLabelProvider() {
        this.colidarr = CorePlugin.getDefault().constants.OBSLIST_COLUMNS.split(",");
    }

    public Image getColumnImage(Object element, int columnIndex) {
        String colid = this.colprefs.get(columnIndex);
        if (colid != null) {
            if (colid.equalsIgnoreCase(this.colidarr[0])) {
                if (((ObservationsModel)element).getStickyNotes()) {
                    return this.imgStickyNotes;
                }
            } else if (colid.equalsIgnoreCase(this.colidarr[1])) {
                if (((ObservationsModel)element).getReportsAvail()) {
                    return this.imgreport;
                }
            } else if (colid.equalsIgnoreCase(this.colidarr[7])) {
                if (((ObservationsModel)element).getTagObservation()) {
                    return this.imgtagged;
                }
                return this.imgtransparent;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String colid = this.colprefs.get(columnIndex);
        if (colid != null) {
            if (colid.equalsIgnoreCase(this.colidarr[0])) {
                return CorePlugin.getDefault().constants.reqdecfmt.format(((ObservationsModel)element).reqnum);
            }
            if (colid.equalsIgnoreCase(this.colidarr[1])) {
                return "";
            }
            if (colid.equalsIgnoreCase(this.colidarr[2])) {
                if (((ObservationsModel)element).getReqlink() > 0) {
                    return "";
                }
                return ((ObservationsModel)element).ownedby;
            }
            if (colid.equalsIgnoreCase(this.colidarr[3])) {
                return ((ObservationsModel)element).r02Description;
            }
            if (colid.equalsIgnoreCase(this.colidarr[4])) {
                if (((ObservationsModel)element).getReqlink() > 0) {
                    if (((ObservationsModel)element).flags3Type.equalsIgnoreCase("MJob")) {
                        return ((ObservationsModel)element).jobname;
                    }
                    if (((ObservationsModel)element).parentVariant.equalsIgnoreCase("I")) {
                        return ((ObservationsModel)element).jobname;
                    }
                    return "";
                }
                return ((ObservationsModel)element).jobname;
            }
            if (colid.equalsIgnoreCase(this.colidarr[5])) {
                if (((ObservationsModel)element).getSessionDateTime() != null) {
                    return this.constants.mmmddyyyyhhmm.format(((ObservationsModel)element).getSessionDateTime()).toString();
                }
            } else if (colid.equalsIgnoreCase(this.colidarr[6])) {
                if (((ObservationsModel)element).getSamples() != null) {
                    return this.constants.decfmt.format(((ObservationsModel)element).getR02Samples());
                }
            } else {
                if (colid.equalsIgnoreCase(this.colidarr[7])) {
                    return ((ObservationsModel)element).getStatusShort();
                }
                if (colid.equalsIgnoreCase(this.colidarr[8])) {
                    if (((ObservationsModel)element).getDeleteDays() != null) {
                        return CorePlugin.getDefault().constants.decfmt.format(((ObservationsModel)element).getDeleteDays());
                    }
                    return Messages.getString("ObservationsView.ObsListColumn.DelDays.Keep");
                }
                if (colid.equalsIgnoreCase(this.colidarr[9])) {
                    return ((ObservationsModel)element).getSystem();
                }
                if (colid.equalsIgnoreCase(this.colidarr[10])) {
                    String duration = "";
                    if (((ObservationsModel)element).getSessionDuration() != null) {
                        Double iduration = (double)(((ObservationsModel)element).getSessionDurationMin() * 60L) + ((ObservationsModel)element).getSessionDurationSec();
                        duration = this.durfmt.format(iduration);
                    }
                    return duration;
                }
            }
        }
        return null;
    }

    public Font getFont(Object element, int columnIndex) {
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        if (columnIndex == 0) {
            ++this.rowcount;
        }
        if (this.rowcount % 2 == 0 && !CorePlugin.getDefault().getPreferenceStore().getBoolean("colorMonochrome")) {
            return CorePlugin.getDefault().productextension.getObsAltRowColor();
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        String colid = this.colprefs.get(columnIndex);
        if (colid != null) {
            if (colid.equalsIgnoreCase(this.colidarr[6])) {
                if (!CorePlugin.getDefault().getPreferenceStore().getBoolean("colorMonochrome")) {
                    if (((ObservationsModel)element).getStatusCode().equalsIgnoreCase("N")) {
                        return Display.getCurrent().getSystemColor(3);
                    }
                    if (((ObservationsModel)element).getStatusCode().equalsIgnoreCase("A") || ((ObservationsModel)element).getStatusCode().equalsIgnoreCase("F") || ((ObservationsModel)element).getStatusCode().equalsIgnoreCase("I") || ((ObservationsModel)element).getStatusCode().equalsIgnoreCase("W") || ((ObservationsModel)element).getStatusCode().equalsIgnoreCase("X")) {
                        return CorePlugin.getDefault().constants.COLOR_DELDAYS_YELLOW;
                    }
                    return Display.getCurrent().getSystemColor(2);
                }
            } else if (colid.equalsIgnoreCase(this.colidarr[7])) {
                if (!CorePlugin.getDefault().getPreferenceStore().getBoolean("colorMonochrome")) {
                    if (((ObservationsModel)element).getVariant().equalsIgnoreCase("T") && ((ObservationsModel)element).getStatusCode().equalsIgnoreCase("N")) {
                        return Display.getCurrent().getSystemColor(3);
                    }
                    return Display.getCurrent().getSystemColor(2);
                }
            } else if (colid.equalsIgnoreCase(this.colidarr[8]) && !CorePlugin.getDefault().getPreferenceStore().getBoolean("colorMonochrome")) {
                if (((ObservationsModel)element).deleteDaysColor != null) {
                    return ((ObservationsModel)element).deleteDaysColor;
                }
                return Display.getCurrent().getSystemColor(2);
            }
        }
        return null;
    }

    public void dispose() {
        this.imgreport.dispose();
        this.imgtagged.dispose();
        this.imgtransparent.dispose();
        this.imgStickyNotes.dispose();
    }
}

