/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.views;

import com.banknet.core.CorePlugin;
import com.banknet.core.actions.DisposeReportsAction;
import com.banknet.core.connection.ZosConnect;
import com.banknet.core.data.ObservationDetail;
import com.banknet.core.data.ObservationsList;
import com.banknet.core.data.reports.ObservationReports;
import com.banknet.core.dialogs.ExportObservationDialog;
import com.banknet.core.dialogs.ImportObservationDialog;
import com.banknet.core.dialogs.ModifyDescriptionDialog;
import com.banknet.core.dialogs.ObservationsFilterDialog;
import com.banknet.core.dialogs.ObservationsSearchDialog;
import com.banknet.core.dialogs.StickyNotesDialog;
import com.banknet.core.dialogs.newobservation.NewObservationDialog;
import com.banknet.core.dialogs.spm.SpmRepositoryDialog;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.ObservationRequestJob;
import com.banknet.core.internal.Utilities;
import com.banknet.core.models.ObservationsModel;
import com.banknet.core.models.ObservationsSearchItem;
import com.banknet.core.models.ReportsModel;
import com.banknet.core.preferences.PreferencesConstants;
import com.banknet.core.views.Messages;
import com.banknet.core.views.ObservationsEditor;
import com.banknet.core.views.ObservationsViewContentProvider;
import com.banknet.core.views.ObservationsViewLabelProvider;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ObservationsView
extends ViewPart
implements ISelectionListener {
    MenuManager menuMgr;
    ObservationsList obs = new ObservationsList();
    Constants constants = new Constants();
    PreferencesConstants pconstants = new PreferencesConstants();
    Utilities utilities = new Utilities();
    ZosConnect zosconnect = new ZosConnect();
    private ObservationRequestJob zosrequestjob;
    ObservationsEditor obseditor = new ObservationsEditor();
    public static final String ID = "com.banknet.core.ObservationsView";
    public static final String viewname = String.valueOf(CorePlugin.getDefault().productextension.getVendorName()) + " " + CorePlugin.getDefault().productextension.getProductName() + Messages.getString("ObservationsView.View.Name.ZosObservationListSST");
    private static final String observationsViewText = String.valueOf(CorePlugin.getDefault().productextension.getProductName()) + Messages.getString("ObservationsView.View.Name.ObservationsList");
    public static final int ASC = 1;
    public static final int NONE = 0;
    public static final int DESC = -1;
    public TreeViewer v;
    private Tree tree;
    private DrillDownAdapter drillDownAdapter;
    private TreeColumnLayout tableLayout;
    public String ACTION_FILTER = "FILTER";
    public String ACTION_SPM = "SPM";
    public String ACTION_REFRESH = "REFRESH";
    public String ACTION_DELREPORTS = "DELREPORTS";
    public String ACTION_SEARCH = "SEARCH";
    private ColumnSorter reqnumSorter;
    private ColumnSorter reportsSorter;
    private ColumnSorter ownedbySorter;
    private ColumnSorter descriptionSorter;
    private ColumnSorter jobnameSorter;
    private ColumnSorter datetimeSorter;
    private ColumnSorter samplesSorter;
    private ColumnSorter statusSorter;
    private ColumnSorter deletedaysSorter;
    private ColumnSorter systemSorter;
    private ColumnSorter durationSorter;
    public String reqaction = "";
    private Action newAction;
    private Action subAction;
    private Action tnewAction;
    private Action multinewAction;
    private Action modAction;
    private Action keepAction;
    private Action cragAction;
    private Action delAction;
    private Action trigAction;
    private Action cancelAction;
    private Action varianceReportsAction;
    private Action cicsMassReportsAction;
    private Action imsMassReportsAction;
    private Action db2ProcReportsAction;
    private Action downloadReportsAction;
    private Action downloadReportsAction2;
    private Action deleteReportsAction;
    private Action spmAction;
    private Action importAction;
    private Action exportAction;
    private Action downloadJsonAction;
    private Action downloadXmlAction;
    private Action downloadPdfAction;
    private Action stickyNotesAction;
    private Action treewalkAction;
    public Action clearSelectionsAction;
    private Action varianceXmlAction;
    private Action variancePdfAction;
    private Action cicsMassXmlAction;
    private Action cicsMassPdfAction;
    private Action imsMassXmlAction;
    private Action imsMassPdfAction;
    private Action treeReportsAction;
    private Action db2ProcXmlAction;
    private Action db2ProcPdfAction;
    public Action refreshAction;
    private Action filterAction;
    private Action searchAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    private static SimpleDateFormat yyyymmddhhmm = new SimpleDateFormat("yyyyMMdd HHmm");
    private String apaRequest;
    private String apaRequestTitle;
    private String apaParms;
    private Shell shell;
    private Integer reqnum = 0;
    ObservationDetail obsdetail;
    private List<ObservationDetail> obsdetails;
    private List<Integer> reqnums;
    private List<Integer> selreqnums;
    private List<String> tagstcids = new ArrayList<String>();
    private List<Integer> tagreqnums = new ArrayList<Integer>();
    private List<String> tagdsns = new ArrayList<String>();
    private int maxtag = 20;
    String expandedReqnums = "";
    int curreqnum = 0;
    public String rptformat = "";
    String[] expandArr;
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);
    private int keycode = 0;
    ObservationReports obsrpts;
    private ObservationsModel rptobs;
    private List<String> saveReportFnames = new ArrayList<String>();
    private List<ObservationsModel> selobservations = new ArrayList<ObservationsModel>();
    private List<ReportsModel> selreports = new ArrayList<ReportsModel>();
    private ReportsModel rptmodel;
    private static final String REPORTSMODEL_ELEMENTTYPE_CATEGORY = "category";
    private static final String REPORTSMODEL_ELEMENTTYPE_REPORT = "report";
    IViewPart viewpart = this;
    int rptmsgscnt = 0;
    String rptmsgs = "";
    String rptimsgs = "";
    ObservationsModel selrptobs;
    String reqtemplate = "";
    TreeColumn column;
    Composite composite;
    List<String> colprefs = Arrays.asList(CorePlugin.getDefault().getPreferenceStore().getString("obsListColumns").split(","));
    List<String> obscolsarr;
    String[] obscolstextarr;
    private final IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener;
    public IMenuCreator newMenuCreator;
    public IMenuCreator tnewMenuCreator;

    public ObservationsView() {
        this.obscolsarr = Arrays.asList(CorePlugin.getDefault().constants.OBSLIST_COLUMNS.split(","));
        this.obscolstextarr = CorePlugin.getDefault().constants.OBSLIST_COLTEXT.split(",");
        this.preferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (!event.getKey().equals("coreConnected")) {
                    if (event.getKey().equals("obsReports")) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                (this).ObservationsView.this.v.refresh();
                                ObservationsView.this.restoreExpandTree();
                            }
                        });
                    } else if (event.getKey().equals("stcViewSel")) {
                        ObservationsView.this.reqnum = 0;
                        ObservationsView.this.curreqnum = 0;
                        CorePlugin.getDefault().selobs = null;
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ObservationsView.this.refreshObs();
                            }
                        });
                    } else if (event.getKey().equals("focusReport") && CorePlugin.getDefault().getPreferenceStore().getString("focusReport").length() > 0) {
                        String[] focuskey = ObservationsView.this.s1.split(CorePlugin.getDefault().getPreferenceStore().getString("focusReport"), -1);
                        String focushoststcid = focuskey[0];
                        int focusreqnum = new Integer(focuskey[1]);
                        String focusrptid = focuskey[2];
                        if (focushoststcid.equals(CorePlugin.getDefault().activeStc) & focusreqnum != CorePlugin.getDefault().selobs.reqnum) {
                            ObservationsModel observation = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(focusreqnum));
                            ObservationsView.this.v.setSelection((ISelection)new StructuredSelection((Object)observation), true);
                            CorePlugin.getDefault().selobs = observation;
                            CorePlugin.getDefault().getPreferenceStore().setValue("reportObs", focusrptid);
                        }
                    }
                }
            }
        };
        this.newMenuCreator = new IMenuCreator(){
            private Menu menu;

            public void dispose() {
            }

            public Menu getMenu(Control parent) {
                if (this.menu != null) {
                    this.menu.dispose();
                }
                this.menu = new Menu(parent);
                MenuItem item = new MenuItem(this.menu, 32);
                item.setText(Messages.getString("ObservationsView.Action.New"));
                item.setToolTipText(Messages.getString("ObservationsView.Tooltip.New"));
                item.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_NEW_WIZARD").createImage());
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        (this).ObservationsView.this.reqaction = (this).ObservationsView.this.constants.ACTION_NEW;
                        ObservationsView.this.reqnum = 0;
                        ObservationsView.this.apaRequestTitle = ObservationsView.this.newAction.getText();
                        ObservationsView.this.runAction();
                    }
                });
                item.setEnabled(true);
                item = new MenuItem(this.menu, 32);
                item.setText(Messages.getString("ObservationsView.Action.TemplateNew"));
                item.setToolTipText(Messages.getString("ObservationsView.Tooltip.TemplateNew"));
                item.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_NEW_WIZARD").createImage());
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        (this).ObservationsView.this.reqaction = (this).ObservationsView.this.constants.ACTION_NEW;
                        ObservationsView.this.reqnum = 0;
                        ObservationsView.this.apaRequestTitle = Messages.getString("ObservationsView.Action.TemplateNew");
                        ObservationsView.this.loadTemplate();
                    }
                });
                item.setEnabled(true);
                return this.menu;
            }

            public Menu getMenu(Menu parent) {
                return this.menu;
            }
        };
        this.tnewMenuCreator = new IMenuCreator(){
            private Menu menu;

            public void dispose() {
            }

            public Menu getMenu(Control parent) {
                if (this.menu != null) {
                    this.menu.dispose();
                }
                this.menu = new Menu(parent);
                MenuItem item = new MenuItem(this.menu, 32);
                item.setText(Messages.getString("ObservationsView.Action.TNew"));
                item.setToolTipText(Messages.getString("ObservationsView.Tooltip.TNew"));
                item.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/tnew_wiz.gif").createImage());
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        (this).ObservationsView.this.reqaction = (this).ObservationsView.this.constants.ACTION_TNEW;
                        ObservationsView.this.reqnum = 0;
                        ObservationsView.this.apaRequestTitle = ObservationsView.this.tnewAction.getText();
                        int rc = (this).ObservationsView.this.obseditor.doRemoteEdit();
                        if (rc < 0) {
                            ObservationsView.this.showMessage((this).ObservationsView.this.obseditor.msgtype, ObservationsView.this.apaRequestTitle, (this).ObservationsView.this.obseditor.msgstr);
                            return;
                        }
                        ObservationsView.this.runAction();
                    }
                });
                item.setEnabled(true);
                item = new MenuItem(this.menu, 32);
                item.setText(Messages.getString("ObservationsView.Action.TemplateTNew"));
                item.setToolTipText(Messages.getString("ObservationsView.Tooltip.TemplateTNew"));
                item.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/tnew_wiz.gif").createImage());
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        (this).ObservationsView.this.reqaction = (this).ObservationsView.this.constants.ACTION_TNEW;
                        ObservationsView.this.reqnum = 0;
                        ObservationsView.this.apaRequestTitle = Messages.getString("ObservationsView.Action.TemplateTNew");
                        ObservationsView.this.loadTemplate();
                    }
                });
                item.setEnabled(true);
                return this.menu;
            }

            public Menu getMenu(Menu parent) {
                return this.menu;
            }
        };
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        CorePlugin.getDefault().connectionextension.createConnectionListener();
    }

    public void createPartControl(Composite parent) {
        IEclipsePreferences preferencesI = InstanceScope.INSTANCE.getNode("com.banknet.core");
        preferencesI.addPreferenceChangeListener(this.preferenceChangeListener);
        this.setPartName(String.valueOf(observationsViewText) + " (" + CorePlugin.getDefault().activeStc + ")");
        CorePlugin.getDefault().getPreferenceStore().setValue("coreConnected", false);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        this.tree = new Tree(composite, 68386);
        GridData gd = new GridData(4, 4, true, true);
        this.tree.setLayoutData((Object)gd);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(true);
        this.v = new TreeViewer(this.tree);
        this.shell = this.v.getControl().getShell();
        this.tableLayout = new TreeColumnLayout();
        composite.setLayout((Layout)this.tableLayout);
        int i = 0;
        while (i < this.colprefs.size()) {
            String colid = this.colprefs.get(i);
            int colidx = this.obscolsarr.indexOf(colid);
            this.addObsColumn(colidx, colid);
            ++i;
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.shell, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".views_ObservationsViewContext");
        this.setSortColumn();
        this.v.setLabelProvider((IBaseLabelProvider)new ObservationsViewLabelProvider());
        this.v.setContentProvider((IContentProvider)new ObservationsViewContentProvider());
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.v);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem treeitem = (TreeItem)e.item;
                ObservationsModel obsmodel = (ObservationsModel)treeitem.getData();
                if (treeitem.getChecked()) {
                    ObservationsView.this.doCheckedObs(treeitem);
                    ObservationsView.this.v.setSelection((ISelection)new StructuredSelection((Object)obsmodel), true);
                } else {
                    CorePlugin.getDefault().selobservations.remove((ObservationsModel)treeitem.getData());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.v.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                try {
                    IWorkbenchWindow window;
                    IWorkbenchPage page;
                    Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    if (obj != null) {
                        TreeItem[] selections = ObservationsView.this.v.getTree().getSelection();
                        if (ObservationsView.this.keycode == 131072 | ObservationsView.this.keycode == 262144) {
                            ObservationsView.this.clearSelectionsAction.run();
                        }
                        int i = 0;
                        while (i < selections.length) {
                            if (ObservationsView.this.keycode == 131072) {
                                if (!selections[i].getChecked()) {
                                    selections[i].setChecked(true);
                                    ObservationsView.this.doCheckedObs(selections[i]);
                                }
                            } else if (ObservationsView.this.keycode == 262144) {
                                selections[i].setChecked(true);
                                ObservationsView.this.doCheckedObs(selections[i]);
                            }
                            ++i;
                        }
                        ObservationsView.this.keycode = 0;
                        CorePlugin.getDefault().selobs = (ObservationsModel)obj;
                    }
                    if (!(page = (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()).getActivePage()).getActivePartReference().getId().equals("com.banknet.core.ReportTextView")) {
                        ObservationsView.this.activateObservationsView();
                    }
                }
                catch (Exception ex) {
                    System.out.println("ObservationsView, ISelectionListener ex " + ex);
                }
            }
        });
        if (CorePlugin.getDefault().getObservationsModel() != null) {
            this.v.setInput((Object)CorePlugin.getDefault().getObservationsModel());
        }
        this.drillDownAdapter = new DrillDownAdapter(this.v);
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        CorePlugin.getDefault().connectionextension.setConnectionStatus(this.getViewSite());
    }

    public String getPartProperty(String key) {
        String partkey = CorePlugin.getDefault().connectionextension.getConnectionPartKey(key);
        if (partkey.length() > 0) {
            return partkey;
        }
        return super.getPartProperty(key);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ObservationsView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.v.getControl());
        this.v.getControl().setMenu(menu);
        this.getSite().registerContextMenu("com.banknet.core.views.observationsview.context", menuMgr, (ISelectionProvider)this.v);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.clearSelectionsAction);
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.filterAction);
        manager.add((IAction)this.searchAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.newAction);
        manager.add((IAction)this.tnewAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.importAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        if (CorePlugin.getDefault().selobservations.size() <= 0) {
            return;
        }
        manager.add((IAction)this.downloadReportsAction);
        manager.add((IAction)this.treeReportsAction);
        manager.add((IContributionItem)new Separator("reportsgroup"));
        MenuManager reportsMenu = new MenuManager(Messages.getString("ObservationsView.Menu.Reports"), AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadReportsBlue.gif"), "reports");
        manager.appendToGroup("reportsgroup", (IContributionItem)reportsMenu);
        reportsMenu.add((IAction)this.varianceReportsAction);
        reportsMenu.add((IAction)this.cicsMassReportsAction);
        if (CorePlugin.getDefault().versionextension.chkObsViewAction(CorePlugin.getDefault().constants.ACTION_IMSMASS)) {
            reportsMenu.add((IAction)this.imsMassReportsAction);
        }
        if (CorePlugin.getDefault().versionextension.chkObsViewAction(CorePlugin.getDefault().constants.ACTION_DB2PROC)) {
            reportsMenu.add((IAction)this.db2ProcReportsAction);
        }
        reportsMenu.add((IContributionItem)new Separator());
        reportsMenu.add((IAction)this.deleteReportsAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.clearSelectionsAction);
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.subAction);
        manager.add((IAction)this.multinewAction);
        manager.add((IAction)this.trigAction);
        manager.add((IAction)this.modAction);
        manager.add((IAction)this.stickyNotesAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.exportAction);
        manager.add((IAction)this.keepAction);
        manager.add((IAction)this.cragAction);
        manager.add((IAction)this.delAction);
        manager.add((IAction)this.cancelAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.spmAction);
        manager.add((IContributionItem)new Separator("xmlgroup"));
        MenuManager xmlMenu = new MenuManager(Messages.getString("ObservationsView.Menu.Xml"), AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadXml.gif"), "xml");
        manager.appendToGroup("xmlgroup", (IContributionItem)xmlMenu);
        xmlMenu.add((IAction)this.downloadXmlAction);
        xmlMenu.add((IAction)this.varianceXmlAction);
        xmlMenu.add((IAction)this.cicsMassXmlAction);
        if (CorePlugin.getDefault().versionextension.chkObsViewAction(CorePlugin.getDefault().constants.ACTION_IMSMASS)) {
            xmlMenu.add((IAction)this.imsMassXmlAction);
        }
        if (CorePlugin.getDefault().versionextension.chkObsViewAction(CorePlugin.getDefault().constants.ACTION_DB2PROC)) {
            xmlMenu.add((IAction)this.db2ProcXmlAction);
        }
        manager.add((IContributionItem)new Separator("jsongroup"));
        MenuManager jsonMenu = new MenuManager(Messages.getString("ObservationsView.Menu.Json"), AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadJson.png"), "json");
        manager.appendToGroup("jsongroup", (IContributionItem)jsonMenu);
        jsonMenu.add((IAction)this.downloadJsonAction);
        manager.add((IContributionItem)new Separator("pdfgroup"));
        MenuManager pdfMenu = new MenuManager(Messages.getString("ObservationsView.Menu.Pdf"), AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadPdf.gif"), "pdf");
        manager.appendToGroup("pdfgroup", (IContributionItem)pdfMenu);
        pdfMenu.add((IAction)this.downloadPdfAction);
        pdfMenu.add((IAction)this.variancePdfAction);
        pdfMenu.add((IAction)this.cicsMassPdfAction);
        if (CorePlugin.getDefault().versionextension.chkObsViewAction(CorePlugin.getDefault().constants.ACTION_IMSMASS)) {
            pdfMenu.add((IAction)this.imsMassPdfAction);
        }
        if (CorePlugin.getDefault().versionextension.chkObsViewAction(CorePlugin.getDefault().constants.ACTION_DB2PROC)) {
            pdfMenu.add((IAction)this.db2ProcPdfAction);
        }
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.clearSelectionsAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshAction);
        manager.add((IAction)this.filterAction);
        manager.add((IAction)this.searchAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.newAction);
        manager.add((IAction)this.tnewAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.importAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.expandAllAction);
        manager.add((IAction)this.collapseAllAction);
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void hookDoubleClickAction() {
        this.v.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (CorePlugin.getDefault().getPreferenceStore().getBoolean("obsListDoubleClick")) {
                    ObservationsView.this.stickyNotesAction.run();
                }
            }
        });
    }

    private void makeActions() {
        this.newAction = new Action(){

            public void run() {
                int rc;
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_NEW;
                ObservationsView.this.reqnum = 0;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.newAction.getText();
                if (!CorePlugin.getDefault().testmode && (rc = ObservationsView.this.obseditor.doRemoteEdit()) < 0) {
                    ObservationsView.this.showMessage(ObservationsView.this.obseditor.msgtype, ObservationsView.this.apaRequestTitle, ObservationsView.this.obseditor.msgstr);
                    return;
                }
                ObservationsView.this.runAction();
            }
        };
        this.newAction.setText(Messages.getString("ObservationsView.Action.New"));
        this.newAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.New"));
        this.newAction.setDescription(Messages.getString("ObservationsView.Tooltip.New"));
        this.newAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.newAction.setMenuCreator(this.newMenuCreator);
        this.tnewAction = new Action(){

            public void run() {
                int rc;
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_TNEW;
                ObservationsView.this.reqnum = 0;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.tnewAction.getText();
                if (!CorePlugin.getDefault().testmode && (rc = ObservationsView.this.obseditor.doRemoteEdit()) < 0) {
                    ObservationsView.this.showMessage(ObservationsView.this.obseditor.msgtype, ObservationsView.this.apaRequestTitle, ObservationsView.this.obseditor.msgstr);
                    return;
                }
                ObservationsView.this.runAction();
            }
        };
        this.tnewAction.setText(Messages.getString("ObservationsView.Action.TNew"));
        this.tnewAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.TNew"));
        this.tnewAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/tnew_wiz.gif"));
        this.tnewAction.setMenuCreator(this.tnewMenuCreator);
        this.subAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_SUB;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.subAction.getText();
                int rc = ObservationsView.this.editSelections();
                if (rc <= 0) {
                    ObservationsView.this.runAction();
                }
            }
        };
        this.subAction.setText(Messages.getString("ObservationsView.Action.Sub"));
        this.subAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.Sub"));
        this.subAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.multinewAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_MULTINEW;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.multinewAction.getText();
                int rc = ObservationsView.this.editSelections();
                if (rc <= 0) {
                    ObservationsView.this.runAction();
                }
            }
        };
        this.multinewAction.setText(Messages.getString("ObservationsView.Action.New"));
        this.multinewAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.New"));
        this.multinewAction.setDescription(Messages.getString("ObservationsView.Tooltip.New"));
        this.multinewAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/new_wiz.gif"));
        this.modAction = new Action(){

            public void run() {
                int rc = 0;
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_MODIFY;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.modAction.getText();
                rc = ObservationsView.this.editSelections();
                if (rc <= 0) {
                    ObservationsView.this.runAction();
                }
            }
        };
        this.modAction.setText(Messages.getString("ObservationsView.Action.Mod"));
        this.modAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.Mod"));
        this.keepAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_KEEP;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.keepAction.getText();
                int rc = ObservationsView.this.editSelections();
                if (rc <= 0) {
                    ObservationsView.this.runAction();
                }
            }
        };
        this.keepAction.setText(Messages.getString("ObservationsView.Action.Keep"));
        this.keepAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.Keep"));
        this.cragAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_CRAG;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.cragAction.getText();
                int rc = ObservationsView.this.editSelections();
                if (rc <= 0) {
                    ObservationsView.this.runAction();
                }
            }
        };
        this.cragAction.setText(Messages.getString("ObservationsView.Action.Crag"));
        this.cragAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.Crag"));
        this.delAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_DELETE;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.delAction.getText();
                int rc = ObservationsView.this.editSelections();
                if (rc <= 0) {
                    ObservationsView.this.runAction();
                }
            }
        };
        this.delAction.setText(Messages.getString("ObservationsView.Action.Del"));
        this.delAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.Del"));
        this.delAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.trigAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_TRIGGER;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.trigAction.getText();
                int rc = ObservationsView.this.editSelections();
                if (rc <= 0) {
                    ObservationsView.this.runAction();
                }
            }
        };
        this.trigAction.setText(Messages.getString("ObservationsView.Action.Trig"));
        this.trigAction.setToolTipText(Messages.getString("ObservationsView.Action.Trig"));
        this.cancelAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_CANCEL;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.cancelAction.getText();
                int rc = ObservationsView.this.editSelections();
                if (rc <= 0) {
                    ObservationsView.this.runAction();
                }
            }
        };
        this.cancelAction.setText(Messages.getString("ObservationsView.Action.Cancel"));
        this.cancelAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.Cancel"));
        this.refreshAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.ACTION_REFRESH;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.refreshAction.getText();
                int rc = ObservationsView.this.editSelections();
                if (rc <= 0) {
                    ObservationsView.this.zosconnect.loadModelsJob();
                }
            }
        };
        this.refreshAction.setText(Messages.getString("ObservationsView.Action.Refresh"));
        this.refreshAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.Refresh"));
        this.refreshAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/refresh.gif"));
        this.downloadReportsAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_REPORTS;
                ObservationsView.this.rptformat = ObservationsView.this.constants.REPORT_FORMAT_PVML;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.downloadReportsAction.getText();
                ObservationsView.this.doReportingAction();
            }
        };
        this.downloadReportsAction.setText(Messages.getString("ObservationsView.Action.DownloadReports"));
        this.downloadReportsAction.setToolTipText(Messages.getString("ObservationsView.Action.DownloadReports"));
        this.downloadReportsAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadReportsBlue.gif"));
        this.downloadReportsAction2 = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_REPORTS;
                ObservationsView.this.rptformat = ObservationsView.this.constants.REPORT_FORMAT_PVML;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.downloadReportsAction.getText();
                ObservationsView.this.doReportingAction();
            }
        };
        this.downloadReportsAction2.setText(Messages.getString("ObservationsView.Action.DownloadReports"));
        this.downloadReportsAction2.setToolTipText(Messages.getString("ObservationsView.Action.DownloadReports"));
        this.downloadReportsAction2.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadReportsBlue.gif"));
        this.treeReportsAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_TREEREPORTS;
                ObservationsView.this.rptformat = ObservationsView.this.constants.REPORT_FORMAT_PVML;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.treeReportsAction.getText();
                ObservationsView.this.selectObsChildren();
                ObservationsView.this.doReportingAction();
            }
        };
        this.treeReportsAction.setText(Messages.getString("ObservationsView.Action.TreeReports"));
        this.treeReportsAction.setToolTipText(Messages.getString("ObservationsView.Action.TreeReports"));
        this.treeReportsAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadReportsBlue.gif"));
        this.varianceReportsAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_VARIANCE;
                ObservationsView.this.rptformat = ObservationsView.this.constants.REPORT_FORMAT_PVML;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.varianceReportsAction.getText();
                ObservationsView.this.doReportingAction();
            }
        };
        this.varianceReportsAction.setText(Messages.getString("ObservationsView.Action.VarianceReports"));
        this.varianceReportsAction.setToolTipText(Messages.getString("ObservationsView.Action.VarianceReports"));
        this.varianceReportsAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadReportsBlue.gif"));
        this.cicsMassReportsAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_CICSMASS;
                ObservationsView.this.rptformat = ObservationsView.this.constants.REPORT_FORMAT_PVML;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.cicsMassReportsAction.getText();
                ObservationsView.this.doReportingAction();
            }
        };
        this.cicsMassReportsAction.setText(Messages.getString("ObservationsView.Action.CicsMassReports"));
        this.cicsMassReportsAction.setToolTipText(Messages.getString("ObservationsView.Action.CicsMassReports"));
        this.cicsMassReportsAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadReportsBlue.gif"));
        this.imsMassReportsAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_IMSMASS;
                ObservationsView.this.rptformat = ObservationsView.this.constants.REPORT_FORMAT_PVML;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.imsMassReportsAction.getText();
                ObservationsView.this.doReportingAction();
            }
        };
        this.imsMassReportsAction.setText(Messages.getString("ObservationsView.Action.ImsMassReports"));
        this.imsMassReportsAction.setToolTipText(Messages.getString("ObservationsView.Action.ImsMassReports"));
        this.imsMassReportsAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadReportsBlue.gif"));
        this.db2ProcReportsAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_DB2PROC;
                ObservationsView.this.rptformat = ObservationsView.this.constants.REPORT_FORMAT_PVML;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.db2ProcReportsAction.getText();
                ObservationsView.this.doReportingAction();
            }
        };
        this.db2ProcReportsAction.setText(Messages.getString("ObservationsView.Action.Db2ProcReports"));
        this.db2ProcReportsAction.setToolTipText(Messages.getString("ObservationsView.Action.Db2ProcReports"));
        this.db2ProcReportsAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadReportsBlue.gif"));
        this.deleteReportsAction = new Action(){

            public void run() {
                new ArrayList();
                ObservationsView.this.reqaction = ObservationsView.this.ACTION_DELREPORTS;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.deleteReportsAction.getText();
                ObservationsView.this.v.setSelection((ISelection)new StructuredSelection((Object)CorePlugin.getDefault().selobservations.get(0)), true);
                DisposeReportsAction closerpts = new DisposeReportsAction(ObservationsView.this.viewpart);
                closerpts.run();
                ObservationsView.this.runDeleteObsReports();
            }
        };
        this.deleteReportsAction.setText(Messages.getString("ObservationsView.Action.DeleteReports"));
        this.deleteReportsAction.setToolTipText(Messages.getString("ObservationsView.Action.DeleteReports"));
        this.deleteReportsAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DeleteReports16x16.gif"));
        this.filterAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.ACTION_FILTER;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.filterAction.getText();
                int rc = ObservationsView.this.obseditor.doRemoteEdit();
                if (rc < 0) {
                    ObservationsView.this.showMessage(ObservationsView.this.obseditor.msgtype, ObservationsView.this.apaRequestTitle, ObservationsView.this.obseditor.msgstr);
                    return;
                }
                ObservationsFilterDialog filterdlg = new ObservationsFilterDialog(ObservationsView.this.getViewSite().getShell());
                int filterrc = filterdlg.open();
                if (filterrc == 0) {
                    ObservationsView.this.setSortColumn();
                    if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
                        ObservationsView.this.runRefresh();
                    } else {
                        ObservationsView.this.v.refresh();
                    }
                }
                ObservationsView.this.clearSelectionsAction.run();
            }
        };
        this.filterAction.setText(Messages.getString("ObservationsView.Action.Filter"));
        this.filterAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.Filter"));
        this.filterAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/elcl16/filter_ps.gif"));
        this.searchAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.ACTION_SEARCH;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.searchAction.getText();
                ObservationsSearchDialog dlg = new ObservationsSearchDialog(ObservationsView.this.getViewSite().getShell());
                dlg.open();
                ObservationsView.this.clearSelectionsAction.run();
            }
        };
        this.searchAction.setText(Messages.getString("ObservationsView.Action.Search"));
        this.searchAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.Search"));
        this.searchAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/search_src.gif"));
        this.expandAllAction = new Action(){

            public void run() {
                ObservationsView.this.v.expandAll();
            }
        };
        this.expandAllAction.setText(Messages.getString("ObservationsView.Action.ExpandAll"));
        this.expandAllAction.setToolTipText(Messages.getString("ObservationsView.Action.ExpandAll"));
        this.expandAllAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/elcl16/expandall.gif"));
        this.expandAllAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/dlcl16/expandseall.gif"));
        this.expandAllAction.setEnabled(true);
        this.collapseAllAction = new Action(){

            public void run() {
                ObservationsView.this.v.collapseAll();
            }
        };
        this.collapseAllAction.setText(Messages.getString("ObservationsView.Action.CollapseAll"));
        this.collapseAllAction.setToolTipText(Messages.getString("ObservationsView.Action.CollapseAll"));
        this.collapseAllAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/elcl16/collapseall.gif"));
        this.collapseAllAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/dlcl16/collapseall.gif"));
        this.collapseAllAction.setEnabled(true);
        this.spmAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.ACTION_SPM;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.spmAction.getText();
                int rc = ObservationsView.this.obseditor.doRemoteEdit();
                if (rc < 0) {
                    ObservationsView.this.showMessage(ObservationsView.this.obseditor.msgtype, ObservationsView.this.apaRequestTitle, ObservationsView.this.obseditor.msgstr);
                    return;
                }
                int i = 0;
                while (i < CorePlugin.getDefault().selobservations.size()) {
                    ObservationsModel obs = CorePlugin.getDefault().selobservations.get(i);
                    ObservationsView.this.v.setSelection((ISelection)new StructuredSelection((Object)obs), true);
                    SpmRepositoryDialog spm = new SpmRepositoryDialog(ObservationsView.this.v.getControl().getShell());
                    spm.open();
                    spm = null;
                    ++i;
                }
                ObservationsView.this.clearSelectionsAction.run();
            }
        };
        this.spmAction.setText(Messages.getString("ObservationsView.Action.SPM"));
        this.spmAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.SPM"));
        this.spmAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/eview16/history_view.gif"));
        this.importAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_IMPORT;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.importAction.getText();
                int rc = ObservationsView.this.obseditor.doRemoteEdit();
                if (rc < 0) {
                    ObservationsView.this.showMessage(ObservationsView.this.obseditor.msgtype, ObservationsView.this.apaRequestTitle, ObservationsView.this.obseditor.msgstr);
                    return;
                }
                ImportObservationDialog iod = new ImportObservationDialog(ObservationsView.this.v.getControl().getShell());
                int iodrc = iod.open();
                if (iodrc == 0) {
                    if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
                        ObservationsView.this.runObservationsJob();
                    }
                    iod = null;
                    ObservationsView.this.v.refresh();
                }
            }
        };
        this.importAction.setText(Messages.getString("ObservationsView.Action.Import"));
        this.importAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.Import"));
        this.importAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/import_wiz.gif"));
        this.importAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/dtool16/import_wiz.gif"));
        this.exportAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_EXPORT;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.exportAction.getText();
                int rc = ObservationsView.this.editSelections();
                if (rc <= 0) {
                    ObservationsView.this.runAction();
                }
            }
        };
        this.exportAction.setText(Messages.getString("ObservationsView.Action.Export"));
        this.exportAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.Export"));
        this.exportAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/etool16/export_wiz.gif"));
        this.exportAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/dtool16/export_wiz.gif"));
        this.downloadXmlAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_REPORTS;
                ObservationsView.this.rptformat = ObservationsView.this.constants.REPORT_FORMAT_XML;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.downloadXmlAction.getText();
                ObservationsView.this.doReportingAction();
            }
        };
        this.downloadXmlAction.setText(Messages.getString("ObservationsView.Action.DownloadXml"));
        this.downloadXmlAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.DownloadXml"));
        this.downloadXmlAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadXml.gif"));
        this.downloadJsonAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_REPORTS;
                ObservationsView.this.rptformat = ObservationsView.this.constants.REPORT_FORMAT_JSON;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.downloadJsonAction.getText();
                ObservationsView.this.doReportingAction();
            }
        };
        this.downloadJsonAction.setText(Messages.getString("ObservationsView.Action.DownloadJson"));
        this.downloadJsonAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.DownloadJson"));
        this.downloadJsonAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadJson.png"));
        this.downloadPdfAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_REPORTS;
                ObservationsView.this.rptformat = ObservationsView.this.constants.REPORT_FORMAT_PDF;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.downloadPdfAction.getText();
                ObservationsView.this.doReportingAction();
            }
        };
        this.downloadPdfAction.setText(Messages.getString("ObservationsView.Action.DownloadPdf"));
        this.downloadPdfAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.DownloadPdf"));
        this.downloadPdfAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadPdf.gif"));
        this.stickyNotesAction = new Action(){

            public void run() {
                new ArrayList();
                int i = 0;
                while (i < CorePlugin.getDefault().selobservations.size()) {
                    ObservationsModel obs = CorePlugin.getDefault().selobservations.get(i);
                    IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
                    CorePlugin.getDefault();
                    String reportPath = String.valueOf(new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + obs.reqnum + File.separator + Platform.getNL() + File.separator).getAbsolutePath()) + File.separator;
                    StickyNotesDialog snd = new StickyNotesDialog(ObservationsView.this.shell);
                    snd.notesPath = reportPath;
                    String sreqnum = CorePlugin.getDefault().constants.reqdecfmt.format(obs.reqnum);
                    snd.rpttitle = String.valueOf(sreqnum) + " (" + CorePlugin.getDefault().activeStc + ")";
                    snd.rptid = obs.reqnum.toString();
                    snd.open();
                    snd = null;
                    ++i;
                }
                ObservationsView.this.clearSelectionsAction.run();
                ObservationsView.this.runObservationsPing();
            }
        };
        this.stickyNotesAction.setText(Messages.getString("ObservationsView.Action.StickyNotes"));
        this.stickyNotesAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.StickyNotes"));
        this.stickyNotesAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/stickyNote.gif"));
        this.stickyNotesAction.setEnabled(true);
        this.treewalkAction = new Action(){

            public void run() {
                new ArrayList();
                TreeItem[] selections = ObservationsView.this.v.getTree().getSelection();
                int i = 0;
                while (i < selections.length) {
                    ObservationsModel obs = (ObservationsModel)selections[i].getData();
                    System.out.println("parent is : " + obs.reqnum + ", link is  , level is " + 0);
                    ObservationsView.this.walkTree(obs.reqnum, 1);
                    ++i;
                }
            }
        };
        this.treewalkAction.setText("Walk Tree");
        this.treewalkAction.setToolTipText("Walk Tree");
        this.clearSelectionsAction = new Action(){

            public void run() {
                ObservationsView.this.clearSelections(ObservationsView.this.tree.getItems());
                CorePlugin.getDefault().selobservations = null;
                CorePlugin.getDefault().selobservations = new ArrayList<ObservationsModel>();
            }
        };
        this.clearSelectionsAction.setText(Messages.getString("ObservationsView.Action.ClearSelections"));
        this.clearSelectionsAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.ClearSelections"));
        this.clearSelectionsAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/checkbox_checked.gif"));
        this.varianceXmlAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_VARIANCE;
                ObservationsView.this.rptformat = ObservationsView.this.constants.REPORT_FORMAT_XML;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.varianceXmlAction.getText();
                ObservationsView.this.doReportingAction();
            }
        };
        this.varianceXmlAction.setText(Messages.getString("ObservationsView.Action.VarianceXml"));
        this.varianceXmlAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.VarianceXml"));
        this.varianceXmlAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadXml.gif"));
        this.variancePdfAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_VARIANCE;
                ObservationsView.this.rptformat = ObservationsView.this.constants.REPORT_FORMAT_PDF;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.variancePdfAction.getText();
                ObservationsView.this.doReportingAction();
            }
        };
        this.variancePdfAction.setText(Messages.getString("ObservationsView.Action.VariancePdf"));
        this.variancePdfAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.VariancePdf"));
        this.variancePdfAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadPdf.gif"));
        this.cicsMassXmlAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_CICSMASS;
                ObservationsView.this.rptformat = ObservationsView.this.constants.REPORT_FORMAT_XML;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.cicsMassXmlAction.getText();
                ObservationsView.this.doReportingAction();
            }
        };
        this.cicsMassXmlAction.setText(Messages.getString("ObservationsView.Action.CicsMassXml"));
        this.cicsMassXmlAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.CicsMassXml"));
        this.cicsMassXmlAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadXml.gif"));
        this.cicsMassPdfAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_CICSMASS;
                ObservationsView.this.rptformat = ObservationsView.this.constants.REPORT_FORMAT_PDF;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.cicsMassPdfAction.getText();
                ObservationsView.this.doReportingAction();
            }
        };
        this.cicsMassPdfAction.setText(Messages.getString("ObservationsView.Action.CicsMassPdf"));
        this.cicsMassPdfAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.CicsMassPdf"));
        this.cicsMassPdfAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadPdf.gif"));
        this.imsMassXmlAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_IMSMASS;
                ObservationsView.this.rptformat = ObservationsView.this.constants.REPORT_FORMAT_XML;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.imsMassXmlAction.getText();
                ObservationsView.this.doReportingAction();
            }
        };
        this.imsMassXmlAction.setText(Messages.getString("ObservationsView.Action.ImsMassXml"));
        this.imsMassXmlAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.ImsMassXml"));
        this.imsMassXmlAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadXml.gif"));
        this.imsMassPdfAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_IMSMASS;
                ObservationsView.this.rptformat = ObservationsView.this.constants.REPORT_FORMAT_PDF;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.imsMassPdfAction.getText();
                ObservationsView.this.doReportingAction();
            }
        };
        this.imsMassPdfAction.setText(Messages.getString("ObservationsView.Action.ImsMassPdf"));
        this.imsMassPdfAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.ImsMassPdf"));
        this.imsMassPdfAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadPdf.gif"));
        this.db2ProcXmlAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_DB2PROC;
                ObservationsView.this.rptformat = ObservationsView.this.constants.REPORT_FORMAT_XML;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.db2ProcXmlAction.getText();
                ObservationsView.this.doReportingAction();
            }
        };
        this.db2ProcXmlAction.setText(Messages.getString("ObservationsView.Action.Db2ProcXml"));
        this.db2ProcXmlAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.Db2ProcXml"));
        this.db2ProcXmlAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadXml.gif"));
        this.db2ProcPdfAction = new Action(){

            public void run() {
                ObservationsView.this.reqaction = ObservationsView.this.constants.ACTION_DB2PROC;
                ObservationsView.this.rptformat = ObservationsView.this.constants.REPORT_FORMAT_PDF;
                ObservationsView.this.apaRequestTitle = ObservationsView.this.db2ProcPdfAction.getText();
                ObservationsView.this.doReportingAction();
            }
        };
        this.db2ProcPdfAction.setText(Messages.getString("ObservationsView.Action.Db2ProcPdf"));
        this.db2ProcPdfAction.setToolTipText(Messages.getString("ObservationsView.Tooltip.Db2ProcPdf"));
        this.db2ProcPdfAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/DownloadPdf.gif"));
    }

    private void walkTree(int req, int level) {
        ObservationsModel obs = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(req));
        List<ObservationsModel> obschildren = obs.getChildren();
        int i = 0;
        while (i < obschildren.size()) {
            ObservationsModel obschild = obschildren.get(i);
            System.out.println("child is : " + obschild.reqnum + ", link is " + obschild.reqlink + ", level is " + level);
            if (obschild.getChildren().size() > 0) {
                this.walkTree(obschild.reqnum, level + 1);
            }
            ++i;
        }
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.v.getControl().getShell(), (String)(String.valueOf(observationsViewText) + " (" + CorePlugin.getDefault().activeStc + ")"), (String)message);
    }

    private void showMessage(String title, String message) {
        MessageDialog.openInformation((Shell)this.v.getControl().getShell(), (String)title, (String)message);
    }

    public void setFocus() {
        try {
            if (this.getSite().getPage().getActivePart() != null && this.getSite().getPage().findView(ID) != null) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.shell, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".views_ObservationsViewContext");
                if (!this.getSite().getPage().getActivePart().getSite().getId().contains("com.ibm") & this.getSite().getPage().findView("com.banknet.core.ReportsView") == null) {
                    this.getSite().getPage().showView("com.banknet.core.ReportsView");
                }
                if (!this.getSite().getPage().getActivePart().getSite().getId().contains("com.ibm") && this.getSite().getPage().findView("com.banknet.core.ObservationView") == null) {
                    this.getSite().getPage().showView("com.banknet.core.ObservationView");
                    this.getSite().getPage().showView("com.banknet.core.ReportsView");
                }
            }
        }
        catch (Exception ex) {
            System.out.println("setFocus ex " + ex);
        }
    }

    public void dispose() {
        IEclipsePreferences preferencesI = InstanceScope.INSTANCE.getNode("com.banknet.core");
        preferencesI.removePreferenceChangeListener(this.preferenceChangeListener);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        String partname = part.toString().toLowerCase();
        if (part.toString().indexOf("ReportTextView") <= 0 && partname.indexOf("banknet") > 0 && part != this) {
            if (!selection.isEmpty()) {
                if (part.toString().indexOf("ObservationsSearchView") > 0) {
                    try {
                        Object obj = ((IStructuredSelection)selection).getFirstElement();
                        int ireqnum = ((ObservationsSearchItem)obj).reqnum;
                        ObservationsModel observation = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(ireqnum));
                        this.v.setSelection((ISelection)new StructuredSelection((Object)observation), true);
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        page.activate(part);
                    }
                    catch (Exception exception) {}
                }
            } else if (CorePlugin.getDefault().getObservationsModel() == null) {
                this.runObservationsJob();
            } else if (!this.v.getControl().isDisposed()) {
                this.v.setInput((Object)CorePlugin.getDefault().getObservationsModel());
            }
        }
    }

    public void runObservationsPing() {
        Job job0 = new Job(Messages.getString("ObservationsView.Job.Title.Ping")){

            public IStatus run(IProgressMonitor monitor) {
                if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
                    monitor.beginTask(Messages.getString("ObservationsView.Job.Task.Ping"), 100);
                    ObservationsView.this.zosconnect.pingZos(monitor);
                    monitor.done();
                    if (ObservationsView.this.zosconnect.getConnectRc() != 0) {
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job0.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Job completed successfully");
                } else {
                    System.out.println("Job did not complete successfully");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("Observations ping rc is " + (this).ObservationsView.this.zosconnect.getConnectRc());
                        if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("local") == 0) {
                            ObservationsView.this.runObservationsJob();
                        } else if ((this).ObservationsView.this.zosconnect.getConnectRc() == 0) {
                            ObservationsView.this.runObservationsJob();
                        } else {
                            ObservationsView.this.showMessage(String.valueOf(Messages.getString("ObservationsView.MessageDialog.infoTitle.Zos")) + CorePlugin.getDefault().productextension.getProductName() + Messages.getString("ObservationsView.MessageDialog.infoMessage.ConnectionLost"), String.valueOf(Messages.getString("ObservationsView.MessageDialog.infoMessage.RemoteConnectionLost")) + Messages.getString("ObservationsView.MessageDialog.infoMessage.ReConnect"));
                            (this).ObservationsView.this.zosconnect.setConnectLocal();
                        }
                    }
                });
            }
        });
        job0.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job0.schedule();
    }

    public void runObservationsJob() {
        Job job = new Job(Messages.getString("ObservationsView.Job.Title.LoadingObservations")){

            public IStatus run(IProgressMonitor monitor) {
                System.out.println("started observations download");
                CorePlugin.getDefault().getObservationsModel(monitor);
                monitor.done();
                System.out.println("completed observations download");
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("ObservationsJob completed successfully");
                } else {
                    System.out.println("ObservationsJob did not complete successfully");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).ObservationsView.this.v.getControl().isDisposed() && CorePlugin.getDefault().session != null) {
                            if (CorePlugin.getDefault().session.getReturnCode() == 0) {
                                ObservationsView.this.updatePartName();
                                ObservationsView.this.reqnum = 0;
                                if ((this).ObservationsView.this.v.getInput() != null) {
                                    ObservationsView.this.storeExpandTree();
                                }
                                if (CorePlugin.getDefault().getObservationsModel() == null) {
                                    (this).ObservationsView.this.v.setInput(null);
                                } else {
                                    if (CorePlugin.getDefault().selobs != null) {
                                        ObservationsView.this.reqnum = CorePlugin.getDefault().selobs.reqnum;
                                    }
                                    (this).ObservationsView.this.v.setInput((Object)CorePlugin.getDefault().getObservationsModel());
                                }
                                ObservationsView.this.getViewSite().getActionBars().getStatusLineManager().setMessage(ObservationsView.this.getTotalStatus());
                                TreeItem[] obsitems = (this).ObservationsView.this.v.getTree().getItems();
                                if (obsitems.length > 0) {
                                    if (ObservationsView.this.reqnum <= 0 || CorePlugin.getDefault().observationId.indexOf(ObservationsView.this.reqnum) < 0) {
                                        ObservationsView.this.reqnum = new Integer(((ObservationsModel)obsitems[0].getData()).reqnum);
                                    }
                                    try {
                                        ObservationsModel observation = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(ObservationsView.this.reqnum));
                                        (this).ObservationsView.this.v.setSelection((ISelection)new StructuredSelection((Object)observation), true);
                                        CorePlugin.getDefault().selobs = observation;
                                        CorePlugin.getDefault().getPreferenceStore().setValue("initDetail", "ObservationDetail");
                                    }
                                    catch (Exception exception) {}
                                }
                            } else {
                                ObservationsView.this.updatePartName();
                                (this).ObservationsView.this.v.setInput((Object)CorePlugin.getDefault().getObservationsModel());
                                ObservationsView.this.showMessage(String.valueOf(Messages.getString("ObservationsView.MessageDialog.infoMessage.GetObservationsFailed")) + CorePlugin.getDefault().session.getReason());
                                CorePlugin.getDefault().session.returnCode = 0;
                                CorePlugin.getDefault().session.reasonCode = 0;
                            }
                        }
                        if ((this).ObservationsView.this.v.getInput() != null) {
                            ObservationsView.this.restoreExpandTree();
                        }
                        ObservationsView.this.updTagObservation();
                        CorePlugin.getDefault().getPreferenceStore().setValue("obsLoaded", true);
                    }
                });
            }
        });
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
    }

    private void setSortColumn() {
        if (CorePlugin.getDefault().getPreferenceStore().getString("sortSeq").equalsIgnoreCase(this.pconstants.SORTSEQ_REQNUM)) {
            this.reqnumSorter.setSorter(this.reqnumSorter, -1);
        } else if (CorePlugin.getDefault().getPreferenceStore().getString("sortSeq").equalsIgnoreCase(this.pconstants.SORTSEQ_REPORTS)) {
            this.reportsSorter.setSorter(this.reportsSorter, -1);
        } else if (CorePlugin.getDefault().getPreferenceStore().getString("sortSeq").equalsIgnoreCase(this.pconstants.SORTSEQ_OWNEDBY)) {
            this.ownedbySorter.setSorter(this.ownedbySorter, 1);
        } else if (CorePlugin.getDefault().getPreferenceStore().getString("sortSeq").equalsIgnoreCase(this.pconstants.SORTSEQ_DESCRIPTION)) {
            this.descriptionSorter.setSorter(this.descriptionSorter, 1);
        } else if (CorePlugin.getDefault().getPreferenceStore().getString("sortSeq").equalsIgnoreCase(this.pconstants.SORTSEQ_JOBNAME)) {
            this.jobnameSorter.setSorter(this.jobnameSorter, 1);
        } else if (CorePlugin.getDefault().getPreferenceStore().getString("sortSeq").equalsIgnoreCase(this.pconstants.SORTSEQ_DATETIME)) {
            this.datetimeSorter.setSorter(this.datetimeSorter, -1);
        } else if (CorePlugin.getDefault().getPreferenceStore().getString("sortSeq").equalsIgnoreCase(this.pconstants.SORTSEQ_SAMPLES)) {
            this.samplesSorter.setSorter(this.samplesSorter, 1);
        } else if (CorePlugin.getDefault().getPreferenceStore().getString("sortSeq").equalsIgnoreCase(this.pconstants.SORTSEQ_STATUS)) {
            this.statusSorter.setSorter(this.statusSorter, 1);
        } else if (CorePlugin.getDefault().getPreferenceStore().getString("sortSeq").equalsIgnoreCase(this.pconstants.SORTSEQ_DELDAYS)) {
            this.deletedaysSorter.setSorter(this.deletedaysSorter, 1);
        } else if (CorePlugin.getDefault().getPreferenceStore().getString("sortSeq").equalsIgnoreCase(this.pconstants.SORTSEQ_SYSTEM)) {
            this.systemSorter.setSorter(this.systemSorter, 1);
        } else if (CorePlugin.getDefault().getPreferenceStore().getString("sortSeq").equalsIgnoreCase(this.pconstants.SORTSEQ_DURATION)) {
            this.durationSorter.setSorter(this.durationSorter, 1);
        } else {
            this.datetimeSorter.setSorter(this.datetimeSorter, -1);
        }
    }

    private void activateObservationsView() {
        int selreqnum = 0;
        if (CorePlugin.getDefault().selobs != null) {
            selreqnum = CorePlugin.getDefault().selobs.reqnum;
        }
        if (this.curreqnum != selreqnum) {
            this.curreqnum = selreqnum;
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            page.activate((IWorkbenchPart)this.getSite().getPage().findView(ID));
        }
    }

    private String getTotalStatus() {
        String totalStatus = Messages.getString("ObservationsView.StatusLine.Filter");
        String ownedByFilter = "";
        String jobNameFilter = "";
        if (!CorePlugin.getDefault().getPreferenceStore().getString("filterOwnedby").equals("*")) {
            ownedByFilter = String.valueOf(Messages.getString("ObservationsView.StatusLine.OwnedBy")) + CorePlugin.getDefault().getPreferenceStore().getString("filterOwnedby");
        }
        if (!CorePlugin.getDefault().getPreferenceStore().getString("filterJobname").equals("*")) {
            jobNameFilter = String.valueOf(Messages.getString("ObservationsView.StatusLine.JobName")) + CorePlugin.getDefault().getPreferenceStore().getString("filterJobname");
        }
        if (ownedByFilter.length() == 0 && jobNameFilter.length() == 0) {
            totalStatus = String.valueOf(totalStatus) + "*";
        } else {
            ownedByFilter = String.valueOf(Messages.getString("ObservationsView.StatusLine.OwnedBy")) + CorePlugin.getDefault().getPreferenceStore().getString("filterOwnedby");
            jobNameFilter = String.valueOf(Messages.getString("ObservationsView.StatusLine.JobName")) + CorePlugin.getDefault().getPreferenceStore().getString("filterJobname");
            totalStatus = String.valueOf(totalStatus) + ownedByFilter + ", " + jobNameFilter;
        }
        totalStatus = String.valueOf(totalStatus) + ")  -  " + CorePlugin.getDefault().getTotalObservations() + Messages.getString("ObservationsView.StatusLine.Observations");
        return totalStatus;
    }

    private void updatePartName() {
        String loc = "";
        loc = CorePlugin.getDefault().getPreferenceStore().getString("dataSource").equalsIgnoreCase("remote") ? Messages.getString("ObservationsView.View.Name.Remote") : Messages.getString("ObservationsView.View.Name.Local");
        this.setPartName(String.valueOf(observationsViewText) + " (" + CorePlugin.getDefault().activeStc + ")" + " - " + loc);
    }

    public void runRefresh() {
        Job job0 = new Job(Messages.getString("ObservationsView.Job.Title.RefreshObservations")){

            public IStatus run(IProgressMonitor monitor) {
                if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
                    monitor.beginTask(Messages.getString("ObservationsView.Job.Task.RefreshObservations"), 100);
                    ObservationsView.this.zosconnect.pingZos(monitor);
                    monitor.done();
                    if (ObservationsView.this.zosconnect.getConnectRc() != 0) {
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job0.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Job completed successfully");
                } else {
                    System.out.println("Job did not complete successfully");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("Refresh ping rc is " + (this).ObservationsView.this.zosconnect.getConnectRc());
                        if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("local") == 0) {
                            (this).ObservationsView.this.v.refresh();
                            CorePlugin.getDefault().getPreferenceStore().setValue("stcRefresh", true);
                        } else if ((this).ObservationsView.this.zosconnect.getConnectRc() == 0) {
                            ObservationsView.this.runObservationsJob();
                            CorePlugin.getDefault().getPreferenceStore().setValue("stcRefresh", true);
                        } else {
                            ObservationsView.this.showMessage(String.valueOf(Messages.getString("ObservationsView.MessageDialog.infoTitle.Zos")) + CorePlugin.getDefault().productextension.getProductName() + Messages.getString("ObservationsView.MessageDialog.infoMessage.ConnectionLost"), String.valueOf(Messages.getString("ObservationsView.MessageDialog.infoMessage.RemoteConnectionLost")) + Messages.getString("ObservationsView.MessageDialog.infoMessage.ReConnect"));
                            (this).ObservationsView.this.zosconnect.setConnectLocal();
                        }
                    }
                });
            }
        });
        job0.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job0.schedule();
    }

    public void runAction() {
        Job job0 = new Job(Messages.getString("ObservationsView.Job.Title.Ping")){

            public IStatus run(IProgressMonitor monitor) {
                ObservationsView.this.apaParms = CorePlugin.getDefault().session.commandLine;
                if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
                    monitor.beginTask(Messages.getString("ObservationsView.Job.Task.Ping2"), 100);
                    System.out.println("Ping");
                    ObservationsView.this.zosconnect.pingZos(monitor);
                    monitor.done();
                    if (ObservationsView.this.zosconnect.getConnectRc() != 0) {
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job0.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("Job completed successfully");
                } else {
                    System.out.println("Job did not complete successfully");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("Request ping rc is " + (this).ObservationsView.this.zosconnect.getConnectRc());
                        boolean runRequestJob = false;
                        if ((this).ObservationsView.this.zosconnect.getConnectRc() == 0) {
                            runRequestJob = true;
                        } else {
                            ObservationsView.this.showMessage(String.valueOf(Messages.getString("ObservationsView.MessageDialog.infoTitle.Zos")) + CorePlugin.getDefault().productextension.getProductName() + Messages.getString("ObservationsView.MessageDialog.infoMessage.ConnectionLost"), String.valueOf(Messages.getString("ObservationsView.MessageDialog.infoMessage.RemoteConnectionLost")) + Messages.getString("ObservationsView.MessageDialog.infoMessage.ReConnect"));
                            (this).ObservationsView.this.zosconnect.setConnectLocal();
                        }
                        if (runRequestJob) {
                            ObservationsView.this.obsdetails = new ArrayList();
                            ObservationsView.this.reqnums = new ArrayList();
                            ObservationsView.this.selreqnums = new ArrayList();
                            if ((this).ObservationsView.this.reqaction.equalsIgnoreCase((this).ObservationsView.this.constants.ACTION_NEW) | (this).ObservationsView.this.reqaction.equalsIgnoreCase((this).ObservationsView.this.constants.ACTION_TNEW)) {
                                ObservationsView.this.reqnum = 0;
                            }
                            if (ObservationsView.this.reqnum == 0) {
                                ObservationsView.this.selreqnums.add(ObservationsView.this.reqnum);
                            } else {
                                int i = 0;
                                while (i < CorePlugin.getDefault().selobservations.size()) {
                                    ObservationsView.this.selreqnums.add(CorePlugin.getDefault().selobservations.get((int)i).reqnum);
                                    ++i;
                                }
                            }
                            ObservationsView.this.runObservationDetail();
                        }
                    }
                });
            }
        });
        job0.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job0.schedule();
    }

    public void runObservationDetail() {
        String tmpaction = this.reqaction.replace("TMODIFY", "MODIFY");
        final String statusaction = tmpaction.replace("MULTINEW", "NEW");
        Job job0 = new Job(String.valueOf(statusaction) + Messages.getString("ObservationsView.Job.Title.ActionRequest")){

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(String.valueOf(statusaction) + " ...", 100);
                monitor.subTask(Messages.getString("ObservationsView.Job.SubTask.StcProperties"));
                CorePlugin.getDefault().getStcProperties(monitor);
                if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                    return Status.CANCEL_STATUS;
                }
                monitor.subTask(String.valueOf(Messages.getString("ObservationsView.Job.SubTask.Do")) + statusaction);
                try {
                    int i = 0;
                    while (i < ObservationsView.this.selreqnums.size()) {
                        ObservationsView.this.reqnum = (Integer)ObservationsView.this.selreqnums.get(i);
                        ObservationDetail obsdetail = new ObservationDetail();
                        obsdetail.getObservationDetail(ObservationsView.this.reqnum, monitor);
                        if (ObservationsView.this.zosconnect.getConnectRc() != 0) {
                            return Status.CANCEL_STATUS;
                        }
                        System.out.println("in runObservationDetail, reqnum is " + ObservationsView.this.reqnum);
                        ObservationsView.this.obsdetails.add(obsdetail);
                        ObservationsView.this.reqnums.add(ObservationsView.this.reqnum);
                        ++i;
                    }
                }
                catch (Exception ex) {
                    String logstr = "runObservationDetail: job exception. " + ex;
                    System.out.println("ObservationsView " + logstr);
                    CorePlugin.getDefault().log.error(logstr);
                }
                monitor.worked(20);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job0.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("runObservationDetail job completed successfully");
                } else {
                    System.out.println("runObservationDetail job did not complete successfully");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (CorePlugin.getDefault().session.getReturnCode() == 0) {
                            ObservationsView.this.doApaRequest();
                        } else {
                            ObservationsView.this.updatePartName();
                            (this).ObservationsView.this.v.setInput((Object)CorePlugin.getDefault().getObservationsModel());
                            ObservationsView.this.showMessage(String.valueOf(Messages.getString("ObservationsView.MessageDialog.infoMessage.JobFailedDownloadingObservations")) + CorePlugin.getDefault().session.getReason());
                        }
                    }
                });
            }
        });
        job0.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job0.schedule();
    }

    private void doApaRequest() {
        int i = 0;
        while (i < this.obsdetails.size()) {
            ObservationDetail obsdetail = this.obsdetails.get(i);
            boolean runaparequest = this.doAction(obsdetail);
            if (runaparequest && CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
                ObservationsModel obs = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(new Integer(this.reqnum)));
                if (!this.reqaction.equals(this.constants.ACTION_EXPORT)) {
                    String logstr = "runObservationDetail: Run apa request for " + this.reqnum;
                    System.out.println("ObservationsView " + logstr);
                    CorePlugin.getDefault().log.debug(logstr);
                    this.zosrequestjob = new ObservationRequestJob(this.shell);
                    this.zosrequestjob.reqnum = this.reqnum;
                    this.zosrequestjob.apaParms = this.apaParms;
                    this.zosrequestjob.apaRequest = this.apaRequest;
                    this.zosrequestjob.apaRequestTitle = this.apaRequestTitle;
                    this.zosrequestjob.ownedby = obsdetail.pme_userid;
                    this.zosrequestjob.validateSystem = obs.validateSystem;
                    this.zosrequestjob.runObservationRequestJob();
                }
            }
            ++i;
        }
        if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0) {
            this.runObservationsJob();
        }
    }

    private boolean doAction(ObservationDetail obsdetail) {
        Object dlg;
        boolean runaparequest = false;
        this.reqnum = obsdetail.getReqnum();
        String sreqnum = CorePlugin.getDefault().constants.reqdecfmt.format(this.reqnum);
        if (this.reqaction.equals(this.constants.ACTION_MULTINEW)) {
            this.reqaction = obsdetail.pme_variant.equals("T") ? this.constants.ACTION_TNEW : this.constants.ACTION_NEW;
            this.apaRequest = this.reqaction;
        } else if (this.reqaction.equals(this.constants.ACTION_SUB) | this.reqaction.equals(this.constants.ACTION_TRIGGER)) {
            this.apaRequest = this.constants.ACTION_NEW;
            if (obsdetail.pme_variant.equals("T") & this.reqaction.equals(this.constants.ACTION_SUB)) {
                this.apaRequest = this.constants.ACTION_TNEW;
            }
        } else if (this.reqaction.equals(this.constants.ACTION_MODIFY)) {
            this.apaRequest = this.constants.ACTION_MODIFY;
            if (obsdetail.pme_variant.equals("T")) {
                this.reqaction = this.constants.ACTION_TMODIFY;
            }
            if (obsdetail.pme_variant.equals("X")) {
                this.reqaction = this.constants.ACTION_TRIGMODIFY;
            }
        } else {
            this.apaRequest = this.reqaction;
        }
        runaparequest = this.editAction(obsdetail);
        if (!runaparequest) {
            return runaparequest;
        }
        if (this.reqaction.equals(this.constants.ACTION_SUB)) {
            this.apaParms = obsdetail.getCommandLine();
        } else if (this.reqaction.equals(this.constants.ACTION_KEEP) | this.reqaction.equals(this.constants.ACTION_CRAG) | this.reqaction.equals(this.constants.ACTION_DELETE) | this.reqaction.equals(this.constants.ACTION_CANCEL)) {
            this.apaParms = "REQNUM=" + this.reqnum;
        } else if (this.reqaction.equals(this.constants.ACTION_EXPORT)) {
            dlg = new ExportObservationDialog(this.getViewSite().getShell(), this.reqnum);
            dlg.open();
            runaparequest = false;
        } else if (this.reqaction.equals(this.constants.ACTION_MODIFYDESC)) {
            ModifyDescriptionDialog moddescdlg = new ModifyDescriptionDialog(this.getViewSite().getShell(), this.reqnum);
            moddescdlg.open();
            runaparequest = false;
        } else {
            dlg = new NewObservationDialog(this.shell, this.reqaction, this.apaRequest, obsdetail);
            ((NewObservationDialog)((Object)dlg)).apaRequestTitle = this.apaRequestTitle;
            int rc = dlg.open();
            runaparequest = rc == 0 && CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") >= 0 ? false : false;
        }
        if (this.reqaction.equals(this.constants.ACTION_DELETE)) {
            ObservationsModel observation = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(this.reqnum));
            int modelsize = observation.getChildren().size();
            String delmsg = String.valueOf(Messages.getString("ObservationsView.ConfirmDialog.ConfirmMessage.DeleteObservation")) + sreqnum + " ?";
            if (modelsize > 0) {
                delmsg = String.valueOf(Messages.getString("ObservationsView.ConfirmDialog.ConfirmMessage.Observation")) + sreqnum + Messages.getString("ObservationsView.ConfirmDialog.ConfirmMessage.RequestList");
            }
            runaparequest = CorePlugin.getDefault().getPreferenceStore().getBoolean("confirmDelete") | modelsize > 0 ? MessageDialog.openConfirm((Shell)this.v.getControl().getShell(), (String)Messages.getString("ObservationsView.ConfirmDialog.ConfirmTitle.DeleteRequest"), (String)delmsg) : true;
        }
        return runaparequest;
    }

    private boolean editAction(ObservationDetail obsdetail) {
        ObservationsModel observation;
        boolean isValid = true;
        String msg = String.valueOf(this.apaRequestTitle) + Messages.getString("ObservationsView.MessageDialog.errorTitle.ForRequest") + this.reqnum;
        if (this.reqaction.equals(this.constants.ACTION_SUB)) {
            if (obsdetail.pme_variant.equals("M") & obsdetail.pme_m_schdarrctr != null && obsdetail.pme_m_schdarrctr > 0) {
                int rsncode = 1;
                String errmsg = this.utilities.getErrorMessage(rsncode, "core_context_rsn_");
                this.showMessage(this.apaRequestTitle, String.valueOf(msg) + Messages.getString("ObservationsView.MessageDialog.errorMessage.Failed") + errmsg);
                String logstr = "editAction: " + msg + " failed. " + errmsg;
                System.out.println("ObservationsView " + logstr);
                CorePlugin.getDefault().log.debug(logstr);
                isValid = false;
            }
        } else if (this.reqaction.equals(this.constants.ACTION_TRIGGER)) {
            ObservationsModel observation2 = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(this.reqnum));
            if (!observation2.getStatusCode().equalsIgnoreCase("N")) {
                int rsncode = 2;
                String errmsg = this.utilities.getErrorMessage(rsncode, "core_context_rsn_");
                this.showMessage(this.apaRequestTitle, String.valueOf(msg) + " failed. \n\n" + errmsg);
                String logstr = "editAction: " + msg + " failed. " + errmsg;
                System.out.println("ObservationsView " + logstr);
                CorePlugin.getDefault().log.debug(logstr);
                isValid = false;
            }
        } else if (this.reqaction.equals(this.constants.ACTION_MODIFY) | this.reqaction.equals(this.constants.ACTION_TMODIFY) && !(observation = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(this.reqnum))).getStatusCode().equalsIgnoreCase("N")) {
            this.reqaction = this.constants.ACTION_MODIFYDESC;
        }
        return isValid;
    }

    private void storeExpandTree() {
        this.expandedReqnums = "";
        TreeItem[] obsitems = this.v.getTree().getItems();
        int i = 0;
        while (i < obsitems.length) {
            this.storeExpandItem(obsitems[i]);
            if (obsitems[i].getItemCount() > 0) {
                TreeItem[] obsitemsc = obsitems[i].getItems();
                int j = 0;
                while (j < obsitemsc.length) {
                    this.storeExpandItem(obsitemsc[j]);
                    if (obsitemsc[j].getItemCount() > 0) {
                        TreeItem[] obsitemsc2 = obsitemsc[j].getItems();
                        int k = 0;
                        while (k < obsitemsc2.length) {
                            this.storeExpandItem(obsitemsc2[k]);
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (this.expandedReqnums.length() > 0) {
            this.expandedReqnums = this.expandedReqnums.substring(0, this.expandedReqnums.length() - 1);
            this.expandArr = this.expandedReqnums.split(",");
        }
    }

    private void storeExpandItem(TreeItem vitem) {
        if (vitem.getExpanded()) {
            ObservationsModel obs = (ObservationsModel)vitem.getData();
            this.expandedReqnums = String.valueOf(this.expandedReqnums) + this.constants.reqdecfmt.format(obs.reqnum) + ",";
        }
    }

    private void restoreExpandTree() {
        boolean doexpand = false;
        TreeItem[] obsitems = this.v.getTree().getItems();
        if (this.expandedReqnums.length() > 0) {
            int i = 0;
            while (i < obsitems.length) {
                if (this.setExpandedItem(obsitems[i])) {
                    doexpand = true;
                    if (this.v.getTree().getItem(i).getItemCount() > 0) {
                        TreeItem[] obsitemsc = this.v.getTree().getItem(i).getItems();
                        int j = 0;
                        while (j < obsitemsc.length) {
                            this.setExpandedItem(obsitemsc[j]);
                            if (obsitemsc[j].getItemCount() > 0) {
                                TreeItem[] obsitemsc2 = obsitemsc[j].getItems();
                                int k = 0;
                                while (k < obsitemsc2.length) {
                                    this.setExpandedItem(obsitemsc2[k]);
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        if (doexpand) {
            this.v.refresh();
        }
    }

    private boolean setExpandedItem(TreeItem vitem) {
        boolean itemexpanded = false;
        int i = 0;
        while (i < this.expandArr.length) {
            if (vitem.getText().equals(this.expandArr[i])) {
                vitem.setExpanded(true);
                itemexpanded = true;
                this.v.refresh();
                break;
            }
            ++i;
        }
        return itemexpanded;
    }

    private void updTagObservation() {
        ObservationsModel obs;
        int i = 0;
        while (i < this.tagreqnums.size()) {
            if (this.tagstcids.get(i).equals(CorePlugin.getDefault().activeStc)) {
                if (CorePlugin.getDefault().observationId.indexOf(this.tagreqnums.get(i)) < 0) {
                    this.tagstcids.remove(i);
                    this.tagreqnums.remove(i);
                    this.tagdsns.remove(i);
                } else {
                    obs = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(this.tagreqnums.get(i)));
                    obs.setTagObservation(true);
                }
            }
            ++i;
        }
        if (this.v != null && !this.v.getControl().isDisposed()) {
            this.v.refresh();
        }
        obs = null;
    }

    private void doReportingAction() {
        int rc = this.editSelections();
        if (rc == 0) {
            this.doAllReportsDownload();
        }
    }

    private int editSelections() {
        int rc = 0;
        rc = this.obseditor.doEdits(this.reqaction);
        if (rc < 0) {
            this.showMessage(this.obseditor.msgtype, this.apaRequestTitle, this.obseditor.msgstr);
        } else if (CorePlugin.getDefault().selobservations.size() > 0) {
            this.v.setSelection((ISelection)new StructuredSelection((Object)CorePlugin.getDefault().selobservations.get(0)), true);
        }
        return rc;
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("E")) {
            CorePlugin.getDefault().getWorkbench().getDisplay();
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
        } else {
            CorePlugin.getDefault().getWorkbench().getDisplay();
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)message);
        }
    }

    private void clearSelections(TreeItem[] items) {
        int i = 0;
        while (i < items.length) {
            TreeItem[] childitems = items[i].getItems();
            items[i].setChecked(false);
            if (childitems.length > 0) {
                this.clearSelections(childitems);
            }
            ++i;
        }
    }

    private void doCheckedObs(TreeItem item) {
        ObservationsModel obs = (ObservationsModel)item.getData();
        int j = 0;
        while (j < CorePlugin.getDefault().selobservations.size()) {
            if (CorePlugin.getDefault().selobservations.get((int)j).reqnum == obs.reqnum) {
                return;
            }
            ++j;
        }
        CorePlugin.getDefault().selobservations.add(obs);
    }

    private void refreshObs() {
        if (!this.v.getControl().isDisposed() && CorePlugin.getDefault().session != null) {
            if (CorePlugin.getDefault().session.getReturnCode() == 0) {
                this.updatePartName();
                this.reqnum = 0;
                if (this.v.getInput() != null) {
                    this.storeExpandTree();
                }
                if (CorePlugin.getDefault().getObservationsModel() == null) {
                    this.v.setInput(null);
                } else {
                    if (CorePlugin.getDefault().selobs != null) {
                        this.reqnum = CorePlugin.getDefault().selobs.reqnum;
                    }
                    this.v.setInput((Object)CorePlugin.getDefault().getObservationsModel());
                }
                this.getViewSite().getActionBars().getStatusLineManager().setMessage(this.getTotalStatus());
                TreeItem[] obsitems = this.v.getTree().getItems();
                if (obsitems.length > 0) {
                    ObservationsModel observation;
                    if (this.reqnum <= 0 || CorePlugin.getDefault().observationId.indexOf(this.reqnum) < 0) {
                        this.reqnum = new Integer(((ObservationsModel)obsitems[0].getData()).reqnum);
                    }
                    try {
                        observation = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(this.reqnum));
                    }
                    catch (Exception exception) {
                        int obslen = CorePlugin.getDefault().observations.get(0).getChildren().size() - 1;
                        observation = CorePlugin.getDefault().observations.get(0).getChildren().get(obslen);
                    }
                    this.v.setSelection((ISelection)new StructuredSelection((Object)observation), true);
                    CorePlugin.getDefault().selobs = observation;
                    CorePlugin.getDefault().getPreferenceStore().setValue("initDetail", "ObservationDetail");
                }
            } else {
                this.updatePartName();
                this.v.setInput((Object)CorePlugin.getDefault().getObservationsModel());
                this.showMessage(String.valueOf(Messages.getString("ObservationsView.MessageDialog.infoMessage.GetObservationsFailed")) + CorePlugin.getDefault().session.getReason());
                CorePlugin.getDefault().session.returnCode = 0;
                CorePlugin.getDefault().session.reasonCode = 0;
            }
        }
        if (this.v.getInput() != null) {
            this.restoreExpandTree();
        }
        this.updTagObservation();
        CorePlugin.getDefault().getPreferenceStore().setValue("obsLoaded", true);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ObservationsView.this.getViewSite().getActionBars().getStatusLineManager().update(true);
            }
        });
    }

    private void doAllReportsDownload() {
        this.obsrpts = new ObservationReports();
        this.obsrpts.rptformat = this.rptformat;
        this.saveReportFnames = new ArrayList<String>();
        String saveReportFname = "";
        int i = 0;
        while (i < CorePlugin.getDefault().selobservations.size()) {
            if (this.rptformat.equals(this.constants.REPORT_FORMAT_XML) | this.rptformat.equals(this.constants.REPORT_FORMAT_JSON) | this.rptformat.equals(this.constants.REPORT_FORMAT_PDF) && (i <= 0 || !(this.reqaction.equals(this.constants.ACTION_VARIANCE) | this.reqaction.equals(this.constants.ACTION_CICSMASS) | this.reqaction.equals(this.constants.ACTION_IMSMASS) | this.reqaction.equals(this.constants.ACTION_DB2PROC)))) {
                File saveReportFile = this.getSaveReportFile(CorePlugin.getDefault().constants.reqdecfmt.format(CorePlugin.getDefault().selobservations.get((int)i).reqnum), "", this.rptformat);
                if (saveReportFile != null) {
                    saveReportFile.getParentFile().mkdirs();
                    saveReportFname = saveReportFile.getPath();
                }
                this.saveReportFnames.add(saveReportFname);
            }
            if (this.reqaction.equals(this.constants.ACTION_VARIANCE) & i > 0) {
                this.obsrpts.variancedsns.add(CorePlugin.getDefault().selobservations.get((int)i).dsname);
            } else if (this.reqaction.equals(this.constants.ACTION_CICSMASS) & i > 0) {
                this.obsrpts.multiaddrdsns.add(CorePlugin.getDefault().selobservations.get((int)i).dsname);
            } else if (this.reqaction.equals(this.constants.ACTION_IMSMASS) & i > 0) {
                this.obsrpts.multiaddrdsns.add(CorePlugin.getDefault().selobservations.get((int)i).dsname);
            } else if (this.reqaction.equals(this.constants.ACTION_DB2PROC) & i > 0) {
                this.obsrpts.multiaddrdsns.add(CorePlugin.getDefault().selobservations.get((int)i).dsname);
            }
            ++i;
        }
        this.runReportsPing();
    }

    private File getSaveReportFile(String sreqnum, String rptid, String rptformat) {
        Shell shell = this.v.getControl().getShell();
        boolean runSaveDialog = true;
        String titleText = Messages.getString("ObservationsView.Dialog.Text.SaveReport");
        titleText = titleText.replace("#rptformat", rptformat.toUpperCase());
        String filename = String.valueOf(CorePlugin.getDefault().productextension.getProductPrefix()) + "_" + CorePlugin.getDefault().activeStc + "_" + sreqnum;
        if (rptid.length() > 0) {
            filename = String.valueOf(filename) + "_" + rptid;
        }
        filename = String.valueOf(filename) + "." + rptformat;
        File file = null;
        FileDialog dialog = null;
        while (runSaveDialog) {
            dialog = new FileDialog(shell, 8192);
            dialog.setFilterNames(new String[]{String.valueOf(rptformat.toUpperCase()) + " Documents (*." + rptformat + ")", "All Files (*.*)"});
            dialog.setFilterExtensions(new String[]{"*." + rptformat, "*.*"});
            dialog.setFilterPath(CorePlugin.getDefault().getPreferenceStore().getString("saveReportPath"));
            dialog.setFileName(filename);
            dialog.setText(titleText);
            filename = dialog.open();
            if (filename != null) {
                file = new File(filename);
                if (file.exists()) {
                    if (MessageDialog.openConfirm((Shell)shell, (String)Messages.getString("ObservationsView.ConfirmDialog.ConfirmTitle.ReplaceFile"), (String)(String.valueOf(Messages.getString("ObservationsView.ConfirmDialog.ConfirmMessage.Replace")) + filename + "?"))) {
                        runSaveDialog = false;
                        continue;
                    }
                    file = null;
                    dialog = null;
                    continue;
                }
                runSaveDialog = false;
                continue;
            }
            runSaveDialog = false;
        }
        CorePlugin.getDefault().getPreferenceStore().setValue("saveReportPath", dialog.getFilterPath());
        dialog = null;
        return file;
    }

    public void runReportsPing() {
        Job job0 = new Job(Messages.getString("ObservationsView.Job.Title.PingApa")){

            public IStatus run(IProgressMonitor monitor) {
                CorePlugin.getDefault().session.monitor = monitor;
                monitor.beginTask(Messages.getString("ObservationsView.Job.Monitor.Ping"), 100);
                ObservationsView.this.zosconnect.pingZos(monitor);
                monitor.done();
                if (ObservationsView.this.zosconnect.getConnectRc() != 0) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job0.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    System.out.println("ReportsView Ping Job completed successfully");
                } else {
                    System.out.println("ReportsView Ping Job did not complete successfully");
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        System.out.println("ReportsView Ping rc is " + (this).ObservationsView.this.zosconnect.getConnectRc());
                        if (CorePlugin.getDefault().session.getReturnCode() != 0) {
                            ObservationsView.this.showMessage("info", Messages.getString("ObservationsView.MessageDialog.infoTitle.ReportsDownload"), String.valueOf(Messages.getString("ObservationsView.MessageDialog.errorMessage.DownloadFailed")) + CorePlugin.getDefault().session.getReason());
                        } else if ((this).ObservationsView.this.zosconnect.getConnectRc() == 0) {
                            ObservationsView.this.runGetAllObsReports();
                        } else {
                            ObservationsView.this.showMessage("info", String.valueOf(Messages.getString("ObservationsView.MessageDialog.infoTitle.Zos")) + CorePlugin.getDefault().productextension.getProductName() + Messages.getString("ObservationsView.MessageDialog.infoTitle.ConnectionLost"), String.valueOf(Messages.getString("ObservationsView.MessageDialog.infoMessage.RemoteConnectionLost")) + Messages.getString("ObservationsView.Messaging.ReConnect"));
                            (this).ObservationsView.this.zosconnect.setConnectLocal();
                        }
                    }
                });
            }
        });
        job0.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job0.schedule();
    }

    private void runGetAllObsReports() {
        this.selrptobs = null;
        this.rptmsgs = "";
        this.rptimsgs = "";
        this.rptmsgscnt = 0;
        Job downloadJob = new Job(Messages.getString("ObservationsView.Job.Title.DownloadingReports")){

            public IStatus run(IProgressMonitor monitor) {
                CorePlugin.getDefault().session.monitor = monitor;
                ObservationsView.this.selobservations = null;
                ObservationsView.this.selobservations = new ArrayList();
                int i = 0;
                while (i < CorePlugin.getDefault().selobservations.size()) {
                    ObservationsView.this.selobservations.add(CorePlugin.getDefault().selobservations.get(i));
                    ++i;
                }
                String sreqnum = "";
                int totrpt = ObservationsView.this.selobservations.size();
                int i2 = 0;
                while (i2 < ObservationsView.this.selobservations.size()) {
                    block25: {
                        block26: {
                            block24: {
                                ObservationsView.this.rptobs = (ObservationsModel)ObservationsView.this.selobservations.get(i2);
                                ObservationsView.this.obsrpts.obs = ObservationsView.this.rptobs;
                                sreqnum = CorePlugin.getDefault().constants.reqdecfmt.format(((ObservationsView)ObservationsView.this).rptobs.reqnum);
                                if (ObservationsView.this.obsrpts.obs.dsname.length() > 0) break block24;
                                if (!ObservationsView.this.reqaction.equals(ObservationsView.this.constants.ACTION_TREEREPORTS)) {
                                    ObservationsView.this.rptimsgs = String.valueOf(ObservationsView.this.rptimsgs) + Messages.getString("ObservationsView.ErrorMessage.ReportsDownloadNoReports") + sreqnum + "\n";
                                }
                                break block25;
                            }
                            if (!(ObservationsView.this.rptformat.equals(ObservationsView.this.constants.REPORT_FORMAT_XML) | ObservationsView.this.rptformat.equals(ObservationsView.this.constants.REPORT_FORMAT_JSON) | ObservationsView.this.rptformat.equals(ObservationsView.this.constants.REPORT_FORMAT_PDF))) break block26;
                            if (((String)ObservationsView.this.saveReportFnames.get(i2)).length() <= 0) break block25;
                            ObservationsView.this.obsrpts.saveReportFname = (String)ObservationsView.this.saveReportFnames.get(i2);
                        }
                        if (ObservationsView.this.obsrpts.rptformat.equals(ObservationsView.this.constants.REPORT_FORMAT_XML) | ObservationsView.this.rptformat.equals(ObservationsView.this.constants.REPORT_FORMAT_JSON) | ObservationsView.this.rptformat.equals(ObservationsView.this.constants.REPORT_FORMAT_PDF)) {
                            ObservationsView.this.obsrpts.runCloseObsReports(sreqnum, monitor);
                        }
                        int currpt = i2 + 1;
                        if (ObservationsView.this.reqaction.equals(ObservationsView.this.constants.ACTION_VARIANCE) | ObservationsView.this.reqaction.equals(ObservationsView.this.constants.ACTION_CICSMASS) | ObservationsView.this.reqaction.equals(ObservationsView.this.constants.ACTION_IMSMASS) | ObservationsView.this.reqaction.equals(ObservationsView.this.constants.ACTION_DB2PROC)) {
                            totrpt = 1;
                        }
                        monitor.beginTask(String.valueOf(Messages.getString("ObservationsView.Job.Monitor.Downloading")) + currpt + Messages.getString("ObservationsView.Job.Monitor.Of") + totrpt + Messages.getString("ObservationsView.Job.Monitor.ReportsForObservation") + sreqnum + " ...", 100);
                        ObservationsView.this.obsrpts.cookie = ObservationsView.this.obsrpts.getCookie(sreqnum, monitor);
                        ObservationsView.this.obsrpts.buildControlCards(ObservationsView.this.selreports);
                        ObservationsView.this.obsrpts.parseRemoteReports(monitor, sreqnum);
                        ObservationsView.this.obsrpts.getobsrc = CorePlugin.getDefault().session.getReturnCode();
                        if (!(ObservationsView.this.obsrpts.getobsrc == 0 | ObservationsView.this.obsrpts.getobsrc == -98)) {
                            this.setName("");
                            ObservationsView.this.obsrpts.getobsrsn = CorePlugin.getDefault().session.getReason();
                            if (ObservationsView.this.obsrpts.getobsrsn.startsWith(CorePlugin.getDefault().productextension.getZosProductId())) {
                                ObservationsView.this.obsrpts.getobsrsn = ObservationsView.this.obsrpts.getobsrsn.substring(ObservationsView.this.obsrpts.getobsrsn.indexOf(" ") + 1, ObservationsView.this.obsrpts.getobsrsn.length());
                            }
                            String logstr = String.valueOf(sreqnum) + " - error rc: " + ObservationsView.this.obsrpts.getobsrc + ", error reason: " + ObservationsView.this.obsrpts.getobsrsn + "\n";
                            System.out.println("ObservationReports - runGetAllObsReports:  " + logstr);
                            CorePlugin.getDefault().log.error(logstr);
                            if (ObservationsView.this.rptmsgscnt <= 20) {
                                ObservationsView.this.rptmsgs = String.valueOf(ObservationsView.this.rptmsgs) + logstr;
                            }
                            ObservationsView.this.obsrpts.runCloseObsReports(sreqnum, monitor);
                            if (ObservationsView.this.obsrpts.getobsrc == -99 | ObservationsView.this.obsrpts.getobsrc >= 1000) {
                                return Status.CANCEL_STATUS;
                            }
                        } else {
                            if (ObservationsView.this.obsrpts.multiaddrdsns.size() > 0) {
                                ObservationsView.this.obsrpts.persistDsns("multiaddrdsns");
                            } else if (ObservationsView.this.obsrpts.variancedsns.size() > 0) {
                                ObservationsView.this.obsrpts.persistDsns("variancedsns");
                            }
                            if (ObservationsView.this.rptformat.equals(ObservationsView.this.constants.REPORT_FORMAT_PVML)) {
                                ObservationsModel observation = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(((ObservationsView)ObservationsView.this).rptobs.reqnum));
                                observation.setReportsAvail(true);
                            } else if (CorePlugin.getDefault().getPreferenceStore().getBoolean("launchXml") | CorePlugin.getDefault().getPreferenceStore().getBoolean("launchPdf")) {
                                ObservationsView.this.obsrpts.runLaunchProgram();
                            }
                            if (!(ObservationsView.this.reqaction.equals(ObservationsView.this.constants.ACTION_REPORTS) & ObservationsView.this.obsrpts.rptformat.equals(ObservationsView.this.constants.REPORT_FORMAT_PVML))) {
                                if (ObservationsView.this.reqaction.equals(ObservationsView.this.constants.ACTION_TREEREPORTS)) {
                                    ObservationsView.this.obsrpts.runCloseObsReports("*", monitor);
                                } else {
                                    ObservationsView.this.obsrpts.runCloseObsReports(sreqnum, monitor);
                                }
                            }
                            monitor.worked(100);
                            if (monitor.isCanceled()) {
                                this.setName("");
                                return Status.CANCEL_STATUS;
                            }
                            if (ObservationsView.this.reqaction.equals(ObservationsView.this.constants.ACTION_VARIANCE) | ObservationsView.this.reqaction.equals(ObservationsView.this.constants.ACTION_CICSMASS) | ObservationsView.this.reqaction.equals(ObservationsView.this.constants.ACTION_IMSMASS) | ObservationsView.this.reqaction.equals(ObservationsView.this.constants.ACTION_DB2PROC)) {
                                CorePlugin.getDefault().selobservations = new ArrayList<ObservationsModel>();
                                monitor.done();
                                this.setName("");
                                return Status.OK_STATUS;
                            }
                        }
                    }
                    ++i2;
                }
                monitor.done();
                this.setName("");
                return Status.OK_STATUS;
            }
        };
        downloadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).ObservationsView.this.rptformat.equals((this).ObservationsView.this.constants.REPORT_FORMAT_PVML)) {
                            try {
                                ObservationsView.this.getSite().getPage().showView("com.banknet.core.ReportsView");
                            }
                            catch (Exception ex) {
                                System.out.println("ObservationsView, doReportingAction ex " + ex);
                            }
                        }
                        ObservationsModel observation = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(((ObservationsView)(this).ObservationsView.this).rptobs.reqnum));
                        (this).ObservationsView.this.v.setSelection((ISelection)new StructuredSelection((Object)observation), true);
                        (this).ObservationsView.this.clearSelectionsAction.run();
                        (this).ObservationsView.this.v.refresh();
                        try {
                            ObservationsView.this.getSite().getPage().showView(ObservationsView.ID);
                        }
                        catch (Exception ex) {
                            System.out.println("ObservationsView, doReportingAction ex " + ex);
                        }
                        if ((this).ObservationsView.this.obsrpts.getobsrc == -99 | (this).ObservationsView.this.obsrpts.getobsrc >= 1000) {
                            ObservationsView.this.showMessage("E", Messages.getString("ObservationsView.MessageDialog.errorTitle.DownloadReports"), String.valueOf(Messages.getString("ObservationsView.Action.DownloadReports")) + Messages.getString("ObservationsView.MessageDialog.errorMessage.Failed") + (this).ObservationsView.this.obsrpts.getobsrsn);
                            CorePlugin.getDefault().connectionextension.disconnectZosJob();
                            (this).ObservationsView.this.v.refresh();
                        }
                        if ((this).ObservationsView.this.rptmsgscnt > 0) {
                            ObservationsView.this.showMessage("E", Messages.getString("ObservationsView.MessageDialog.errorTitle.DownloadReports"), String.valueOf((this).ObservationsView.this.rptmsgs) + "Check log for details");
                            String logstr = "runGetAllObsReports:  Problems found downloading reports *** : \n" + (this).ObservationsView.this.rptmsgs;
                            System.out.println("ObservationReports - " + logstr);
                            CorePlugin.getDefault().log.error(logstr);
                        }
                        if ((this).ObservationsView.this.rptimsgs.length() > 0) {
                            ObservationsView.this.showMessage("I", Messages.getString("ObservationsView.MessageDialog.errorTitle.DownloadReports"), (this).ObservationsView.this.rptimsgs);
                        }
                    }
                });
            }
        });
        downloadJob.setRule(CorePlugin.getDefault().schedrule);
        downloadJob.setUser(true);
        downloadJob.setPriority(20);
        downloadJob.schedule();
    }

    public void runDeleteObsReports() {
        Job deleteJob = new Job(Messages.getString("ObservationReports.Job.Title.DeletingReports")){

            public IStatus run(IProgressMonitor monitor) {
                CorePlugin.getDefault().session.monitor = monitor;
                int reqcnt = ObservationsView.this.selobservations.size();
                int curreq = 0;
                int reqnum = 0;
                ObservationsView.this.selobservations = null;
                ObservationsView.this.selobservations = new ArrayList();
                int i = 0;
                while (i < CorePlugin.getDefault().selobservations.size()) {
                    ObservationsView.this.selobservations.add(CorePlugin.getDefault().selobservations.get(i));
                    ++i;
                }
                i = 0;
                while (i < ObservationsView.this.selobservations.size()) {
                    ObservationsView.this.rptobs = (ObservationsModel)ObservationsView.this.selobservations.get(i);
                    reqnum = ((ObservationsView)ObservationsView.this).rptobs.reqnum;
                    CorePlugin.getDefault().constants.reqdecfmt.format(((ObservationsView)ObservationsView.this).rptobs.reqnum);
                    monitor.beginTask(String.valueOf(Messages.getString("ObservationReports.Job.Monitor.Deleting")) + ++curreq + Messages.getString("ReportsView.Job.Monitor.Of") + reqcnt + Messages.getString("ReportsView.Job.Monitor.ReportsForObservation") + reqnum + " ...", 100);
                    try {
                        IPreferenceStore iPreferenceStore = CorePlugin.getDefault().getPreferenceStore();
                        CorePlugin.getDefault();
                        File dir = new File(String.valueOf(iPreferenceStore.getString("coreDataPath")) + CorePlugin.getDefault().productextension.getReportsFolder() + File.separator + CorePlugin.getDefault().getPreferenceStore().getString("activeConnectionId") + File.separator + CorePlugin.getDefault().activeStc + File.separator + reqnum + File.separator + Platform.getNL() + File.separator);
                        File[] files = dir.listFiles();
                        if (files != null) {
                            int ii = 0;
                            while (ii < files.length) {
                                files[ii].delete();
                                ++ii;
                            }
                            dir.delete();
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e.toString());
                    }
                    ObservationsModel observation = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(((ObservationsView)ObservationsView.this).rptobs.reqnum));
                    observation.setReportsAvail(false);
                    monitor.worked(100);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    ++i;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        deleteJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                event.getResult().isOK();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (CorePlugin.getDefault().session.getReturnCode() == 0 | CorePlugin.getDefault().session.getReturnCode() == -99) {
                            (this).ObservationsView.this.v.setSelection((ISelection)new StructuredSelection((Object)ObservationsView.this.rptobs), true);
                            (this).ObservationsView.this.clearSelectionsAction.run();
                            (this).ObservationsView.this.v.refresh();
                        } else {
                            ObservationsView.this.showMessage("error", Messages.getString("ObservationReports.MessageDialog.errorTitle.DeleteReports"), String.valueOf(Messages.getString("ObservationReports.MessageDialog.errorMessage.ReportsDeleteFor")) + ((ObservationsView)(this).ObservationsView.this).rptobs.reqnum + Messages.getString("ObservationReports.MessageDialog.errorMessage.ReportsDeleteFailed") + CorePlugin.getDefault().session.getReason());
                            String logstr = "runDeleteObsReports:  Reports Delete for " + ((ObservationsView)(this).ObservationsView.this).rptobs.reqnum + " failed.  " + CorePlugin.getDefault().session.getReason();
                            System.out.println("ObservationReports - " + logstr);
                            CorePlugin.getDefault().log.debug(logstr);
                        }
                    }
                });
            }
        });
        deleteJob.schedule();
    }

    public void selectObsChildren() {
        List<ObservationsModel> selobslist = CorePlugin.getDefault().selobservations;
        int i = 0;
        while (i < selobslist.size()) {
            ObservationsModel obs = selobslist.get(i);
            if (obs.getChildren().size() > 0) {
                this.selectObsChild(obs.reqnum, 0);
            }
            ++i;
        }
    }

    private void selectObsChild(int req, int level) {
        ObservationsModel obs = CorePlugin.getDefault().observations.get(CorePlugin.getDefault().observationId.indexOf(req));
        List<ObservationsModel> obschildren = obs.getChildren();
        int i = 0;
        while (i < obschildren.size()) {
            ObservationsModel obschild = obschildren.get(i);
            if (obschild.dsname.length() > 0 && this.chkSelChildObs(obschild.reqnum)) {
                CorePlugin.getDefault().selobservations.add(obschild);
            }
            if (obschild.getChildren().size() > 0) {
                this.selectObsChild(obschild.reqnum, level + 1);
            }
            ++i;
        }
    }

    private boolean chkSelChildObs(int reqnum) {
        boolean selectobs = true;
        int j = 0;
        while (j < CorePlugin.getDefault().selobservations.size()) {
            if (CorePlugin.getDefault().selobservations.get((int)j).reqnum == reqnum) {
                return false;
            }
            ++j;
        }
        return selectobs;
    }

    private void loadTemplate() {
        ObservationDetail obsdetail = new ObservationDetail();
        this.obsdetails = new ArrayList<ObservationDetail>();
        this.reqnums = new ArrayList<Integer>();
        this.selreqnums = new ArrayList<Integer>();
        obsdetail.ireqnum = this.reqnum;
        this.selreqnums.add(this.reqnum);
        this.reqnums.add(this.reqnum);
        this.obsdetails.add(obsdetail);
        this.doApaRequest();
    }

    private void addObsColumn(int colidx, String colid) {
        this.column = new TreeColumn(this.v.getTree(), 0);
        this.column.setResizable(true);
        this.column.setText(this.obscolstextarr[colidx]);
        this.column.setToolTipText(this.obscolstextarr[colidx]);
        if (colidx == 0) {
            this.column.setWidth(175);
            this.tableLayout.setColumnData((Widget)this.column, (ColumnLayoutData)new ColumnWeightData(10));
            this.reqnumSorter = new ColumnSorter(this.v, this.column){

                @Override
                protected int doCompare(Viewer v, Object e1, Object e2) {
                    if (((ObservationsModel)e1).reqlink <= 0) {
                        return ((ObservationsModel)e1).reqnum.compareTo(((ObservationsModel)e2).reqnum);
                    }
                    return ((ObservationsModel)e1).reqnum;
                }
            };
        } else if (colidx == 1) {
            this.column.setText("");
            this.column.setWidth(25);
            this.tableLayout.setColumnData((Widget)this.column, (ColumnLayoutData)new ColumnWeightData(3));
            this.column.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/msBlue14x14.gif").createImage());
            this.reportsSorter = new ColumnSorter(this.v, this.column){

                @Override
                protected int doCompare(Viewer v, Object e1, Object e2) {
                    return ((ObservationsModel)e1).reportsDownloaded.compareTo(((ObservationsModel)e2).reportsDownloaded);
                }
            };
        } else if (colidx == 2) {
            this.column.setMoveable(true);
            this.column.setWidth(65);
            this.tableLayout.setColumnData((Widget)this.column, (ColumnLayoutData)new ColumnWeightData(8));
            this.ownedbySorter = new ColumnSorter(this.v, this.column){

                @Override
                protected int doCompare(Viewer v, Object e1, Object e2) {
                    return ((ObservationsModel)e1).ownedby.compareToIgnoreCase(((ObservationsModel)e2).ownedby);
                }
            };
        } else if (colidx == 3) {
            this.column.setMoveable(true);
            this.column.setWidth(150);
            this.tableLayout.setColumnData((Widget)this.column, (ColumnLayoutData)new ColumnWeightData(18));
            this.descriptionSorter = new ColumnSorter(this.v, this.column){

                @Override
                protected int doCompare(Viewer v, Object e1, Object e2) {
                    return ((ObservationsModel)e1).description.compareToIgnoreCase(((ObservationsModel)e2).description);
                }
            };
        } else if (colidx == 4) {
            this.column.setMoveable(true);
            this.column.setWidth(65);
            this.tableLayout.setColumnData((Widget)this.column, (ColumnLayoutData)new ColumnWeightData(9));
            this.jobnameSorter = new ColumnSorter(this.v, this.column){

                @Override
                protected int doCompare(Viewer v, Object e1, Object e2) {
                    return ((ObservationsModel)e1).jobname.compareToIgnoreCase(((ObservationsModel)e2).jobname);
                }
            };
        } else if (colidx == 5) {
            this.column.setMoveable(true);
            this.column.setWidth(125);
            this.tableLayout.setColumnData((Widget)this.column, (ColumnLayoutData)new ColumnWeightData(14));
            this.datetimeSorter = new ColumnSorter(this.v, this.column){

                @Override
                protected int doCompare(Viewer v, Object e1, Object e2) {
                    String key1 = String.valueOf(CorePlugin.getDefault().constants.yyyymmddhhmm.format(((ObservationsModel)e1).getSessionDateTime()).toString()) + " " + CorePlugin.getDefault().constants.reqdecfmt.format(((ObservationsModel)e1).reqnum);
                    String key2 = String.valueOf(CorePlugin.getDefault().constants.yyyymmddhhmm.format(((ObservationsModel)e2).getSessionDateTime()).toString()) + " " + CorePlugin.getDefault().constants.reqdecfmt.format(((ObservationsModel)e2).reqnum);
                    return key1.compareTo(key2);
                }
            };
        } else if (colidx == 6) {
            this.column.setMoveable(true);
            this.column.setAlignment(131072);
            this.column.setWidth(55);
            this.tableLayout.setColumnData((Widget)this.column, (ColumnLayoutData)new ColumnWeightData(8));
            this.samplesSorter = new ColumnSorter(this.v, this.column){

                @Override
                protected int doCompare(Viewer v, Object e1, Object e2) {
                    return ((ObservationsModel)e1).r02Samples.compareTo(((ObservationsModel)e2).r02Samples);
                }
            };
        } else if (colidx == 7) {
            this.column.setMoveable(true);
            this.column.setWidth(50);
            this.tableLayout.setColumnData((Widget)this.column, (ColumnLayoutData)new ColumnWeightData(8));
            this.statusSorter = new ColumnSorter(this.v, this.column){

                @Override
                protected int doCompare(Viewer v, Object e1, Object e2) {
                    return ((ObservationsModel)e1).statusShort.compareToIgnoreCase(((ObservationsModel)e2).statusShort);
                }
            };
        } else if (colidx == 8) {
            this.column.setMoveable(true);
            this.column.setWidth(65);
            this.tableLayout.setColumnData((Widget)this.column, (ColumnLayoutData)new ColumnWeightData(8));
            this.deletedaysSorter = new ColumnSorter(this.v, this.column){

                @Override
                protected int doCompare(Viewer v, Object e1, Object e2) {
                    Integer d2;
                    Integer d1 = ((ObservationsModel)e1).deleteDays;
                    if (d1 == null) {
                        d1 = 0;
                    }
                    if ((d2 = ((ObservationsModel)e2).deleteDays) == null) {
                        d2 = 0;
                    }
                    return d1.compareTo(d2);
                }
            };
        } else if (colidx == 9) {
            this.column.setMoveable(true);
            this.column.setWidth(50);
            this.tableLayout.setColumnData((Widget)this.column, (ColumnLayoutData)new ColumnWeightData(6));
            this.systemSorter = new ColumnSorter(this.v, this.column){

                @Override
                protected int doCompare(Viewer v, Object e1, Object e2) {
                    return ((ObservationsModel)e1).system.compareToIgnoreCase(((ObservationsModel)e2).system);
                }
            };
        } else if (colidx == 10) {
            this.column.setMoveable(true);
            this.column.setAlignment(131072);
            this.column.setWidth(65);
            this.tableLayout.setColumnData((Widget)this.column, (ColumnLayoutData)new ColumnWeightData(8));
            this.durationSorter = new ColumnSorter(this.v, this.column){

                @Override
                protected int doCompare(Viewer v, Object e1, Object e2) {
                    Double d1 = 0.0;
                    if (((ObservationsModel)e1).getSessionDuration() != null) {
                        d1 = (double)(((ObservationsModel)e1).getSessionDurationMin() * 60L) + ((ObservationsModel)e1).getSessionDurationSec();
                    }
                    Double d2 = 0.0;
                    if (((ObservationsModel)e2).getSessionDuration() != null) {
                        d2 = (double)(((ObservationsModel)e2).getSessionDurationMin() * 60L) + ((ObservationsModel)e2).getSessionDurationSec();
                    }
                    return d1.compareTo(d2);
                }
            };
        }
    }

    private static abstract class ColumnSorter
    extends ViewerComparator {
        public static final int ASC = 1;
        public static final int NONE = 0;
        public static final int DESC = -1;
        private int direction = 0;
        private TreeColumn column;
        private TreeViewer viewer;

        public ColumnSorter(TreeViewer viewer, TreeColumn column) {
            this.column = column;
            this.viewer = viewer;
            this.column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (viewer.getComparator() != null) {
                        if (viewer.getComparator() == this) {
                            int tdirection = direction;
                            if (tdirection == 1) {
                                this.setSorter(this, -1);
                            } else if (tdirection == -1) {
                                this.setSorter(this, 1);
                            }
                        } else {
                            this.setSorter(this, 1);
                        }
                    } else {
                        this.setSorter(this, 1);
                    }
                }
            });
        }

        public void setSorter(ColumnSorter sorter, int direction) {
            if (direction == 0) {
                this.column.getParent().setSortColumn(null);
                this.column.getParent().setSortDirection(0);
                this.viewer.setComparator(null);
            } else {
                this.column.getParent().setSortColumn(this.column);
                sorter.direction = direction;
                if (direction == 1) {
                    this.column.getParent().setSortDirection(128);
                } else {
                    this.column.getParent().setSortDirection(1024);
                }
                if (this.viewer.getComparator() == sorter) {
                    this.viewer.refresh();
                } else {
                    this.viewer.setComparator((ViewerComparator)sorter);
                }
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.direction * this.doCompare(viewer, e1, e2);
        }

        protected abstract int doCompare(Viewer var1, Object var2, Object var3);
    }
}

