/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.views;

import com.banknet.core.CorePlugin;
import com.banknet.core.internal.Constants;
import com.banknet.core.models.ObservationsSearchItem;
import com.banknet.core.models.ObservationsSearchItems;
import com.banknet.core.preferences.PreferencesConstants;
import com.banknet.core.views.Messages;
import com.banknet.core.views.ObservationsSearchViewLabelProvider;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ObservationsSearchView
extends ViewPart
implements SelectionListener {
    public static final String ID = "com.banknet.core.ObservationsSearchView";
    private Table table;
    private TableViewer tableViewer;
    private NumberFormat priceFormat = NumberFormat.getInstance();
    private List pages = new ArrayList();
    public static final int ASC = 1;
    public static final int NONE = 0;
    public static final int DESC = -1;
    private Action historyMenu;
    private Action refreshAction;
    private Action removeCurrentAction;
    private Action removeAllAction;
    private ColumnSorter reqnumSorter;
    private ColumnSorter descriptionSorter;
    private ColumnSorter jobnameSorter;
    protected List results = new ArrayList();
    Constants constants = new Constants();
    PreferencesConstants pconstants = new PreferencesConstants();
    ObservationsSearchItems items = new ObservationsSearchItems();
    ObservationsSearchViewLabelProvider labelProvider = new ObservationsSearchViewLabelProvider();
    private final IEclipsePreferences.IPreferenceChangeListener preferenceChangeListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            if (!event.getKey().equals("coreConnected") && !event.getKey().equals("obsReports") && event.getKey().equals("stcViewSel") && CorePlugin.getDefault().getObservationsModel() != null) {
                ObservationsSearchView.this.doSearch();
            }
        }
    };
    private IMenuCreator menuCreator = new IMenuCreator(){
        private Menu menu;

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return this.menu;
        }
    };

    public ObservationsSearchView() {
        this.priceFormat.setGroupingUsed(true);
        this.priceFormat.setMinimumIntegerDigits(1);
        this.priceFormat.setMinimumFractionDigits(4);
        this.priceFormat.setMaximumFractionDigits(4);
        IEclipsePreferences preferencesI = InstanceScope.INSTANCE.getNode("com.banknet.core");
        preferencesI.addPreferenceChangeListener(this.preferenceChangeListener);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        CorePlugin.getDefault().connectionextension.createConnectionListener();
    }

    public void createPartControl(Composite parent) {
        Composite client = new Composite(parent, 64);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout = new GridLayout(1, false);
        client.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        client.setLayoutData((Object)gd);
        this.table = new Table(client, 66306);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.table.setLayoutData((Object)gd);
        this.tableViewer = new TableViewer(this.table);
        TableColumn column = new TableColumn(this.table, 16384);
        column.setWidth(85);
        column.setToolTipText(Messages.getString("ObservationsSearchView.SearchListColumn.ReqNum"));
        column.setText(Messages.getString("ObservationsSearchView.SearchListColumn.ReqNum"));
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.reqnumSorter = new ColumnSorter(this.tableViewer, column){

            @Override
            protected int doCompare(Viewer v, Object e1, Object e2) {
                return ((ObservationsSearchItem)e1).reqnum.compareTo(((ObservationsSearchItem)e2).reqnum);
            }
        };
        column = new TableColumn(this.table, 16384);
        column.setWidth(100);
        column.setText(Messages.getString("ObservationsSearchView.SearchListColumn.Description"));
        column.setToolTipText(Messages.getString("ObservationsSearchView.SearchListColumn.Description"));
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.descriptionSorter = new ColumnSorter(this.tableViewer, column){

            @Override
            protected int doCompare(Viewer v, Object e1, Object e2) {
                return ((ObservationsSearchItem)e1).description.compareToIgnoreCase(((ObservationsSearchItem)e2).description);
            }
        };
        column = new TableColumn(this.table, 16384);
        column.setWidth(65);
        column.setText(Messages.getString("ObservationsSearchView.SearchListColumn.JobName"));
        column.setToolTipText(Messages.getString("ObservationsSearchView.SearchListColumn.JobName"));
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.jobnameSorter = new ColumnSorter(this.tableViewer, column){

            @Override
            protected int doCompare(Viewer v, Object e1, Object e2) {
                return ((ObservationsSearchItem)e1).jobname.compareToIgnoreCase(((ObservationsSearchItem)e2).jobname);
            }
        };
        this.setSortColumn();
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (CorePlugin.getDefault().getObservationsModel() != null) {
            this.doSearch();
        }
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
    }

    public String getPartProperty(String key) {
        String partkey = CorePlugin.getDefault().connectionextension.getConnectionPartKey(key);
        if (partkey.length() > 0) {
            return partkey;
        }
        return super.getPartProperty(key);
    }

    public void addPage() {
        Job job = new Job(Messages.getString("ObservationsSearchView.Job.Title.Searching")){

            protected IStatus run(IProgressMonitor monitor) {
                ObservationsSearchView.this.table.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ObservationsSearchView.this.doSearch();
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void doSearch() {
        this.table.removeAll();
        this.items.searchModel();
        this.setContentDescription(String.valueOf(this.items.getResults().size()) + Messages.getString("ObservationsSearchView.SearchDescription.Results"));
        this.tableViewer.setInput((Object)this.items.getResults().toArray());
        if (this.items.getResults().size() > 0) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection(this.tableViewer.getTable().getItems()[0].getData()));
        }
    }

    public void setFocus() {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getSite().getShell(), String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".views_ObservationsSearchContext");
    }

    public void dispose() {
        IEclipsePreferences preferencesI = InstanceScope.INSTANCE.getNode("com.banknet.core");
        preferencesI.removePreferenceChangeListener(this.preferenceChangeListener);
        try {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            page.setEditorAreaVisible(false);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        System.out.println("In widgetSelected()");
    }

    private void setSortColumn() {
        if (CorePlugin.getDefault().getPreferenceStore().getString("sortSeq").equalsIgnoreCase(this.pconstants.SORTSEQ_REQNUM)) {
            this.reqnumSorter.setSorter(this.reqnumSorter, -1);
        } else if (CorePlugin.getDefault().getPreferenceStore().getString("sortSeq").equalsIgnoreCase(this.pconstants.SORTSEQ_DESCRIPTION)) {
            this.descriptionSorter.setSorter(this.descriptionSorter, 1);
        } else if (CorePlugin.getDefault().getPreferenceStore().getString("sortSeq").equalsIgnoreCase(this.pconstants.SORTSEQ_JOBNAME)) {
            this.jobnameSorter.setSorter(this.jobnameSorter, 1);
        } else {
            this.reqnumSorter.setSorter(this.reqnumSorter, -1);
        }
    }

    private static abstract class ColumnSorter
    extends ViewerComparator {
        public static final int ASC = 1;
        public static final int NONE = 0;
        public static final int DESC = -1;
        private int direction = 0;
        private TableColumn column;
        private TableViewer viewer;

        public ColumnSorter(TableViewer viewer, TableColumn column) {
            this.column = column;
            this.viewer = viewer;
            this.column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (viewer.getComparator() != null) {
                        if (viewer.getComparator() == this) {
                            int tdirection = direction;
                            if (tdirection == 1) {
                                this.setSorter(this, -1);
                            } else if (tdirection == -1) {
                                this.setSorter(this, 1);
                            }
                        } else {
                            this.setSorter(this, 1);
                        }
                    } else {
                        this.setSorter(this, 1);
                    }
                }
            });
        }

        public void setSorter(ColumnSorter sorter, int direction) {
            if (direction == 0) {
                this.column.getParent().setSortColumn(null);
                this.column.getParent().setSortDirection(0);
                this.viewer.setComparator(null);
            } else {
                this.column.getParent().setSortColumn(this.column);
                sorter.direction = direction;
                if (direction == 1) {
                    this.column.getParent().setSortDirection(128);
                } else {
                    this.column.getParent().setSortDirection(1024);
                }
                if (this.viewer.getComparator() == sorter) {
                    this.viewer.refresh();
                } else {
                    this.viewer.setComparator((ViewerComparator)sorter);
                }
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.direction * this.doCompare(viewer, e1, e2);
        }

        protected abstract int doCompare(Viewer var1, Object var2, Object var3);
    }
}

