/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.views;

import com.banknet.core.CorePlugin;
import com.banknet.core.models.ObservationsModel;
import com.banknet.core.views.Messages;

public class ObservationsEditor {
    final String MSGTYPE_ERROR = "E";
    final String MSGTYPE_INFO = "I";
    private static String VARIANT_IMSMASS = "I";
    private static String OBS_STATUS_ACTIVE = "A";
    private static String OBS_STATUS_WRITING = "W";
    public String msgstr = "";
    public String msgtype = "E";
    ObservationsModel obs;
    public boolean multiobs = false;
    String action = "";

    public int doEdits(String reqaction) {
        int rc = 0;
        this.msgstr = "";
        this.msgtype = "E";
        this.action = reqaction;
        this.doGeneralEdits();
        if (this.msgstr.length() > 0) {
            return -1;
        }
        if (reqaction.equals(CorePlugin.getDefault().constants.ACTION_SUB)) {
            rc = this.doSubEdits();
        } else if (reqaction.equals(CorePlugin.getDefault().constants.ACTION_REPORTS) | reqaction.equals(CorePlugin.getDefault().constants.ACTION_TREEREPORTS) | reqaction.equals(CorePlugin.getDefault().constants.ACTION_VARIANCE)) {
            rc = this.doReportsEdits();
        } else if (reqaction.equals(CorePlugin.getDefault().constants.ACTION_CRAG)) {
            rc = this.doCragEdits();
        } else if (reqaction.equals(CorePlugin.getDefault().constants.ACTION_CICSMASS) | reqaction.equals(CorePlugin.getDefault().constants.ACTION_IMSMASS) | reqaction.equals(CorePlugin.getDefault().constants.ACTION_DB2PROC)) {
            rc = this.doReportsEdits();
            if (rc == 0) {
                rc = this.doMinSelEdit();
            }
            if (rc == 0) {
                rc = this.doMultiAddrEdits(reqaction);
            }
        }
        return rc;
    }

    public void doGeneralEdits() {
        int rc = this.doRemoteEdit();
        if (rc < 0) {
            return;
        }
    }

    public int doRemoteEdit() {
        int rc = 0;
        this.msgtype = "E";
        this.msgstr = "";
        if (CorePlugin.getDefault().getPreferenceStore().getString("dataSource").compareToIgnoreCase("remote") < 0) {
            this.msgstr = Messages.getString("ObservationsEditor.GeneralEdits.RemoteConnectionReqd");
            this.msgtype = "I";
            return -1;
        }
        return rc;
    }

    public int doMinSelEdit() {
        int rc = 0;
        this.msgtype = "E";
        this.msgstr = "";
        if (CorePlugin.getDefault().selobservations.size() <= 1) {
            this.msgstr = Messages.getString("ObservationsEditor.MinSelEdit.InvalidSelections");
            return -1;
        }
        return rc;
    }

    public int doSubEdits() {
        int rc = 0;
        int i = 0;
        while (i < CorePlugin.getDefault().selobservations.size()) {
            this.obs = CorePlugin.getDefault().selobservations.get(i);
            if (this.obs.variant.equalsIgnoreCase(VARIANT_IMSMASS)) {
                this.msgstr = Messages.getString("ObservationsEditor.SubEdits.InvalidSelection");
                return -1;
            }
            ++i;
        }
        return rc;
    }

    public int doReportsEdits() {
        int rc = 0;
        if (rc < 0) {
            return rc;
        }
        int i = 0;
        while (i < CorePlugin.getDefault().selobservations.size()) {
            this.obs = CorePlugin.getDefault().selobservations.get(i);
            if (this.obs.dsname.length() <= 0 && !(this.action.equals(CorePlugin.getDefault().constants.ACTION_REPORTS) | this.action.equals(CorePlugin.getDefault().constants.ACTION_TREEREPORTS))) {
                this.msgstr = Messages.getString("ObservationsEditor.Reports.SelectionMissingDsname");
                return -1;
            }
            if (this.obs.ltbe64 & !CorePlugin.getDefault().versionextension.isValidObsField("ltbe64")) {
                this.msgstr = Messages.getString("ObservationsEditor.ReportsEdits.SelectionNotLtbe64");
                return -1;
            }
            ++i;
        }
        return rc;
    }

    public int doCragEdits() {
        int rc = 0;
        int i = 0;
        while (i < CorePlugin.getDefault().selobservations.size()) {
            this.obs = CorePlugin.getDefault().selobservations.get(i);
            if (this.obs.statusCode.equalsIgnoreCase(OBS_STATUS_ACTIVE) || this.obs.statusCode.equalsIgnoreCase(OBS_STATUS_WRITING)) {
                this.msgstr = Messages.getString("ObservationsEditor.CragEdits.InvalidSelection");
                return -1;
            }
            ++i;
        }
        return rc;
    }

    public int doMultiAddrEdits(String reqaction) {
        int rc = 0;
        int i = 0;
        while (i < CorePlugin.getDefault().selobservations.size()) {
            this.obs = CorePlugin.getDefault().selobservations.get(i);
            if (reqaction.equals(CorePlugin.getDefault().constants.ACTION_CICSMASS)) {
                if (!this.obs.cicsExtractor) {
                    this.msgstr = Messages.getString("ObservationsEditor.MultiObsEdits.SelectionNotCics");
                    return -1;
                }
            } else if (reqaction.equals(CorePlugin.getDefault().constants.ACTION_IMSMASS)) {
                if (!this.obs.imsExtractor) {
                    this.msgstr = Messages.getString("ObservationsEditor.MultiObsEdits.SelectionNotIms");
                    return -1;
                }
            } else if (reqaction.equals(CorePlugin.getDefault().constants.ACTION_DB2PROC) && !this.obs.db2Type.equalsIgnoreCase("P") && !this.obs.cdb2) {
                this.msgstr = Messages.getString("ObservationsEditor.MultiObsEdits.SelectionNotDb2");
                return -1;
            }
            ++i;
        }
        return rc;
    }
}

