/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.preferences;

import com.banknet.core.CorePlugin;
import com.banknet.core.dialogs.spm.SpmSettings;
import com.banknet.core.preferences.PreferencesConstants;
import java.util.regex.Pattern;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class SpmPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    PreferencesConstants pconstants = new PreferencesConstants();
    SpmSettings pms;
    Shell shell;
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);
    String styleDelimiter2 = "[,]";
    Pattern s2 = Pattern.compile(this.styleDelimiter2);

    protected Control createContents(Composite parent) {
        this.shell = this.getShell();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".preferences_SpmContext");
        this.pms = new SpmSettings(this.shell);
        this.pms.createContents(parent);
        return parent;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.pms.restoreDefaults();
        CorePlugin.getDefault().getPreferenceStore().setValue("spmSettings", CorePlugin.getDefault().getPreferenceStore().getDefaultString("spmSettings"));
    }

    public boolean performOk() {
        if (this.pms.chkComplete()) {
            this.updateSpmSettings();
            this.pms = null;
        }
        return super.performOk();
    }

    public void performApply() {
        if (this.pms.chkComplete()) {
            this.updateSpmSettings();
        }
    }

    private void updateSpmSettings() {
        String[] spmSettings = this.s1.split(CorePlugin.getDefault().getPreferenceStore().getString("spmSettings"), -1);
        this.s2.split(CorePlugin.getDefault().getPreferenceStore().getString("spmP01Args"), -1);
        String spmSettingsParms = "";
        String spmSettingParm = "";
        int i = 0;
        while (i < spmSettings.length) {
            String[] spmSetting = spmSettings[i].split(",");
            spmSettingParm = String.valueOf(spmSetting[0]) + "," + spmSetting[1] + "," + spmSetting[2] + "," + spmSetting[3] + ",";
            if (i == 0) {
                spmSetting[4] = this.pms.numAdjacentLines.getText().trim();
            } else if (i == 1) {
                spmSetting[4] = this.pms.displayAllStmts.getSelection() ? "/" : " ";
            } else if (i == 2) {
                spmSetting[4] = this.pms.includeAsmObjCode.getSelection() ? "/" : " ";
            } else if (i == 3) {
                spmSetting[4] = this.pms.showStmtCntGraph.getSelection() ? "/" : " ";
            } else if (i == 4) {
                spmSetting[4] = this.pms.showHeadingDetailInfo.getSelection() ? "/" : " ";
            } else if (i == 5) {
                spmSetting[4] = this.pms.showCPseudo.getSelection() ? "/" : " ";
            } else if (i == 6) {
                spmSetting[4] = this.pms.displayValuesPct.getSelection() ? "/" : " ";
            }
            spmSettingsParms = i == 0 ? String.valueOf(spmSettingParm) + spmSetting[4] : String.valueOf(spmSettingsParms) + "|" + spmSettingParm + spmSetting[4];
            ++i;
        }
        CorePlugin.getDefault().getPreferenceStore().setValue("spmSettings", spmSettingsParms);
    }
}

