/*
 * Decompiled with CFR 0.152.
 */
package com.banknet.core.preferences;

import com.banknet.core.CorePlugin;
import com.banknet.core.dialogs.reports.OptionEditorDialog;
import com.banknet.core.internal.Constants;
import com.banknet.core.internal.Utilities;
import com.banknet.core.preferences.Messages;
import com.banknet.core.preferences.PreferencesConstants;
import com.banknet.core.preferences.ReportDownloadPreferenceInitializer;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReportDownloadPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    PreferencesConstants pconstants = new PreferencesConstants();
    private ReportDownloadModel reportdownloadmodel = null;
    private ReportDownloadModel reportdownloadmodel2 = null;
    private Bundle bundle;
    private static Document doc;
    private int nodecnt = 0;
    List<ReportDownloadModel> reports;
    List reportId;
    Tree tree;
    Table table;
    XPathFactory factory = XPathFactory.newInstance();
    XPath xpath = this.factory.newXPath();
    NodeList nodeList2;
    private Button editOptionButton;
    private Button selectAllButton;
    private Button unselectAllButton;
    private TreeViewer viewer;
    private Combo expandReport;
    private String selrptid = "";
    private String seloption = "";
    private Action doubleClickAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    String styleDelimiter1 = "[|]";
    Pattern s1 = Pattern.compile(this.styleDelimiter1);
    private String[] optionprefs;
    String errmsg = "";
    List<String> excludedRpts = new ArrayList<String>();

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(CorePlugin.getDefault().getPreferenceStore());
        try {
            URL fileUrl = CorePlugin.getDefault().productextension.getReportXmlUrl();
            File in = new File(fileUrl.getFile());
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(in);
        }
        catch (Exception ex) {
            String logstr = "init: ReportDownloadPreferencePage initialization exception. " + ex;
            System.out.println("ReportDownloadPreferencePage " + logstr);
            CorePlugin.getDefault().log.error(logstr);
        }
        this.loadOptionPrefsArray();
        this.loadExcludedRptsList();
    }

    private void loadOptionPrefsArray() {
        String rptid = "";
        String prefs = "";
        String options = "";
        String section = "";
        NodeList childNodes2 = doc.getElementsByTagName("report");
        int ii = 0;
        while (ii < childNodes2.getLength()) {
            Node item2 = childNodes2.item(ii);
            String nodeName2 = item2.getNodeName();
            if (nodeName2.equals("report")) {
                NamedNodeMap atrs = item2.getAttributes();
                section = item2.getParentNode().getAttributes().getNamedItem("id").getNodeValue();
                rptid = ((Attr)atrs.item(0)).getNodeValue();
                options = this.validateOptions(section, rptid, CorePlugin.getDefault().getPreferenceStore().getString(rptid));
                prefs = String.valueOf(prefs) + rptid + ":" + options + "|";
            }
            ++ii;
        }
        prefs = prefs.substring(0, prefs.length() - 1);
        this.optionprefs = this.s1.split(prefs, -1);
    }

    private String validateOptions(String section, String rptid, String options) {
        String rptoptions = "";
        String[] optsarr = options.split(",");
        String option = "";
        String val = "";
        if (options.length() > 0) {
            int i = 0;
            while (i < optsarr.length) {
                block5: {
                    String[] optarr = optsarr[i].split("=");
                    option = optarr[0];
                    val = optarr[1];
                    try {
                        int rc;
                        if (CorePlugin.getDefault().versionextension.chkReportOptions(section, rptid, option) && (rc = this.chkReportXmlOption(rptid, option, val)) >= 0) break block5;
                    }
                    catch (Exception exception) {}
                }
                rptoptions = String.valueOf(rptoptions) + option + "=" + val + ",";
                ++i;
            }
            if (rptoptions.length() > 0) {
                rptoptions = rptoptions.substring(0, rptoptions.length() - 1);
            }
        }
        return rptoptions;
    }

    private int chkReportXmlOption(String rptid, String rptoption, String val) {
        int rc = 0;
        try {
            String expression = "//reports/category/report[@code='" + rptid + "']/reportOption[@value='" + rptoption + "']/optionValue";
            this.nodeList2 = (NodeList)this.xpath.evaluate(expression, doc, XPathConstants.NODESET);
            if (this.nodeList2.getLength() <= 0) {
                rc = -1;
            }
        }
        catch (Exception e) {
            String logstr = "chkReportXmlOption:  Exception reading xml: " + rptid + "/" + rptoption + "/" + val + " - " + ". " + e;
            System.out.println("ReportDownloadPreferencePage - " + logstr);
            rc = -1;
        }
        return rc;
    }

    private void loadExcludedRptsList() {
        String[] rpts = CorePlugin.getDefault().getPreferenceStore().getString("excludedRpts").split(",");
        int i = 0;
        while (i < rpts.length) {
            this.excludedRpts.add(rpts[i]);
            ++i;
        }
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(CorePlugin.getDefault().productextension.getHelpPluginId()) + ".preferences_ReportOptionsContext");
        this.makeActions();
        Composite reportlistComp = new Composite(parent, 0);
        reportlistComp.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        reportlistComp.setLayout((Layout)new GridLayout(1, false));
        Composite grpt = new Composite(reportlistComp, 0);
        grpt.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        grpt.setLayout((Layout)new GridLayout(2, false));
        Label expandReportLabel = new Label(grpt, 0);
        expandReportLabel.setText(Messages.getString("ReportDownloadPreferencePage.Label.ExpandDflt"));
        new GridData(1, 128, false, false);
        this.expandReport = new Combo(grpt, 8);
        this.loadExpandReport();
        this.selectExpandReport(CorePlugin.getDefault().getPreferenceStore().getString("expandReport"));
        Composite g1 = new Composite(reportlistComp, 0);
        g1.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        g1.setLayout((Layout)new GridLayout(2, false));
        this.tree = new Tree(g1, 68386);
        GridData gd = new GridData(4, 4, true, true);
        this.tree.setLayoutData((Object)gd);
        ((GridData)this.tree.getLayoutData()).heightHint = 125;
        TableLayout tableLayout = new TableLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.tree.setLayout((Layout)tableLayout);
        this.viewer = new TreeViewer(this.tree);
        this.reportdownloadmodel = this.getReportDownloadModel();
        this.viewer.setAutoExpandLevel(1);
        TreeColumn column1 = new TreeColumn(this.tree, 0);
        column1.setText(Messages.getString("ReportDownloadPreferencePage.ReportsColumn.Reports"));
        this.tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem treeitem = (TreeItem)e.item;
                boolean checked = treeitem.getChecked();
                ReportDownloadModel reportmodel = (ReportDownloadModel)treeitem.getData();
                reportmodel.reportchecked = checked;
                if (reportmodel.elementtype.equals("category")) {
                    if (reportmodel.reportid.equalsIgnoreCase("V")) {
                        checked = true;
                        treeitem.setChecked(checked);
                        reportmodel.reportchecked = checked;
                    }
                    ArrayList childmodels = reportmodel.child;
                    int i = 0;
                    while (i < childmodels.size()) {
                        ((ReportDownloadModel)childmodels.get((int)i)).reportchecked = checked;
                        ++i;
                    }
                    ReportDownloadPreferencePage.this.updateTable();
                } else {
                    ReportDownloadModel parentmodel = reportmodel.parent;
                    if (checked) {
                        parentmodel.reportchecked = true;
                    } else if (parentmodel.reportid.equalsIgnoreCase("V") || CorePlugin.getDefault().versionextension.chkIsMultiAddr(reportmodel.reportid, parentmodel.reportid)) {
                        checked = true;
                        treeitem.setChecked(checked);
                        reportmodel.reportchecked = checked;
                    } else {
                        boolean parentchecked = false;
                        ArrayList childmodels = parentmodel.child;
                        int i = 0;
                        while (i < childmodels.size()) {
                            if (((ReportDownloadModel)childmodels.get((int)i)).reportchecked) {
                                parentchecked = true;
                                break;
                            }
                            ++i;
                        }
                        if (!parentchecked) {
                            parentmodel.reportchecked = false;
                        }
                    }
                    ReportDownloadPreferencePage.this.selrptid = reportmodel.reportid;
                    ReportDownloadPreferencePage.this.loadOptionPreferences(ReportDownloadPreferencePage.this.selrptid);
                }
                ReportDownloadPreferencePage.this.setCheckedItems();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tree.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                TreeItem[] childitems = ((TreeItem)event.item).getItems();
                ReportDownloadModel reportitem = (ReportDownloadModel)childitems[0].getData();
                if (reportitem != null) {
                    int j = 0;
                    while (j < childitems.length) {
                        reportitem = (ReportDownloadModel)childitems[j].getData();
                        childitems[j].setChecked(false);
                        if (reportitem.reportchecked) {
                            childitems[j].setChecked(true);
                        }
                        ++j;
                    }
                }
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ReportsViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ReportsViewLabelProvider());
        this.viewer.setInput((Object)this.reportdownloadmodel);
        this.setCheckedItems();
        Composite reportButtonsComposite = new Composite(g1, 0);
        GridLayout gridLayout2 = new GridLayout(2, false);
        gridLayout2.marginHeight = 0;
        gridLayout2.marginWidth = 0;
        reportButtonsComposite.setLayout((Layout)gridLayout2);
        reportButtonsComposite.setLayoutData((Object)new GridData(4, 1, false, false));
        ToolBar toolBar = new ToolBar(reportButtonsComposite, 256);
        ToolBarManager toolBarMgr = new ToolBarManager(toolBar);
        toolBarMgr.add((IAction)this.expandAllAction);
        toolBarMgr.add((IAction)this.collapseAllAction);
        toolBarMgr.update(true);
        GridData gdb3 = new GridData(131072, 1, false, false, 2, 1);
        gdb3.widthHint = 75;
        toolBar.setLayoutData((Object)gdb3);
        this.selectAllButton = new Button(reportButtonsComposite, 8);
        this.selectAllButton.setText(Messages.getString("ReportDownloadPreferencePage.Button.SelectAll"));
        GridData gdb2 = new GridData(4, 1, true, false, 2, 1);
        gdb2.minimumWidth = 75;
        this.selectAllButton.setLayoutData((Object)gdb2);
        this.selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportDownloadPreferencePage.this.selectAllReports();
            }
        });
        this.unselectAllButton = new Button(reportButtonsComposite, 8);
        this.unselectAllButton.setText(Messages.getString("ReportDownloadPreferencePage.Button.UnselectAll"));
        gdb2 = new GridData(4, 1, true, false, 2, 1);
        gdb2.minimumWidth = 75;
        this.unselectAllButton.setLayoutData((Object)gdb2);
        this.unselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList rptlist = ((ReportDownloadPreferencePage)ReportDownloadPreferencePage.this).reportdownloadmodel.child;
                int i = 0;
                while (i < rptlist.size()) {
                    ((ReportDownloadModel)rptlist.get((int)i)).reportchecked = false;
                    ArrayList childlist = ((ReportDownloadModel)rptlist.get((int)i)).child;
                    int j = 0;
                    while (j < childlist.size()) {
                        ((ReportDownloadModel)childlist.get((int)j)).reportchecked = false;
                        ++j;
                    }
                    ++i;
                }
                ReportDownloadPreferencePage.this.setCheckedItems();
            }
        });
        Label label2 = new Label(reportlistComp, 0);
        label2.setText(Messages.getString("ReportDownloadPreferencePage.Label.DownloadOptions"));
        Composite g2 = new Composite(reportlistComp, 0);
        g2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        g2.setLayout((Layout)new GridLayout(2, false));
        this.table = new Table(g2, 67588);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(false);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)this.table.getLayoutData()).heightHint = 100;
        TableColumn column = new TableColumn(this.table, 0);
        column.setWidth(0);
        column.setResizable(false);
        column = new TableColumn(this.table, 16384);
        column.setText(Messages.getString("ReportDownloadPreferencePage.OptionsColumn.Option"));
        column = new TableColumn(this.table, 16384);
        column.setText(Messages.getString("ReportDownloadPreferencePage.OptionsColumn.Value"));
        int i = 1;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(i).pack();
            ++i;
        }
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReportDownloadPreferencePage.this.editOptionButton.setEnabled(true);
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (ReportDownloadPreferencePage.this.table.getItem(new Point(e.x, e.y)) == null) {
                    ReportDownloadPreferencePage.this.table.deselectAll();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
                TableItem[] items = ReportDownloadPreferencePage.this.table.getSelection();
                String opt = ReportDownloadPreferencePage.this.getOptionLabel("getvalue", items[0].getText(1));
                String val = items[0].getText(2);
                if (opt.equalsIgnoreCase("sequence")) {
                    val = ReportDownloadPreferencePage.this.getSortLabel("getvalue", val);
                }
                ReportDownloadPreferencePage.this.editOption(opt, val);
            }
        });
        Composite buttonsComposite = new Composite(g2, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        buttonsComposite.setLayout((Layout)gridLayout);
        buttonsComposite.setLayoutData((Object)new GridData(4, 1, false, false));
        this.editOptionButton = new Button(buttonsComposite, 8);
        this.editOptionButton.setText(Messages.getString("ReportDownloadPreferencePage.Button.Edit"));
        GridData gdb = new GridData(4, 1, true, false);
        gdb.minimumWidth = 75;
        this.editOptionButton.setLayoutData((Object)gdb);
        this.editOptionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = ReportDownloadPreferencePage.this.table.getSelection();
                String opt = ReportDownloadPreferencePage.this.getOptionLabel("getvalue", items[0].getText(1));
                String val = items[0].getText(2);
                if (opt.equalsIgnoreCase("sequence")) {
                    val = ReportDownloadPreferencePage.this.getSortLabel("getvalue", val);
                }
                ReportDownloadPreferencePage.this.editOption(opt, val);
            }
        });
        this.editOptionButton.setEnabled(false);
        return reportlistComp;
    }

    public void setCheckedItems() {
        TreeItem[] items = this.tree.getItems();
        int i = 0;
        while (i < items.length) {
            TreeItem[] childitems;
            ReportDownloadModel reportitem = (ReportDownloadModel)items[i].getData();
            items[i].setChecked(false);
            if (reportitem.reportchecked) {
                items[i].setChecked(true);
            }
            if ((childitems = items[i].getItems()).length > 0 && (reportitem = (ReportDownloadModel)childitems[0].getData()) != null) {
                int j = 0;
                while (j < childitems.length) {
                    reportitem = (ReportDownloadModel)childitems[j].getData();
                    childitems[j].setChecked(false);
                    if (reportitem.reportchecked) {
                        childitems[j].setChecked(true);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void editOption(String optid, String optval) {
        OptionEditorDialog editopt;
        boolean exitedit = false;
        String seloptid = optid;
        String seloptval = optval;
        String optionprefs = "";
        optionprefs = this.getOptions(this.selrptid);
        while (!exitedit) {
            editopt = new OptionEditorDialog(this.table.getShell());
            OptionEditorDialog.doc = doc;
            editopt.rptid = this.selrptid;
            editopt.optid = seloptid;
            editopt.optval = seloptval;
            editopt.options = optionprefs;
            editopt.optionslabels = this.reportdownloadmodel2.optionslabels;
            int editoptrc = editopt.open();
            if (editoptrc == 0) {
                optionprefs = editopt.options;
                this.setOptions(editopt.rptid, optionprefs);
                this.loadOptionPreferences(this.selrptid);
                this.setOptionSelected(editopt.optid);
                exitedit = true;
                continue;
            }
            if (editoptrc == 1) {
                exitedit = true;
                continue;
            }
            optionprefs = editopt.options;
            seloptid = editopt.nextoptid;
            seloptval = editopt.nextoptval;
            this.setOptionSelected(seloptid);
            editopt = null;
        }
        editopt = null;
    }

    private void makeActions() {
        this.expandAllAction = new Action(){

            public void run() {
                ReportDownloadPreferencePage.this.viewer.expandAll();
                ReportDownloadPreferencePage.this.setCheckedItems();
            }
        };
        this.expandAllAction.setText(Messages.getString("ReportDownloadPreferencePage.Action.ExpandAll"));
        this.expandAllAction.setToolTipText(Messages.getString("ReportDownloadPreferencePage.Tooltip.ExpandAll"));
        this.expandAllAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/elcl16/expandall.gif"));
        this.expandAllAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/dlcl16/expandseall.gif"));
        this.expandAllAction.setEnabled(true);
        this.collapseAllAction = new Action(){

            public void run() {
                ReportDownloadPreferencePage.this.viewer.collapseAll();
            }
        };
        this.collapseAllAction.setText(Messages.getString("ReportDownloadPreferencePage.Action.CollapseAll"));
        this.collapseAllAction.setToolTipText(Messages.getString("ReportDownloadPreferencePage.Tooltip.CollapseAll"));
        this.collapseAllAction.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/elcl16/collapseall.gif"));
        this.collapseAllAction.setDisabledImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.banknet.core", (String)"icons/dlcl16/collapseall.gif"));
        this.collapseAllAction.setEnabled(true);
    }

    private void setDefaultSelected() {
        TreeItem[] tvitems = this.viewer.getTree().getItems();
        int i = 0;
        while (i < tvitems.length) {
            if (tvitems[i].getText().startsWith("S -")) {
                this.viewer.setSelection((ISelection)new StructuredSelection(tvitems[i].getData()));
            } else {
                tvitems[i].setExpanded(false);
            }
            ++i;
        }
    }

    private void setReportSelected(String rptid) {
        TreeItem[] tvitems = this.viewer.getTree().getItems();
        int i = 0;
        while (i < tvitems.length) {
            if (tvitems[i].getText().equals(rptid)) {
                this.viewer.setSelection((ISelection)new StructuredSelection(tvitems[i].getData()));
                break;
            }
            ++i;
        }
    }

    private void setOptionSelected(String optid) {
        TableItem[] items = this.table.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getText(1).equals(optid)) {
                this.table.setSelection(i);
                break;
            }
            ++i;
        }
    }

    protected void performDefaults() {
        this.selectExpandReport(CorePlugin.getDefault().getPreferenceStore().getDefaultString("expandReport"));
        ReportDownloadPreferenceInitializer downloadinit = new ReportDownloadPreferenceInitializer();
        this.optionprefs = null;
        this.optionprefs = downloadinit.getPreferenceDefaults(doc);
        downloadinit = null;
        if (this.selrptid.length() > 0) {
            this.setReportSelected(this.selrptid);
            this.loadOptionPreferences(this.selrptid);
        } else {
            this.setDefaultSelected();
        }
        this.selectAllReports();
    }

    private void selectAllReports() {
        ArrayList rptlist = this.reportdownloadmodel.child;
        int i = 0;
        while (i < rptlist.size()) {
            ((ReportDownloadModel)rptlist.get((int)i)).reportchecked = true;
            ArrayList childlist = ((ReportDownloadModel)rptlist.get((int)i)).child;
            int j = 0;
            while (j < childlist.size()) {
                ((ReportDownloadModel)childlist.get((int)j)).reportchecked = true;
                ++j;
            }
            ++i;
        }
        this.setCheckedItems();
    }

    public boolean performOk() {
        if (this.chkComplete()) {
            CorePlugin.getDefault().getPreferenceStore().setValue("expandReport", (String)this.expandReport.getData(String.valueOf(this.expandReport.getSelectionIndex())));
            this.updatePreferences();
            return super.performOk();
        }
        return false;
    }

    public void performApply() {
        if (this.chkComplete()) {
            CorePlugin.getDefault().getPreferenceStore().setValue("expandReport", (String)this.expandReport.getData(String.valueOf(this.expandReport.getSelectionIndex())));
            this.updatePreferences();
        }
    }

    private void updatePreferences() {
        IPreferenceStore preferenceStore = CorePlugin.getDefault().getPreferenceStore();
        int i = 0;
        while (i < this.optionprefs.length) {
            String[] optionpref = this.optionprefs[i].split(":");
            if (optionpref.length > 1) {
                preferenceStore.setValue(optionpref[0], optionpref[1]);
            }
            ++i;
        }
        String excludedRpts = "";
        ArrayList rptlist = this.reportdownloadmodel.child;
        int i2 = 0;
        while (i2 < rptlist.size()) {
            if (!((ReportDownloadModel)rptlist.get((int)i2)).reportchecked) {
                excludedRpts = String.valueOf(excludedRpts) + ((ReportDownloadModel)rptlist.get((int)i2)).reportid + ",";
            } else {
                ArrayList childlist = ((ReportDownloadModel)rptlist.get((int)i2)).child;
                int j = 0;
                while (j < childlist.size()) {
                    if (!((ReportDownloadModel)childlist.get((int)j)).reportchecked) {
                        excludedRpts = String.valueOf(excludedRpts) + ((ReportDownloadModel)childlist.get((int)j)).reportid + ",";
                    }
                    ++j;
                }
            }
            ++i2;
        }
        if (excludedRpts.length() > 0) {
            excludedRpts = excludedRpts.substring(0, excludedRpts.length() - 1);
        }
        preferenceStore.setValue("excludedRpts", excludedRpts);
    }

    public boolean chkComplete() {
        boolean isComplete = true;
        this.errmsg = "";
        if (!this.chkMandatory()) {
            isComplete = false;
        }
        if (this.errmsg.length() > 0) {
            this.showMessage("error", Messages.getString("ReportDownloadPreferencePage.PageTitle"), this.errmsg);
        }
        return isComplete;
    }

    private boolean chkMandatory() {
        boolean isValid = false;
        ArrayList rptlist = this.reportdownloadmodel.child;
        int i = 0;
        while (i < rptlist.size()) {
            if (((ReportDownloadModel)rptlist.get((int)i)).reportchecked) {
                return true;
            }
            ++i;
        }
        this.errmsg = Messages.getString("ReportDownloadPreferencePage.ErrorMessage.Mandatory");
        return isValid;
    }

    private void loadOptionPreferences(String rptid) {
        this.reportdownloadmodel2 = this.reports.get(this.reportId.indexOf(rptid));
        String enopt = "";
        String opt = "";
        String val = "";
        String[] options = this.getOptions(rptid).split(",");
        this.table.setRedraw(false);
        this.table.removeAll();
        int i = 0;
        while (i < options.length) {
            if (options[i].length() > 0) {
                enopt = options[i].substring(0, options[i].indexOf("="));
                opt = this.getOptionLabel("getlabel", enopt);
                val = options[i].substring(options[i].indexOf("=") + 1, options[i].length());
                if (enopt.equalsIgnoreCase("sequence")) {
                    val = this.getSortLabel("getlabel", val);
                }
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setText(1, opt);
                tableItem.setText(2, val);
            }
            ++i;
        }
        if (this.table.getItemCount() == 0) {
            this.editOptionButton.setEnabled(false);
        } else {
            this.editOptionButton.setEnabled(true);
        }
        this.table.setRedraw(true);
        i = 1;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(i).pack();
            ++i;
        }
    }

    private String getOptionLabel(String req, String val) {
        String optionlabel = val;
        String[] optionslabels = this.reportdownloadmodel2.optionslabels.split(",");
        int i = 0;
        while (i < optionslabels.length) {
            String[] optionslabel = this.s1.split(optionslabels[i], -1);
            if (req.equals("getlabel")) {
                if (val.equals(optionslabel[0])) {
                    return optionslabel[1];
                }
            } else if (val.equals(optionslabel[1])) {
                return optionslabel[0];
            }
            ++i;
        }
        return optionlabel;
    }

    private String getSortLabel(String req, String val) {
        String sortlabel = val;
        String[] sorts = this.reportdownloadmodel2.sortlabels.split(",");
        int i = 0;
        while (i < sorts.length) {
            String[] sortoptions = this.s1.split(sorts[i], -1);
            if (req.equals("getlabel")) {
                if (val.equals(sortoptions[0])) {
                    return sortoptions[1];
                }
            } else if (val.equals(sortoptions[1])) {
                return sortoptions[0];
            }
            ++i;
        }
        return sortlabel;
    }

    private String getOptions(String rptid) {
        int i = 0;
        while (i < this.optionprefs.length) {
            String[] optionpref = this.optionprefs[i].split(":");
            if (rptid.equals(optionpref[0])) {
                if (optionpref.length > 1) {
                    return optionpref[1];
                }
                return "";
            }
            ++i;
        }
        return "";
    }

    private void setOptions(String rptid, String options) {
        int i = 0;
        while (i < this.optionprefs.length) {
            String[] optionpref = this.optionprefs[i].split(":");
            if (rptid.equals(optionpref[0])) {
                this.optionprefs[i] = String.valueOf(rptid) + ":" + options;
                break;
            }
            ++i;
        }
    }

    private void updateTable() {
        this.table.setRedraw(false);
        this.table.removeAll();
        this.editOptionButton.setEnabled(false);
        this.table.setRedraw(true);
        int i = 1;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(i).pack();
            ++i;
        }
    }

    private ReportDownloadModel getReportDownloadModel() {
        ReportDownloadModel root = new ReportDownloadModel(0, "", "", "", "", "", "", "", true, null);
        root.counter = 0;
        this.reports = Collections.synchronizedList(new ArrayList());
        this.reportId = new ArrayList();
        Node firstNode = doc.getFirstChild();
        this.getCategoryNodes(firstNode, root);
        return root;
    }

    private void getCategoryNodes(Node node, ReportDownloadModel root) {
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            ReportDownloadModel parent1 = root;
            Node item = childNodes.item(i);
            String nodeName = item.getNodeName();
            item.getNodeValue();
            if (nodeName.equals("category")) {
                this.getReportNodes(item, parent1);
            }
            ++i;
        }
    }

    private void getReportNodes(Node node, ReportDownloadModel root) {
        ReportDownloadModel parent1 = root;
        String section = "";
        boolean addparent = true;
        NodeList childNodes2 = node.getChildNodes();
        int ii = 0;
        while (ii < childNodes2.getLength()) {
            block11: {
                Node item2 = childNodes2.item(ii);
                String nodeName2 = item2.getNodeName();
                if (nodeName2.equals("report")) {
                    boolean reportchecked;
                    String optionslabels;
                    String sortlabels;
                    String sortoptions;
                    String optionprefs;
                    String rptname;
                    String rptid;
                    block10: {
                        NamedNodeMap atrs = item2.getAttributes();
                        rptid = ((Attr)atrs.item(0)).getNodeValue();
                        rptname = ((Attr)atrs.item(1)).getNodeValue();
                        optionprefs = CorePlugin.getDefault().getPreferenceStore().getString(rptid);
                        String lcoptionprefs = optionprefs.toLowerCase();
                        sortoptions = "";
                        sortlabels = "";
                        optionslabels = this.getReportOptions(item2, "optionslabels");
                        if (optionslabels.length() > 0) {
                            optionslabels = optionslabels.substring(0, optionslabels.length() - 1);
                        }
                        if (lcoptionprefs.indexOf("sequence") >= 0) {
                            sortoptions = this.getReportOptions(item2, "sortoptions");
                            sortlabels = this.getReportOptions(item2, "sortlabels");
                        }
                        reportchecked = true;
                        if (this.excludedRpts.indexOf(rptid) >= 0) {
                            reportchecked = false;
                        }
                        if (addparent) {
                            atrs = node.getAttributes();
                            String parentrptid = ((Attr)atrs.item(1)).getNodeValue();
                            String parentoptionprefs = CorePlugin.getDefault().getPreferenceStore().getString(parentrptid);
                            boolean parentreportchecked = true;
                            if (this.excludedRpts.indexOf(((Attr)atrs.item(1)).getNodeValue()) >= 0) {
                                parentreportchecked = false;
                                reportchecked = false;
                            }
                            ReportDownloadModel mother = new ReportDownloadModel(this.nodecnt, node.getNodeName(), ((Attr)atrs.item(1)).getNodeValue(), ((Attr)atrs.item(0)).getNodeValue(), parentoptionprefs, "", "", "", parentreportchecked, parent1);
                            parent1.child.add(mother);
                            parent1 = mother;
                            ++this.nodecnt;
                            addparent = false;
                            section = parent1.reportid;
                        }
                        if (!parent1.reportchecked) {
                            reportchecked = false;
                        }
                        try {
                            if (CorePlugin.getDefault().versionextension.chkReportControlCards(rptid, section)) break block10;
                            break block11;
                        }
                        catch (Exception exception) {}
                    }
                    ReportDownloadModel mother = new ReportDownloadModel(this.nodecnt, nodeName2, rptid, rptname, optionprefs, optionslabels, sortoptions, sortlabels, reportchecked, parent1);
                    parent1.child.add(mother);
                    ++this.nodecnt;
                    this.reports.add(mother);
                    this.reportId.add(rptid);
                }
            }
            ++ii;
        }
    }

    private String getReportOptions(Node node, String req) {
        String options = "";
        String val = "";
        NodeList childNodes2 = node.getChildNodes();
        int ii = 0;
        while (ii < childNodes2.getLength()) {
            Node item2 = childNodes2.item(ii);
            String nodeName2 = item2.getNodeName();
            if (nodeName2.equals("reportOption")) {
                NamedNodeMap atrs = item2.getAttributes();
                Node valatr = atrs.getNamedItem("value");
                Node labelatr = atrs.getNamedItem("label");
                Node sortatr = atrs.getNamedItem("sort");
                if (req.equalsIgnoreCase("optionslabels")) {
                    val = String.valueOf(val) + valatr.getNodeValue() + "|" + labelatr.getNodeValue() + ",";
                } else if (valatr.getNodeValue().equalsIgnoreCase("sequence")) {
                    if (req.equalsIgnoreCase("sortoptions") && sortatr != null) {
                        val = this.getOptionValue(item2, req);
                        options = String.valueOf(options) + val + ",";
                    } else if (req.equalsIgnoreCase("sortlabels")) {
                        val = this.getOptionValue(item2, req);
                        options = String.valueOf(options) + val + ",";
                    }
                }
            }
            ++ii;
        }
        return val;
    }

    private String getOptionValue(Node node, String req) {
        String vals = "";
        NodeList childNodes2 = node.getChildNodes();
        int ii = 0;
        while (ii < childNodes2.getLength()) {
            Node item2 = childNodes2.item(ii);
            String nodeName2 = item2.getNodeName();
            if (nodeName2.equals("optionValue")) {
                NamedNodeMap atrs = item2.getAttributes();
                Node valatr = atrs.getNamedItem("value");
                Node labelatr = atrs.getNamedItem("label");
                if (req.equalsIgnoreCase("sortoptions")) {
                    Node dfltatr = atrs.getNamedItem("default");
                    Node hdrcolatr = atrs.getNamedItem("sorthdrpi");
                    Node bodycolatr = atrs.getNamedItem("sortbodypi");
                    vals = String.valueOf(vals) + valatr.getNodeValue() + "|" + labelatr.getNodeValue() + "|" + dfltatr.getNodeValue() + "|" + hdrcolatr.getNodeValue() + "|" + bodycolatr.getNodeValue() + ",";
                } else {
                    vals = String.valueOf(vals) + valatr.getNodeValue() + "|" + labelatr.getNodeValue() + ",";
                }
            }
            ++ii;
        }
        if (vals.length() > 0) {
            vals = vals.substring(0, vals.length() - 1);
        }
        return vals;
    }

    private void loadExpandReport() {
        String rptid = "";
        String rptname = "";
        NodeList childNodes2 = doc.getElementsByTagName("category");
        int ii = 0;
        while (ii < childNodes2.getLength()) {
            Node item2 = childNodes2.item(ii);
            NamedNodeMap atrs = item2.getAttributes();
            rptid = ((Attr)atrs.item(1)).getNodeValue();
            rptname = ((Attr)atrs.item(0)).getNodeValue();
            this.expandReport.setData(String.valueOf(this.expandReport.getItemCount()), (Object)rptid);
            this.expandReport.add(String.valueOf(rptid) + " - " + rptname);
            ++ii;
        }
    }

    private void selectExpandReport(String rptid) {
        if (rptid != null) {
            int i = 0;
            while (i < this.expandReport.getItemCount()) {
                if (rptid.equals((String)this.expandReport.getData(String.valueOf(i)))) {
                    this.expandReport.select(i);
                }
                ++i;
            }
        }
    }

    static void checkPath(TreeItem item, boolean checked, boolean grayed) {
        if (item == null) {
            return;
        }
        if (grayed) {
            checked = true;
        } else {
            int index = 0;
            TreeItem[] items = item.getItems();
            while (index < items.length) {
                TreeItem child = items[index];
                if (child.getGrayed() || checked != child.getChecked()) {
                    grayed = true;
                    checked = true;
                    break;
                }
                ++index;
            }
        }
        item.setChecked(checked);
        item.setGrayed(grayed);
        ReportDownloadPreferencePage.checkPath(item.getParentItem(), checked, grayed);
    }

    static void checkItems(TreeItem item, boolean checked) {
        item.setGrayed(false);
        item.setChecked(checked);
        TreeItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            ReportDownloadPreferencePage.checkItems(items[i], checked);
            ++i;
        }
    }

    private void showMessage(String msgtype, String title, String message) {
        if (msgtype.equalsIgnoreCase("error")) {
            MessageDialog.openError((Shell)this.table.getShell(), (String)title, (String)message);
        } else {
            MessageDialog.openInformation((Shell)this.table.getShell(), (String)title, (String)message);
        }
    }

    public class ReportDownloadModel {
        public ReportDownloadModel parent;
        public ArrayList child = new ArrayList();
        public int counter;
        public String elementtype;
        public String reportid;
        public String reportname;
        public String optionprefs;
        public String optionslabels;
        public String sortoptions;
        public String sortlabels;
        public boolean reportchecked;

        public ReportDownloadModel(int counter, String elementtype, String reportid, String reportname, String optionprefs, String optionslabels, String sortoptions, String sortlabels, boolean reportchecked, ReportDownloadModel parent) {
            this.parent = parent;
            this.counter = counter;
            this.elementtype = elementtype;
            this.reportid = reportid;
            this.reportname = reportname;
            this.optionprefs = optionprefs;
            this.optionslabels = optionslabels;
            this.sortoptions = sortoptions;
            this.sortlabels = sortlabels;
            this.reportchecked = reportchecked;
        }
    }

    public class ReportsViewContentProvider
    implements ITreeContentProvider {
        public Object[] getElements(Object inputElement) {
            return ((ReportDownloadModel)inputElement).child.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return this.getElements(parentElement);
        }

        public Object getParent(Object element) {
            if (element == null) {
                return null;
            }
            return ((ReportDownloadModel)element).parent;
        }

        public boolean hasChildren(Object element) {
            return ((ReportDownloadModel)element).child.size() > 0;
        }
    }

    public class ReportsViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableFontProvider {
        FontRegistry registry = new FontRegistry();
        Constants constants = new Constants();
        Utilities utilities = new Utilities();
        int rowcount = 0;

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return String.valueOf(((ReportDownloadModel)element).reportid) + " - " + ((ReportDownloadModel)element).reportname;
        }

        public Font getFont(Object element, int columnIndex) {
            if (((ReportDownloadModel)element).elementtype.equals("category")) {
                return this.registry.getBold(Display.getCurrent().getSystemFont().getFontData()[0].getName());
            }
            return null;
        }
    }
}

